//
// Copyright 2017 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

// ErrorStrings.h: Contains mapping of commonly used error messages

#ifndef LIBANGLE_ERRORSTRINGS_H_
#define LIBANGLE_ERRORSTRINGS_H_

namespace gl
{
namespace err
{

// clang-format off
inline constexpr const char *k3DDepthStencil = "Format cannot be GL_DEPTH_COMPONENT or GL_DEPTH_STENCIL if target is GL_TEXTURE_3D.";
inline constexpr const char *kANGLECopyTextureMissingRequiredExtension = "Copy*TextureCHROMIUM from EXTERNAL_OES to integer format requires OES_EGL_image_external_essl3.";
inline constexpr const char *kAdvancedBlendEquationWithMRT = "Advanced blend equation can only be used when only one draw buffer is not NONE.";
inline constexpr const char *kAtomicCounterResourceName = "Active atomic counter resources are not assigned name strings.";
inline constexpr const char *kAttributeListNotNull = "Attribute list must be NULL or GL_NONE.";
inline constexpr const char *kAttributeNameNull = "Attribute name is null.";
inline constexpr const char *kAttributeNotMatch = "Attribute is incompatible with egl image.";
inline constexpr const char *kAttributeNotValid = "Attribute is not valid.";
inline constexpr const char *kAttributeZeroRequiresDivisorLimitation = "The current context doesn't support setting a non-zero divisor on the attribute with index zero. Please reorder the attributes in your vertex shader so that attribute zero can have a zero divisor.";
inline constexpr const char *kBaseLevelNegative = "Negative base level.";
inline constexpr const char *kBaseLevelNonZero = "Non-zero base level.";
inline constexpr const char *kBaseLevelOutOfRange = "Texture base level out of range.";
inline constexpr const char *kBlendEquationNotEnabled = "Active fragment shader does not include the layout qualifier matching the blend equation.";
inline constexpr const char *kBlitDepthOrStencilFormatMismatch = "Depth/stencil buffer format combination not allowed for blit.";
inline constexpr const char *kBlitDimensionsOutOfRange = "BlitFramebuffer dimensions out of 32-bit integer range.";
inline constexpr const char *kBlitExtensionDepthStencilWholeBufferBlit = "Only whole-buffer depth and stencil blits are supported by this extension.";
inline constexpr const char *kBlitExtensionFormatMismatch = "Attempting to blit and the read and draw buffer formats don't match. read: 0x%04X draw: 0x%04X.";
inline constexpr const char *kBlitExtensionFromInvalidAttachmentType = "Blits are only supported from 2D texture, renderbuffer or default framebuffer attachments in this extension.";
inline constexpr const char *kBlitExtensionLinear = "Linear blit not supported in this extension.";
inline constexpr const char *kBlitExtensionMultisampledDepthOrStencil = "Multisampled depth/stencil blit is not supported by this extension.";
inline constexpr const char *kBlitExtensionMultisampledWholeBufferBlit = "Only whole-buffer blit is supported from a multisampled read buffer in this extension.";
inline constexpr const char *kBlitExtensionScaleOrFlip = "Scaling and flipping in BlitFramebufferANGLE not supported by this implementation.";
inline constexpr const char *kBlitExtensionToInvalidAttachmentType = "Blits are only supported to 2D texture, renderbuffer or default framebuffer attachments in this extension.";
inline constexpr const char *kBlitFeedbackLoop = "Blit feedback loop: the read and draw framebuffers are the same.";
inline constexpr const char *kBlitFramebufferMissing = "Read and draw framebuffers must both exist for a blit to succeed.";
inline constexpr const char *kBlitFromMultiview = "Attempt to read from a multi-view framebuffer.";
inline constexpr const char *kBlitIntegerWithLinearFilter = "Cannot use GL_LINEAR filter when blitting a integer framebuffer.";
inline constexpr const char *kBlitInvalidFilter = "Invalid blit filter.";
inline constexpr const char *kBlitInvalidMask = "Invalid blit mask.";
inline constexpr const char *kBlitMissingColor = "Attempt to read from a missing color attachment of a complete framebuffer.";
inline constexpr const char *kBlitMissingDepthOrStencil = "Attempt to read from a missing depth/stencil attachment of a complete framebuffer.";
inline constexpr const char *kBlitMultisampledBoundsMismatch = "Attempt to blit from a multisampled framebuffer and the bounds don't match with the draw framebuffer.";
inline constexpr const char *kBlitMultisampledFormatOrBoundsMismatch = "Attempt to blit from a multisampled framebuffer and the bounds or format of the color buffer don't match with the draw framebuffer.";
inline constexpr const char *kBlitOnlyNearestForNonColor = "Only nearest filtering can be used when blitting buffers other than the color buffer.";
inline constexpr const char *kBlitSameImageColor = "Read and write color attachments cannot be the same image.";
inline constexpr const char *kBlitSameImageDepthOrStencil = "Read and write depth stencil attachments cannot be the same image.";
inline constexpr const char *kBlitToMultiview = "Attempt to write to a multi-view framebuffer.";
inline constexpr const char *kBlitTypeMismatchFixedOrFloat = "If the read buffer contains fixed-point or floating-point values, the draw buffer must as well.";
inline constexpr const char *kBlitTypeMismatchFixedPoint = "If the read buffer contains fixed-point values, the draw buffer must as well.";
inline constexpr const char *kBlitTypeMismatchSignedInteger = "If the read buffer contains signed integer values the draw buffer must as well.";
inline constexpr const char *kBlitTypeMismatchUnsignedInteger = "If the read buffer contains unsigned integer values the draw buffer must as well.";
inline constexpr const char *kBlitYUVFramebuffer = "Blitting to or from a YUV framebuffer is disallowed.";
inline constexpr const char *kBlobCacheCallbacksUnbalanced = "Blob cache callbacks must both be NULL or both be non-NULL.";
inline constexpr const char *kBufferAlreadyMapped = "Buffer is already mapped.";
inline constexpr const char *kBufferBoundForTransformFeedback = "Buffer is bound for transform feedback.";
inline constexpr const char *kBufferImmutable = "Buffer is immutable.";
inline constexpr const char *kBufferMapped = "An active buffer is mapped.";
inline constexpr const char *kBufferNotBound = "A buffer must be bound.";
inline constexpr const char *kBufferNotMappable = "Attempted to map buffer object zero.";
inline constexpr const char *kBufferNotMapped = "Buffer is not mapped.";
inline constexpr const char *kBufferNotUpdatable = "Buffer is not updatable.";
inline constexpr const char *kBufferOffsetOverflow = "Buffer offset overflow.";
inline constexpr const char *kBufferPointerNotAvailable = "Can not get pointer for reserved buffer name zero.";
inline constexpr const char *kBufferTextureNotAllowed = "Buffer textures are not allowed.";
inline constexpr const char *kCannotPopDefaultDebugGroup = "Cannot pop the default debug group.";
inline constexpr const char *kClientBufferInvalid = "Size must not exceed the size of clientbuffer.";
inline constexpr const char *kClientDataInVertexArray = "Client data cannot be used with a non-default vertex array object.";
inline constexpr const char *kColorNumberGreaterThanMaxDrawBuffers = "Color number for primary color greater than or equal to MAX_DRAW_BUFFERS.";
inline constexpr const char *kColorNumberGreaterThanMaxDualSourceDrawBuffers = "Color number for secondary color greater than or equal to MAX_DUAL_SOURCE_DRAW_BUFFERS.";
inline constexpr const char *kCompressedDataSizeTooSmall = "dataSize is too small.";
inline constexpr const char *kCompressedMismatch = "Compressed data is valid if-and-only-if the texture is compressed.";
inline constexpr const char *kCompressedTextureDimensionsMustMatchData = "Compressed texture dimensions must exactly match the dimensions of the data passed in.";
inline constexpr const char *kCompressedTexturesNotAttachable = "Compressed textures cannot be attached to a framebuffer.";
inline constexpr const char *kConstantColorAlphaLimitation = "Simultaneous use of GL_CONSTANT_ALPHA/GL_ONE_MINUS_CONSTANT_ALPHA and GL_CONSTANT_COLOR/GL_ONE_MINUS_CONSTANT_COLOR as color factors is not supported by this implementation.";
inline constexpr const char *kContextLost = "Context has been lost.";
inline constexpr const char *kCopyAlias = "The read and write copy regions alias memory.";
inline constexpr const char *kCopyFromYUVFramebuffer = "Copying from a YUV framebuffer is disallowed.";
inline constexpr const char *kCubemapFacesEqualDimensions = "Each cubemap face must have equal width and height.";
inline constexpr const char *kCubemapIncomplete = "Texture is not cubemap complete. All cubemaps faces must be defined and be the same size.";
inline constexpr const char *kCubemapInvalidDepth = "The cubemap depth must be a multiple of 6.";
inline constexpr const char *kDataTypeNotAligned = "Data is not evenly divisible into the number of bytes needed to store in memory a datum indicated by type.";
inline constexpr const char *kDebugMessageNULL = "The message is null.";
inline constexpr const char *kDebugMessageControlIdsNULL = "the <ids> of DebugMessageControl cannot be null.";
inline constexpr const char *kDefaultFramebuffer = "Default framebuffer is bound.";
inline constexpr const char *kDefaultFramebufferAttachmentOnUserFBO = "Invalid attachment when a user framebuffer is bound.";
inline constexpr const char *kDefaultFramebufferInvalidAttachment = "Invalid attachment when the default framebuffer is bound.";
inline constexpr const char *kDefaultFramebufferInvalidDrawBuffer = "Only NONE or BACK are valid draw buffers for the default framebuffer.";
inline constexpr const char *kDefaultFramebufferTarget = "It is invalid to change default FBO's attachments.";
inline constexpr const char *kDefaultVertexArray = "Default vertex array object is bound.";
inline constexpr const char *kDestinationImmutable = "Destination texture cannot be immutable.";
inline constexpr const char *kDestinationLevelNotDefined = "The destination level of the destination texture must be defined.";
inline constexpr const char *kDestinationTextureTooSmall = "Destination texture too small.";
inline constexpr const char *kDimensionsMustBePow2 = "Texture dimensions must be power-of-two.";
inline constexpr const char *kDispatchIndirectBufferNotBound = "Dispatch indirect buffer must be bound.";
inline constexpr const char *kDrawBufferMaskMismatch = "Active draw buffers with missing fragment shader outputs.";
inline constexpr const char *kDrawBuffersIndexedExtensionNotAvailable = "EXT/OES_draw_buffers_indexed is not available.";
inline constexpr const char *kDrawBufferTypeMismatch = "Fragment shader output type does not match the bound framebuffer attachment type.";
inline constexpr const char *kDrawFramebufferIncomplete = "Draw framebuffer is incomplete.";
inline constexpr const char *kDrawIndirectBufferNotBound = "Draw indirect buffer must be bound.";
inline constexpr const char *kDualSourceBlendingDrawBuffersLimit = "Dual-source blending functions limit the number of supported draw buffers.";
inline constexpr const char *kEGLImageCannotCreate2DMultisampled = "Cannot create a 2D texture from a multisampled EGL image.";
inline constexpr const char *kEGLImageRenderbufferFormatNotSupported = "EGL image internal format is not supported as a renderbuffer.";
inline constexpr const char *kEGLImageTextureFormatNotSupported = "EGL image internal format is not supported as a texture.";
inline constexpr const char *kEGLImageTextureTargetMismatch = "The source EGL image is incompatible with the target texture type.";
inline constexpr const char *kElementArrayBufferBoundForTransformFeedback = "It is undefined behavior to use an element array buffer that is bound for transform feedback.";
inline constexpr const char *kElementArrayNoBufferOrPointer = "No element array buffer and no pointer.";
inline constexpr const char *kEntryPointBaseUnsupported = "The base command requires an extension or a higher context version.";
inline constexpr const char *kEntryPointRequiresES10 = "Command requires OpenGL ES 1.0.";
inline constexpr const char *kEntryPointRequiresES10or32 = "Command requires OpenGL ES 1.0 or 3.2.";
inline constexpr const char *kEntryPointRequiresES20 = "Command requires OpenGL ES 2.0.";
inline constexpr const char *kEntryPointRequiresES30 = "Command requires OpenGL ES 3.0.";
inline constexpr const char *kEntryPointRequiresES31 = "Command requires OpenGL ES 3.1.";
inline constexpr const char *kEntryPointRequiresES32 = "Command requires OpenGL ES 3.2.";
inline constexpr const char *kEntryPointRequiresESEXT = "Command requires an extension.";
inline constexpr const char *kEnumInvalid = "Invalid enum provided.";
inline constexpr const char *kEnumNotSupported = "Enum 0x%04X is currently not supported.";
inline constexpr const char *kEnumRequiresGLES30 = "Enum requires GLES 3.0.";
inline constexpr const char *kEnumRequiresGLES31 = "Enum requires GLES 3.1.";
inline constexpr const char *kES2Required = "OpenGL ES 2.0 Required.";
inline constexpr const char *kES31Required = "OpenGL ES 3.1 Required.";
inline constexpr const char *kES3Required = "OpenGL ES 3.0 Required.";
inline constexpr const char *kExceedsComputeWorkGroupCountX = "num_groups_x cannot be greater than MAX_COMPUTE_WORK_GROUP_COUNT[0].";
inline constexpr const char *kExceedsComputeWorkGroupCountY = "num_groups_y cannot be greater than MAX_COMPUTE_WORK_GROUP_COUNT[1].";
inline constexpr const char *kExceedsComputeWorkGroupCountZ = "num_groups_z cannot be greater than MAX_COMPUTE_WORK_GROUP_COUNT[2].";
inline constexpr const char *kExceedsElementRange = "Element value exceeds element range.";
inline constexpr const char *kExceedsFramebufferHeight = "Params less than 0 or greater than GL_MAX_FRAMEBUFFER_HEIGHT.";
inline constexpr const char *kExceedsFramebufferSamples = "Params less than 0 or greater than GL_MAX_FRAMEBUFFER_SAMPLES.";
inline constexpr const char *kExceedsFramebufferWidth = "Params less than 0 or greater than GL_MAX_FRAMEBUFFER_WIDTH.";
inline constexpr const char *kExceedsMaxColorAttachments = "Index is greater than the maximum supported color attachments.";
inline constexpr const char *kExceedsMaxDebugGroupStackDepth = "Cannot push more than GL_MAX_DEBUG_GROUP_STACK_DEPTH debug groups.";
inline constexpr const char *kExceedsMaxDebugMessageLength = "Message length is larger than GL_MAX_DEBUG_MESSAGE_LENGTH.";
inline constexpr const char *kExceedsMaxDrawBuffers = "Draw buffer greater than MAX_DRAW_BUFFERS.";
inline constexpr const char *kExceedsMaxElement = "Element value exceeds maximum element index.";
inline constexpr const char *kExceedsMaxImageUnits = "Index must be within [0, MAX_IMAGE_UNITS).";
inline constexpr const char *kExceedsMaxLabelLength = "Label length is larger than GL_MAX_LABEL_LENGTH.";
inline constexpr const char *kExceedsMaxShaderStorageBufferBindings = "Index must be within [0, MAX_SHADER_STORAGE_BUFFER_BINDINGS).";
inline constexpr const char *kExceedsMaxVertexAttribBindings = "Index must be within [0, MAX_VERTEX_ATTRIB_BINDINGS).";
inline constexpr const char *kExceedsMaxVertexAttribStride = "Stride must be within [0, MAX_VERTEX_ATTRIB_STRIDE).";
inline constexpr const char *kExceedsNumExtensions = "Index must be within [0, NUM_EXTENSIONS).";
inline constexpr const char *kExceedsNumRequestableExtensions = "Index must be within [0, NUM_REQUESTABLE_EXTENSIONS_ANGLE).";
inline constexpr const char *kExpectedProgramName = "Expected a program name, but found a shader name.";
inline constexpr const char *kExpectedShaderName = "Expected a shader name, but found a program name.";
inline constexpr const char *kExtensionNotEnabled = "Extension is not enabled.";
inline constexpr const char *kExtensionNotDisablable = "Extension is not disablable.";
inline constexpr const char *kExtensionNotRequestable = "Extension is not requestable.";
inline constexpr const char *kExternalBufferInvalidOffset = "Offset must be zero for external buffers.";
inline constexpr const char *kExternalTextureAttachmentNotYUV = "External texture attached to framebuffer is not YUV.";
inline constexpr const char *kExternalTextureNotSupported = "External texture extension not enabled.";
inline constexpr const char *kFeedbackLoop = "Feedback loop formed between Framebuffer and active Texture.";
inline constexpr const char *kFixedNotInWebGL = "GL_FIXED is not supported in WebGL.";
inline constexpr const char *kFocalPointsExceedMaxFocalPoints = "Requested focal point exceeds the supported maximum.";
inline constexpr const char *kFormatNotRenderable = "Internal format is not renderable.";
inline constexpr const char *kFoveatedTextureCannotDisable = "Cannot disable foveation on a foveated texture.";
inline constexpr const char *kFoveatedTextureInvalidParameters = "Invalid parameters given for GL_TEXTURE_FOVEATED_FEATURE_BITS_QCOM.";
inline constexpr const char *kFoveatedTextureInvalidPixelDensity = "Pixel density must be between 0.0 and 1.0.";
inline constexpr const char *kFoveatedTextureQcomExtensionRequired = "GL_QCOM_texture_foveated not enabled.";
inline constexpr const char *kFragDataBindingIndexOutOfRange = "Fragment output color index must be zero or one.";
inline constexpr const char *kFragmentInputTypeNotFloatingPoint = "Fragment input type is not a floating point scalar or vector.";
inline constexpr const char *kFramebufferFoveationAlreadyConfigured = "glFramebufferFoveationConfigQCOM called on a framebuffer that has already been configured for foveated rendering.";
inline constexpr const char *kFramebufferFoveationAttachmentChanged = "Attachments have been changed on a framebuffer configured for foveated rendering.";
inline constexpr const char *kFramebufferFoveationLayersExceedMaxArrayLayers = "Requested layer exceeds the supported maximum.";
inline constexpr const char *kFramebufferFoveationNotConfigured = "glFramebufferFoveationParametersQCOM called on a framebuffer that has not been configured for foveated rendering.";
inline constexpr const char *kFramebufferIncomplete = "Framebuffer is incomplete.";
inline constexpr const char *kFramebufferIncompleteAttachment = "Attachment type must be compatible with attachment object.";
inline constexpr const char *kFramebufferIncompleteAttachmentDepthGreaterThanMaxLayers = "Framebuffer is incomplete: Attachment depth is greater than MAX_FRAMEBUFFER_LAYERS.";
inline constexpr const char *kFramebufferIncompleteAttachmentInconsistantBitPlanes = "Framebuffer is incomplete: Attachments have inconsistent bit plane counts.";
inline constexpr const char *kFramebufferIncompleteAttachmentLayerGreaterThanDepth = "Framebuffer is incomplete: Attachment layer is greater than texture layer count.";
inline constexpr const char *kFramebufferIncompleteAttachmentLevelNotBaseLevelForIncompleteMipTexture = "Framebuffer is incomplete: Attachment level not equal to the base level and the texture is not mipmap complete.";
inline constexpr const char *kFramebufferIncompleteAttachmentLevelOutOfBaseMaxLevelRange = "Framebuffer is incomplete: Attachment level is not in the [base level, max level] range.";
inline constexpr const char *kFramebufferIncompleteAttachmentNoDepthBitsInDepthBuffer = "Framebuffer is incomplete: Depth attachment has no depth bits.";
inline constexpr const char *kFramebufferIncompleteAttachmentNoStencilBitsInStencilBuffer = "Framebuffer is incomplete: Stencil attachment has no stencil bits.";
inline constexpr const char *kFramebufferIncompleteAttachmentNotCubeComplete = "Framebuffer is incomplete: Attachment is an incomplete cube map.";
inline constexpr const char *kFramebufferIncompleteAttachmentNotRenderable = "Framebuffer is incomplete: Attachment is not renderable.";
inline constexpr const char *kFramebufferIncompleteAttachmentSamplesGreaterThanMaxSupportedSamples = "Framebuffer is incomplete: Attachment samples are greater than the maximum supported samples for this format.";
inline constexpr const char *kFramebufferIncompleteAttachmentsNotUnique = "Framebuffer is incomplete: All attachments must be unique.";
inline constexpr const char *kFramebufferIncompleteAttachmentWebGLDepthBufferHasStencilBits = "Framebuffer is incomplete: Stencil attachment has depth bits.";
inline constexpr const char *kFramebufferIncompleteAttachmentWebGLDepthStencilNoDepthOrStencilBits = "Framebuffer is incomplete: Depth stencil attachment has no depth bits or no stencil bits.";
inline constexpr const char *kFramebufferIncompleteAttachmentWebGLStencilBufferHasDepthBits = "Framebuffer is incomplete: Stencil attachment has depth bits.";
inline constexpr const char *kFramebufferIncompleteAttachmentZeroSize = "Framebuffer is incomplete: Attachment has zero size.";
inline constexpr const char *kFramebufferIncompleteColorBitsUsedExceedsMaxColorBitsSupported = "Framebuffer is incomplete: The total number of color bits exceeds the number of output bits supported.";
inline constexpr const char *kFramebufferIncompleteDefaultZeroSize = "Framebuffer is incomplete: No attachments and default size is zero.";
inline constexpr const char *kFramebufferIncompleteDepthAndStencilBuffersNotTheSame = "Framebuffer is incomplete: Depth and stencil attachments are not the same.";
inline constexpr const char *kFramebufferIncompleteDepthStencilInColorBuffer = "Framebuffer is incomplete: Depth stencil texture in color attachment.";
inline constexpr const char *kFramebufferIncompleteDriverUnsupported = "Framebuffer is incomplete: Driver does not support this framebuffer configuration.";
inline constexpr const char *kFramebufferIncompleteFoveatedRendering = "Framebuffer is incomplete: Invalid framebuffer configuration for foveated rendering.";
inline constexpr const char *kFramebufferIncompleteInconsistantAttachmentSizes = "Framebuffer is incomplete: Attachments are not all the same size.";
inline constexpr const char *kFramebufferIncompleteInternalError = "Framebuffer is incomplete: Internal error.";
inline constexpr const char *kFramebufferIncompleteMismatchedLayeredAttachments = "Framebuffer is incomplete: If one attachment is layered, all must be layered.";
inline constexpr const char *kFramebufferIncompleteMismatchedLayeredTexturetypes = "Framebuffer is incomplete: If an attachments are layered, they must all be the same texture type.";
inline constexpr const char *kFramebufferIncompleteMultisampleDepthStencilSampleCountDivisibleByColorSampleCount = "Framebuffer is incomplete: Depth stencil sample count must be divisible by the color sample count.";
inline constexpr const char *kFramebufferIncompleteMultisampleInconsistentFixedSampleLocations = "Framebuffer is incomplete: Attachments have inconsistent fixed sample locations.";
inline constexpr const char *kFramebufferIncompleteMultisampleInconsistentSampleCounts = "Framebuffer is incomplete: Attachments have different sample counts.";
inline constexpr const char *kFramebufferIncompleteMultisampleNonFixedSamplesWithRenderbuffers = "Framebuffer is incomplete: All textures must have fixed samples if paired with multisample renderbuffers.";
inline constexpr const char *kFramebufferIncompleteMultiviewBaseViewMismatch = "Framebuffer is incomplete: Attachments have inconsistent multiview base view.";
inline constexpr const char *kFramebufferIncompleteMultiviewMismatch = "Framebuffer is incomplete: Attachments have inconsistent multiview enabled state.";
inline constexpr const char *kFramebufferIncompleteMultiviewViewsMismatch = "Framebuffer is incomplete: Attachments have inconsistent multiview view counts.";
inline constexpr const char *kFramebufferIncompleteSurfaceless = "Framebuffer is incomplete: Framebuffer is surfaceless.";
inline constexpr const char *kFramebufferIncompleteUnsupportedMissmatchedDimensions = "Framebuffer is incomplete: Mismatched attachment sizes are unsupported.";
inline constexpr const char *kFramebufferIncompleteUnsupportedNonUniqueAttachments = "Framebuffer is incomplete: Non-unique attachments are unsupported.";
inline constexpr const char *kFramebufferIncompleteUnsupportedSeparateDepthStencilBuffers = "Framebuffer is incomplete: Separate depth and stencil buffers are unsupported.";
inline constexpr const char *kFramebufferIncompleteUnsupportedSeparateDepthStencilBuffersCombinedFormat = "Framebuffer is incomplete: Combined depth/stencil formats cannot be used with separate depth and stencil buffers.";
inline constexpr const char *kFramebufferIncompleteWebGLDepthStencilInconsistant = "Framebuffer is incomplete: WebGL depth stencil state is inconsistent.";
inline constexpr const char *kFramebufferTextureInvalidLayer = "Layer invalid for framebuffer texture attachment.";
inline constexpr const char *kFramebufferTextureInvalidMipLevel = "Mip level invalid for framebuffer texture attachment.";
inline constexpr const char *kFramebufferTextureLayerIncorrectTextureType = "Texture is not a three-dimensional, two-dimensional array, two-dimensional multisample array, cube map, or cube map array texture.";
inline constexpr const char *kGenerateMipmapNotAllowed = "Texture format does not support mipmap generation.";
inline constexpr const char *kGenerateMipmapZeroSize = "Cannot generate mipmaps for a zero-size texture in a WebGL context.";
inline constexpr const char *kGeometryOrTessellationShaderBoundForFoveatedDraw = "Invalid to draw with foveation while current bound program uses tessellation or geometry shaders.";
inline constexpr const char *kGeometryShaderExtensionNotEnabled = "GL_EXT_geometry_shader or GL_OES_geometry_shader extension not enabled.";
inline constexpr const char *kGetImageExtensionNotEnabled = "GL_ANGLE_get_image extension not enabled.";
inline constexpr const char *kGetImageCompressed = "Texture is compressed, call GetCompressedTexImage instead.";
inline constexpr const char *kGetImageNotCompressed = "Texture is not compressed, call GetTexImage instead.";
inline constexpr const char *kGLES1Only = "GLES1-only function.";
inline constexpr const char *kImageSizeMustBeZero = "imageSize must be 0 if no texture data is provided.";
inline constexpr const char *kImageSizeTooSmall = "imageSize is too small.";
inline constexpr const char *kImmutableMemoryObject = "The memory object is immutable.";
inline constexpr const char *kImmutableTextureBound = "The value of TEXTURE_IMMUTABLE_FORMAT for the texture currently bound to target on the active texture unit is true.";
inline constexpr const char *kIncompatibleDrawModeAgainstGeometryShader = "Primitive mode is incompatible with the input primitive type of the geometry shader.";
inline constexpr const char *kIncompatibleDrawModeWithTessellationShader = "When tessellation is active the primitive mode must be GL_PATCHES.";
inline constexpr const char *kIncompatibleDrawModeWithoutTessellationShader = "When tessellation is not active the primitive mode must not be GL_PATCHES.";
inline constexpr const char *kIncompatibleTextures = "Texture formats are not compatible.";
inline constexpr const char *kIndexExceedsActiveUniformBlockCount = "Index exceeds active uniform block count.";
inline constexpr const char *kIndexExceedsMaxActiveUniform = "Index must be less than program active uniform count.";
inline constexpr const char *kIndexExceedsMaxActiveUniformBlock = "Index must be less than program active uniform block count.";
inline constexpr const char *kIndexExceedsMaxAtomicCounterBufferBindings = "Index must be less than MAX_ATOMIC_COUNTER_BUFFER_BINDINGS.";
inline constexpr const char *kIndexExceedsMaxDrawBuffer = "Index must be less than MAX_DRAW_BUFFERS.";
inline constexpr const char *kIndexExceedsMaxTransformFeedbackAttribs = "Index must be less than MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS.";
inline constexpr const char *kIndexExceedsMaxUniformBufferBindings = "Index must be less than MAX_UNIFORM_BUFFER_BINDINGS.";
inline constexpr const char *kIndexExceedsMaxVertexAttribute = "Index must be less than MAX_VERTEX_ATTRIBS.";
inline constexpr const char *kIndexExceedsMaxWorkgroupDimensions = "Index must be less than the number of workgroup dimensions (3).";
inline constexpr const char *kIndexExceedsSamples = "Index must be less than the value of SAMPLES.";
inline constexpr const char *kIndexExceedsTransformFeedbackBufferBindings = "Index is greater than or equal to the number of TRANSFORM_FEEDBACK_BUFFER indexed binding points.";
inline constexpr const char *kInsufficientBufferSize = "Insufficient buffer size.";
inline constexpr const char *kInsufficientParams = "More parameters are required than were provided.";
inline constexpr const char *kInsufficientVertexBufferSize = "Vertex buffer is not big enough for the draw call.";
inline constexpr const char *kIntegerOverflow = "Integer overflow.";
inline constexpr const char *kInternalError = "Internal error.";
inline constexpr const char *kInternalErrorFormatNotFound = "Internal error: unknown internal format.";
inline constexpr const char *kInternalFormatRequiresTexture2D = "internalformat is an ETC1 or PVRTC1 format.";
inline constexpr const char *kInternalFormatRequiresTexture2DArray = "internalformat is an ETC2/EAC format and target is not GL_TEXTURE_2D_ARRAY.";
inline constexpr const char *kInternalFormatRequiresTexture2DArrayS3TC = "internalformat is an S3TC format and target is not GL_TEXTURE_2D_ARRAY.";
inline constexpr const char *kInternalFormatRequiresTexture2DArrayRGTC = "internalformat is an RGTC format and target is not GL_TEXTURE_2D_ARRAY.";
inline constexpr const char *kInternalFormatRequiresTexture2DArrayBPTC = "internalformat is a BPTC format and target is not GL_TEXTURE_2D_ARRAY.";
inline constexpr const char *kInternalFormatRequiresTexture2DArrayASTC = "internalformat is an ASTC format and target is not GL_TEXTURE_2D_ARRAY.";
inline constexpr const char *kInvalidAccessBits = "Invalid access bits.";
inline constexpr const char *kInvalidAccessBitsFlush = "The explicit flushing bit may only be set if the buffer is mapped for writing.";
inline constexpr const char *kInvalidAccessBitsRead = "Invalid access bits when mapping buffer for reading.";
inline constexpr const char *kInvalidAccessBitsReadWrite = "Need to map buffer for either reading or writing.";
inline constexpr const char *kInvalidAttachment = "Invalid Attachment Type.";
inline constexpr const char *kInvalidAttribList = "Invalid texture storage attrib list.";
inline constexpr const char *kInvalidBindBufferSize = "Invalid buffer binding size.";
inline constexpr const char *kInvalidBindUniformLocation = "Location must be less than (MAX_VERTEX_UNIFORM_VECTORS + MAX_FRAGMENT_UNIFORM_VECTORS) * 4.";
inline constexpr const char *kInvalidBlendEquation = "Invalid blend equation.";
inline constexpr const char *kInvalidBlendFunction = "Invalid blend function.";
inline constexpr const char *kInvalidBlendStateForYUV = "Blending must be disabled when writing to YUV framebuffers.";
inline constexpr const char *kInvalidBooleanValue = "Invalid boolean value. Must be GL_FALSE or GL_TRUE.";
inline constexpr const char *kInvalidBorder = "Border must be 0.";
inline constexpr const char *kInvalidBufferName = "name is not a valid buffer.";
inline constexpr const char *kInvalidBufferTypes = "Invalid buffer target.";
inline constexpr const char *kInvalidBufferUsage = "Invalid buffer usage enum.";
inline constexpr const char *kInvalidBufferUsageFlags = "Invalid buffer usage flags.";
inline constexpr const char *kInvalidClearMask = "Invalid mask bits.";
inline constexpr const char *kInvalidClientState = "Invalid client vertex array type.";
inline constexpr const char *kInvalidClipPlane = "Invalid clip plane.";
inline constexpr const char *kInvalidColorMaskForYUV = "Red, green, blue color and alpha writes must be enabled when writing to YUV framebuffers.";
inline constexpr const char *kInvalidCombinedImageUnit = "Specified unit must be in [GL_TEXTURE0, GL_TEXTURE0 + GL_MAX_COMBINED_IMAGE_UNITS).";
inline constexpr const char *kInvalidComponents = "Invalid components.";
inline constexpr const char *kInvalidCompressedFormat = "Not a valid compressed texture format.";
inline constexpr const char *kInvalidCompressedImageSize = "Invalid compressed image size.";
inline constexpr const char *kInvalidCompressedRegionSize = "Invalid region for compressed texture format.";
inline constexpr const char *kInvalidConstantColor = "CONSTANT_COLOR (or ONE_MINUS_CONSTANT_COLOR) and CONSTANT_ALPHA (or ONE_MINUS_CONSTANT_ALPHA) cannot be used together as source and destination color factors in the blend function.";
inline constexpr const char *kInvalidCopyCombination = "Invalid copy texture format combination.";
inline constexpr const char *kInvalidCoverageComponents = "components is not one of GL_RGB, GL_RGBA, GL_ALPHA or GL_NONE.";
inline constexpr const char *kInvalidCoverMode = "Invalid cover mode.";
inline constexpr const char *kInvalidExternalCreateFlags = "Create flags must only include bits defined by GL_ANGLE_external_objects_flags.";
inline constexpr const char *kInvalidCullMode = "Cull mode not recognized.";
inline constexpr const char *kInvalidDebugSeverity = "Invalid debug severity.";
inline constexpr const char *kInvalidDebugSource = "Invalid debug source.";
inline constexpr const char *kInvalidDebugSourceType = "If count is greater than zero, source and type cannot be GL_DONT_CARE.";
inline constexpr const char *kInvalidDebugType = "Invalid debug type.";
inline constexpr const char *kInvalidDefaultReadBuffer = "Read buffer must be GL_NONE or GL_BACK when reading from the default framebuffer.";
inline constexpr const char *kInvalidDepthEnum = "Invalid depth enum.";
inline constexpr const char *kInvalidDepthRange = "Near value cannot be greater than far.";
inline constexpr const char *kInvalidDepthStencilDrawBuffer = "Draw buffer must be zero when using depth or stencil.";
inline constexpr const char *kInvalidDestinationTexture = "Destination texture is not a valid texture object.";
inline constexpr const char *kInvalidDestinationTextureType = "Invalid destination texture type.";
inline constexpr const char *kInvalidDrawBuffer = "Invalid draw buffer.";
inline constexpr const char *kInvalidDrawBufferCountForDefault = "The default framebuffer must have exactly one draw buffer.";
inline constexpr const char *kInvalidDrawBufferValue = "Ith value does not match COLOR_ATTACHMENTi or NONE.";
inline constexpr const char *kInvalidDrawMode = "Invalid draw mode.";
inline constexpr const char *kInvalidDrawModeTransformFeedback = "Draw mode must match current transform feedback object's draw mode.";
inline constexpr const char *kInvalidEGLImage = "EGL image is not valid.";
inline constexpr const char *kInvalidElementRange = "Invalid element range.";
inline constexpr const char *kInvalidEmulatedFormat = "Implementation format is emulated.";
inline constexpr const char *kInvalidFence = "Invalid fence object.";
inline constexpr const char *kInvalidFenceCondition = "Invalid value for condition.";
inline constexpr const char *kInvalidFenceState = "Fence must be set.";
inline constexpr const char *kInvalidFillMode = "Invalid fill mode.";
inline constexpr const char *kInvalidFilterTexture = "Texture only supports NEAREST and LINEAR filtering.";
inline constexpr const char *kInvalidFlags = "Invalid value for flags.";
inline constexpr const char *kInvalidFlushOutOfRange = "Flushed range does not fit into buffer mapping dimensions.";
inline constexpr const char *kInvalidFlushTarget = "Attempted to flush a buffer not mapped for explicit flushing.";
inline constexpr const char *kInvalidFlushZero = "Attempted to flush buffer object zero.";
inline constexpr const char *kInvalidFogDensity = "Invalid fog density (must be nonnegative).";
inline constexpr const char *kInvalidFogMode = "Invalid fog mode.";
inline constexpr const char *kInvalidFogParameter = "Invalid fog parameter.";
inline constexpr const char *kInvalidFormat = "Invalid format.";
inline constexpr const char *kInvalidFormatCombination = "Invalid combination of format, type and internalFormat.";
inline constexpr const char *kInvalidFragDataNamePointer = "Invalid fragment output name pointer.";
inline constexpr const char *kInvalidFragmentInputBinding = "No such binding.";
inline constexpr const char *kInvalidFramebufferAttachmentParameter = "Invalid parameter name for framebuffer attachment.";
inline constexpr const char *kInvalidFramebufferLayer = "Framebuffer layer cannot be less than 0 or greater than GL_MAX_FRAMEBUFFER_LAYERS_EXT.";
inline constexpr const char *kInvalidFramebufferName = "name is not a valid framebuffer.";
inline constexpr const char *kInvalidFramebufferTarget = "Invalid framebuffer target.";
inline constexpr const char *kInvalidFramebufferTextureLevel = "Mipmap level must be 0 when attaching a texture.";
inline constexpr const char *kInvalidHandleType = "Invalid handle type.";
inline constexpr const char *kInvalidImageAccess = "access is not one of the supported tokens.";
inline constexpr const char *kInvalidImageLayout = "Invalid image layout.";
inline constexpr const char *kInvalidImageFormat = "format is not one of supported image unit formats.";
inline constexpr const char *kInvalidIndentifier = "Invalid identifier.";
inline constexpr const char *kInvalidIndirectOffset = "indirect must be a multiple of the size of uint in basic machine units.";
inline constexpr const char *kInvalidInternalFormat = "Invalid internal format 0x%04X.";
inline constexpr const char *kInvalidLight = "Invalid light.";
inline constexpr const char *kInvalidLightModelParameter = "Invalid light model parameter.";
inline constexpr const char *kInvalidLightParameter = "Invalid light parameter.";
inline constexpr const char *kInvalidLogicOp = "Invalid logical operation.";
inline constexpr const char *kInvalidMapPointerQuery = "GL_BUFFER_MAP_POINTER can only be queried with GetBufferPointerv.";
inline constexpr const char *kInvalidMaterialFace = "Invalid material face.";
inline constexpr const char *kInvalidMaterialParameter = "Invalid material parameter.";
inline constexpr const char *kInvalidMatrixMode = "Invalid matrix mode.";
inline constexpr const char *kInvalidMemoryBarrierBit = "Invalid memory barrier bit.";
inline constexpr const char *kInvalidMemoryObject = "Invalid memory object.";
inline constexpr const char *kInvalidMemoryObjectParameter = "Invalid memory object parameter.";
inline constexpr const char *kInvalidMipLevel = "Level of detail outside of range.";
inline constexpr const char *kInvalidMipLevels = "Invalid level count.";
inline constexpr const char *kInvalidMultisampledFramebufferOperation = "Invalid operation on multisampled framebuffer.";
inline constexpr const char *kInvalidMultitextureUnit = "Specified unit must be in [GL_TEXTURE0, GL_TEXTURE0 + GL_MAX_TEXTURE_UNITS).";
inline constexpr const char *kInvalidName = "Invalid name.";
inline constexpr const char *kInvalidNameCharacters = "Name contains invalid characters.";
inline constexpr const char *kInvalidOriginEnum = "Invalid origin enum.";
inline constexpr const char *kInvalidPackParametersForWebGL = "Invalid combination of pack parameters for WebGL.";
inline constexpr const char *kInvalidPerfMonitor = "Invalid perf monitor.";
inline constexpr const char *kInvalidPerfMonitorCounter = "Invalid perf monitor counter.";
inline constexpr const char *kInvalidPerfMonitorGroup = "Invalid perf monitor counter group.";
inline constexpr const char *kInvalidPname = "Invalid pname.";
inline constexpr const char *kInvalidPointerQuery = "Invalid pointer query.";
inline constexpr const char *kInvalidPointParameter = "Invalid point parameter.";
inline constexpr const char *kInvalidPointParameterValue = "Invalid point parameter value (must be non-negative).";
inline constexpr const char *kInvalidPointSizeValue = "Invalid point size (must be positive).";
inline constexpr const char *kInvalidPolygonMode = "Invalid polygon mode.";
inline constexpr const char *kInvalidPrecision = "Invalid or unsupported precision type.";
inline constexpr const char *kInvalidPrimitiveMode = "Invalid primitive mode.";
inline constexpr const char *kInvalidProgramBinaryFormat = "Program binary format is not valid.";
inline constexpr const char *kInvalidProgramInterface = "Invalid program interface.";
inline constexpr const char *kInvalidProgramName = "Program object expected.";
inline constexpr const char *kInvalidProgramPipelineName = "name is not a valid program pipeline.";
inline constexpr const char *kInvalidProgramResourceIndex = "Invalid program resource index.";
inline constexpr const char *kInvalidProgramResourceProperty = "Invalid program resource property.";
inline constexpr const char *kInvalidProjectionMatrix = "Invalid projection matrix. Left/right, top/bottom, near/far intervals cannot be zero, and near/far cannot be less than zero.";
inline constexpr const char *kInvalidPropCount = "Invalid propCount.";
inline constexpr const char *kInvalidPropertyForProgramInterface = "Not an allowed program resource property for this program interface.";
inline constexpr const char *kInvalidProvokingVertex = "Invalid provoking vertex.";
inline constexpr const char *kInvalidQueryId = "Invalid query Id.";
inline constexpr const char *kInvalidQueryName = "name is not a valid query.";
inline constexpr const char *kInvalidQueryTarget = "Invalid query target.";
inline constexpr const char *kInvalidQueryType = "Invalid query type.";
inline constexpr const char *kInvalidRange = "Invalid range.";
inline constexpr const char *kInvalidReadBuffer = "Invalid read buffer.";
inline constexpr const char *kInvalidRenderbufferInternalFormat = "Invalid renderbuffer internalformat.";
inline constexpr const char *kInvalidRenderbufferName = "name is not a valid renderbuffer.";
inline constexpr const char *kInvalidRenderbufferTarget = "Invalid renderbuffer target.";
inline constexpr const char *kInvalidRenderbufferTextureParameter = "Invalid parameter name for renderbuffer attachment.";
inline constexpr const char *kInvalidRenderbufferWidthHeight = "Renderbuffer width and height cannot be negative and cannot exceed maximum texture size.";
inline constexpr const char *kInvalidResetStatus = "Reset status is not valid.";
inline constexpr const char *kInvalidSampleMaskNumber = "MaskNumber cannot be greater than or equal to the value of MAX_SAMPLE_MASK_WORDS.";
inline constexpr const char *kInvalidSampler = "Sampler is not valid.";
inline constexpr const char *kInvalidSamplerName = "name is not a valid sampler.";
inline constexpr const char *kInvalidShaderBinaryFormat = "Invalid shader binary format.";
inline constexpr const char *kInvalidShaderBinary = "Invalid or incompatible shader binary.";
inline constexpr const char *kMismatchedShaderBinaryType = "Mismatched shader binary and shader object type.";
inline constexpr const char *kInvalidShaderCount = "Invalid Shader count.";
inline constexpr const char *kInvalidShaderName = "Shader object expected.";
inline constexpr const char *kInvalidShaderType = "Invalid shader type.";
inline constexpr const char *kInvalidShadingCombinerOp = "Invalid shading CombinerOp.";
inline constexpr const char *kInvalidShadingModel = "Invalid shading model.";
inline constexpr const char *kInvalidShadingRate = "Invalid shading rate.";
inline constexpr const char *kInvalidSourceTexture = "Source texture is not a valid texture object.";
inline constexpr const char *kInvalidSourceTextureInternalFormat = "Source texture internal format is invalid.";
inline constexpr const char *kInvalidSourceTextureLevel = "Invalid source texture level.";
inline constexpr const char *kInvalidSourceTextureSize = "Invalid source texture height or width.";
inline constexpr const char *kInvalidSourceTextureType = "Source texture must be a valid texture type.";
inline constexpr const char *kInvalidStencil = "Invalid stencil.";
inline constexpr const char *kInvalidStencilBitMask = "Invalid stencil bit mask.";
inline constexpr const char *kInvalidSyncPointer = "Not a valid sync pointer.";
inline constexpr const char *kInvalidTarget = "Invalid target.";
inline constexpr const char *kInvalidTextureCombine = "Invalid texture combine mode.";
inline constexpr const char *kInvalidTextureCombineOp = "Invalid texture combine operand.";
inline constexpr const char *kInvalidTextureCombineSrc = "Invalid texture combine source.";
inline constexpr const char *kInvalidTextureEnvMode = "Invalid texture environment mode.";
inline constexpr const char *kInvalidTextureEnvParameter = "Invalid texture environment parameter.";
inline constexpr const char *kInvalidTextureEnvScale = "Invalid texture environment scale.";
inline constexpr const char *kInvalidTextureEnvTarget = "Invalid texture environment target.";
inline constexpr const char *kInvalidTextureFilterParam = "Texture filter not recognized.";
inline constexpr const char *kInvalidTextureLevel = "Texture level does not exist.";
inline constexpr const char *kInvalidTextureName = "Not a valid texture object name.";
inline constexpr const char *kInvalidTextureRange = "Cannot be less than 0 or greater than maximum number of textures.";
inline constexpr const char *kInvalidTextureTarget = "Invalid or unsupported texture target.";
inline constexpr const char *kInvalidTextureType = "Texture has incompatible target.";
inline constexpr const char *kInvalidTextureWrap = "Texture wrap mode not recognized.";
inline constexpr const char *kInvalidTimeout = "Invalid value for timeout.";
inline constexpr const char *kInvalidTransformation = "Invalid transformation.";
inline constexpr const char *kInvalidTransformFeedbackAttribsCount = "Count exceeds MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS.";
inline constexpr const char *kInvalidTransformFeedbackName = "name is not a valid transform feedback.";
inline constexpr const char *kInvalidType = "Invalid type.";
inline constexpr const char *kInvalidUniformCount = "Only array uniforms may have count > 1.";
inline constexpr const char *kInvalidUniformLocation = "Invalid uniform location.";
inline constexpr const char *kInvalidUniformValuePointer = "Invalid uniform value pointer.";
inline constexpr const char *kInvalidUnpackAlignment = "Unpack alignment must be 1, 2, 4 or 8.";
inline constexpr const char *kInvalidUnpackParametersForWebGL = "Invalid combination of unpack parameters for WebGL.";
inline constexpr const char *kInvalidExternalUsageFlags = "Usage flags must only include bits defined by GL_ANGLE_external_objects_flags.";
inline constexpr const char *kInvalidValueExceedsMaxPatchSize = "Value must be less than or equal to MAX_PATCH_SIZE.";
inline constexpr const char *kInvalidValueNonPositive = "Value must be greater than zero.";
inline constexpr const char *kInvalidVaryingLocation = "Location exceeds max varying.";
inline constexpr const char *kInvalidVertexArray = "Vertex array does not exist.";
inline constexpr const char *kInvalidVertexArrayName = "name is not a valid vertex array.";
inline constexpr const char *kInvalidVertexAttribSize2101010 = "Type is INT_2_10_10_10_REV or UNSIGNED_INT_2_10_10_10_REV and size is not 4.";
inline constexpr const char *kInvalidVertexAttribSize1010102 = "Type is INT_10_10_10_2_OES or UNSIGNED_INT_10_10_10_2_OES and size is not 3 or 4.";
inline constexpr const char *kInvalidVertexAttrSize = "Vertex attribute size must be 1, 2, 3, or 4.";
inline constexpr const char *kInvalidVertexPointerSize = "Size for built-in vertex attribute is outside allowed range.";
inline constexpr const char *kInvalidVertexPointerStride = "Invalid stride for built-in vertex attribute.";
inline constexpr const char *kInvalidVertexPointerType = "Invalid type for built-in vertex attribute.";
inline constexpr const char *kInvalidWidth = "Invalid width.";
inline constexpr const char *kInvalidWrapModeTexture = "Invalid wrap mode for texture type.";
inline constexpr const char *kInvalidZOffset = "zoffset is larger than MAX_3D_TEXTURE_SIZE-1.";
inline constexpr const char *kLengthZero = "Length must not be zero.";
inline constexpr const char *kLevelNotZero = "Texture level must be zero.";
inline constexpr const char *kLightParameterOutOfRange = "Light parameter out of range.";
inline constexpr const char *kMapOutOfRange = "Mapped range does not fit into buffer dimensions.";
inline constexpr const char *kMaterialParameterOutOfRange = "Material parameter out of range.";
inline constexpr const char *kMatrixStackOverflow = "Current matrix stack is full.";
inline constexpr const char *kMatrixStackUnderflow = "Current matrix stack has only a single matrix.";
inline constexpr const char *kMaxActiveVariablesInterface = "MAX_NUM_ACTIVE_VARIABLES requires a buffer or block interface.";
inline constexpr const char *kMismatchedFormat = "Format must match internal format.";
inline constexpr const char *kMismatchedTargetAndFormat = "Invalid texture target and format combination.";
inline constexpr const char *kMismatchedTypeAndFormat = "Invalid format and type combination.";
inline constexpr const char *kMismatchedVariableProgram = "Variable is not part of the current program.";
inline constexpr const char *kMissingName = "No name given.";
inline constexpr const char *kMissingReadAttachment = "Missing read attachment.";
inline constexpr const char *kMissingTexture = "No Texture is bound to the specified target.";
inline constexpr const char *kMissingTextureName = "texture is not the name of an existing texture object.";
inline constexpr const char *kMultisampleArrayExtensionOrES32Required = "GL_OES_texture_storage_multisample_2d_array or GLES 3.2 required.";
inline constexpr const char *kMultisampleTextureExtensionOrES31Required = "GL_ANGLE_texture_multisample or GLES 3.1 required.";
inline constexpr const char *kMultiviewActive = "The number of views in the active draw framebuffer is greater than 1.";
inline constexpr const char *kMultiviewMismatch = "The number of views in the active program and draw framebuffer does not match.";
inline constexpr const char *kMultiviewReadFramebuffer = "The active read framebuffer object has multiview attachments.";
inline constexpr const char *kMultiviewTimerQuery = "There is an active query for target GL_TIME_ELAPSED_EXT when the number of views in the active draw framebuffer is greater than 1.";
inline constexpr const char *kMultiviewTransformFeedback = "There is an active transform feedback object when the number of views in the active draw framebuffer is greater than 1.";
inline constexpr const char *kMultiviewViewsTooLarge = "numViews cannot be greater than GL_MAX_VIEWS_ANGLE.";
inline constexpr const char *kMultiviewViewsTooSmall = "numViews cannot be less than 1.";
inline constexpr const char *kMustHaveElementArrayBinding = "Must have element array buffer bound.";
inline constexpr const char *kNameStartsWithReservedPrefix = "Name starts with a reserved prefix.";
inline constexpr const char *kNegativeAttachments = "Negative number of attachments.";
inline constexpr const char *kNegativeBaseViewIndex = "Negative baseViewIndex.";
inline constexpr const char *kNegativeBufSize = "Negative bufSize.";
inline constexpr const char *kNegativeCount = "Negative count.";
inline constexpr const char *kNegativeDrawcount = "Negative drawcount.";
inline constexpr const char *kNegativeHeightWidthDepth = "Negative height, width, or depth.";
inline constexpr const char *kNegativeLayer = "Negative layer.";
inline constexpr const char *kNegativeLength = "Negative length.";
inline constexpr const char *kNegativeLevel = "Negative level.";
inline constexpr const char *kNegativeLocation = "Negative location.";
inline constexpr const char *kNegativeMaxCount = "Negative maxcount.";
inline constexpr const char *kNegativeOffset = "Negative offset.";
inline constexpr const char *kNegativeParam = "Negative param.";
inline constexpr const char *kNegativePrimcount = "Negative primcount.";
inline constexpr const char *kNegativeSize = "Negative size.";
inline constexpr const char *kNegativeStart = "Negative start.";
inline constexpr const char *kNegativeStride = "Negative stride.";
inline constexpr const char *kNegativeXYZ = "Negative x, y, or z.";
inline constexpr const char *kNoActiveComputeShaderStage = "No active compute shader stage in this program.";
inline constexpr const char *kNoActiveTessellationControlShaderStage = "No active tessellation control shader stage in this program.";
inline constexpr const char *kNoActiveTessellationEvaluationShaderStage = "No active tessellation evaluation shader stage in this program.";
inline constexpr const char *kNoActiveGeometryShaderStage = "No active geometry shader stage in this program.";
inline constexpr const char *kNoActiveGraphicsShaderStage = "It is a undefined behaviour to render without vertex shader stage or fragment shader stage.";
inline constexpr const char *kNoActiveProgramWithComputeShader = "No active program for the compute shader stage.";
inline constexpr const char *kNoDefinedClearConversion = "No defined conversion between clear value and attachment format.";
inline constexpr const char *kNonPositiveDrawTextureDimension = "Both width and height argument of drawn texture must be positive.";
inline constexpr const char *kNonPositiveSize = "Size must be greater than 0.";
inline constexpr const char *kNoProgramBinaryFormats = "No program binary formats supported.";
inline constexpr const char *kNoReadFramebuffer = "No active read framebuffer.";
inline constexpr const char *kNoSampleAlphaToCoveragesLimitation = "Current renderer doesn't support alpha-to-coverage.";
inline constexpr const char *kNotTextureComplete = "The texture is not complete.";
inline constexpr const char *kNoTransformArray = "No transform array given.";
inline constexpr const char *kNoTransformFeedbackOutputVariables = "The active program has specified no output variables to record.";
inline constexpr const char *kNoZeroDivisor = "At least one enabled attribute must have a divisor of zero.";
inline constexpr const char *kObjectNotGenerated = "Object cannot be used because it has not been generated.";
inline constexpr const char *kOffsetAlignment = "offset must be a multiple of 4.";
inline constexpr const char *kOffsetAndSizeAlignment = "Offset and size must be multiple of 4.";
inline constexpr const char *kOffsetMustBeMultipleOfType = "Offset must be a multiple of the passed in datatype.";
inline constexpr const char *kOffsetMustBeMultipleOfUint = "Offset must be a multiple of sizeof(uint) in basic machine units.";
inline constexpr const char *kOffsetOverflow = "Offset overflows texture dimensions.";
inline constexpr const char *kOtherQueryActive = "Other query is active.";
inline constexpr const char *kOutsideOfBounds = "Parameter outside of bounds.";
inline constexpr const char *kParamOverflow = "The provided parameters overflow with the provided buffer.";
inline constexpr const char *kBufferOffsetNotAligned = "Buffer offset in ReadPixels not aligned with type.";
inline constexpr const char *kPerfMonitorNotActive = "Perf monitor is not started.";
inline constexpr const char *kPixelDataNotNull = "Pixel data must be null.";
inline constexpr const char *kPixelDataNull = "Pixel data cannot be null.";
inline constexpr const char *kPixelPackBufferBoundForTransformFeedback = "It is undefined behavior to use a pixel pack buffer that is bound for transform feedback.";
inline constexpr const char *kPixelUnpackBufferBoundForTransformFeedback = "It is undefined behavior to use a pixel unpack buffer that is bound for transform feedback.";
inline constexpr const char *kPLSActive = "Operation not permitted while pixel local storage is active.";
inline constexpr const char *kPLSColorAttachmentReserved = "Color attachment is actively reserved for pixel local storage.";
inline constexpr const char *kActivePLSBackingTexture = "Operation not permitted on an active pixel local storage backing texture.";
inline constexpr const char *kPLSCapNotAllowed = "Cap 0x%04X cannot be enabled or disabled while pixel local storage is active.";
inline constexpr const char *kPLSDefaultFramebufferBound = "Default framebuffer object name 0 does not support pixel local storage.";
inline constexpr const char *kPLSDimensionsDontMatchRenderingArea = "Pixel local storage backing texture dimensions not equal to the rendering area.";
inline constexpr const char *kPLSDitherEnabled = "Attempted to begin pixel local storage with GL_DITHER enabled.";
inline constexpr const char *kPLSDrawBufferExceedsCombinedAttachmentLimit = "Argument <%s> must be less than (MAX_COMBINED_DRAW_BUFFERS_AND_PIXEL_LOCAL_STORAGE_PLANES_ANGLE - ACTIVE_PIXEL_LOCAL_STORAGE_PLANES_ANGLE) when pixel local storage is active.";
inline constexpr const char *kPLSDrawProgramActivePlanesUnused = "Active pixel local storage plane(s) are not referenced by the draw program.";
inline constexpr const char *kPLSDrawProgramFormatMismatch = "Pixel local storage formats in the draw program do not match actively bound planes.";
inline constexpr const char *kPLSDrawProgramPlanesInactive = "Draw program references pixel local storage plane(s) that are not currently active.";
inline constexpr const char *kPLSEnablingDeinitializedPlane = "Attempted to enable a pixel local storage plane that is in a deinitialized state.";
inline constexpr const char *kPLSInactive = "Pixel local storage is not active.";
inline constexpr const char *kPLSInvalidInternalformat = "Invalid pixel local storage internal format.";
inline constexpr const char *kPLSInvalidLoadOperation = "Invalid pixel local storage Load Operation: 0x%04X.";
inline constexpr const char *kPLSInvalidStoreOperation = "Invalid pixel local storage Store Operation: 0x%04X.";
inline constexpr const char *kPLSInvalidTextureType = "Invalid pixel local storage texture type.";
inline constexpr const char *kPLSKeepingMemorylessPlane = "Load Operation GL_LOAD_OP_LOAD_ANGLE is invalid for memoryless planes.";
inline constexpr const char *kPLSLevelIndexOutOfRange = "Mipmap level for PLS backing texture outside the effective base/max range.";
inline constexpr const char *kPLSLoadOpsNULL = "<loadops> cannot be null.";
inline constexpr const char *kPLSMaxCombinedDrawBuffersAndPlanesExceded = "Framebuffer cannot have images attached to color attachment points on or after COLOR_ATTACHMENT0 + MAX_COMBINED_DRAW_BUFFERS_AND_PIXEL_LOCAL_STORAGE_PLANES_ANGLE - <n>.";
inline constexpr const char *kPLSMismatchedBackingTextureSizes = "Mismatched pixel local storage backing texture sizes.";
inline constexpr const char *kPLSMultisamplingEnabled = "Attempted to begin pixel local storage with a multisampled framebuffer.";
inline constexpr const char *kPLSNNotEqualActivePlanes = "<n> != ACTIVE_PIXEL_LOCAL_STORAGE_PLANES_ANGLE.";
inline constexpr const char *kPLSNoAttachmentsNoTextureBacked = "Draw framebuffer has no attachments and no enabled, texture-backed pixel local storage planes.";
inline constexpr const char *kPLSInterruptOverflow = "Pixel local storage does not support more than 255 nested interruptions.";
inline constexpr const char *kPLSInterrupted = "Pixel local storage on the draw framebuffer is interrupted.";
inline constexpr const char *kPLSNotInterrupted = "Pixel local storage on the draw framebuffer is not interrupted.";
inline constexpr const char *kPLSParamsNULL = "<params> cannot be null.";
inline constexpr const char *kPLSPlaneLessThanZero = "Plane cannot be less than 0.";
inline constexpr const char *kPLSPlaneOutOfRange = "Plane must be less than GL_MAX_PIXEL_LOCAL_STORAGE_PLANES_ANGLE.";
inline constexpr const char *kPLSPlanesLessThanOne = "Planes must be greater than 0.";
inline constexpr const char *kPLSPlanesOutOfRange = "Planes must be less than or equal to GL_MAX_PIXEL_LOCAL_STORAGE_PLANES_ANGLE.";
inline constexpr const char *kPLSAdvancedBlendEnabled = "Attempted to begin pixel local storage with an advanced blend equation enabled.";
inline constexpr const char *kPLSAdvancedBlendNotSupported = "Advanced blend equations are not supported when pixel local storage is active.";
inline constexpr const char *kPLSRasterizerDiscardEnabled = "Attempted to begin pixel local storage with GL_RASTERIZER_DISCARD enabled.";
inline constexpr const char *kPLSSingleTexImageMultiplePlanes = "A single texture slice is bound to multiple active pixel local storage planes.";
inline constexpr const char *kPLSSingleTexImagePLSAndAttachment = "A single texture slice is simultaneously bound to an active pixel local storage plane and attached to an enabled drawbuffer.";
inline constexpr const char *kPLSTransformFeedbackActive = "Attempted to begin pixel local storage with transform feedback active.";
inline constexpr const char *kPLSTiledRenderingActive = "Attempted to begin pixel local storage with QCOM_tiled_rendering active.";
inline constexpr const char *kPLSReservedDrawBufferInUse = "When beginning pixel local storage, glDrawBuffers must all be GL_NONE at indices greater than or equal to: min(GL_MAX_COLOR_ATTACHMENTS_WITH_ACTIVE_PLS_ANGLE, GL_MAX_COMBINED_DRAW_BUFFERS_AND_PLS_PLANES_ANGLE - <n>).";
inline constexpr const char *kPLSSecondaryBlendEnabled = "Attempted to begin pixel local storage with a blend function requiring the secondary color input.";
inline constexpr const char *kPLSSecondaryBlendNotSupported = "Blend functions requiring the secondary color input are not supported when pixel local storage is active.";
inline constexpr const char *kPointSizeArrayExtensionNotEnabled = "GL_OES_point_size_array not enabled.";
inline constexpr const char *kProgramDoesNotExist = "Program doesn't exist.";
inline constexpr const char *kProgramInterfaceMustBeProgramOutput = "programInterface must be set to GL_PROGRAM_OUTPUT.";
inline constexpr const char *kProgramNotBound = "A program must be bound.";
inline constexpr const char *kProgramNotLinked = "Program not linked.";
inline constexpr const char *kQueryActive = "Query is active.";
inline constexpr const char *kQueryInactive = "Query is not active.";
inline constexpr const char *kQueryTargetMismatch = "Query type does not match target.";
inline constexpr const char *kReadBufferNone = "Read buffer is GL_NONE.";
inline constexpr const char *kReadBufferNotAttached = "Read buffer has no attachment.";
inline constexpr const char *kRectangleTextureCompressed = "Rectangle texture cannot have a compressed format.";
inline constexpr const char *kRelativeOffsetTooLarge = "relativeOffset cannot be greater than MAX_VERTEX_ATTRIB_RELATIVE_OFFSET.";
inline constexpr const char *kRenderableInternalFormat = "SizedInternalformat must be color-renderable, depth-renderable, or stencil-renderable.";
inline constexpr const char *kRenderbufferNotBound = "A renderbuffer must be bound.";
inline constexpr const char *kResourceMaxRenderbufferSize = "Desired resource size is greater than max renderbuffer size.";
inline constexpr const char *kResourceMaxTextureSize = "Desired resource size is greater than max texture size.";
inline constexpr const char *kRobustResourceInitializationExtensionRequired = "EGL_ANGLE_robust_resource_initialization not enabled.";
inline constexpr const char *kSamplerFormatMismatch = "Mismatch between texture format and sampler type (signed/unsigned/float/shadow).";
inline constexpr const char *kSamplesOutOfRange = "Samples value is negative or greater than maximum supported value for the format.";
inline constexpr const char *kSamplerUniformValueOutOfRange = "Sampler uniform value out of range.";
inline constexpr const char *kSamplesZero = "Samples may not be zero.";
inline constexpr const char *kShaderAttachmentHasShader = "Shader attachment already has a shader.";
inline constexpr const char *kShaderSourceInvalidCharacters = "Shader source contains invalid characters.";
inline constexpr const char *kShaderStorageBufferOffsetAlignment = "Offset must be multiple of value of SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT.";
inline constexpr const char *kShaderToDetachMustBeAttached = "Shader to be detached must be currently attached to the program.";
inline constexpr const char *kShadingRateExtensionNotAvailable = "GL_QCOM_shading_rate extension not available.";
inline constexpr const char *kSourceLevelNotDefined = "The source level of the source texture must be defined.";
inline constexpr const char *kSourceTextureLevelZeroDefined = "Source texture must level 0 defined.";
inline constexpr const char *kSourceTextureMustBeCompressed = "Source texture must have a compressed internal format.";
inline constexpr const char *kSourceTextureTooSmall = "The specified dimensions are outside of the bounds of the texture.";
inline constexpr const char *kStencilReferenceMaskOrMismatch = "Stencil reference and mask values must be the same for front facing and back facing triangles.";
inline constexpr const char *kStrideExceedsWebGLLimit = "Stride is over the maximum stride allowed by WebGL.";
inline constexpr const char *kStrideMustBeMultipleOfType = "Stride must be a multiple of the passed in datatype.";
inline constexpr const char *kSyncMissing = "Sync object does not exist.";
inline constexpr const char *kTessellationShaderEXTNotEnabled = "GL_EXT_tessellation_shader extension not enabled.";
inline constexpr const char *kTessellationShaderRequiresBothControlAndEvaluation = "Tessellation requires both control and evaluation shaders.";
inline constexpr const char *kTessellationShaderRequiresVertexShader = "Any command that transfers vertices to the GL requires a vertex shader if the current program uses a tessellation shader.";
inline constexpr const char *kTextureBufferExtensionNotAvailable = "Texture buffer extension not available.";
inline constexpr const char *kTextureBufferOffsetAlignment = "Offset must be multiple of value of TEXTURE_BUFFER_OFFSET_ALIGNMENT.";
inline constexpr const char *kTextureBufferSize = "Texture buffer size must be a positive integer.";
inline constexpr const char *kTextureBufferSizeOffset = "Texture buffer offset + size must be less than or equal to BUFFER_SIZE.";
inline constexpr const char *kTextureBufferTarget = "Target must be TEXTURE_BUFFER.";
inline constexpr const char *kTextureBufferInternalFormat = "Internal format is not an accepted sized internal format.";
inline constexpr const char *kTextureBufferInvalidBuffer = "If buffer is nonzero, it must match the name of an existing buffer object.";
inline constexpr const char *kTextureFixedCompressedNotSupportBindImageTexture = "Fixed rate compressed texture image not supported in glBindImageTexture.";
inline constexpr const char *kTextureFormatMismatch = "Passed in texture target and format must match the one originally used to define the texture.";
inline constexpr const char *kTextureFoveationNotEnabled = "glTextureFoveationParametersQCOM called on a texture that does not support GL_FOVEATION_ENABLE_BIT_QCOM.";
inline constexpr const char *kTextureIsCompressed = "Texture is compressed.";
inline constexpr const char *kTextureIsImmutable = "Texture is immutable.";
inline constexpr const char *kTextureIsNotImmutable = "Texture is not immutable.";
inline constexpr const char *kTextureIsNeitherImmutableNorTextureBuffer = "Texture is not the name of an immutable texture object or a buffer texture.";
inline constexpr const char *kTextureLayerOutOfRange = "Layer is larger than texture depth.";
inline constexpr const char *kTextureLevelOutOfRange = "Level is larger than texture level count.";
inline constexpr const char *kTextureNotBound = "A texture must be bound.";
inline constexpr const char *kTextureNotPow2 = "The texture is a non-power-of-two texture.";
inline constexpr const char *kTextureRectangleNotSupported = "Context does not support GL_ANGLE_texture_rectangle.";
inline constexpr const char *kTextureSizeTooSmall = "Texture dimensions must all be greater than zero.";
inline constexpr const char *kTextureStorageCompressionExtensionRequired = "GL_EXT_texture_storage_compression not enabled.";
inline constexpr const char *kTextureTargetInvalidForCopyImage = "Texture target is TEXTURE_BUFFER or does not match the type of the texture.";
inline constexpr const char *kTextureTargetMismatch = "Textarget must match the texture target type.";
inline constexpr const char *kTextureTargetMismatchWithLabel = "Textarget must match the texture target type. Requested: %d Texture's: %d label: %s.";
inline constexpr const char *kTextureTargetRequiresES31 = "Texture target requires at least OpenGL ES 3.1.";
inline constexpr const char *kTextureTypeConflict = "Two textures of different types use the same sampler location.";
inline constexpr const char *kTextureTypeMismatch = "Passed in texture type must match the one originally used to define the texture.";
inline constexpr const char *kTextureWidthOrHeightOutOfRange = "Width and height must be less than or equal to GL_MAX_TEXTURE_SIZE.";
inline constexpr const char *kTextureDepthOutOfRange = "Depth must be less than or equal to MAX_ARRAY_TEXTURE_LAYERS.";
inline constexpr const char *kTilingEndCalledWithoutStart = "EndTiling called without corresponding StartTiling.";
inline constexpr const char *kTilingStartCalledWithoutEnd = "StartTiling called without corresponding EndTiling.";
inline constexpr const char *kTransfomFeedbackAlreadyActive = "Transform feedback is already active.";
inline constexpr const char *kTransformFeedbackActiveDelete = "Attempt to delete an active transform feedback.";
inline constexpr const char *kTransformFeedbackActiveDuringLink = "Cannot link program while program is associated with an active transform feedback object.";
inline constexpr const char *kTransformFeedbackBufferDoubleBound = "A transform feedback buffer that would be written to is also bound to a non-transform-feedback target, which would cause undefined behavior.";
inline constexpr const char *kTransformFeedbackBufferMissing = "Every binding point used in transform feedback mode must have a buffer object bound.";
inline constexpr const char *kTransformFeedbackBufferMultipleOutputs = "Transform feedback has a buffer bound to multiple outputs.";
inline constexpr const char *kTransformFeedbackBufferTooSmall = "Not enough space in bound transform feedback buffers.";
inline constexpr const char *kTransformFeedbackDoesNotExist = "Transform feedback object that does not exist.";
inline constexpr const char *kTransformFeedbackNotActive = "No Transform Feedback object is active.";
inline constexpr const char *kTransformFeedbackNotPaused = "The active Transform Feedback object is not paused.";
inline constexpr const char *kTransformFeedbackPaused = "The active Transform Feedback object is paused.";
inline constexpr const char *kTransformFeedbackProgramBinary = "Cannot change program binary while program is associated with an active transform feedback object.";
inline constexpr const char *kTransformFeedbackTargetActive = "Target is TRANSFORM_FEEDBACK_BUFFER and transform feedback is currently active.";
inline constexpr const char *kTransformFeedbackUseProgram = "Cannot change active program while transform feedback is unpaused.";
inline constexpr const char *kTransformFeedbackVaryingIndexOutOfRange = "Index must be less than the transform feedback varying count in the program.";
inline constexpr const char *kTypeNotUnsignedShortByte = "Only UNSIGNED_SHORT and UNSIGNED_BYTE types are supported.";
inline constexpr const char *kUniformBlockNameNull = "Uniform block name can not be null.";
inline constexpr const char *kUniformBufferBoundForTransformFeedback = "It is undefined behavior to use an uniform buffer that is bound for transform feedback.";
inline constexpr const char *kUniformBufferOffsetAlignment = "Offset must be multiple of value of UNIFORM_BUFFER_OFFSET_ALIGNMENT.";
inline constexpr const char *kUniformBufferTooSmall = "It is undefined behaviour to use a uniform buffer that is too small.";
inline constexpr const char *kUniformBufferUnbound = "It is undefined behaviour to have a used but unbound uniform buffer.";
inline constexpr const char *kUniformNameNull = "Uniform name is null.";
inline constexpr const char *kUniformSizeMismatch = "Uniform size does not match uniform method.";
inline constexpr const char *kUniformTypeMismatch = "Uniform type does not match uniform method.";
inline constexpr const char *kUnimplementedComputeShaderPrecision = "Compute shader precision not yet implemented.";
inline constexpr const char *kUnknownParameter = "Unknown parameter value.";
inline constexpr const char *kUnsizedInternalFormatUnsupported = "Internalformat is one of the unsupported unsized base internalformats.";
inline constexpr const char *kUnsupportedDrawModeForTransformFeedback = "The draw command is unsupported when transform feedback is active and not paused.";
inline constexpr const char *kUnsupportedFloatBlending = "GL_BLEND with floating-point color attachments requires the EXT_float_blend extension.";
inline constexpr const char *kUnsupportedColorMaskForSharedExponentColorBuffer = "Color writemask for a GL_RGB9_E5 draw buffer must have the same values for red, green, and blue channels.";
inline constexpr const char *kVertexArrayNoBuffer = "An enabled vertex array has no buffer.";
inline constexpr const char *kVertexArrayNoBufferPointer = "An enabled vertex array has no buffer and no pointer.";
inline constexpr const char *kVertexAttributeValueNULL = "Vertex attribute cannot be null.";
inline constexpr const char *kVertexBufferBoundForTransformFeedback = "It is undefined behavior to use a vertex buffer that is bound for transform feedback.";
inline constexpr const char *kVertexShaderTypeMismatch = "Vertex shader input type does not match the type of the bound vertex attribute.";
inline constexpr const char *kViewportNegativeSize = "Negative viewport size.";
inline constexpr const char *kViewsExceedMaxArrayLayers = "baseViewIndex+numViews cannot be greater than GL_MAX_ARRAY_TEXTURE_LAYERS.";
inline constexpr const char *kWebGLNameLengthLimitExceeded = "Name is longer than %d characters.";
inline constexpr const char *kYUVOutputMissmatch = "Program and framebuffer YUV output state does not match.";
inline constexpr const char *kYUVTargetExtensionRequired = "GL_EXT_YUV_target not enabled.";
inline constexpr const char *kZeroBoundToTarget = "Zero is bound to target.";
inline constexpr const char *kUnrecognizedShaderStageBit = "Unrecognized shader stage bit.";
inline constexpr const char *kProgramNotSeparable = "Program object was not linked with its PROGRAM_SEPARABLE status set.";
inline constexpr const char *kProgramPipelineDoesNotExist = "Program pipeline does not exist.";
inline constexpr const char *kNotAllStagesOfSeparableProgramUsed = "A program object is active for at least one, but not all of the shader stages that were present when the program was linked.";
inline constexpr const char *kNoExecutableCodeInstalled = "There is no current program object specified by UseProgram, there is a current program pipeline object, and that object is empty (no executable code is installed for any stage).";
inline constexpr const char *kProgramPipelineLinkFailed = "Program pipeline link failed.";
inline constexpr const char *kProgramPipelineInfoLogNULL = "Program pipeline infolog cannot be null.";
inline constexpr const char *kProtectedTexturesExtensionRequired = "GL_EXT_protected_textures not enabled.";
inline constexpr const char *kTextureCompressionASTCDecodeModeExtensionRequired = "GL_EXT_texture_compression_astc_decode_mode not enabled.";
inline constexpr const char *kTextureCompressionASTCDecodeModeRGB9E5ExtensionRequired = "GL_EXT_texture_compression_astc_decode_mode_rgb9e5 not enabled.";
inline constexpr const char *kProgramNotValid = "Program is not a program object.";
// clang-format on

}  // namespace err
}  // namespace gl
#endif  // LIBANGLE_ERRORSTRINGS_H_
