/* mutter-cogl-14.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Cogl", gir_namespace = "Cogl", gir_version = "14", lower_case_cprefix = "cogl_")]
namespace Cogl {
#if HAS_MUTTER47
	namespace Bits {
		[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_A_BIT")]
		public const int A;
		[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_AFIRST_BIT")]
		public const int AFIRST;
		[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_BGR_BIT")]
		public const int BGR;
		[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_DEPTH_BIT")]
		public const int DEPTH;
		[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_PREMULT_BIT")]
		public const int PREMULT;
		[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_STENCIL_BIT")]
		public const int STENCIL;
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_atlas_get_type ()")]
	public class Atlas : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Atlas ();
		public bool reserve_space (uint width, uint height, void* user_data);
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_atlas_texture_get_type ()")]
	public sealed class AtlasTexture : Cogl.Texture {
		[CCode (has_construct_function = false)]
		protected AtlasTexture ();
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public AtlasTexture.from_bitmap (Cogl.Bitmap bmp);
#if !HAS_MUTTER47
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public AtlasTexture.from_data (Cogl.Context ctx, int width, int height, Cogl.PixelFormat format, int rowstride, uint8 data) throws GLib.Error;
#endif
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public AtlasTexture.with_size (Cogl.Context ctx, int width, int height);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_attribute_get_type ()")]
	public class Attribute : GLib.Object {
		[CCode (has_construct_function = false)]
		public Attribute (Cogl.AttributeBuffer attribute_buffer, string name, size_t stride, size_t offset, int components, Cogl.AttributeType type);
#if !HAS_MUTTER47
		[CCode (has_construct_function = false)]
		public Attribute.const_1f (Cogl.Context context, string name, float value);
		[CCode (has_construct_function = false)]
		public Attribute.const_2f (Cogl.Context context, string name, float component0, float component1);
		[CCode (has_construct_function = false)]
		public Attribute.const_2fv (Cogl.Context context, string name, float value);
		[CCode (has_construct_function = false)]
		public Attribute.const_2x2fv (Cogl.Context context, string name, float matrix2x2, bool transpose);
		[CCode (has_construct_function = false)]
		public Attribute.const_3f (Cogl.Context context, string name, float component0, float component1, float component2);
		[CCode (has_construct_function = false)]
		public Attribute.const_3fv (Cogl.Context context, string name, float value);
		[CCode (has_construct_function = false)]
		public Attribute.const_3x3fv (Cogl.Context context, string name, float matrix3x3, bool transpose);
		[CCode (has_construct_function = false)]
		public Attribute.const_4f (Cogl.Context context, string name, float component0, float component1, float component2, float component3);
		[CCode (has_construct_function = false)]
		public Attribute.const_4fv (Cogl.Context context, string name, float value);
		[CCode (has_construct_function = false)]
		public Attribute.const_4x4fv (Cogl.Context context, string name, float matrix4x4, bool transpose);
#endif
		public unowned Cogl.AttributeBuffer get_buffer ();
#if !HAS_MUTTER47
		public bool get_normalized ();
		public void set_buffer (Cogl.AttributeBuffer attribute_buffer);
#endif
		public void set_normalized (bool normalized);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_attribute_buffer_get_type ()")]
	public sealed class AttributeBuffer : Cogl.Buffer {
		[CCode (has_construct_function = false)]
		public AttributeBuffer (Cogl.Context context, [CCode (array_length_cname = "bytes", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] data);
		[CCode (has_construct_function = false)]
		public AttributeBuffer.with_size (Cogl.Context context, size_t bytes);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_bitmap_get_type ()")]
	public class Bitmap : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Bitmap ();
		[CCode (has_construct_function = false)]
		public Bitmap.for_data (Cogl.Context context, int width, int height, Cogl.PixelFormat format, int rowstride, [CCode (array_length = false)] owned uint8[] data);
		[CCode (has_construct_function = false)]
		public Bitmap.from_buffer (Cogl.Buffer buffer, Cogl.PixelFormat format, int width, int height, int rowstride, int offset);
		public unowned Cogl.Buffer? get_buffer ();
		public Cogl.PixelFormat get_format ();
		public int get_height ();
		public int get_rowstride ();
		public int get_width ();
		[CCode (has_construct_function = false)]
		public Bitmap.with_size (Cogl.Context context, uint width, uint height, Cogl.PixelFormat format);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_buffer_get_type ()")]
	public abstract class Buffer : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Buffer ();
		public uint get_size ();
		public Cogl.BufferUpdateHint get_update_hint ();
		public void* map (Cogl.BufferAccess access, Cogl.BufferMapHint hints);
		public void* map_range (size_t offset, size_t size, Cogl.BufferAccess access, Cogl.BufferMapHint hints) throws GLib.Error;
		public bool set_data (size_t offset, [CCode (array_length = false)] uint8[] data, size_t size);
		public void set_update_hint (Cogl.BufferUpdateHint hint);
		public void unmap ();
		[NoAccessorMethod]
		public Cogl.Context context { construct; }
		[NoAccessorMethod]
		public Cogl.BufferBindTarget default_target { construct; }
		[NoAccessorMethod]
		public uint64 size { construct; }
		public Cogl.BufferUpdateHint update_hint { set construct; }
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_context_get_type ()")]
	public class Context : GLib.Object {
		[CCode (has_construct_function = false)]
		public Context (Cogl.Display? display) throws GLib.Error;
#if HAS_MUTTER47
		public void flush ();
#else
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_foreach_feature")]
		public void foreach_feature (Cogl.FeatureCallback callback);
#endif
		public void free_timestamp_query (owned Cogl.TimestampQuery query);
		public unowned Cogl.Display get_display ();
		public int64 get_gpu_time_ns ();
#if !HAS_MUTTER47
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_get_graphics_reset_status")]
#endif
		public Cogl.GraphicsResetStatus get_graphics_reset_status ();
		public unowned Cogl.Pipeline get_named_pipeline (Cogl.PipelineKey key);
		public unowned Cogl.Renderer get_renderer ();
#if !HAS_MUTTER47
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_has_feature")]
#endif
		public bool has_feature (Cogl.FeatureID feature);
#if HAS_MUTTER47
		public bool has_winsys_feature (Cogl.WinsysFeature feature);
#endif
		public bool is_hardware_accelerated ();
		public void set_named_pipeline (Cogl.PipelineKey key, Cogl.Pipeline? pipeline);
		public int64 timestamp_query_get_time_ns (Cogl.TimestampQuery query);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_display_get_type ()")]
	public class Display : GLib.Object {
		[CCode (has_construct_function = false)]
#if HAS_MUTTER47
		public Display (Cogl.Renderer renderer);
#else
		public Display (Cogl.Renderer renderer, Cogl.OnscreenTemplate onscreen_template);
#endif
		public unowned Cogl.Renderer get_renderer ();
#if !HAS_MUTTER47
		public void set_onscreen_template (Cogl.OnscreenTemplate onscreen_template);
#endif
		public bool setup () throws GLib.Error;
	}
	[CCode (cheader_filename = "cogl/cogl.h", free_function = "cogl_dma_buf_handle_free", has_type_id = false)]
	[Compact]
	public class DmaBufHandle {
		[DestroysInstance]
		public void free ();
		public int get_bpp ();
		public int get_fd ();
		public unowned Cogl.Framebuffer get_framebuffer ();
		public int get_height ();
		public int get_offset ();
		public int get_stride ();
		public int get_width ();
		public void* mmap () throws GLib.Error;
		public bool munmap (void* data) throws GLib.Error;
		public bool sync_read_end () throws GLib.Error;
		public bool sync_read_start () throws GLib.Error;
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class Fence {
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class FenceClosure {
		public void* get_user_data ();
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_frame_closure_get_type ()")]
	[Compact]
	public class FrameClosure {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_frame_info_get_type ()")]
	public class FrameInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FrameInfo ();
		public int64 get_frame_counter ();
		public int64 get_global_frame_counter ();
		public bool get_is_symbolic ();
		public int64 get_presentation_time_us ();
		public float get_refresh_rate ();
		public int64 get_rendering_duration_ns ();
		public uint get_sequence ();
		public int64 get_time_before_buffer_swap_us ();
#if HAS_MUTTER47
		public bool has_valid_gpu_rendering_duration ();
#endif
		public bool is_hw_clock ();
		public bool is_vsync ();
		public bool is_zero_copy ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_framebuffer_get_type ()")]
	public abstract class Framebuffer : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Framebuffer ();
#if !HAS_MUTTER47
		public unowned Cogl.FenceClosure? add_fence_callback ([CCode (scope = "async")] Cogl.FenceCallback callback);
#endif
		public virtual bool allocate () throws GLib.Error;
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_blit_framebuffer")]
		public bool blit (Cogl.Framebuffer dst, int src_x, int src_y, int dst_x, int dst_y, int width, int height) throws GLib.Error;
#if !HAS_MUTTER47
		public void cancel_fence_callback (Cogl.FenceClosure closure);
#endif
		public void clear (ulong buffers, Cogl.Color color);
		public void clear4f (ulong buffers, float red, float green, float blue, float alpha);
		public void discard_buffers (ulong buffers);
		public void draw_multitextured_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2, [CCode (array_length = false)] float[] tex_coords, int tex_coords_len);
		public void draw_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2);
		public void draw_rectangles (Cogl.Pipeline pipeline, [CCode (array_length = false)] float[] coordinates, uint n_rectangles);
		public void draw_textured_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2, float s_1, float t_1, float s_2, float t_2);
		public void draw_textured_rectangles (Cogl.Pipeline pipeline, [CCode (array_length = false)] float[] coordinates, uint n_rectangles);
		public static uint32 error_quark ();
		public void finish ();
		public void flush ();
		public void frustum (float left, float right, float bottom, float top, float z_near, float z_far);
		public int get_alpha_bits ();
		public int get_blue_bits ();
		public unowned Cogl.Context get_context ();
#if !HAS_MUTTER47
		public int get_depth_bits ();
#endif
		public bool get_depth_write_enabled ();
		public bool get_dither_enabled ();
		public int get_green_bits ();
		public int get_height ();
#if !HAS_MUTTER47
		public bool get_is_stereo ();
#endif
		public Graphene.Matrix get_modelview_matrix ();
		public Graphene.Matrix get_projection_matrix ();
		public int get_red_bits ();
#if !HAS_MUTTER47
		public int get_samples_per_pixel ();
		public Cogl.StereoMode get_stereo_mode ();
#endif
		public void get_viewport4fv ([CCode (array_length = false)] out unowned float viewport[4]);
		public float get_viewport_height ();
		public float get_viewport_width ();
		public float get_viewport_x ();
		public float get_viewport_y ();
		public int get_width ();
#if !HAS_MUTTER47
		public void identity_matrix ();
#endif
		[NoWrapper]
		public virtual bool is_y_flipped ();
		public void orthographic (float x_1, float y_1, float x_2, float y_2, float near, float far);
		public void perspective (float fov_y, float aspect, float z_near, float z_far);
		public void pop_clip ();
		public void pop_matrix ();
		public void push_matrix ();
#if !HAS_MUTTER47
		public void push_primitive_clip (Cogl.Primitive primitive, float bounds_x1, float bounds_y1, float bounds_x2, float bounds_y2);
#endif
		public void push_rectangle_clip (float x_1, float y_1, float x_2, float y_2);
		public void push_region_clip (Mtk.Region region);
		public bool read_pixels (int x, int y, int width, int height, Cogl.PixelFormat format, uint8 pixels);
		public bool read_pixels_into_bitmap (int x, int y, Cogl.ReadPixelsFlags source, Cogl.Bitmap bitmap);
#if !HAS_MUTTER47
		public void resolve_samples ();
		public void resolve_samples_region (int x, int y, int width, int height);
#endif
		public void rotate (float angle, float x, float y, float z);
#if !HAS_MUTTER47
		public void rotate_euler (Graphene.Euler euler);
#endif
		public void scale (float x, float y, float z);
		public void set_depth_write_enabled (bool depth_write_enabled);
		public void set_dither_enabled (bool dither_enabled);
		public void set_modelview_matrix (Graphene.Matrix matrix);
		public void set_projection_matrix (Graphene.Matrix matrix);
#if !HAS_MUTTER47
		public void set_samples_per_pixel (int samples_per_pixel);
		public void set_stereo_mode (Cogl.StereoMode stereo_mode);
#endif
		public void set_viewport (float x, float y, float width, float height);
		public void transform (Graphene.Matrix matrix);
		public void translate (float x, float y, float z);
		public Cogl.Context context { get; construct; }
		[NoAccessorMethod]
		public void* driver_config { get; construct; }
		[NoAccessorMethod]
		public int height { get; set construct; }
		[NoAccessorMethod]
		public int width { get; set construct; }
		public signal void destroy ();
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class FramebufferDriverConfig {
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_index_buffer_get_type ()")]
	public sealed class IndexBuffer : Cogl.Buffer {
		[CCode (has_construct_function = false)]
		public IndexBuffer (Cogl.Context context, size_t bytes);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_indices_get_type ()")]
	public class Indices : GLib.Object {
		[CCode (has_construct_function = false)]
		public Indices (Cogl.Context context, Cogl.IndicesType type, void* indices_data, int n_indices);
		[CCode (has_construct_function = false)]
		public Indices.for_buffer (Cogl.IndicesType type, Cogl.IndexBuffer buffer, size_t offset);
		public unowned Cogl.IndexBuffer get_buffer ();
		public Cogl.IndicesType get_indices_type ();
		public size_t get_offset ();
		public void set_offset (size_t offset);
	}
	[CCode (cheader_filename = "cogl/cogl.h", ref_function = "cogl_matrix_entry_ref", type_id = "cogl_matrix_entry_get_type ()", unref_function = "cogl_matrix_entry_unref")]
	[Compact]
	public class MatrixEntry {
		public bool calculate_translation (Cogl.MatrixEntry entry1, out float x, out float y, out float z);
#if !HAS_MUTTER47
		public bool equal (Cogl.MatrixEntry entry1);
#endif
		public Graphene.Matrix? @get (out Graphene.Matrix matrix);
		public bool is_identity ();
		public Cogl.MatrixEntry @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_matrix_stack_get_type ()")]
	public class MatrixStack : GLib.Object {
		[CCode (has_construct_function = false)]
		public MatrixStack (Cogl.Context ctx);
		public void frustum (float left, float right, float bottom, float top, float z_near, float z_far);
		public Graphene.Matrix? @get (out Graphene.Matrix matrix);
		public unowned Cogl.MatrixEntry get_entry ();
#if !HAS_MUTTER47
		public bool get_inverse (out Graphene.Matrix inverse);
#endif
		public void load_identity ();
		public void multiply (Graphene.Matrix matrix);
#if !HAS_MUTTER47
		public void orthographic (float x_1, float y_1, float x_2, float y_2, float near, float far);
		public void perspective (float fov_y, float aspect, float z_near, float z_far);
#endif
		public void pop ();
		public void push ();
		public void rotate (float angle, float x, float y, float z);
		public void rotate_euler (Graphene.Euler euler);
		public void scale (float x, float y, float z);
		public void @set (Graphene.Matrix matrix);
		public void translate (float x, float y, float z);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_offscreen_get_type ()")]
	public class Offscreen : Cogl.Framebuffer {
		[CCode (has_construct_function = false)]
		protected Offscreen ();
		public unowned Cogl.Texture get_texture ();
		[CCode (has_construct_function = false)]
		public Offscreen.with_texture (Cogl.Texture texture);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_onscreen_get_type ()")]
	public class Onscreen : Cogl.Framebuffer {
		[CCode (has_construct_function = false)]
		protected Onscreen ();
#if !HAS_MUTTER47
		public unowned Cogl.OnscreenDirtyClosure add_dirty_callback (owned Cogl.OnscreenDirtyCallback callback);
#endif
		public unowned Cogl.FrameClosure add_frame_callback (owned Cogl.FrameCallback callback);
		public void add_frame_info (owned Cogl.FrameInfo info);
		[NoWrapper]
		public virtual void bind ();
		public virtual bool direct_scanout (Cogl.Scanout scanout, Cogl.FrameInfo info) throws GLib.Error;
		public virtual int get_buffer_age ();
		public int64 get_frame_counter ();
#if !HAS_MUTTER47
		public void hide ();
#endif
		public virtual void queue_damage_region ([CCode (array_length_cname = "n_rectangles", array_length_pos = 1.1)] int[] rectangles);
#if !HAS_MUTTER47
		public void remove_dirty_callback (Cogl.OnscreenDirtyClosure closure);
#endif
		public void remove_frame_callback (Cogl.FrameClosure closure);
#if !HAS_MUTTER47
		public void show ();
#endif
		public void swap_buffers (Cogl.FrameInfo frame_info, void* user_data);
		public virtual void swap_buffers_with_damage ([CCode (array_length_cname = "n_rectangles", array_length_pos = 1.5)] int[] rectangles, Cogl.FrameInfo info);
		public virtual void swap_region ([CCode (array_length_cname = "n_rectangles", array_length_pos = 1.5)] int[] rectangles, Cogl.FrameInfo info);
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_onscreen_dirty_closure_get_type ()")]
	[Compact]
	public class OnscreenDirtyClosure {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_onscreen_template_get_type ()")]
	public class OnscreenTemplate : GLib.Object {
		[CCode (has_construct_function = false)]
		public OnscreenTemplate (Cogl.SwapChain swap_chain);
		public void set_samples_per_pixel (int n);
		public void set_stereo_enabled (bool enabled);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_output_get_type ()")]
	public class Output : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Output ();
		public int get_height ();
		public int get_mm_height ();
		public int get_mm_width ();
		public float get_refresh_rate ();
		public Cogl.SubpixelOrder get_subpixel_order ();
		public int get_width ();
		public int get_x ();
		public int get_y ();
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_pipeline_get_type ()")]
	public sealed class Pipeline : GLib.Object {
		[CCode (has_construct_function = false)]
		public Pipeline (Cogl.Context context);
		public void add_layer_snippet (int layer, Cogl.Snippet snippet);
		public void add_snippet (Cogl.Snippet snippet);
		public Cogl.Pipeline copy ();
		public void foreach_layer (Cogl.PipelineLayerCallback callback);
		public Cogl.PipelineAlphaFunc get_alpha_test_function ();
		public float get_alpha_test_reference ();
		public Cogl.Color get_color ();
		public Cogl.PipelineCullFaceMode get_cull_face_mode ();
		public Cogl.DepthState get_depth_state ();
		public Cogl.Winding get_front_face_winding ();
		public void get_layer_filters (int layer_index, out Cogl.PipelineFilter min_filter, out Cogl.PipelineFilter mag_filter);
		public bool get_layer_point_sprite_coords_enabled (int layer_index);
		public unowned Cogl.Texture get_layer_texture (int layer_index);
		public Cogl.PipelineWrapMode get_layer_wrap_mode_s (int layer_index);
		public Cogl.PipelineWrapMode get_layer_wrap_mode_t (int layer_index);
		public int get_n_layers ();
		public bool get_per_vertex_point_size ();
		public float get_point_size ();
		public int get_uniform_location (string uniform_name);
		public unowned Cogl.Program get_user_program ();
		public void remove_layer (int layer_index);
		public void set_alpha_test_function (Cogl.PipelineAlphaFunc alpha_func, float alpha_reference);
		public bool set_blend (string blend_string) throws GLib.Error;
		public void set_blend_constant (Cogl.Color constant_color);
		public void set_color (Cogl.Color color);
		public void set_cull_face_mode (Cogl.PipelineCullFaceMode cull_face_mode);
		public bool set_depth_state (Cogl.DepthState state) throws GLib.Error;
		public void set_front_face_winding (Cogl.Winding front_winding);
		public bool set_layer_combine (int layer_index, string blend_string) throws GLib.Error;
		public void set_layer_combine_constant (int layer_index, Cogl.Color constant);
		public void set_layer_filters (int layer_index, Cogl.PipelineFilter min_filter, Cogl.PipelineFilter mag_filter);
		public void set_layer_matrix (int layer_index, Graphene.Matrix matrix);
		public void set_layer_max_mipmap_level (int layer, int max_level);
		public void set_layer_null_texture (int layer_index);
		public bool set_layer_point_sprite_coords_enabled (int layer_index, bool enable) throws GLib.Error;
		public void set_layer_texture (int layer_index, Cogl.Texture texture);
		public void set_layer_wrap_mode (int layer_index, Cogl.PipelineWrapMode mode);
		public void set_layer_wrap_mode_s (int layer_index, Cogl.PipelineWrapMode mode);
		public void set_layer_wrap_mode_t (int layer_index, Cogl.PipelineWrapMode mode);
		public bool set_per_vertex_point_size (bool enable) throws GLib.Error;
		public void set_point_size (float point_size);
#if HAS_MUTTER47
		public void set_static_name (string name);
#endif
		public void set_uniform_1f (int uniform_location, float value);
		public void set_uniform_1i (int uniform_location, int value);
		public void set_uniform_float (int uniform_location, int n_components, int count, float value);
		public void set_uniform_int (int uniform_location, int n_components, int count, int value);
		public void set_uniform_matrix (int uniform_location, int dimensions, int count, bool transpose, float value);
		public void set_user_program (Cogl.Program program);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_pixel_buffer_get_type ()")]
	public sealed class PixelBuffer : Cogl.Buffer {
		[CCode (has_construct_function = false)]
		public PixelBuffer (Cogl.Context context, [CCode (array_length_cname = "size", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] data);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_primitive_get_type ()")]
	public class Primitive : GLib.Object {
		[CCode (has_construct_function = false)]
		public Primitive (Cogl.VerticesMode mode, int n_vertices, ...);
#if !HAS_MUTTER47
		public Cogl.Primitive copy ();
#endif
		public void draw (Cogl.Framebuffer framebuffer, Cogl.Pipeline pipeline);
#if !HAS_MUTTER47
		public void foreach_attribute (Cogl.PrimitiveAttributeCallback callback);
		public int get_first_vertex ();
		[CCode (array_length = false)]
		public unowned Cogl.Indices[]? get_indices ();
		public Cogl.VerticesMode get_mode ();
		public int get_n_vertices ();
#endif
		[CCode (has_construct_function = false)]
		public Primitive.p2 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2[] data);
		[CCode (has_construct_function = false)]
		public Primitive.p2c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2C4[] data);
		[CCode (has_construct_function = false)]
		public Primitive.p2t2 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2T2[] data);
#if !HAS_MUTTER47
		[CCode (has_construct_function = false)]
		public Primitive.p2t2c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2T2C4[] data);
#endif
		[CCode (has_construct_function = false)]
		public Primitive.p3 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3[] data);
#if !HAS_MUTTER47
		[CCode (has_construct_function = false)]
		public Primitive.p3c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3C4[] data);
#endif
		[CCode (has_construct_function = false)]
		public Primitive.p3t2 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3T2[] data);
#if !HAS_MUTTER47
		[CCode (has_construct_function = false)]
		public Primitive.p3t2c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3T2C4[] data);
#endif
		public void set_first_vertex (int first_vertex);
		public void set_indices ([CCode (array_length_cname = "n_indices", array_length_pos = 1.1)] Cogl.Indices[] indices);
#if !HAS_MUTTER47
		public void set_mode (Cogl.VerticesMode mode);
#endif
		public void set_n_vertices (int n_vertices);
#if !HAS_MUTTER47
		public static void texture_set_auto_mipmap (Cogl.Texture primitive_texture, bool value);
#endif
		[CCode (has_construct_function = false)]
		public Primitive.with_attributes (Cogl.VerticesMode mode, int n_vertices, [CCode (array_length_cname = "n_attributes", array_length_pos = 3.1)] Cogl.Attribute[] attributes);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_program_get_type ()")]
	public class Program : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Program ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void attach_shader (Cogl.Shader shader);
#if !HAS_MUTTER47
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_create_program")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public static Cogl.Program create ();
#endif
		[Version (deprecated = true, deprecated_since = "1.16")]
		public int get_uniform_location (string uniform_name);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void link ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void set_uniform_1f (int uniform_location, float value);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void set_uniform_1i (int uniform_location, int value);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void set_uniform_float (int uniform_location, int n_components, [CCode (array_length_cname = "count", array_length_pos = 2.5)] float[] value);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void set_uniform_int (int uniform_location, int n_components, [CCode (array_length_cname = "count", array_length_pos = 2.5)] int[] value);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void set_uniform_matrix (int uniform_location, int dimensions, bool transpose, [CCode (array_length_cname = "count", array_length_pos = 2.5)] float[] value);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_renderer_get_type ()")]
	public class Renderer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Renderer ();
#if !HAS_MUTTER47
		public void add_constraint (Cogl.RendererConstraint constraint);
#endif
		public void bind_api ();
#if !HAS_MUTTER47
		public bool check_onscreen_template (Cogl.OnscreenTemplate onscreen_template) throws GLib.Error;
#endif
		public bool connect () throws GLib.Error;
		public static uint32 error_quark ();
#if !HAS_MUTTER47
		public void foreach_output (Cogl.OutputCallback callback);
#endif
		public Cogl.Driver get_driver ();
#if HAS_MUTTER47
		public void* get_proc_address (string name);
#endif
		public Cogl.WinsysID get_winsys_id ();
		public bool is_dma_buf_supported ();
#if !HAS_MUTTER47
		public void remove_constraint (Cogl.RendererConstraint constraint);
#endif
		public void set_driver (Cogl.Driver driver);
#if !HAS_MUTTER47
		public void set_winsys_id (Cogl.WinsysID winsys_id);
#endif
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_scanout_get_type ()")]
	public sealed class Scanout : GLib.Object {
		[CCode (has_construct_function = false)]
		public Scanout (Cogl.ScanoutBuffer scanout_buffer);
		public bool blit_to_framebuffer (Cogl.Framebuffer framebuffer, int x, int y) throws GLib.Error;
		public unowned Cogl.ScanoutBuffer get_buffer ();
		public void get_dst_rect (Mtk.Rectangle rect);
		public void get_src_rect (Graphene.Rect rect);
		public void notify_failed (Cogl.Onscreen onscreen);
		public void set_dst_rect (Mtk.Rectangle rect);
		public void set_src_rect (Graphene.Rect rect);
		public signal void scanout_failed (Cogl.Onscreen object);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_shader_get_type ()")]
	public class Shader : GLib.Object {
		[CCode (has_construct_function = false)]
#if HAS_MUTTER47
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Shader (Cogl.ShaderType shader_type);
#else
		protected Shader ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_create_shader")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public static Cogl.Shader create (Cogl.ShaderType shader_type);
#endif
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Cogl.ShaderType get_shader_type ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void source (string source);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_snippet_get_type ()")]
	public class Snippet : GLib.Object {
		[CCode (has_construct_function = false)]
		public Snippet (Cogl.SnippetHook hook, string? declarations, string? post);
		public unowned string get_declarations ();
		public Cogl.SnippetHook get_hook ();
		public unowned string get_post ();
		public unowned string get_pre ();
		public unowned string get_replace ();
#if HAS_MUTTER47
		public void set_capability (GLib.Quark domain, uint capability);
#endif
		public void set_declarations (string declarations);
		public void set_post (string post);
		public void set_pre (string pre);
		public void set_replace (string replace);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_sub_texture_get_type ()")]
	public sealed class SubTexture : Cogl.Texture {
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public SubTexture (Cogl.Context ctx, Cogl.Texture parent_texture, int sub_x, int sub_y, int sub_width, int sub_height);
		public unowned Cogl.Texture get_parent ();
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_swap_chain_get_type ()")]
	public class SwapChain : GLib.Object {
		[CCode (has_construct_function = false)]
		public SwapChain ();
		public void set_has_alpha (bool has_alpha);
		public void set_length (int length);
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_texture_get_type ()")]
	public abstract class Texture : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Texture ();
		public bool allocate () throws GLib.Error;
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_meta_texture_foreach_in_region")]
		public void foreach_in_region (float tx_1, float ty_1, float tx_2, float ty_2, Cogl.PipelineWrapMode wrap_s, Cogl.PipelineWrapMode wrap_t, Cogl.MetaTextureCallback callback);
		public Cogl.TextureComponents get_components ();
#if HAS_MUTTER47
		public unowned Cogl.Context get_context ();
#endif
		public int get_data (Cogl.PixelFormat format, uint rowstride, [CCode (array_length = false)] uint8[] data);
#if HAS_MUTTER47
		public Cogl.PixelFormat get_format ();
#endif
		public bool get_gl_texture (out uint out_gl_handle, out uint out_gl_target);
		public uint get_height ();
		public int get_max_waste ();
		public bool get_premultiplied ();
		public uint get_width ();
		public bool is_get_data_supported ();
		public bool is_sliced ();
#if HAS_MUTTER47
		public void set_auto_mipmap (bool value);
#endif
		public void set_components (Cogl.TextureComponents components);
		public bool set_data (Cogl.PixelFormat format, int rowstride, [CCode (array_length = false)] uint8[] data, int level) throws GLib.Error;
		public void set_premultiplied (bool premultiplied);
		public bool set_region (int src_x, int src_y, int dst_x, int dst_y, uint dst_width, uint dst_height, int width, int height, Cogl.PixelFormat format, uint rowstride, [CCode (array_length = false)] uint8[] data);
		public bool set_region_from_bitmap (int src_x, int src_y, int dst_x, int dst_y, uint dst_width, uint dst_height, Cogl.Bitmap bitmap);
		[NoAccessorMethod]
		public Cogl.Context context { construct; }
		[NoAccessorMethod]
		public Cogl.PixelFormat format { construct; }
		[NoAccessorMethod]
		public int height { construct; }
		[NoAccessorMethod]
		public void* loader { construct; }
		[NoAccessorMethod]
		public int width { construct; }
	}
	[CCode (cheader_filename = "cogl/cogl.h", lower_case_csuffix = "texture_2d", type_id = "cogl_texture_2d_get_type ()")]
	public sealed class Texture2D : Cogl.Texture {
		[CCode (has_construct_function = false)]
		protected Texture2D ();
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public Texture2D.from_bitmap (Cogl.Bitmap bitmap);
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public Texture2D.from_data (Cogl.Context ctx, int width, int height, Cogl.PixelFormat format, int rowstride, [CCode (array_length = false)] uint8[] data) throws GLib.Error;
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public Texture2D.with_format (Cogl.Context ctx, int width, int height, Cogl.PixelFormat format);
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public Texture2D.with_size (Cogl.Context ctx, int width, int height);
	}
	[CCode (cheader_filename = "cogl/cogl.h", lower_case_csuffix = "texture_2d_sliced", type_id = "cogl_texture_2d_sliced_get_type ()")]
	public sealed class Texture2DSliced : Cogl.Texture {
		[CCode (has_construct_function = false)]
		protected Texture2DSliced ();
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public Texture2DSliced.from_bitmap (Cogl.Bitmap bmp, int max_waste);
#if !HAS_MUTTER47
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public Texture2DSliced.from_data (Cogl.Context ctx, int width, int height, int max_waste, Cogl.PixelFormat format, int rowstride, [CCode (array_length = false)] uint8[] data) throws GLib.Error;
#endif
		[CCode (has_construct_function = false, type = "CoglTexture*")]
		public Texture2DSliced.with_size (Cogl.Context ctx, int width, int height, int max_waste);
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class TimestampQuery {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_cname = "CoglScanoutBufferInterface", type_id = "cogl_scanout_buffer_get_type ()")]
	public interface ScanoutBuffer : GLib.Object {
		public abstract int get_height ();
		public abstract int get_width ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_color_get_type ()")]
	public struct Color {
#if HAS_MUTTER47
		public uint8 red;
		public uint8 green;
		public uint8 blue;
		public uint8 alpha;
#endif
		public Cogl.Color? copy ();
		public bool equal ([CCode (type = "void*")] Cogl.Color v2);
#if !HAS_MUTTER47
		public void free ();
#endif
		[CCode (cname = "cogl_color_init_from_4f")]
		public Color.from_4f (float red, float green, float blue, float alpha);
#if !HAS_MUTTER47
		[CCode (cname = "cogl_color_init_from_4fv")]
		public Color.from_4fv (float color_array);
#endif
		[CCode (cname = "cogl_color_init_from_hsl")]
		public Color.from_hsl (float hue, float saturation, float luminance);
#if HAS_MUTTER47
		[CCode (cname = "_vala_cogl_color_from_string")]
		public static Cogl.Color? from_string (string str) {
			Cogl.Color color = { };
			if (color.init_from_string (str)) {
				return color;
			}
			return null;
		}
#endif
		public float get_alpha ();
		public float get_blue ();
		public float get_green ();
		public float get_red ();
#if HAS_MUTTER47
		public uint hash ();
#endif
		public void init_from_4f (float red, float green, float blue, float alpha);
		public void init_from_hsl (float hue, float saturation, float luminance);
#if HAS_MUTTER47
		[CCode (cname = "cogl_color_from_string")]
		public bool init_from_string (string str);
#endif
		public void premultiply ();
		public void to_hsl (out float hue, out float saturation, out float luminance);
#if HAS_MUTTER47
		public string to_string ();
#endif
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct DepthState {
#if !HAS_MUTTER47
		public void get_range (float near_val, float far_val);
		public bool get_test_enabled ();
		public Cogl.DepthTestFunction get_test_function ();
		public bool get_write_enabled ();
#endif
		public void init ();
		public void set_range (float near_val, float far_val);
		public void set_test_enabled (bool enable);
		public void set_test_function (Cogl.DepthTestFunction function);
		public void set_write_enabled (bool enable);
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct OnscreenDirtyInfo {
		public int x;
		public int y;
		public int width;
		public int height;
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h")]
	[SimpleType]
	public struct PipelineKey : char {
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct PollFD {
		public int fd;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct TextureVertex {
		public float x;
		public float y;
		public float z;
		public float tx;
		public float ty;
		public Cogl.Color color;
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP2 {
		public float x;
		public float y;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP2C4 {
		public float x;
		public float y;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP2T2 {
		public float x;
		public float y;
		public float s;
		public float t;
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP2T2C4 {
		public float x;
		public float y;
		public float s;
		public float t;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP3 {
		public float x;
		public float y;
		public float z;
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP3C4 {
		public float x;
		public float y;
		public float z;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP3T2 {
		public float x;
		public float y;
		public float z;
		public float s;
		public float t;
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct VertexP3T2C4 {
		public float x;
		public float y;
		public float z;
		public float s;
		public float t;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_ATLAS_", has_type_id = false)]
	[Flags]
	public enum AtlasFlags {
		CLEAR_TEXTURE,
		DISABLE_MIGRATION
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_ATTRIBUTE_TYPE_", has_type_id = false)]
	public enum AttributeType {
		BYTE,
		UNSIGNED_BYTE,
		SHORT,
		UNSIGNED_SHORT,
		FLOAT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_ACCESS_", type_id = "cogl_buffer_access_get_type ()")]
	[Flags]
	public enum BufferAccess {
		READ,
		WRITE,
		READ_WRITE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_BIND_TARGET_", type_id = "cogl_buffer_bind_target_get_type ()")]
	public enum BufferBindTarget {
		PIXEL_PACK,
		PIXEL_UNPACK,
		ATTRIBUTE_BUFFER,
		INDEX_BUFFER,
		COUNT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_BIT_", has_type_id = false)]
	[Flags]
	public enum BufferBit {
		COLOR,
		DEPTH,
		STENCIL
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_ERROR_", type_id = "cogl_buffer_error_get_type ()")]
	public enum BufferError {
		MAP
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_MAP_HINT_", type_id = "cogl_buffer_map_hint_get_type ()")]
	[Flags]
	public enum BufferMapHint {
		DISCARD,
		DISCARD_RANGE
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_", has_type_id = false)]
	[Flags]
	public enum BufferTarget {
		WINDOW_BUFFER,
		OFFSCREEN_BUFFER
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_UPDATE_HINT_", type_id = "cogl_buffer_update_hint_get_type ()")]
	public enum BufferUpdateHint {
		STATIC,
		DYNAMIC,
		STREAM
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_DEPTH_TEST_FUNCTION_", has_type_id = false)]
	public enum DepthTestFunction {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_DRIVER_", has_type_id = false)]
	public enum Driver {
		ANY,
		NOP,
		GL3,
		GLES2
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_EGL_IMAGE_FLAG_", has_type_id = false)]
	[Flags]
	public enum EglImageFlags {
		NONE,
		NO_GET_DATA
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FEATURE_ID_", has_type_id = false)]
	public enum FeatureID {
		[CCode (cname = "COGL_FEATURE_ID_UNSIGNED_INT_INDICES")]
		OGL_FEATURE_ID_UNSIGNED_INT_INDICES,
		[CCode (cname = "COGL_FEATURE_ID_MAP_BUFFER_FOR_READ")]
		OGL_FEATURE_ID_MAP_BUFFER_FOR_READ,
		[CCode (cname = "COGL_FEATURE_ID_MAP_BUFFER_FOR_WRITE")]
		OGL_FEATURE_ID_MAP_BUFFER_FOR_WRITE,
		[CCode (cname = "COGL_FEATURE_ID_FENCE")]
		OGL_FEATURE_ID_FENCE,
		[CCode (cname = "COGL_FEATURE_ID_TEXTURE_RG")]
		OGL_FEATURE_ID_TEXTURE_RG,
		[CCode (cname = "COGL_FEATURE_ID_TEXTURE_RGBA1010102")]
		OGL_FEATURE_ID_TEXTURE_RGBA1010102,
		[CCode (cname = "COGL_FEATURE_ID_TEXTURE_HALF_FLOAT")]
		OGL_FEATURE_ID_TEXTURE_HALF_FLOAT,
		[CCode (cname = "COGL_FEATURE_ID_TEXTURE_NORM16")]
		OGL_FEATURE_ID_TEXTURE_NORM16,
		[CCode (cname = "COGL_FEATURE_ID_BUFFER_AGE")]
		OGL_FEATURE_ID_BUFFER_AGE,
		[CCode (cname = "COGL_FEATURE_ID_TEXTURE_EGL_IMAGE_EXTERNAL")]
		OGL_FEATURE_ID_TEXTURE_EGL_IMAGE_EXTERNAL,
		[CCode (cname = "COGL_FEATURE_ID_BLIT_FRAMEBUFFER")]
		OGL_FEATURE_ID_BLIT_FRAMEBUFFER,
#if HAS_MUTTER47
		[CCode (cname = "COGL_FEATURE_ID_SYNC_FD")]
		OGL_FEATURE_ID_SYNC_FD,
#endif
		[CCode (cname = "COGL_FEATURE_ID_TIMESTAMP_QUERY")]
		OGL_FEATURE_ID_TIMESTAMP_QUERY
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FILTER_", has_type_id = false)]
	public enum FilterReturn {
		CONTINUE,
		REMOVE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FRAME_EVENT_", has_type_id = false)]
	public enum FrameEvent {
		SYNC,
		COMPLETE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_GRAPHICS_RESET_STATUS_", has_type_id = false)]
	public enum GraphicsResetStatus {
		NO_ERROR,
		GUILTY_CONTEXT_RESET,
		INNOCENT_CONTEXT_RESET,
		UNKNOWN_CONTEXT_RESET,
		PURGED_CONTEXT_RESET
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_INDICES_TYPE_UNSIGNED_", has_type_id = false)]
	public enum IndicesType {
		BYTE,
		SHORT,
		INT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_ALPHA_FUNC_", has_type_id = false)]
	public enum PipelineAlphaFunc {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_CULL_FACE_MODE_", has_type_id = false)]
	public enum PipelineCullFaceMode {
		NONE,
		FRONT,
		BACK,
		BOTH
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_FILTER_", has_type_id = false)]
	public enum PipelineFilter {
		NEAREST,
		LINEAR,
		NEAREST_MIPMAP_NEAREST,
		LINEAR_MIPMAP_NEAREST,
		NEAREST_MIPMAP_LINEAR,
		LINEAR_MIPMAP_LINEAR
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_WRAP_MODE_", has_type_id = false)]
	public enum PipelineWrapMode {
		REPEAT,
		MIRRORED_REPEAT,
		CLAMP_TO_EDGE,
		AUTOMATIC
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIXEL_FORMAT_", type_id = "cogl_pixel_format_get_type ()")]
	public enum PixelFormat {
		CAIRO_ARGB32_COMPAT,
		ANY,
		A_8,
		RGB_565,
		RGBA_4444,
		RGBA_5551,
		YUV,
		R_8,
		RG_88,
		RGB_888,
		BGR_888,
		RGBX_8888,
		RGBA_8888,
		BGRX_8888,
		BGRA_8888,
		XRGB_8888,
		ARGB_8888,
		XBGR_8888,
		ABGR_8888,
		RGBA_8888_PRE,
		BGRA_8888_PRE,
		ARGB_8888_PRE,
		ABGR_8888_PRE,
		RGBA_4444_PRE,
		RGBA_5551_PRE,
		RGBA_1010102,
		BGRA_1010102,
		XRGB_2101010,
		ARGB_2101010,
		XBGR_2101010,
		ABGR_2101010,
		RGBA_1010102_PRE,
		BGRA_1010102_PRE,
		ARGB_2101010_PRE,
		ABGR_2101010_PRE,
		RGBX_FP_16161616,
		RGBA_FP_16161616,
		BGRX_FP_16161616,
		BGRA_FP_16161616,
		XRGB_FP_16161616,
		ARGB_FP_16161616,
		XBGR_FP_16161616,
		ABGR_FP_16161616,
		RGBA_FP_16161616_PRE,
		BGRA_FP_16161616_PRE,
		ARGB_FP_16161616_PRE,
		ABGR_FP_16161616_PRE,
		RGBA_FP_32323232,
		RGBA_FP_32323232_PRE,
		R_16,
		RG_1616,
		RGBA_16161616,
		RGBA_16161616_PRE,
		DEPTH_16,
		DEPTH_24_STENCIL_8;
		public int get_bytes_per_pixel (int plane);
		public int get_n_planes ();
		public unowned string to_string ();
		[CCode (cheader_filename = "cogl/cogl.h")]
		public const int MAX_PLANES;
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_POLL_FD_EVENT_", has_type_id = false)]
	public enum PollFDEvent {
		IN,
		PRI,
		OUT,
		ERR,
		HUP,
		NVAL
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_READ_PIXELS_COLOR_", has_type_id = false)]
	[Flags]
	public enum ReadPixelsFlags {
		[CCode (cname = "COGL_READ_PIXELS_COLOR_BUFFER")]
		READ_PIXELS_COLOR_BUFFER
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_RENDERER_CONSTRAINT_USES_", has_type_id = false)]
	[Flags]
	public enum RendererConstraint {
		X11,
		XLIB,
		EGL
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SHADER_TYPE_", has_type_id = false)]
	public enum ShaderType {
		VERTEX,
		FRAGMENT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SNIPPET_HOOK_", has_type_id = false)]
	public enum SnippetHook {
		VERTEX,
		VERTEX_TRANSFORM,
		VERTEX_GLOBALS,
		POINT_SIZE,
		FRAGMENT,
		FRAGMENT_GLOBALS,
		TEXTURE_COORD_TRANSFORM,
		LAYER_FRAGMENT,
		TEXTURE_LOOKUP
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_STEREO_", has_type_id = false)]
	public enum StereoMode {
		BOTH,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SUBPIXEL_ORDER_", has_type_id = false)]
	public enum SubpixelOrder {
		UNKNOWN,
		NONE,
		HORIZONTAL_RGB,
		HORIZONTAL_BGR,
		VERTICAL_RGB,
		VERTICAL_BGR
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_COMPONENTS_", has_type_id = false)]
	public enum TextureComponents {
		A,
		RG,
		RGB,
		RGBA,
		DEPTH
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_VERTICES_MODE_", has_type_id = false)]
	public enum VerticesMode {
		POINTS,
		LINES,
		LINE_LOOP,
		LINE_STRIP,
		TRIANGLES,
		TRIANGLE_STRIP,
		TRIANGLE_FAN
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_WINDING_", has_type_id = false)]
	public enum Winding {
		CLOCKWISE,
		COUNTER_CLOCKWISE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_WINSYS_FEATURE_", has_type_id = false)]
	public enum WinsysFeature {
		VBLANK_COUNTER,
		VBLANK_WAIT,
		TEXTURE_FROM_PIXMAP,
		SWAP_BUFFERS_EVENT,
		SWAP_REGION,
		SWAP_REGION_THROTTLE,
		SWAP_REGION_SYNCHRONIZED,
		BUFFER_AGE,
		SYNC_AND_COMPLETE_EVENT,
		N_FEATURES
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_WINSYS_ID_", has_type_id = false)]
	public enum WinsysID {
		ANY,
		STUB,
		GLX,
		EGL_XLIB,
		CUSTOM
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BITMAP_ERROR_", has_type_id = false)]
	public errordomain BitmapError {
		FAILED,
		UNKNOWN_TYPE,
		CORRUPT_IMAGE;
		public static uint32 quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BLEND_STRING_ERROR_", has_type_id = false)]
	public errordomain BlendStringError {
		PARSE_ERROR,
		ARGUMENT_PARSE_ERROR,
		INVALID_ERROR,
		GPU_UNSUPPORTED_ERROR;
		[CCode (cheader_filename = "cogl/cogl.h")]
		public static uint32 quark ();
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FRAMEBUFFER_ERROR_", has_type_id = false)]
	public errordomain FramebufferError {
		[CCode (cname = "COGL_FRAMEBUFFER_ERROR_ALLOCATE")]
		FRAMEBUFFER_ERROR_ALLOCATE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_RENDERER_ERROR_", has_type_id = false)]
	public errordomain RendererError {
		XLIB_DISPLAY_OPEN,
		BAD_CONSTRAINT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SCANOUT_ERROR_", has_type_id = false)]
	public errordomain ScanoutError {
		[CCode (cname = "COGL_SCANOUT_ERROR_INHIBITED")]
		SCANOUT_ERROR_INHIBITED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SYSTEM_ERROR_", has_type_id = false)]
	public errordomain SystemError {
		UNSUPPORTED,
		NO_MEMORY
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_ERROR_", has_type_id = false)]
	public errordomain TextureError {
		SIZE,
		FORMAT,
		BAD_PARAMETER,
		TYPE;
		public static uint32 quark ();
	}
#if HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 0.9)]
	public delegate void AtlasUpdatePositionCallback (Cogl.Texture new_texture, Mtk.Rectangle rect);
#endif
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	public delegate void FeatureCallback (Cogl.FeatureID feature);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	public delegate void FenceCallback (Cogl.Fence fence);
#endif
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 3.9)]
	public delegate void FrameCallback (Cogl.Onscreen onscreen, Cogl.FrameEvent event, Cogl.FrameInfo info);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 3.9)]
	public delegate void MetaTextureCallback (Cogl.Texture sub_texture, float sub_texture_coords, float meta_coords);
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	public delegate void OnscreenDirtyCallback (Cogl.Onscreen onscreen, Cogl.OnscreenDirtyInfo info);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	public delegate void OutputCallback (Cogl.Output output);
#endif
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	public delegate bool PipelineLayerCallback (Cogl.Pipeline pipeline, int layer_index);
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	public delegate bool PrimitiveAttributeCallback (Cogl.Primitive primitive, Cogl.Attribute attribute);
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_TEXTURE_MAX_WASTE")]
	public const int TEXTURE_MAX_WASTE;
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool clutter_winsys_has_feature (Cogl.WinsysFeature feature);
#endif
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (replacement = "Color.init_from_hsl")]
	public static void color_init_from_hsl (out Cogl.Color color, float hue, float saturation, float luminance);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void debug_matrix_entry_print (Cogl.MatrixEntry entry);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void flush ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static unowned Cogl.Indices get_rectangle_indices (Cogl.Context context, int n_rectangles);
#if HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static GLib.Source glib_source_new (Cogl.Renderer renderer, int priority);
#else
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static GLib.Source glib_renderer_source_new (Cogl.Renderer renderer, int priority);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static GLib.Source glib_source_new (Cogl.Context context, int priority);
#endif
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void graphene_matrix_project_point (Graphene.Matrix matrix, ref float x, ref float y, ref float z, ref float w);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void graphene_matrix_project_points (Graphene.Matrix matrix, int n_components, size_t stride_in, void* points_in, size_t stride_out, void* points_out, int n_points);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void graphene_matrix_transform_points (Graphene.Matrix matrix, int n_components, size_t stride_in, void* points_in, size_t stride_out, void* points_out, int n_points);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (replacement = "PixelFormat.get_bytes_per_pixel")]
	public static int pixel_format_get_bytes_per_pixel (Cogl.PixelFormat format, int plane);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (replacement = "PixelFormat.get_n_planes")]
	public static int pixel_format_get_n_planes (Cogl.PixelFormat format);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (replacement = "PixelFormat.to_string")]
	public static unowned string pixel_format_to_string (Cogl.PixelFormat format);
#if !HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void poll_renderer_dispatch (Cogl.Renderer renderer, Cogl.PollFD poll_fds, int n_poll_fds);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static int poll_renderer_get_info (Cogl.Renderer renderer, Cogl.PollFD poll_fds, int n_poll_fds, int64 timeout);
#endif
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_tracing_disabled_on_thread (void* data);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_tracing_enabled_on_thread (void* data, string group);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool start_tracing_with_fd (int fd) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool start_tracing_with_path (string filename) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void stop_tracing ();
#if HAS_MUTTER47
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static unowned Cogl.Color? value_get_color (GLib.Value value);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void value_set_color (GLib.Value value, Cogl.Color color);
#endif
}
