/* mutter-cogl-6.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Cogl", gir_namespace = "Cogl", gir_version = "6", lower_case_cprefix = "cogl_")]
namespace Cogl {
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_bitmap_get_gtype ()")]
	public class Bitmap : Cogl.Object {
		[CCode (has_construct_function = false)]
		protected Bitmap ();
		[CCode (has_construct_function = false)]
		[Version (since = "1.0")]
		public Bitmap.from_file (string filename) throws GLib.Error;
		[Version (since = "1.10")]
		public Cogl.PixelFormat get_format ();
		[Version (since = "1.10")]
		public int get_height ();
		[Version (since = "1.10")]
		public int get_rowstride ();
		[Version (since = "1.0")]
		public static bool get_size_from_file (string filename, out int width, out int height);
		[Version (since = "1.10")]
		public int get_width ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_context_get_gtype ()")]
	public class Context : Cogl.Object {
		[CCode (has_construct_function = false)]
		protected Context ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_foreach_feature")]
		[Version (since = "1.10")]
		public void foreach_feature (Cogl.FeatureCallback callback);
		public void free_timestamp_query (owned Cogl.TimestampQuery query);
		public int64 get_gpu_time_ns ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_get_graphics_reset_status")]
		public Cogl.GraphicsResetStatus get_graphics_reset_status ();
		public unowned Cogl.Pipeline get_named_pipeline (Cogl.PipelineKey key);
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_has_feature")]
		[Version (since = "1.10")]
		public bool has_feature (Cogl.FeatureID feature);
		public bool is_hardware_accelerated ();
		public void set_named_pipeline (Cogl.PipelineKey key, Cogl.Pipeline? pipeline);
		public int64 timestamp_query_get_time_ns (Cogl.TimestampQuery query);
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_frame_closure_get_gtype ()")]
	[Compact]
	[Version (since = "1.14")]
	public class FrameClosure {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_frame_info_get_gtype ()")]
	public class FrameInfo : Cogl.Object {
		[CCode (has_construct_function = false)]
		protected FrameInfo ();
		[Version (since = "1.14")]
		public int64 get_frame_counter ();
		public bool get_is_symbolic ();
		[Version (since = "1.14")]
		public int64 get_presentation_time_us ();
		[Version (since = "1.14")]
		public float get_refresh_rate ();
		public int64 get_rendering_duration_ns ();
		public uint get_sequence ();
		public int64 get_time_before_buffer_swap_us ();
		public bool is_hw_clock ();
		public bool is_vsync ();
		public bool is_zero_copy ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_framebuffer_get_type ()")]
	public abstract class Framebuffer : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Framebuffer ();
		[Version (since = "1.8")]
		public virtual bool allocate () throws GLib.Error;
		[Version (since = "1.8")]
		public void clear (ulong buffers, Cogl.Color color);
		[Version (since = "1.8")]
		public void clear4f (ulong buffers, float red, float green, float blue, float alpha);
		[Version (since = "1.8")]
		public void discard_buffers (ulong buffers);
		[Version (since = "1.10")]
		public void draw_multitextured_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2, [CCode (array_length = false)] float[] tex_coords, int tex_coords_len);
		[Version (since = "1.10")]
		public void draw_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2);
		[Version (since = "1.10")]
		public void draw_rectangles (Cogl.Pipeline pipeline, [CCode (array_length = false)] float[] coordinates, uint n_rectangles);
		[Version (since = "1.10")]
		public void draw_textured_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2, float s_1, float t_1, float s_2, float t_2);
		[Version (since = "1.10")]
		public void draw_textured_rectangles (Cogl.Pipeline pipeline, [CCode (array_length = false)] float[] coordinates, uint n_rectangles);
		public static uint32 error_quark ();
		[Version (since = "1.10")]
		public void finish ();
		public void flush ();
		[Version (since = "1.10")]
		public void frustum (float left, float right, float bottom, float top, float z_near, float z_far);
		[Version (since = "1.8")]
		public int get_alpha_bits ();
		[Version (since = "1.8")]
		public int get_blue_bits ();
		[Version (since = "1.8")]
		public unowned Cogl.Context get_context ();
		[Version (since = "2.0")]
		public int get_depth_bits ();
		[Version (since = "1.18")]
		public bool get_depth_write_enabled ();
		[Version (since = "1.8")]
		public bool get_dither_enabled ();
		[Version (since = "1.8")]
		public int get_green_bits ();
		[Version (since = "1.8")]
		public int get_height ();
		public bool get_is_stereo ();
		[Version (since = "1.10")]
		public Graphene.Matrix get_modelview_matrix ();
		[Version (since = "1.10")]
		public Graphene.Matrix get_projection_matrix ();
		[Version (since = "1.8")]
		public int get_red_bits ();
		[Version (since = "1.10")]
		public int get_samples_per_pixel ();
		[Version (since = "1.20")]
		public Cogl.StereoMode get_stereo_mode ();
		[Version (since = "1.8")]
		public void get_viewport4fv ([CCode (array_length = false)] out unowned float viewport[4]);
		[Version (since = "1.8")]
		public float get_viewport_height ();
		[Version (since = "1.8")]
		public float get_viewport_width ();
		[Version (since = "1.8")]
		public float get_viewport_x ();
		[Version (since = "1.8")]
		public float get_viewport_y ();
		[Version (since = "1.8")]
		public int get_width ();
		[Version (since = "1.10")]
		public void identity_matrix ();
		[NoWrapper]
		public virtual bool is_y_flipped ();
		[Version (since = "1.10")]
		public void orthographic (float x_1, float y_1, float x_2, float y_2, float near, float far);
		[Version (since = "1.10")]
		public void perspective (float fov_y, float aspect, float z_near, float z_far);
		[Version (since = "1.10")]
		public void pop_clip ();
		[Version (since = "1.10")]
		public void pop_matrix ();
		[Version (since = "1.10")]
		public void push_matrix ();
		[Version (since = "1.10")]
		public void push_rectangle_clip (float x_1, float y_1, float x_2, float y_2);
		public void push_region_clip (Cairo.Region region);
		[Version (since = "1.10")]
		public void push_scissor_clip (int x, int y, int width, int height);
		[Version (since = "1.10")]
		public bool read_pixels (int x, int y, int width, int height, Cogl.PixelFormat format, uint8 pixels);
		[Version (since = "1.10")]
		public bool read_pixels_into_bitmap (int x, int y, Cogl.ReadPixelsFlags source, Cogl.Bitmap bitmap);
		[Version (since = "1.8")]
		public void resolve_samples ();
		[Version (since = "1.8")]
		public void resolve_samples_region (int x, int y, int width, int height);
		[Version (since = "1.10")]
		public void rotate (float angle, float x, float y, float z);
		[Version (since = "2.0")]
		public void rotate_euler (Graphene.Euler euler);
		[Version (since = "1.10")]
		public void scale (float x, float y, float z);
		[Version (since = "1.18")]
		public void set_depth_write_enabled (bool depth_write_enabled);
		[Version (since = "1.8")]
		public void set_dither_enabled (bool dither_enabled);
		[Version (since = "1.10")]
		public void set_modelview_matrix (Graphene.Matrix matrix);
		[Version (since = "1.10")]
		public void set_projection_matrix (Graphene.Matrix matrix);
		[Version (since = "1.8")]
		public void set_samples_per_pixel (int samples_per_pixel);
		[Version (since = "1.20")]
		public void set_stereo_mode (Cogl.StereoMode stereo_mode);
		[Version (since = "1.8")]
		public void set_viewport (float x, float y, float width, float height);
		[Version (since = "1.10")]
		public void transform (Graphene.Matrix matrix);
		[Version (since = "1.10")]
		public void translate (float x, float y, float z);
		[NoAccessorMethod]
		public void* driver_config { get; construct; }
		[NoAccessorMethod]
		public int height { get; set construct; }
		[NoAccessorMethod]
		public int width { get; set construct; }
		public signal void destroy ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class FramebufferDriverConfig {
	}
	[CCode (cheader_filename = "cogl/cogl.h", ref_function = "cogl_object_ref", type_id = "cogl_handle_get_gtype ()", unref_function = "cogl_object_unref")]
	[Compact]
	public class Handle {
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_material")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public bool is_material ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_program")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public bool is_program (Cogl.Handle handle);
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_shader")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public bool is_shader ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_texture")]
		public bool is_texture ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", ref_function = "cogl_object_ref", type_id = "cogl_object_get_gtype ()", unref_function = "cogl_object_unref")]
	public abstract class Object {
		[CCode (has_construct_function = false)]
		protected Object ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_bitmap")]
		[Version (since = "1.0")]
		public bool is_bitmap ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_context")]
		[Version (since = "1.10")]
		public bool is_context ();
		[Version (since = "2.0")]
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_frame_info")]
		public bool is_frame_info ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_framebuffer")]
		[Version (since = "1.10")]
		public bool is_framebuffer ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_pipeline")]
		[Version (since = "2.0")]
		public bool is_pipeline ();
#if HAS_MUTTER43
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_snippet")]
		[Version (since = "1.10")]
		public bool is_snippet ();
#endif
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_texture")]
		public bool is_texture ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_texture_2d")]
		public bool is_texture_2d ();
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_is_texture_2d_sliced")]
		[Version (since = "1.10")]
		public bool is_texture_2d_sliced ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_offscreen_get_type ()")]
	public sealed class Offscreen : Cogl.Framebuffer {
		[CCode (has_construct_function = false)]
		protected Offscreen ();
		[CCode (has_construct_function = false)]
		public Offscreen.with_texture (Cogl.Texture texture);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_onscreen_get_type ()")]
	public class Onscreen : Cogl.Framebuffer {
		[CCode (has_construct_function = false)]
		protected Onscreen ();
		[Version (since = "1.16")]
		public Cogl.OnscreenDirtyClosure add_dirty_callback ([CCode (delegate_target_pos = 1.5)] Cogl.OnscreenDirtyCallback callback, Cogl.UserDataDestroyCallback? destroy);
		[Version (since = "1.14")]
		public Cogl.FrameClosure add_frame_callback ([CCode (delegate_target_pos = 1.5)] Cogl.FrameCallback callback, Cogl.UserDataDestroyCallback? destroy);
		[NoWrapper]
		public virtual void bind ();
		[Version (since = "1.14")]
		public virtual int get_buffer_age ();
		[Version (since = "1.14")]
		public int64 get_frame_counter ();
		[Version (since = "2.0")]
		public void hide ();
		public virtual void queue_damage_region (int rectangles, int n_rectangles);
		[Version (since = "1.16")]
		public void remove_dirty_callback (Cogl.OnscreenDirtyClosure closure);
		[Version (since = "1.14")]
		public void remove_frame_callback (Cogl.FrameClosure closure);
		[Version (since = "2.0")]
		public void show ();
		[Version (since = "1.10")]
		public void swap_buffers (Cogl.FrameInfo frame_info, void* user_data);
		[Version (since = "1.16")]
		public virtual void swap_buffers_with_damage (int rectangles, int n_rectangles, Cogl.FrameInfo info);
		[Version (since = "1.10")]
		public virtual void swap_region (int rectangles, int n_rectangles, Cogl.FrameInfo info);
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_onscreen_dirty_closure_get_gtype ()")]
	[Compact]
	[Version (since = "1.16")]
	public class OnscreenDirtyClosure {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_pipeline_get_gtype ()")]
	public class Pipeline : Cogl.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "2.0")]
		public Pipeline (Cogl.Context context);
#if HAS_MUTTER43
		[Version (since = "1.10")]
		public void add_layer_snippet (int layer, Cogl.Snippet snippet);
		[Version (since = "1.10")]
		public void add_snippet (Cogl.Snippet snippet);
#endif
		[Version (since = "2.0")]
		public Cogl.Pipeline copy ();
		[Version (since = "2.0")]
		public void foreach_layer (Cogl.PipelineLayerCallback callback);
		[Version (since = "2.0")]
		public Cogl.PipelineAlphaFunc get_alpha_test_function ();
		[Version (since = "2.0")]
		public float get_alpha_test_reference ();
		[Version (since = "2.0")]
		public Cogl.Color get_color ();
		[Version (since = "2.0")]
		public Cogl.PipelineCullFaceMode get_cull_face_mode ();
		[Version (since = "2.0")]
		public Cogl.Winding get_front_face_winding ();
#if HAS_MUTTER44
		public void get_layer_filters (int layer_index, out Cogl.PipelineFilter min_filter, out Cogl.PipelineFilter mag_filter);
#else
		[Version (since = "1.10")]
		public Cogl.PipelineFilter get_layer_mag_filter (int layer_index);
		[Version (since = "1.10")]
		public Cogl.PipelineFilter get_layer_min_filter (int layer_index);
#endif
		[Version (since = "2.0")]
		public bool get_layer_point_sprite_coords_enabled (int layer_index);
		[Version (since = "1.10")]
		public unowned Cogl.Texture get_layer_texture (int layer_index);
		[Version (since = "1.6")]
		public Cogl.PipelineWrapMode get_layer_wrap_mode_s (int layer_index);
		[Version (since = "1.6")]
		public Cogl.PipelineWrapMode get_layer_wrap_mode_t (int layer_index);
		[Version (since = "2.0")]
		public int get_n_layers ();
		[Version (since = "2.0")]
		public bool get_per_vertex_point_size ();
		[Version (since = "2.0")]
		public float get_point_size ();
		[Version (since = "2.0")]
		public int get_uniform_location (string uniform_name);
		[Version (since = "2.0")]
		public unowned Cogl.Handle get_user_program ();
		[Version (since = "1.10")]
		public void remove_layer (int layer_index);
		[Version (since = "2.0")]
		public void set_alpha_test_function (Cogl.PipelineAlphaFunc alpha_func, float alpha_reference);
		[Version (since = "2.0")]
		public bool set_blend (string blend_string) throws GLib.Error;
		[Version (since = "2.0")]
		public void set_blend_constant (Cogl.Color constant_color);
		[Version (since = "2.0")]
		public void set_color (Cogl.Color color);
		[Version (since = "2.0")]
		public void set_color4f (float red, float green, float blue, float alpha);
		[Version (since = "2.0")]
		public void set_color4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
		[Version (since = "2.0")]
		public void set_cull_face_mode (Cogl.PipelineCullFaceMode cull_face_mode);
		[Version (since = "2.0")]
		public void set_front_face_winding (Cogl.Winding front_winding);
		[Version (since = "2.0")]
		public bool set_layer_combine (int layer_index, string blend_string) throws GLib.Error;
		[Version (since = "2.0")]
		public void set_layer_combine_constant (int layer_index, Cogl.Color constant);
		[Version (since = "1.10")]
		public void set_layer_filters (int layer_index, Cogl.PipelineFilter min_filter, Cogl.PipelineFilter mag_filter);
		[Version (since = "1.10")]
		public void set_layer_matrix (int layer_index, Graphene.Matrix matrix);
		public void set_layer_max_mipmap_level (int layer, int max_level);
		[Version (since = "1.10")]
		public void set_layer_null_texture (int layer_index);
		[Version (since = "2.0")]
		public bool set_layer_point_sprite_coords_enabled (int layer_index, bool enable) throws GLib.Error;
		public void set_layer_texture (int layer_index, Cogl.Texture texture);
		[Version (since = "2.0")]
		public void set_layer_wrap_mode (int layer_index, Cogl.PipelineWrapMode mode);
		[Version (since = "2.0")]
		public void set_layer_wrap_mode_s (int layer_index, Cogl.PipelineWrapMode mode);
		[Version (since = "2.0")]
		public void set_layer_wrap_mode_t (int layer_index, Cogl.PipelineWrapMode mode);
		[Version (since = "2.0")]
		public bool set_per_vertex_point_size (bool enable) throws GLib.Error;
		[Version (since = "2.0")]
		public void set_point_size (float point_size);
		[Version (since = "2.0")]
		public void set_uniform_1f (int uniform_location, float value);
		[Version (since = "2.0")]
		public void set_uniform_1i (int uniform_location, int value);
		[Version (since = "2.0")]
		public void set_uniform_float (int uniform_location, int n_components, int count, float value);
		[Version (since = "2.0")]
		public void set_uniform_int (int uniform_location, int n_components, int count, int value);
		[Version (since = "2.0")]
		public void set_uniform_matrix (int uniform_location, int dimensions, int count, bool transpose, float value);
		[Version (since = "2.0")]
		public void set_user_program (Cogl.Handle program);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "G_TYPE_STRING")]
	[Compact]
	public class PipelineKey : string {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_primitive_get_gtype ()")]
	public class Primitive : Cogl.Object {
		[CCode (has_construct_function = false)]
		protected Primitive ();
		[Version (since = "1.10")]
		public Cogl.Primitive copy ();
		[Version (since = "1.16")]
		public void draw (Cogl.Framebuffer framebuffer, Cogl.Pipeline pipeline);
		public int get_first_vertex ();
		public Cogl.VerticesMode get_mode ();
		[Version (since = "1.8")]
		public int get_n_vertices ();
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p2 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2[] data);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p2c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2C4[] data);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p2t2 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2T2[] data);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p2t2c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP2T2C4[] data);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p3 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3[] data);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p3c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3C4[] data);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p3t2 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3T2[] data);
		[CCode (has_construct_function = false)]
		[Version (since = "1.6")]
		public Primitive.p3t2c4 (Cogl.Context context, Cogl.VerticesMode mode, [CCode (array_length_cname = "n_vertices", array_length_pos = 2.5)] Cogl.VertexP3T2C4[] data);
		public void set_first_vertex (int first_vertex);
		public void set_mode (Cogl.VerticesMode mode);
		[Version (since = "1.8")]
		public void set_n_vertices (int n_vertices);
	}
	[CCode (cheader_filename = "cogl/cogl.h", cname = "CoglHandle", ref_function = "cogl_object_ref", type_id = "cogl_handle_get_gtype ()", unref_function = "cogl_object_unref")]
	[Compact]
	public class Program : Cogl.Handle {
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void attach_shader (Cogl.Handle shader_handle);
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_create_program")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public static unowned Cogl.Program create ();
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public int get_uniform_location (string uniform_name);
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void link ();
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_uniform_1f (int uniform_location, float value);
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_uniform_1i (int uniform_location, int value);
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_uniform_float (int uniform_location, int n_components, [CCode (array_length_cname = "count", array_length_pos = 2.5)] float[] value);
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_uniform_int (int uniform_location, int n_components, [CCode (array_length_cname = "count", array_length_pos = 2.5)] int[] value);
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_uniform_matrix (int uniform_location, int dimensions, bool transpose, [CCode (array_length_cname = "count", array_length_pos = 2.5)] float[] value);
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class Scanout {
	}
	[CCode (cheader_filename = "cogl/cogl.h", cname = "CoglHandle", ref_function = "cogl_object_ref", type_id = "cogl_handle_get_gtype ()", unref_function = "cogl_object_unref")]
	[Compact]
	public class Shader : Cogl.Handle {
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_create_shader")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public static unowned Cogl.Shader create (Cogl.ShaderType shader_type);
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Cogl.ShaderType get_type ();
		[CCode (cheader_filename = "cogl/cogl.h")]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void source (string source);
	}
#if HAS_MUTTER43
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_snippet_get_gtype ()")]
	public class Snippet : Cogl.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "1.10")]
		public Snippet (Cogl.SnippetHook hook, string? declarations, string? post);
		[Version (since = "1.10")]
		public unowned string get_declarations ();
		[Version (since = "1.10")]
		public Cogl.SnippetHook get_hook ();
		[Version (since = "1.10")]
		public unowned string get_post ();
		[Version (since = "1.10")]
		public unowned string get_pre ();
		[Version (since = "1.10")]
		public unowned string get_replace ();
		[Version (since = "1.10")]
		public void set_declarations (string declarations);
		[Version (since = "1.10")]
		public void set_post (string post);
		[Version (since = "1.10")]
		public void set_pre (string pre);
		[Version (since = "1.10")]
		public void set_replace (string replace);
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", lower_case_csuffix = "texture_2d", type_id = "cogl_texture_2d_get_gtype ()")]
	public class Texture2D : Cogl.Object, Cogl.Texture {
		[CCode (has_construct_function = false)]
		protected Texture2D ();
		public void egl_image_external_alloc_finish (void* user_data, GLib.DestroyNotify destroy);
		public void egl_image_external_bind ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.0")]
		public Texture2D.from_bitmap (Cogl.Bitmap bitmap);
		[CCode (has_construct_function = false)]
		[Version (since = "2.0")]
		public Texture2D.from_data (Cogl.Context ctx, int width, int height, Cogl.PixelFormat format, int rowstride, [CCode (array_length = false, type = "const uint8_t*")] uint8[] data) throws GLib.Error;
	}
	[CCode (cheader_filename = "cogl/cogl.h", lower_case_csuffix = "texture_2d_sliced", type_id = "cogl_texture_2d_sliced_get_gtype ()")]
	public class Texture2DSliced : Cogl.Object, Cogl.Texture {
		[CCode (has_construct_function = false)]
		protected Texture2DSliced ();
		[CCode (has_construct_function = false)]
		[Version (since = "1.16")]
		public Texture2DSliced.from_bitmap (Cogl.Bitmap bmp, int max_waste);
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class TimestampQuery {
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class TraceContext {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_texture_get_gtype ()")]
	public interface Texture : Cogl.Object {
		public bool allocate () throws GLib.Error;
#if !HAS_MUTTER43
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_texture_new_from_bitmap")]
		[Version (deprecated = true, deprecated_since = "1.18", replacement = "Texture.new_from_bitmap", since = "1.0")]
		public static Cogl.Texture from_bitmap (Cogl.Bitmap bitmap, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_texture_new_from_data")]
		[Version (deprecated = true, deprecated_since = "1.18", replacement = "Texture.new_from_data", since = "0.8")]
		public static Cogl.Texture from_data (int width, int height, Cogl.TextureFlags flags, Cogl.PixelFormat format, Cogl.PixelFormat internal_format, int rowstride, [CCode (array_length = false)] uint8[] data);
		[CCode (cheader_filename = "cogl/cogl.h", cname = "cogl_texture_new_from_file")]
		[Version (deprecated = true, deprecated_since = "1.18", replacement = "Texture.new_from_file", since = "0.8")]
		public static Cogl.Texture from_file (string filename, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format) throws GLib.Error;
#endif
		[Version (since = "1.18")]
		public Cogl.TextureComponents get_components ();
		public int get_data (Cogl.PixelFormat format, uint rowstride, [CCode (array_length = false)] uint8[] data);
		public bool get_gl_texture (out uint out_gl_handle, out uint out_gl_target);
		public uint get_height ();
		public int get_max_waste ();
		[Version (since = "1.18")]
		public bool get_premultiplied ();
		public uint get_width ();
		public bool is_sliced ();
#if !HAS_MUTTER43
		[Version (deprecated = true, deprecated_since = "1.18", since = "1.0")]
		public static Cogl.Texture new_from_bitmap (Cogl.Bitmap bitmap, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
		[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
		public static Cogl.Texture new_from_data (int width, int height, Cogl.TextureFlags flags, Cogl.PixelFormat format, Cogl.PixelFormat internal_format, int rowstride, [CCode (array_length = false)] uint8[] data);
		[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
		public static Cogl.Texture new_from_file (string filename, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format) throws GLib.Error;
#endif
		[Version (since = "1.18")]
		public void set_components (Cogl.TextureComponents components);
		public bool set_data (Cogl.PixelFormat format, int rowstride, [CCode (array_length = false)] uint8[] data, int level) throws GLib.Error;
		[Version (since = "1.18")]
		public void set_premultiplied (bool premultiplied);
		public bool set_region (int src_x, int src_y, int dst_x, int dst_y, uint dst_width, uint dst_height, int width, int height, Cogl.PixelFormat format, uint rowstride, [CCode (array_length = false)] uint8[] data);
		[Version (since = "1.8")]
		public bool set_region_from_bitmap (int src_x, int src_y, int dst_x, int dst_y, uint dst_width, uint dst_height, Cogl.Bitmap bitmap);
	}
	[CCode (cheader_filename = "cogl/cogl.h")]
	[SimpleType]
	public struct Angle : int32 {
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_color_get_gtype ()")]
	[Version (since = "1.0")]
	public struct Color {
		[CCode (has_construct_function = false, type = "CoglColor*")]
		public Color ();
		public Cogl.Color? copy ();
		[CCode (cheader_filename = "cogl/cogl.h")]
		public bool equal ([CCode (type = "void*")] Cogl.Color v2);
		public void free ();
		[CCode (cname = "cogl_color_init_from_4f")]
		[Version (since = "1.4")]
		public Color.from_4f (float red, float green, float blue, float alpha);
		[CCode (cname = "cogl_color_init_from_4fv")]
		[Version (since = "1.4")]
		public Color.from_4fv (float color_array);
		[CCode (cname = "cogl_color_init_from_4ub")]
		[Version (since = "1.4")]
		public Color.from_4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
		[CCode (cname = "cogl_color_init_from_hsl")]
		[Version (since = "1.16")]
		public Color.from_hsl (float hue, float saturation, float luminance);
		public float get_alpha ();
		public uint8 get_alpha_byte ();
		public float get_alpha_float ();
		public float get_blue ();
		public uint8 get_blue_byte ();
		public float get_blue_float ();
		public float get_green ();
		public uint8 get_green_byte ();
		public float get_green_float ();
		public float get_red ();
		public uint8 get_red_byte ();
		public float get_red_float ();
		[Version (since = "1.4")]
		public void init_from_4f (float red, float green, float blue, float alpha);
		[Version (since = "1.4")]
		public void init_from_4fv (float color_array);
		[Version (since = "1.4")]
		public void init_from_4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
		[Version (since = "1.16")]
		public void init_from_hsl (float hue, float saturation, float luminance);
		public void premultiply ();
		[Version (since = "1.4")]
		public void set_alpha (float alpha);
		[Version (since = "1.4")]
		public void set_alpha_byte (uint8 alpha);
		[Version (since = "1.4")]
		public void set_alpha_float (float alpha);
		[Version (since = "1.4")]
		public void set_blue (float blue);
		[Version (since = "1.4")]
		public void set_blue_byte (uint8 blue);
		[Version (since = "1.4")]
		public void set_blue_float (float blue);
		[Version (since = "1.4")]
		public void set_green (float green);
		[Version (since = "1.4")]
		public void set_green_byte (uint8 green);
		[Version (since = "1.4")]
		public void set_green_float (float green);
		[Version (since = "1.4")]
		public void set_red (float red);
		[Version (since = "1.4")]
		public void set_red_byte (uint8 red);
		[Version (since = "1.4")]
		public void set_red_float (float red);
		[Version (since = "1.16")]
		public void to_hsl (out float hue, out float saturation, out float luminance);
		[Version (since = "1.4")]
		public void unpremultiply ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.8")]
	public struct DebugObjectTypeInfo {
		public weak string name;
		public ulong instance_count;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.16")]
	public struct OnscreenDirtyInfo {
		public int x;
		public int y;
		public int width;
		public int height;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct TextureVertex {
		public float x;
		public float y;
		public float z;
		public float tx;
		public float ty;
		public Cogl.Color color;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct TraceHead {
		public uint64 begin_time;
		public weak string name;
		public weak string description;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.4")]
	public struct UserDataKey {
		public int unused;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP2 {
		public float x;
		public float y;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP2C4 {
		public float x;
		public float y;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP2T2 {
		public float x;
		public float y;
		public float s;
		public float t;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP2T2C4 {
		public float x;
		public float y;
		public float s;
		public float t;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP3 {
		public float x;
		public float y;
		public float z;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP3C4 {
		public float x;
		public float y;
		public float z;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP3T2 {
		public float x;
		public float y;
		public float z;
		public float s;
		public float t;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.6")]
	public struct VertexP3T2C4 {
		public float x;
		public float y;
		public float z;
		public float s;
		public float t;
		public uint8 r;
		public uint8 g;
		public uint8 b;
		public uint8 a;
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_ATTRIBUTE_TYPE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum AttributeType {
		BYTE,
		UNSIGNED_BYTE,
		SHORT,
		UNSIGNED_SHORT,
		FLOAT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_BIT_", has_type_id = false)]
	[Flags]
	[Version (since = "1.0")]
	public enum BufferBit {
		COLOR,
		DEPTH,
		STENCIL
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_", has_type_id = false)]
	[Flags]
	[Version (since = "0.8")]
	public enum BufferTarget {
		WINDOW_BUFFER,
		OFFSCREEN_BUFFER
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_DEPTH_TEST_FUNCTION_", has_type_id = false)]
	public enum DepthTestFunction {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_EGL_IMAGE_FLAG_", has_type_id = false)]
	[Flags]
	public enum EglImageFlags {
		NONE,
		NO_GET_DATA
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FEATURE_ID_", has_type_id = false)]
	[Version (since = "1.10")]
	public enum FeatureID {
		[CCode (cname = "COGL_FEATURE_ID_UNSIGNED_INT_INDICES")]
		OGL_FEATURE_ID_UNSIGNED_INT_INDICES,
		[CCode (cname = "COGL_FEATURE_ID_MAP_BUFFER_FOR_READ")]
		OGL_FEATURE_ID_MAP_BUFFER_FOR_READ,
		[CCode (cname = "COGL_FEATURE_ID_MAP_BUFFER_FOR_WRITE")]
		OGL_FEATURE_ID_MAP_BUFFER_FOR_WRITE,
		[CCode (cname = "COGL_FEATURE_ID_FENCE")]
		OGL_FEATURE_ID_FENCE,
		[CCode (cname = "COGL_FEATURE_ID_TEXTURE_RG")]
		OGL_FEATURE_ID_TEXTURE_RG,
		[CCode (cname = "COGL_FEATURE_ID_BUFFER_AGE")]
		OGL_FEATURE_ID_BUFFER_AGE,
		[CCode (cname = "COGL_FEATURE_ID_TEXTURE_EGL_IMAGE_EXTERNAL")]
		OGL_FEATURE_ID_TEXTURE_EGL_IMAGE_EXTERNAL,
		[CCode (cname = "COGL_FEATURE_ID_BLIT_FRAMEBUFFER")]
		OGL_FEATURE_ID_BLIT_FRAMEBUFFER,
		[CCode (cname = "COGL_FEATURE_ID_TIMESTAMP_QUERY")]
		OGL_FEATURE_ID_TIMESTAMP_QUERY
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FILTER_", has_type_id = false)]
	public enum FilterReturn {
		CONTINUE,
		REMOVE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FRAME_EVENT_", has_type_id = false)]
	[Version (since = "1.14")]
	public enum FrameEvent {
		SYNC,
		COMPLETE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_GRAPHICS_RESET_STATUS_", has_type_id = false)]
	public enum GraphicsResetStatus {
		NO_ERROR,
		GUILTY_CONTEXT_RESET,
		INNOCENT_CONTEXT_RESET,
		UNKNOWN_CONTEXT_RESET,
		PURGED_CONTEXT_RESET
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_INDICES_TYPE_UNSIGNED_", has_type_id = false)]
	public enum IndicesType {
		BYTE,
		SHORT,
		INT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_ALPHA_FUNC_", has_type_id = false)]
	public enum PipelineAlphaFunc {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_CULL_FACE_MODE_", has_type_id = false)]
	public enum PipelineCullFaceMode {
		NONE,
		FRONT,
		BACK,
		BOTH
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_FILTER_", has_type_id = false)]
	public enum PipelineFilter {
		NEAREST,
		LINEAR,
		NEAREST_MIPMAP_NEAREST,
		LINEAR_MIPMAP_NEAREST,
		NEAREST_MIPMAP_LINEAR,
		LINEAR_MIPMAP_LINEAR
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_WRAP_MODE_", has_type_id = false)]
	[Version (since = "2.0")]
	public enum PipelineWrapMode {
		REPEAT,
		MIRRORED_REPEAT,
		CLAMP_TO_EDGE,
		AUTOMATIC
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIXEL_FORMAT_", has_type_id = false)]
	[Flags]
	[Version (since = "0.8")]
	public enum PixelFormat {
		ANY,
		A_8,
		RGB_565,
		RGBA_4444,
		RGBA_5551,
		YUV,
		G_8,
		RG_88,
		RGB_888,
		BGR_888,
#if HAS_MUTTER45
		RGBX_8888,
#endif
		RGBA_8888,
#if HAS_MUTTER45
		BGRX_8888,
#endif
		BGRA_8888,
#if HAS_MUTTER45
		XRGB_8888,
#endif
		ARGB_8888,
#if HAS_MUTTER45
		XBGR_8888,
#endif
		ABGR_8888,
		RGBA_1010102,
		BGRA_1010102,
		XRGB_2101010,
		ARGB_2101010,
		XBGR_2101010,
		ABGR_2101010,
#if HAS_MUTTER45
		RGBX_FP_16161616,
#endif
		RGBA_FP_16161616,
#if HAS_MUTTER45
		BGRX_FP_16161616,
#endif
		BGRA_FP_16161616,
		XRGB_FP_16161616,
		ARGB_FP_16161616,
		XBGR_FP_16161616,
		ABGR_FP_16161616,
		RGBA_8888_PRE,
		BGRA_8888_PRE,
		ARGB_8888_PRE,
		ABGR_8888_PRE,
		RGBA_4444_PRE,
		RGBA_5551_PRE,
		RGBA_1010102_PRE,
		BGRA_1010102_PRE,
		ARGB_2101010_PRE,
		ABGR_2101010_PRE,
		RGBA_FP_16161616_PRE,
		BGRA_FP_16161616_PRE,
		ARGB_FP_16161616_PRE,
		ABGR_FP_16161616_PRE,
		DEPTH_16,
		DEPTH_32,
		DEPTH_24_STENCIL_8;
		[CCode (cheader_filename = "cogl/cogl.h")]
		public int get_bytes_per_pixel (int plane);
		[CCode (cheader_filename = "cogl/cogl.h")]
		public int get_n_planes ();
		[CCode (cheader_filename = "cogl/cogl.h")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_READ_PIXELS_COLOR_", has_type_id = false)]
	[Flags]
	[Version (since = "1.0")]
	public enum ReadPixelsFlags {
		[CCode (cname = "COGL_READ_PIXELS_COLOR_BUFFER")]
		READ_PIXELS_COLOR_BUFFER
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SHADER_TYPE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum ShaderType {
		VERTEX,
		FRAGMENT
	}
#if HAS_MUTTER43
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SNIPPET_HOOK_", has_type_id = false)]
	[Version (since = "1.10")]
	public enum SnippetHook {
		VERTEX,
		VERTEX_TRANSFORM,
		VERTEX_GLOBALS,
		POINT_SIZE,
		FRAGMENT,
		FRAGMENT_GLOBALS,
		TEXTURE_COORD_TRANSFORM,
		LAYER_FRAGMENT,
		TEXTURE_LOOKUP
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_STEREO_", has_type_id = false)]
	public enum StereoMode {
		BOTH,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_COMPONENTS_", has_type_id = false)]
	[Version (since = "1.18")]
	public enum TextureComponents {
		A,
		RG,
		RGB,
		RGBA,
		DEPTH
	}
#if !HAS_MUTTER43
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_", has_type_id = false)]
	[Flags]
	[Version (since = "1.0")]
	public enum TextureFlags {
		NONE,
		NO_AUTO_MIPMAP,
		NO_SLICING,
		NO_ATLAS
	}
#endif
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_VERTICES_MODE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum VerticesMode {
		POINTS,
		LINES,
		LINE_LOOP,
		LINE_STRIP,
		TRIANGLES,
		TRIANGLE_STRIP,
		TRIANGLE_FAN
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_WINDING_", has_type_id = false)]
	public enum Winding {
		CLOCKWISE,
		COUNTER_CLOCKWISE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_WINSYS_FEATURE_", has_type_id = false)]
	public enum WinsysFeature {
		VBLANK_COUNTER,
		VBLANK_WAIT,
		TEXTURE_FROM_PIXMAP,
		SWAP_BUFFERS_EVENT,
		SWAP_REGION,
		SWAP_REGION_THROTTLE,
		SWAP_REGION_SYNCHRONIZED,
		BUFFER_AGE,
		SYNC_AND_COMPLETE_EVENT,
		N_FEATURES
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BITMAP_ERROR_", has_type_id = false)]
	[Version (since = "1.4")]
	public errordomain BitmapError {
		FAILED,
		UNKNOWN_TYPE,
		CORRUPT_IMAGE;
		public static uint32 quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BLEND_STRING_ERROR_", has_type_id = false)]
	[Version (since = "1.0")]
	public errordomain BlendStringError {
		PARSE_ERROR,
		ARGUMENT_PARSE_ERROR,
		INVALID_ERROR,
		GPU_UNSUPPORTED_ERROR;
		[CCode (cheader_filename = "cogl/cogl.h")]
		public static uint32 quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FRAMEBUFFER_ERROR_", has_type_id = false)]
	public errordomain FramebufferError {
		[CCode (cname = "COGL_FRAMEBUFFER_ERROR_ALLOCATE")]
		FRAMEBUFFER_ERROR_ALLOCATE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_RENDERER_ERROR_", has_type_id = false)]
	public errordomain RendererError {
		XLIB_DISPLAY_OPEN,
		BAD_CONSTRAINT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SCANOUT_ERROR_", has_type_id = false)]
	public errordomain ScanoutError {
		[CCode (cname = "COGL_SCANOUT_ERROR_INHIBITED")]
		SCANOUT_ERROR_INHIBITED;
		[CCode (cheader_filename = "cogl/cogl.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SYSTEM_ERROR_", has_type_id = false)]
	[Version (since = "1.4")]
	public errordomain SystemError {
		UNSUPPORTED,
		NO_MEMORY
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_ERROR_", has_type_id = false)]
	[Version (since = "1.8")]
	public errordomain TextureError {
		SIZE,
		FORMAT,
		BAD_PARAMETER,
		TYPE;
		public static uint32 quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	[Version (since = "1.8")]
	public delegate void DebugObjectForeachTypeCallback (Cogl.DebugObjectTypeInfo info);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	[Version (since = "0.10")]
	public delegate void FeatureCallback (Cogl.FeatureID feature);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 3.9)]
	[Version (since = "1.14")]
	public delegate void FrameCallback (Cogl.Onscreen onscreen, Cogl.FrameEvent event, Cogl.FrameInfo info);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	[Version (since = "1.16")]
	public delegate void OnscreenDirtyCallback (Cogl.Onscreen onscreen, Cogl.OnscreenDirtyInfo info);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	[Version (since = "2.0")]
	public delegate bool PipelineLayerCallback (Cogl.Pipeline pipeline, int layer_index);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	public delegate bool Texture2DEGLImageExternalAlloc (Cogl.Texture2D tex_2d) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void UserDataDestroyCallback (void* data);
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_AFIRST_BIT")]
	public const int AFIRST_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_A_BIT")]
	public const int A_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_BGR_BIT")]
	public const int BGR_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_DEPTH_BIT")]
	public const int DEPTH_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_PIXEL_FORMAT_MAX_PLANES")]
	public const int PIXEL_FORMAT_MAX_PLANES;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_PREMULT_BIT")]
	public const int PREMULT_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_STENCIL_BIT")]
	public const int STENCIL_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_TEXTURE_MAX_WASTE")]
	public const int TEXTURE_MAX_WASTE;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool blit_framebuffer (Cogl.Framebuffer framebuffer, Cogl.Framebuffer dst, int src_x, int src_y, int dst_x, int dst_y, int width, int height) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool clutter_winsys_has_feature_CLUTTER (Cogl.WinsysFeature feature);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.8")]
	public static void debug_object_foreach_type (Cogl.DebugObjectForeachTypeCallback func);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.8")]
	public static void debug_object_print_instances ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.0")]
	public static void flush ();
#if !HAS_MUTTER44
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static GLib.OptionGroup get_option_group ();
#endif
#if HAS_MUTTER45
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool is_tracing ();
#endif
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_tracing_disabled_on_thread (GLib.MainContext main_context);
#if HAS_MUTTER45
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_tracing_enabled_on_thread (GLib.MainContext main_context, string group);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool start_tracing_with_fd (int fd) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static bool start_tracing_with_path (string filename) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void stop_tracing ();
#else
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_tracing_enabled_on_thread (GLib.MainContext main_context, string group, string filename);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void set_tracing_enabled_on_thread_with_fd (GLib.MainContext main_context, string group, int fd);
#endif
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void trace_describe (Cogl.TraceHead head, string description);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void trace_end (Cogl.TraceHead head);
}

