// @target: es5
// @declaration: true

// Should allow accessor in ambient contexts even when targeting ES5

declare class AmbientClass {
    accessor prop1: string;
    static accessor prop2: number;
    private accessor prop3: boolean;
    private static accessor prop4: symbol;
}

declare namespace AmbientNamespace {
    class C {
        accessor prop: string;
    }
}

// Should also work in .d.ts files (simulated with declare)
declare module "some-module" {
    export class ExportedClass {
        accessor value: any;
    }
}

// Regular class should still error when targeting ES5
class RegularClass {
    accessor shouldError: string; // Should still error
}