; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; smax(smin(X, MinC), MaxC) -> smin(smax(X, MaxC), MinC)
; umax(umin(X, MinC), MaxC) -> umin(smax(X, MaxC), MinC)


define i16 @smax_smin(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -1)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smin.i16(i16 [[TMP1]], i16 255)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 -1)
  ret i16 %max
}

define i16 @umax_umin(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 63)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umin.i16(i16 [[TMP1]], i16 255)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 63)
  ret i16 %max
}

define i16 @smax_smin_commute0(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin_commute0(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -128)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smin.i16(i16 [[TMP1]], i16 127)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 127)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 -128)
  ret i16 %max
}

define i16 @umax_umin_commute0(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_commute0(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 127)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umin.i16(i16 [[TMP1]], i16 255)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 127)
  ret i16 %max
}

define i16 @smax_smin_commute1(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin_commute1(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -128)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smin.i16(i16 [[TMP1]], i16 127)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.smin.i16(i16 127, i16 %x)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 -128)
  ret i16 %max
}

define i16 @umax_umin_commute1(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_commute1(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 127)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umin.i16(i16 [[TMP1]], i16 255)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.umin.i16(i16 255, i16 %x)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 127)
  ret i16 %max
}

define i16 @smax_smin_commute2(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin_commute2(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -128)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smin.i16(i16 [[TMP1]], i16 127)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 127)
  %max = call i16 @llvm.smax.i16(i16 -128, i16 %min)
  ret i16 %max
}

define i16 @umax_umin_commute2(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_commute2(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 127)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umin.i16(i16 [[TMP1]], i16 255)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.umax.i16(i16 127, i16 %min)
  ret i16 %max
}

define i16 @smax_smin_commute3(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin_commute3(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -128)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smin.i16(i16 [[TMP1]], i16 127)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 127)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 -128)
  ret i16 %max
}

define i16 @umax_umin_commute3(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_commute3(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 127)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umin.i16(i16 [[TMP1]], i16 255)
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 127)
  ret i16 %max
}

define <2 x i16> @smax_smin_v2i16(<2 x i16> %x) {
; CHECK-LABEL: define <2 x i16> @smax_smin_v2i16(
; CHECK-SAME: <2 x i16> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i16> @llvm.smax.v2i16(<2 x i16> [[X]], <2 x i16> splat (i16 -128))
; CHECK-NEXT:    [[MAX:%.*]] = call <2 x i16> @llvm.smin.v2i16(<2 x i16> [[TMP1]], <2 x i16> splat (i16 127))
; CHECK-NEXT:    ret <2 x i16> [[MAX]]
;
  %min = call <2 x i16> @llvm.smin.v2i16(<2 x i16> %x, <2 x i16> splat (i16 127))
  %max = call <2 x i16> @llvm.smax.v2i16(<2 x i16> %min, <2 x i16> splat (i16 -128))
  ret <2 x i16> %max
}

define <2 x i16> @umax_umin_v2i16(<2 x i16> %x) {
; CHECK-LABEL: define <2 x i16> @umax_umin_v2i16(
; CHECK-SAME: <2 x i16> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i16> @llvm.umax.v2i16(<2 x i16> [[X]], <2 x i16> splat (i16 127))
; CHECK-NEXT:    [[MAX:%.*]] = call <2 x i16> @llvm.umin.v2i16(<2 x i16> [[TMP1]], <2 x i16> splat (i16 255))
; CHECK-NEXT:    ret <2 x i16> [[MAX]]
;
  %min = call <2 x i16> @llvm.umin.v2i16(<2 x i16> %x, <2 x i16> splat (i16 255))
  %max = call <2 x i16> @llvm.umax.v2i16(<2 x i16> %min, <2 x i16> splat (i16 127))
  ret <2 x i16> %max
}

define <2 x i8> @smax_smin_v2i16_nonsplat_1(<2 x i8> %a) {
; CHECK-LABEL: define <2 x i8> @smax_smin_v2i16_nonsplat_1(
; CHECK-SAME: <2 x i8> [[A:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call <2 x i8> @llvm.smin.v2i8(<2 x i8> [[A]], <2 x i8> <i8 20, i8 10>)
; CHECK-NEXT:    [[MAX:%.*]] = call <2 x i8> @llvm.smax.v2i8(<2 x i8> [[MIN]], <2 x i8> <i8 10, i8 0>)
; CHECK-NEXT:    ret <2 x i8> [[MAX]]
;
  %min = call <2 x i8> @llvm.smin(<2 x i8> %a, <2 x i8> <i8 20, i8 10>)
  %max = call <2 x i8> @llvm.smax(<2 x i8> %min, <2 x i8> <i8 10, i8 0>)
  ret <2 x i8> %max
}

define <2 x i16> @umax_umin_v2i16_nonsplat_1(<2 x i16> %a) {
; CHECK-LABEL: define <2 x i16> @umax_umin_v2i16_nonsplat_1(
; CHECK-SAME: <2 x i16> [[A:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call <2 x i16> @llvm.umin.v2i16(<2 x i16> [[A]], <2 x i16> <i16 20, i16 10>)
; CHECK-NEXT:    [[MAX:%.*]] = call <2 x i16> @llvm.umax.v2i16(<2 x i16> [[MIN]], <2 x i16> <i16 10, i16 1>)
; CHECK-NEXT:    ret <2 x i16> [[MAX]]
;
  %min = call <2 x i16> @llvm.umin(<2 x i16> %a, <2 x i16> <i16 20, i16 10>)
  %max = call <2 x i16> @llvm.umax(<2 x i16> %min, <2 x i16> <i16 10, i16 1>)
  ret <2 x i16> %max
}

define <2 x i8> @smax_smin_v2i16_nonsplat_2(<2 x i8> %a) {
; CHECK-LABEL: define <2 x i8> @smax_smin_v2i16_nonsplat_2(
; CHECK-SAME: <2 x i8> [[A:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call <2 x i8> @llvm.smin.v2i8(<2 x i8> [[A]], <2 x i8> <i8 0, i8 10>)
; CHECK-NEXT:    [[MAX:%.*]] = call <2 x i8> @llvm.smax.v2i8(<2 x i8> [[MIN]], <2 x i8> <i8 10, i8 0>)
; CHECK-NEXT:    ret <2 x i8> [[MAX]]
;
  %min = call <2 x i8> @llvm.smin(<2 x i8> %a, <2 x i8> <i8 0, i8 10>)
  %max = call <2 x i8> @llvm.smax(<2 x i8> %min, <2 x i8> <i8 10, i8 0>)
  ret <2 x i8> %max
}

define <2 x i16> @umax_umin_v2i16_nonsplat_2(<2 x i16> %a) {
; CHECK-LABEL: define <2 x i16> @umax_umin_v2i16_nonsplat_2(
; CHECK-SAME: <2 x i16> [[A:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call <2 x i16> @llvm.umin.v2i16(<2 x i16> [[A]], <2 x i16> <i16 1, i16 10>)
; CHECK-NEXT:    [[MAX:%.*]] = call <2 x i16> @llvm.umax.v2i16(<2 x i16> [[MIN]], <2 x i16> <i16 10, i16 1>)
; CHECK-NEXT:    ret <2 x i16> [[MAX]]
;
  %min = call <2 x i16> @llvm.umin(<2 x i16> %a, <2 x i16> <i16 1, i16 10>)
  %max = call <2 x i16> @llvm.umax(<2 x i16> %min, <2 x i16> <i16 10, i16 1>)
  ret <2 x i16> %max
}

declare void @use(i16)

define i16 @smax_smin_used(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin_used(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.smin.i16(i16 [[X]], i16 127)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smax.i16(i16 [[MIN]], i16 -128)
; CHECK-NEXT:    call void @use(i16 [[MIN]])
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 127)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 -128)
  call void @use(i16 %min)
  ret i16 %max
}

define i16 @umax_umin_used(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_used(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.umin.i16(i16 [[X]], i16 255)
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umax.i16(i16 [[MIN]], i16 127)
; CHECK-NEXT:    call void @use(i16 [[MIN]])
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 127)
  call void @use(i16 %min)
  ret i16 %max
}


define i16 @smax_smin_i16_limits(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin_i16_limits(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    ret i16 [[X]]
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 32767)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 -32768)
  ret i16 %max
}

define i16 @umax_umin_i16_limits(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_i16_limits(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    ret i16 [[X]]
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 65535)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 0)
  ret i16 %max
}

define i16 @min_smax_smin_nested(i16 %x) {
; CHECK-LABEL: define i16 @min_smax_smin_nested(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -128)
; CHECK-NEXT:    [[MIN2:%.*]] = call i16 @llvm.smin.i16(i16 [[TMP1]], i16 127)
; CHECK-NEXT:    ret i16 [[MIN2]]
;
  %min1 = call i16 @llvm.smin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.smax.i16(i16 %min1, i16 -128)
  %min2 = call i16 @llvm.smin.i16(i16 %max, i16 127)
  ret i16 %min2
}

define i16 @umax_umin_nested(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_nested(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 63)
; CHECK-NEXT:    [[MIN2:%.*]] = call i16 @llvm.umin.i16(i16 [[MAX]], i16 127)
; CHECK-NEXT:    ret i16 [[MIN2]]
;
  %min1 = call i16 @llvm.umin.i16(i16 %x, i16 255)
  %max = call i16 @llvm.umax.i16(i16 %min1, i16 63)
  %min2 = call i16 @llvm.umin.i16(i16 %max, i16 127)
  ret i16 %min2
}

define i16 @smax_smin_cmax_sgt_cmin(i16 %x) {
; CHECK-LABEL: define i16 @smax_smin_cmax_sgt_cmin(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    ret i16 127
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 126)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 127)
  ret i16 %max
}

define i16 @umax_umin_cmax_ugt_cmin(i16 %x) {
; CHECK-LABEL: define i16 @umax_umin_cmax_ugt_cmin(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    ret i16 127
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 126)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 127)
  ret i16 %max
}

define i16 @smax_smin_variables(i16 %x, i16 %y, i16 %z) {
; CHECK-LABEL: define i16 @smax_smin_variables(
; CHECK-SAME: i16 [[X:%.*]], i16 [[Y:%.*]], i16 [[Z:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.smin.i16(i16 [[X]], i16 [[Y]])
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smax.i16(i16 [[MIN]], i16 [[Z]])
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.smin.i16(i16 %x, i16 %y)
  %max = call i16 @llvm.smax.i16(i16 %min, i16 %z)
  ret i16 %max
}

define i16 @umax_umin_variables(i16 %x, i16 %y, i16 %z) {
; CHECK-LABEL: define i16 @umax_umin_variables(
; CHECK-SAME: i16 [[X:%.*]], i16 [[Y:%.*]], i16 [[Z:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.umin.i16(i16 [[X]], i16 [[Y]])
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umax.i16(i16 [[MIN]], i16 [[Z]])
; CHECK-NEXT:    ret i16 [[MAX]]
;
  %min = call i16 @llvm.umin.i16(i16 %x, i16 %y)
  %max = call i16 @llvm.umax.i16(i16 %min, i16 %z)
  ret i16 %max
}

define i16 @smin_smax(i16 %x) {
; CHECK-LABEL: define i16 @smin_smax(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -128)
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.smin.i16(i16 [[MAX]], i16 127)
; CHECK-NEXT:    ret i16 [[MIN]]
;
  %max = call i16 @llvm.smax.i16(i16 %x, i16 -128)
  %min = call i16 @llvm.smin.i16(i16 %max, i16 127)
  ret i16 %min
}

define i16 @umin_umax(i16 %x) {
; CHECK-LABEL: define i16 @umin_umax(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 127)
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.umin.i16(i16 [[MAX]], i16 255)
; CHECK-NEXT:    ret i16 [[MIN]]
;
  %max = call i16 @llvm.umax.i16(i16 %x, i16 127)
  %min = call i16 @llvm.umin.i16(i16 %max, i16 255)
  ret i16 %min
}

define i16 @smin_umax(i16 %x) {
; CHECK-LABEL: define i16 @smin_umax(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.umax.i16(i16 [[X]], i16 127)
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.smin.i16(i16 [[MAX]], i16 255)
; CHECK-NEXT:    ret i16 [[MIN]]
;
  %max = call i16 @llvm.umax.i16(i16 %x, i16 127)
  %min = call i16 @llvm.smin.i16(i16 %max, i16 255)
  ret i16 %min
}

define i16 @umin_smax(i16 %x) {
; CHECK-LABEL: define i16 @umin_smax(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i16 @llvm.smax.i16(i16 [[X]], i16 -128)
; CHECK-NEXT:    [[MIN:%.*]] = call i16 @llvm.umin.i16(i16 [[MAX]], i16 127)
; CHECK-NEXT:    ret i16 [[MIN]]
;
  %max = call i16 @llvm.smax.i16(i16 %x, i16 -128)
  %min = call i16 @llvm.umin.i16(i16 %max, i16 127)
  ret i16 %min
}
