; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc -O0 -mtriple=aarch64-linux-gnu -global-isel -stop-after=irtranslator %s -o - | FileCheck %s

define void @scmp_i32(i32 %arg1, i32 %arg2) {
  ; CHECK-LABEL: name: scmp_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[SCMP:%[0-9]+]]:_(s4) = G_SCMP [[COPY]](s32), [[COPY1]]
  ; CHECK-NEXT:   RET_ReallyLR
  %res4 = call i4 @llvm.scmp.i4.i32(i32 %arg1, i32 %arg2)
  ret void
}

define void @scmp_4_32i(<4 x i32> %arg1, <4 x i32> %arg2) {
  ; CHECK-LABEL: name: scmp_4_32i
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $q0, $q1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<4 x s32>) = COPY $q0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(<4 x s32>) = COPY $q1
  ; CHECK-NEXT:   [[SCMP:%[0-9]+]]:_(<4 x s32>) = G_SCMP [[COPY]](<4 x s32>), [[COPY1]]
  ; CHECK-NEXT:   RET_ReallyLR
  %res4 = call <4 x i32> @llvm.scmp.v4i32.i32(<4 x i32> %arg1, <4 x i32> %arg2)
  ret void
}

define void @ucmp_i32(i32 %arg1, i32 %arg2) {
  ; CHECK-LABEL: name: ucmp_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[UCMP:%[0-9]+]]:_(s4) = G_UCMP [[COPY]](s32), [[COPY1]]
  ; CHECK-NEXT:   RET_ReallyLR
  %res4 = call i4 @llvm.ucmp.i4.i32(i32 %arg1, i32 %arg2)
  ret void
}

define void @ucmp_4_32i(<4 x i32> %arg1, <4 x i32> %arg2) {
  ; CHECK-LABEL: name: ucmp_4_32i
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $q0, $q1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<4 x s32>) = COPY $q0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(<4 x s32>) = COPY $q1
  ; CHECK-NEXT:   [[UCMP:%[0-9]+]]:_(<4 x s32>) = G_UCMP [[COPY]](<4 x s32>), [[COPY1]]
  ; CHECK-NEXT:   RET_ReallyLR
  %res4 = call <4 x i32> @llvm.ucmp.v4i32.i32(<4 x i32> %arg1, <4 x i32> %arg2)
  ret void
}
