; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i1 @test_switch_with_neg(i32 %a) {
; CHECK-LABEL: define i1 @test_switch_with_neg(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[A]], label [[SW_DEFAULT:%.*]] [
; CHECK-NEXT:      i32 -37, label [[SW_BB:%.*]]
; CHECK-NEXT:      i32 -38, label [[SW_BB]]
; CHECK-NEXT:      i32 -39, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    ret i1 true
; CHECK:       sw.default:
; CHECK-NEXT:    ret i1 false
;
entry:
  %a.neg = sub i32 0, %a
  switch i32 %a.neg, label %sw.default [
  i32 37, label %sw.bb
  i32 38, label %sw.bb
  i32 39, label %sw.bb
  ]

sw.bb:
  ret i1 true
sw.default:
  ret i1 false
}

define i1 @test_switch_with_sub(i32 %a) {
; CHECK-LABEL: define i1 @test_switch_with_sub(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[A]], label [[SW_DEFAULT:%.*]] [
; CHECK-NEXT:      i32 0, label [[SW_BB:%.*]]
; CHECK-NEXT:      i32 -1, label [[SW_BB]]
; CHECK-NEXT:      i32 -2, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    ret i1 true
; CHECK:       sw.default:
; CHECK-NEXT:    ret i1 false
;
entry:
  %a.neg = sub i32 37, %a
  switch i32 %a.neg, label %sw.default [
  i32 37, label %sw.bb
  i32 38, label %sw.bb
  i32 39, label %sw.bb
  ]

sw.bb:
  ret i1 true
sw.default:
  ret i1 false
}

; Negative tests

define i1 @test_switch_with_sub_nonconst(i32 %a, i32 %b) {
; CHECK-LABEL: define i1 @test_switch_with_sub_nonconst(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_NEG:%.*]] = sub i32 [[B]], [[A]]
; CHECK-NEXT:    switch i32 [[A_NEG]], label [[SW_DEFAULT:%.*]] [
; CHECK-NEXT:      i32 37, label [[SW_BB:%.*]]
; CHECK-NEXT:      i32 38, label [[SW_BB]]
; CHECK-NEXT:      i32 39, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    ret i1 true
; CHECK:       sw.default:
; CHECK-NEXT:    ret i1 false
;
entry:
  %a.neg = sub i32 %b, %a
  switch i32 %a.neg, label %sw.default [
  i32 37, label %sw.bb
  i32 38, label %sw.bb
  i32 39, label %sw.bb
  ]

sw.bb:
  ret i1 true
sw.default:
  ret i1 false
}
