//go:build linux && cgo && !agent

package cluster

// The code below was generated by lxd-generate - DO NOT EDIT!

import (
	"context"
	"database/sql"
	"errors"
	"fmt"
	"net/http"
	"strings"

	"github.com/canonical/lxd/lxd/db/query"
	"github.com/canonical/lxd/shared/api"
)

var _ = api.ServerEnvironment{}

var placementGroupObjects = RegisterStmt(`
SELECT placement_groups.id, placement_groups.name, projects.name AS project, coalesce(placement_groups.description, '')
  FROM placement_groups
  JOIN projects ON placement_groups.project_id = projects.id
  ORDER BY placement_groups.name, projects.id
`)

var placementGroupObjectsByID = RegisterStmt(`
SELECT placement_groups.id, placement_groups.name, projects.name AS project, coalesce(placement_groups.description, '')
  FROM placement_groups
  JOIN projects ON placement_groups.project_id = projects.id
  WHERE ( placement_groups.id = ? )
  ORDER BY placement_groups.name, projects.id
`)

var placementGroupObjectsByProject = RegisterStmt(`
SELECT placement_groups.id, placement_groups.name, projects.name AS project, coalesce(placement_groups.description, '')
  FROM placement_groups
  JOIN projects ON placement_groups.project_id = projects.id
  WHERE ( project = ? )
  ORDER BY placement_groups.name, projects.id
`)

var placementGroupObjectsByNameAndProject = RegisterStmt(`
SELECT placement_groups.id, placement_groups.name, projects.name AS project, coalesce(placement_groups.description, '')
  FROM placement_groups
  JOIN projects ON placement_groups.project_id = projects.id
  WHERE ( placement_groups.name = ? AND project = ? )
  ORDER BY placement_groups.name, projects.id
`)

var placementGroupID = RegisterStmt(`
SELECT placement_groups.id FROM placement_groups
  JOIN projects ON placement_groups.project_id = projects.id
  WHERE placement_groups.name = ? AND projects.name = ?
`)

var placementGroupCreate = RegisterStmt(`
INSERT INTO placement_groups (name, project_id, description)
  VALUES (?, (SELECT projects.id FROM projects WHERE projects.name = ?), ?)
`)

var placementGroupDeleteByNameAndProject = RegisterStmt(`
DELETE FROM placement_groups WHERE name = ? AND project_id = (SELECT projects.id FROM projects WHERE projects.name = ?)
`)

var placementGroupUpdate = RegisterStmt(`
UPDATE placement_groups
  SET name = ?, project_id = (SELECT projects.id FROM projects WHERE projects.name = ?), description = ?
 WHERE id = ?
`)

var placementGroupRename = RegisterStmt(`
UPDATE placement_groups SET name = ? WHERE name = ? AND project_id = (SELECT projects.id FROM projects WHERE projects.name = ?)
`)

// getPlacementGroups can be used to run handwritten sql.Stmts to return a slice of objects.
func getPlacementGroups(ctx context.Context, stmt *sql.Stmt, args ...any) ([]PlacementGroup, error) {
	objects := make([]PlacementGroup, 0)

	dest := func(scan func(dest ...any) error) error {
		p := PlacementGroup{}
		err := scan(&p.ID, &p.Name, &p.Project, &p.Description)
		if err != nil {
			return err
		}

		objects = append(objects, p)

		return nil
	}

	err := query.SelectObjects(ctx, stmt, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"placements_groups\" table: %w", err)
	}

	return objects, nil
}

// getPlacementGroupsRaw can be used to run handwritten query strings to return a slice of objects.
func getPlacementGroupsRaw(ctx context.Context, tx *sql.Tx, sql string, args ...any) ([]PlacementGroup, error) {
	objects := make([]PlacementGroup, 0)

	dest := func(scan func(dest ...any) error) error {
		p := PlacementGroup{}
		err := scan(&p.ID, &p.Name, &p.Project, &p.Description)
		if err != nil {
			return err
		}

		objects = append(objects, p)

		return nil
	}

	err := query.Scan(ctx, tx, sql, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"placements_groups\" table: %w", err)
	}

	return objects, nil
}

// GetPlacementGroups returns all available placement_groups.
// generator: placement_group GetMany
func GetPlacementGroups(ctx context.Context, tx *sql.Tx, filters ...PlacementGroupFilter) ([]PlacementGroup, error) {
	var err error

	// Result slice.
	objects := make([]PlacementGroup, 0)

	// Pick the prepared statement and arguments to use based on active criteria.
	var sqlStmt *sql.Stmt
	args := []any{}
	queryParts := [2]string{}

	if len(filters) == 0 {
		sqlStmt, err = Stmt(tx, placementGroupObjects)
		if err != nil {
			return nil, fmt.Errorf("Failed to get \"placementGroupObjects\" prepared statement: %w", err)
		}
	}

	for i, filter := range filters {
		if filter.Name != nil && filter.Project != nil && filter.ID == nil {
			args = append(args, []any{filter.Name, filter.Project}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(tx, placementGroupObjectsByNameAndProject)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"placementGroupObjectsByNameAndProject\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(placementGroupObjectsByNameAndProject)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"placementGroupObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.Project != nil && filter.ID == nil && filter.Name == nil {
			args = append(args, []any{filter.Project}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(tx, placementGroupObjectsByProject)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"placementGroupObjectsByProject\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(placementGroupObjectsByProject)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"placementGroupObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID != nil && filter.Project == nil && filter.Name == nil {
			args = append(args, []any{filter.ID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(tx, placementGroupObjectsByID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"placementGroupObjectsByID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(placementGroupObjectsByID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"placementGroupObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID == nil && filter.Project == nil && filter.Name == nil {
			return nil, errors.New("Cannot filter on empty PlacementGroupFilter")
		} else {
			return nil, errors.New("No statement exists for the given Filter")
		}
	}

	// Select.
	if sqlStmt != nil {
		objects, err = getPlacementGroups(ctx, sqlStmt, args...)
	} else {
		queryStr := strings.Join(queryParts[:], "ORDER BY")
		objects, err = getPlacementGroupsRaw(ctx, tx, queryStr, args...)
	}

	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"placements_groups\" table: %w", err)
	}

	return objects, nil
}

// GetPlacementGroup returns the placement_group with the given key.
// generator: placement_group GetOne
func GetPlacementGroup(ctx context.Context, tx *sql.Tx, name string, project string) (*PlacementGroup, error) {
	filter := PlacementGroupFilter{}
	filter.Name = &name
	filter.Project = &project

	objects, err := GetPlacementGroups(ctx, tx, filter)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"placements_groups\" table: %w", err)
	}

	switch len(objects) {
	case 0:
		return nil, api.StatusErrorf(http.StatusNotFound, "PlacementGroup not found")
	case 1:
		return &objects[0], nil
	default:
		return nil, errors.New("More than one \"placements_groups\" entry matches")
	}
}

// GetPlacementGroupID return the ID of the placement_group with the given key.
// generator: placement_group ID
func GetPlacementGroupID(ctx context.Context, tx *sql.Tx, name string, project string) (int64, error) {
	stmt, err := Stmt(tx, placementGroupID)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"placementGroupID\" prepared statement: %w", err)
	}

	row := stmt.QueryRowContext(ctx, name, project)
	var id int64
	err = row.Scan(&id)
	if err != nil {
		if errors.Is(err, sql.ErrNoRows) {
			return -1, api.StatusErrorf(http.StatusNotFound, "PlacementGroup not found")
		}

		return -1, fmt.Errorf("Failed to get \"placements_groups\" ID: %w", err)
	}

	return id, nil
}

// PlacementGroupExists checks if a placement_group with the given key exists.
// generator: placement_group Exists
func PlacementGroupExists(ctx context.Context, tx *sql.Tx, name string, project string) (bool, error) {
	_, err := GetPlacementGroupID(ctx, tx, name, project)
	if err != nil {
		if api.StatusErrorCheck(err, http.StatusNotFound) {
			return false, nil
		}

		return false, err
	}

	return true, nil
}

// CreatePlacementGroup adds a new placement_group to the database.
// generator: placement_group Create
func CreatePlacementGroup(ctx context.Context, tx *sql.Tx, object PlacementGroup) (int64, error) {
	args := make([]any, 3)

	// Populate the statement arguments.
	args[0] = object.Name
	args[1] = object.Project
	args[2] = object.Description

	// Prepared statement to use.
	stmt, err := Stmt(tx, placementGroupCreate)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"placementGroupCreate\" prepared statement: %w", err)
	}

	// Execute the statement.
	result, err := stmt.ExecContext(ctx, args...)
	if err != nil {
		if query.IsConflictErr(err) {
			return -1, api.NewStatusError(http.StatusConflict, "This \"placements_groups\" entry already exists")
		}

		return -1, fmt.Errorf("Failed to create \"placements_groups\" entry: %w", err)
	}

	id, err := result.LastInsertId()
	if err != nil {
		return -1, fmt.Errorf("Failed to fetch \"placements_groups\" entry ID: %w", err)
	}

	return id, nil
}

// DeletePlacementGroup deletes the placement_group matching the given key parameters.
// generator: placement_group DeleteOne-by-Name-and-Project
func DeletePlacementGroup(ctx context.Context, tx *sql.Tx, name string, project string) error {
	stmt, err := Stmt(tx, placementGroupDeleteByNameAndProject)
	if err != nil {
		return fmt.Errorf("Failed to get \"placementGroupDeleteByNameAndProject\" prepared statement: %w", err)
	}

	result, err := stmt.ExecContext(ctx, name, project)
	if err != nil {
		return fmt.Errorf("Delete \"placements_groups\": %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n == 0 {
		return api.StatusErrorf(http.StatusNotFound, "PlacementGroup not found")
	} else if n > 1 {
		return fmt.Errorf("Query deleted %d PlacementGroup rows instead of 1", n)
	}

	return nil
}

// UpdatePlacementGroup updates the placement_group matching the given key parameters.
// generator: placement_group Update
func UpdatePlacementGroup(ctx context.Context, tx *sql.Tx, name string, project string, object PlacementGroup) error {
	id, err := GetPlacementGroupID(ctx, tx, name, project)
	if err != nil {
		return err
	}

	stmt, err := Stmt(tx, placementGroupUpdate)
	if err != nil {
		return fmt.Errorf("Failed to get \"placementGroupUpdate\" prepared statement: %w", err)
	}

	result, err := stmt.ExecContext(ctx, object.Name, object.Project, object.Description, id)
	if err != nil {
		if query.IsConflictErr(err) {
			return api.NewStatusError(http.StatusConflict, "A \"placements_groups\" entry already exists with these properties")
		}

		return fmt.Errorf("Update \"placements_groups\" entry failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query updated %d rows instead of 1", n)
	}

	return nil
}

// RenamePlacementGroup renames the placement_group matching the given key parameters.
// generator: placement_group Rename
func RenamePlacementGroup(ctx context.Context, tx *sql.Tx, name string, project string, to string) error {
	stmt, err := Stmt(tx, placementGroupRename)
	if err != nil {
		return fmt.Errorf("Failed to get \"placementGroupRename\" prepared statement: %w", err)
	}

	result, err := stmt.ExecContext(ctx, to, name, project)
	if err != nil {
		if query.IsConflictErr(err) {
			return api.NewStatusError(http.StatusConflict, "A \"placements_groups\" entry already exists with this name")
		}

		return fmt.Errorf("Rename PlacementGroup failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows failed: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query affected %d rows instead of 1", n)
	}

	return nil
}
