
#include "Meta_Maps.h"

#include <glbinding/gl/extension.h>


using namespace gl;


namespace glbinding { namespace aux
{


const std::unordered_map<GLextension, std::set<std::string>> Meta_FunctionStringsByExtension =
{
    { GLextension::GL_3DFX_tbuffer, { "glTbufferMask3DFX" } },
    { GLextension::GL_AMD_debug_output, { "glDebugMessageCallbackAMD", "glDebugMessageEnableAMD", "glDebugMessageInsertAMD", "glGetDebugMessageLogAMD" } },
    { GLextension::GL_AMD_draw_buffers_blend, { "glBlendEquationIndexedAMD", "glBlendEquationSeparateIndexedAMD", "glBlendFuncIndexedAMD", "glBlendFuncSeparateIndexedAMD" } },
    { GLextension::GL_AMD_framebuffer_multisample_advanced, { "glNamedRenderbufferStorageMultisampleAdvancedAMD", "glRenderbufferStorageMultisampleAdvancedAMD" } },
    { GLextension::GL_AMD_framebuffer_sample_positions, { "glFramebufferSamplePositionsfvAMD", "glGetFramebufferParameterfvAMD", "glGetNamedFramebufferParameterfvAMD", "glNamedFramebufferSamplePositionsfvAMD" } },
    { GLextension::GL_AMD_gpu_shader_int64, { "glGetUniformi64vNV", "glGetUniformui64vNV", "glProgramUniform1i64NV", "glProgramUniform1i64vNV", "glProgramUniform1ui64NV", "glProgramUniform1ui64vNV", "glProgramUniform2i64NV", "glProgramUniform2i64vNV", "glProgramUniform2ui64NV", "glProgramUniform2ui64vNV", "glProgramUniform3i64NV", "glProgramUniform3i64vNV", "glProgramUniform3ui64NV", "glProgramUniform3ui64vNV", "glProgramUniform4i64NV", "glProgramUniform4i64vNV", "glProgramUniform4ui64NV", "glProgramUniform4ui64vNV", "glUniform1i64NV", "glUniform1i64vNV", "glUniform1ui64NV", "glUniform1ui64vNV", "glUniform2i64NV", "glUniform2i64vNV", "glUniform2ui64NV", "glUniform2ui64vNV", "glUniform3i64NV", "glUniform3i64vNV", "glUniform3ui64NV", "glUniform3ui64vNV", "glUniform4i64NV", "glUniform4i64vNV", "glUniform4ui64NV", "glUniform4ui64vNV" } },
    { GLextension::GL_AMD_interleaved_elements, { "glVertexAttribParameteriAMD" } },
    { GLextension::GL_AMD_multi_draw_indirect, { "glMultiDrawArraysIndirectAMD", "glMultiDrawElementsIndirectAMD" } },
    { GLextension::GL_AMD_name_gen_delete, { "glDeleteNamesAMD", "glGenNamesAMD", "glIsNameAMD" } },
    { GLextension::GL_AMD_occlusion_query_event, { "glQueryObjectParameteruiAMD" } },
    { GLextension::GL_AMD_performance_monitor, { "glBeginPerfMonitorAMD", "glDeletePerfMonitorsAMD", "glEndPerfMonitorAMD", "glGenPerfMonitorsAMD", "glGetPerfMonitorCounterDataAMD", "glGetPerfMonitorCounterInfoAMD", "glGetPerfMonitorCountersAMD", "glGetPerfMonitorCounterStringAMD", "glGetPerfMonitorGroupsAMD", "glGetPerfMonitorGroupStringAMD", "glSelectPerfMonitorCountersAMD" } },
    { GLextension::GL_AMD_sample_positions, { "glSetMultisamplefvAMD" } },
    { GLextension::GL_AMD_sparse_texture, { "glTexStorageSparseAMD", "glTextureStorageSparseAMD" } },
    { GLextension::GL_AMD_stencil_operation_extended, { "glStencilOpValueAMD" } },
    { GLextension::GL_AMD_vertex_shader_tessellator, { "glTessellationFactorAMD", "glTessellationModeAMD" } },
    { GLextension::GL_APPLE_element_array, { "glDrawElementArrayAPPLE", "glDrawRangeElementArrayAPPLE", "glElementPointerAPPLE", "glMultiDrawElementArrayAPPLE", "glMultiDrawRangeElementArrayAPPLE" } },
    { GLextension::GL_APPLE_fence, { "glDeleteFencesAPPLE", "glFinishFenceAPPLE", "glFinishObjectAPPLE", "glGenFencesAPPLE", "glIsFenceAPPLE", "glSetFenceAPPLE", "glTestFenceAPPLE", "glTestObjectAPPLE" } },
    { GLextension::GL_APPLE_flush_buffer_range, { "glBufferParameteriAPPLE", "glFlushMappedBufferRangeAPPLE" } },
    { GLextension::GL_APPLE_object_purgeable, { "glGetObjectParameterivAPPLE", "glObjectPurgeableAPPLE", "glObjectUnpurgeableAPPLE" } },
    { GLextension::GL_APPLE_texture_range, { "glGetTexParameterPointervAPPLE", "glTextureRangeAPPLE" } },
    { GLextension::GL_APPLE_vertex_array_object, { "glBindVertexArrayAPPLE", "glDeleteVertexArraysAPPLE", "glGenVertexArraysAPPLE", "glIsVertexArrayAPPLE" } },
    { GLextension::GL_APPLE_vertex_array_range, { "glFlushVertexArrayRangeAPPLE", "glVertexArrayParameteriAPPLE", "glVertexArrayRangeAPPLE" } },
    { GLextension::GL_APPLE_vertex_program_evaluators, { "glDisableVertexAttribAPPLE", "glEnableVertexAttribAPPLE", "glIsVertexAttribEnabledAPPLE", "glMapVertexAttrib1dAPPLE", "glMapVertexAttrib1fAPPLE", "glMapVertexAttrib2dAPPLE", "glMapVertexAttrib2fAPPLE" } },
    { GLextension::GL_ARB_base_instance, { "glDrawArraysInstancedBaseInstance", "glDrawElementsInstancedBaseInstance", "glDrawElementsInstancedBaseVertexBaseInstance" } },
    { GLextension::GL_ARB_bindless_texture, { "glGetImageHandleARB", "glGetTextureHandleARB", "glGetTextureSamplerHandleARB", "glGetVertexAttribLui64vARB", "glIsImageHandleResidentARB", "glIsTextureHandleResidentARB", "glMakeImageHandleNonResidentARB", "glMakeImageHandleResidentARB", "glMakeTextureHandleNonResidentARB", "glMakeTextureHandleResidentARB", "glProgramUniformHandleui64ARB", "glProgramUniformHandleui64vARB", "glUniformHandleui64ARB", "glUniformHandleui64vARB", "glVertexAttribL1ui64ARB", "glVertexAttribL1ui64vARB" } },
    { GLextension::GL_ARB_blend_func_extended, { "glBindFragDataLocationIndexed", "glGetFragDataIndex" } },
    { GLextension::GL_ARB_buffer_storage, { "glBufferStorage" } },
    { GLextension::GL_ARB_cl_event, { "glCreateSyncFromCLeventARB" } },
    { GLextension::GL_ARB_clear_buffer_object, { "glClearBufferData", "glClearBufferSubData" } },
    { GLextension::GL_ARB_clear_texture, { "glClearTexImage", "glClearTexSubImage" } },
    { GLextension::GL_ARB_clip_control, { "glClipControl" } },
    { GLextension::GL_ARB_color_buffer_float, { "glClampColorARB" } },
    { GLextension::GL_ARB_compute_shader, { "glDispatchCompute", "glDispatchComputeIndirect" } },
    { GLextension::GL_ARB_compute_variable_group_size, { "glDispatchComputeGroupSizeARB" } },
    { GLextension::GL_ARB_copy_buffer, { "glCopyBufferSubData" } },
    { GLextension::GL_ARB_copy_image, { "glCopyImageSubData" } },
    { GLextension::GL_ARB_debug_output, { "glDebugMessageCallbackARB", "glDebugMessageControlARB", "glDebugMessageInsertARB", "glGetDebugMessageLogARB" } },
    { GLextension::GL_ARB_direct_state_access, { "glBindTextureUnit", "glBlitNamedFramebuffer", "glCheckNamedFramebufferStatus", "glClearNamedBufferData", "glClearNamedBufferSubData", "glClearNamedFramebufferfi", "glClearNamedFramebufferfv", "glClearNamedFramebufferiv", "glClearNamedFramebufferuiv", "glCompressedTextureSubImage1D", "glCompressedTextureSubImage2D", "glCompressedTextureSubImage3D", "glCopyNamedBufferSubData", "glCopyTextureSubImage1D", "glCopyTextureSubImage2D", "glCopyTextureSubImage3D", "glCreateBuffers", "glCreateFramebuffers", "glCreateProgramPipelines", "glCreateQueries", "glCreateRenderbuffers", "glCreateSamplers", "glCreateTextures", "glCreateTransformFeedbacks", "glCreateVertexArrays", "glDisableVertexArrayAttrib", "glEnableVertexArrayAttrib", "glFlushMappedNamedBufferRange", "glGenerateTextureMipmap", "glGetCompressedTextureImage", "glGetNamedBufferParameteri64v", "glGetNamedBufferParameteriv", "glGetNamedBufferPointerv", "glGetNamedBufferSubData", "glGetNamedFramebufferAttachmentParameteriv", "glGetNamedFramebufferParameteriv", "glGetNamedRenderbufferParameteriv", "glGetQueryBufferObjecti64v", "glGetQueryBufferObjectiv", "glGetQueryBufferObjectui64v", "glGetQueryBufferObjectuiv", "glGetTextureImage", "glGetTextureLevelParameterfv", "glGetTextureLevelParameteriv", "glGetTextureParameterfv", "glGetTextureParameterIiv", "glGetTextureParameterIuiv", "glGetTextureParameteriv", "glGetTransformFeedbacki64_v", "glGetTransformFeedbacki_v", "glGetTransformFeedbackiv", "glGetVertexArrayIndexed64iv", "glGetVertexArrayIndexediv", "glGetVertexArrayiv", "glInvalidateNamedFramebufferData", "glInvalidateNamedFramebufferSubData", "glMapNamedBuffer", "glMapNamedBufferRange", "glNamedBufferData", "glNamedBufferStorage", "glNamedBufferSubData", "glNamedFramebufferDrawBuffer", "glNamedFramebufferDrawBuffers", "glNamedFramebufferParameteri", "glNamedFramebufferReadBuffer", "glNamedFramebufferRenderbuffer", "glNamedFramebufferTexture", "glNamedFramebufferTextureLayer", "glNamedRenderbufferStorage", "glNamedRenderbufferStorageMultisample", "glTextureBuffer", "glTextureBufferRange", "glTextureParameterf", "glTextureParameterfv", "glTextureParameteri", "glTextureParameterIiv", "glTextureParameterIuiv", "glTextureParameteriv", "glTextureStorage1D", "glTextureStorage2D", "glTextureStorage2DMultisample", "glTextureStorage3D", "glTextureStorage3DMultisample", "glTextureSubImage1D", "glTextureSubImage2D", "glTextureSubImage3D", "glTransformFeedbackBufferBase", "glTransformFeedbackBufferRange", "glUnmapNamedBuffer", "glVertexArrayAttribBinding", "glVertexArrayAttribFormat", "glVertexArrayAttribIFormat", "glVertexArrayAttribLFormat", "glVertexArrayBindingDivisor", "glVertexArrayElementBuffer", "glVertexArrayVertexBuffer", "glVertexArrayVertexBuffers" } },
    { GLextension::GL_ARB_draw_buffers, { "glDrawBuffersARB" } },
    { GLextension::GL_ARB_draw_buffers_blend, { "glBlendEquationiARB", "glBlendEquationSeparateiARB", "glBlendFunciARB", "glBlendFuncSeparateiARB" } },
    { GLextension::GL_ARB_draw_elements_base_vertex, { "glDrawElementsBaseVertex", "glDrawElementsInstancedBaseVertex", "glDrawRangeElementsBaseVertex", "glMultiDrawElementsBaseVertex" } },
    { GLextension::GL_ARB_draw_indirect, { "glDrawArraysIndirect", "glDrawElementsIndirect" } },
    { GLextension::GL_ARB_draw_instanced, { "glDrawArraysInstancedARB", "glDrawElementsInstancedARB" } },
    { GLextension::GL_ARB_ES2_compatibility, { "glClearDepthf", "glDepthRangef", "glGetShaderPrecisionFormat", "glReleaseShaderCompiler", "glShaderBinary" } },
    { GLextension::GL_ARB_ES3_1_compatibility, { "glMemoryBarrierByRegion" } },
    { GLextension::GL_ARB_ES3_2_compatibility, { "glPrimitiveBoundingBoxARB" } },
    { GLextension::GL_ARB_fragment_program, { "glBindProgramARB", "glDeleteProgramsARB", "glGenProgramsARB", "glGetProgramEnvParameterdvARB", "glGetProgramEnvParameterfvARB", "glGetProgramivARB", "glGetProgramLocalParameterdvARB", "glGetProgramLocalParameterfvARB", "glGetProgramStringARB", "glIsProgramARB", "glProgramEnvParameter4dARB", "glProgramEnvParameter4dvARB", "glProgramEnvParameter4fARB", "glProgramEnvParameter4fvARB", "glProgramLocalParameter4dARB", "glProgramLocalParameter4dvARB", "glProgramLocalParameter4fARB", "glProgramLocalParameter4fvARB", "glProgramStringARB" } },
    { GLextension::GL_ARB_framebuffer_no_attachments, { "glFramebufferParameteri", "glGetFramebufferParameteriv" } },
    { GLextension::GL_ARB_framebuffer_object, { "glBindFramebuffer", "glBindRenderbuffer", "glBlitFramebuffer", "glCheckFramebufferStatus", "glDeleteFramebuffers", "glDeleteRenderbuffers", "glFramebufferRenderbuffer", "glFramebufferTexture1D", "glFramebufferTexture2D", "glFramebufferTexture3D", "glFramebufferTextureLayer", "glGenerateMipmap", "glGenFramebuffers", "glGenRenderbuffers", "glGetFramebufferAttachmentParameteriv", "glGetRenderbufferParameteriv", "glIsFramebuffer", "glIsRenderbuffer", "glRenderbufferStorage", "glRenderbufferStorageMultisample" } },
    { GLextension::GL_ARB_geometry_shader4, { "glFramebufferTextureARB", "glFramebufferTextureFaceARB", "glFramebufferTextureLayerARB", "glProgramParameteriARB" } },
    { GLextension::GL_ARB_get_program_binary, { "glGetProgramBinary", "glProgramBinary", "glProgramParameteri" } },
    { GLextension::GL_ARB_get_texture_sub_image, { "glGetCompressedTextureSubImage", "glGetTextureSubImage" } },
    { GLextension::GL_ARB_gl_spirv, { "glSpecializeShaderARB" } },
    { GLextension::GL_ARB_gpu_shader_fp64, { "glGetUniformdv", "glUniform1d", "glUniform1dv", "glUniform2d", "glUniform2dv", "glUniform3d", "glUniform3dv", "glUniform4d", "glUniform4dv", "glUniformMatrix2dv", "glUniformMatrix2x3dv", "glUniformMatrix2x4dv", "glUniformMatrix3dv", "glUniformMatrix3x2dv", "glUniformMatrix3x4dv", "glUniformMatrix4dv", "glUniformMatrix4x2dv", "glUniformMatrix4x3dv" } },
    { GLextension::GL_ARB_gpu_shader_int64, { "glGetnUniformi64vARB", "glGetnUniformui64vARB", "glGetUniformi64vARB", "glGetUniformui64vARB", "glProgramUniform1i64ARB", "glProgramUniform1i64vARB", "glProgramUniform1ui64ARB", "glProgramUniform1ui64vARB", "glProgramUniform2i64ARB", "glProgramUniform2i64vARB", "glProgramUniform2ui64ARB", "glProgramUniform2ui64vARB", "glProgramUniform3i64ARB", "glProgramUniform3i64vARB", "glProgramUniform3ui64ARB", "glProgramUniform3ui64vARB", "glProgramUniform4i64ARB", "glProgramUniform4i64vARB", "glProgramUniform4ui64ARB", "glProgramUniform4ui64vARB", "glUniform1i64ARB", "glUniform1i64vARB", "glUniform1ui64ARB", "glUniform1ui64vARB", "glUniform2i64ARB", "glUniform2i64vARB", "glUniform2ui64ARB", "glUniform2ui64vARB", "glUniform3i64ARB", "glUniform3i64vARB", "glUniform3ui64ARB", "glUniform3ui64vARB", "glUniform4i64ARB", "glUniform4i64vARB", "glUniform4ui64ARB", "glUniform4ui64vARB" } },
    { GLextension::GL_ARB_imaging, { "glBlendColor", "glBlendEquation", "glColorSubTable", "glColorTable", "glColorTableParameterfv", "glColorTableParameteriv", "glConvolutionFilter1D", "glConvolutionFilter2D", "glConvolutionParameterf", "glConvolutionParameterfv", "glConvolutionParameteri", "glConvolutionParameteriv", "glCopyColorSubTable", "glCopyColorTable", "glCopyConvolutionFilter1D", "glCopyConvolutionFilter2D", "glGetColorTable", "glGetColorTableParameterfv", "glGetColorTableParameteriv", "glGetConvolutionFilter", "glGetConvolutionParameterfv", "glGetConvolutionParameteriv", "glGetHistogram", "glGetHistogramParameterfv", "glGetHistogramParameteriv", "glGetMinmax", "glGetMinmaxParameterfv", "glGetMinmaxParameteriv", "glGetSeparableFilter", "glHistogram", "glMinmax", "glResetHistogram", "glResetMinmax", "glSeparableFilter2D" } },
    { GLextension::GL_ARB_indirect_parameters, { "glMultiDrawArraysIndirectCountARB", "glMultiDrawElementsIndirectCountARB" } },
    { GLextension::GL_ARB_instanced_arrays, { "glVertexAttribDivisorARB" } },
    { GLextension::GL_ARB_internalformat_query, { "glGetInternalformativ" } },
    { GLextension::GL_ARB_internalformat_query2, { "glGetInternalformati64v" } },
    { GLextension::GL_ARB_invalidate_subdata, { "glInvalidateBufferData", "glInvalidateBufferSubData", "glInvalidateFramebuffer", "glInvalidateSubFramebuffer", "glInvalidateTexImage", "glInvalidateTexSubImage" } },
    { GLextension::GL_ARB_map_buffer_range, { "glFlushMappedBufferRange", "glMapBufferRange" } },
    { GLextension::GL_ARB_matrix_palette, { "glCurrentPaletteMatrixARB", "glMatrixIndexPointerARB", "glMatrixIndexubvARB", "glMatrixIndexuivARB", "glMatrixIndexusvARB" } },
    { GLextension::GL_ARB_multi_bind, { "glBindBuffersBase", "glBindBuffersRange", "glBindImageTextures", "glBindSamplers", "glBindTextures", "glBindVertexBuffers" } },
    { GLextension::GL_ARB_multi_draw_indirect, { "glMultiDrawArraysIndirect", "glMultiDrawElementsIndirect" } },
    { GLextension::GL_ARB_multisample, { "glSampleCoverageARB" } },
    { GLextension::GL_ARB_multitexture, { "glActiveTextureARB", "glClientActiveTextureARB", "glMultiTexCoord1dARB", "glMultiTexCoord1dvARB", "glMultiTexCoord1fARB", "glMultiTexCoord1fvARB", "glMultiTexCoord1iARB", "glMultiTexCoord1ivARB", "glMultiTexCoord1sARB", "glMultiTexCoord1svARB", "glMultiTexCoord2dARB", "glMultiTexCoord2dvARB", "glMultiTexCoord2fARB", "glMultiTexCoord2fvARB", "glMultiTexCoord2iARB", "glMultiTexCoord2ivARB", "glMultiTexCoord2sARB", "glMultiTexCoord2svARB", "glMultiTexCoord3dARB", "glMultiTexCoord3dvARB", "glMultiTexCoord3fARB", "glMultiTexCoord3fvARB", "glMultiTexCoord3iARB", "glMultiTexCoord3ivARB", "glMultiTexCoord3sARB", "glMultiTexCoord3svARB", "glMultiTexCoord4dARB", "glMultiTexCoord4dvARB", "glMultiTexCoord4fARB", "glMultiTexCoord4fvARB", "glMultiTexCoord4iARB", "glMultiTexCoord4ivARB", "glMultiTexCoord4sARB", "glMultiTexCoord4svARB" } },
    { GLextension::GL_ARB_occlusion_query, { "glBeginQueryARB", "glDeleteQueriesARB", "glEndQueryARB", "glGenQueriesARB", "glGetQueryivARB", "glGetQueryObjectivARB", "glGetQueryObjectuivARB", "glIsQueryARB" } },
    { GLextension::GL_ARB_parallel_shader_compile, { "glMaxShaderCompilerThreadsARB" } },
    { GLextension::GL_ARB_point_parameters, { "glPointParameterfARB", "glPointParameterfvARB" } },
    { GLextension::GL_ARB_polygon_offset_clamp, { "glPolygonOffsetClamp" } },
    { GLextension::GL_ARB_program_interface_query, { "glGetProgramInterfaceiv", "glGetProgramResourceIndex", "glGetProgramResourceiv", "glGetProgramResourceLocation", "glGetProgramResourceLocationIndex", "glGetProgramResourceName" } },
    { GLextension::GL_ARB_provoking_vertex, { "glProvokingVertex" } },
    { GLextension::GL_ARB_robustness, { "glGetGraphicsResetStatusARB", "glGetnColorTableARB", "glGetnCompressedTexImageARB", "glGetnConvolutionFilterARB", "glGetnHistogramARB", "glGetnMapdvARB", "glGetnMapfvARB", "glGetnMapivARB", "glGetnMinmaxARB", "glGetnPixelMapfvARB", "glGetnPixelMapuivARB", "glGetnPixelMapusvARB", "glGetnPolygonStippleARB", "glGetnSeparableFilterARB", "glGetnTexImageARB", "glGetnUniformdvARB", "glGetnUniformfvARB", "glGetnUniformivARB", "glGetnUniformuivARB", "glReadnPixelsARB" } },
    { GLextension::GL_ARB_sample_locations, { "glEvaluateDepthValuesARB", "glFramebufferSampleLocationsfvARB", "glNamedFramebufferSampleLocationsfvARB" } },
    { GLextension::GL_ARB_sample_shading, { "glMinSampleShadingARB" } },
    { GLextension::GL_ARB_sampler_objects, { "glBindSampler", "glDeleteSamplers", "glGenSamplers", "glGetSamplerParameterfv", "glGetSamplerParameterIiv", "glGetSamplerParameterIuiv", "glGetSamplerParameteriv", "glIsSampler", "glSamplerParameterf", "glSamplerParameterfv", "glSamplerParameteri", "glSamplerParameterIiv", "glSamplerParameterIuiv", "glSamplerParameteriv" } },
    { GLextension::GL_ARB_separate_shader_objects, { "glActiveShaderProgram", "glBindProgramPipeline", "glCreateShaderProgramv", "glDeleteProgramPipelines", "glGenProgramPipelines", "glGetProgramPipelineInfoLog", "glGetProgramPipelineiv", "glIsProgramPipeline", "glProgramParameteri", "glProgramUniform1d", "glProgramUniform1dv", "glProgramUniform1f", "glProgramUniform1fv", "glProgramUniform1i", "glProgramUniform1iv", "glProgramUniform1ui", "glProgramUniform1uiv", "glProgramUniform2d", "glProgramUniform2dv", "glProgramUniform2f", "glProgramUniform2fv", "glProgramUniform2i", "glProgramUniform2iv", "glProgramUniform2ui", "glProgramUniform2uiv", "glProgramUniform3d", "glProgramUniform3dv", "glProgramUniform3f", "glProgramUniform3fv", "glProgramUniform3i", "glProgramUniform3iv", "glProgramUniform3ui", "glProgramUniform3uiv", "glProgramUniform4d", "glProgramUniform4dv", "glProgramUniform4f", "glProgramUniform4fv", "glProgramUniform4i", "glProgramUniform4iv", "glProgramUniform4ui", "glProgramUniform4uiv", "glProgramUniformMatrix2dv", "glProgramUniformMatrix2fv", "glProgramUniformMatrix2x3dv", "glProgramUniformMatrix2x3fv", "glProgramUniformMatrix2x4dv", "glProgramUniformMatrix2x4fv", "glProgramUniformMatrix3dv", "glProgramUniformMatrix3fv", "glProgramUniformMatrix3x2dv", "glProgramUniformMatrix3x2fv", "glProgramUniformMatrix3x4dv", "glProgramUniformMatrix3x4fv", "glProgramUniformMatrix4dv", "glProgramUniformMatrix4fv", "glProgramUniformMatrix4x2dv", "glProgramUniformMatrix4x2fv", "glProgramUniformMatrix4x3dv", "glProgramUniformMatrix4x3fv", "glUseProgramStages", "glValidateProgramPipeline" } },
    { GLextension::GL_ARB_shader_atomic_counters, { "glGetActiveAtomicCounterBufferiv" } },
    { GLextension::GL_ARB_shader_image_load_store, { "glBindImageTexture", "glMemoryBarrier" } },
    { GLextension::GL_ARB_shader_objects, { "glAttachObjectARB", "glCompileShaderARB", "glCreateProgramObjectARB", "glCreateShaderObjectARB", "glDeleteObjectARB", "glDetachObjectARB", "glGetActiveUniformARB", "glGetAttachedObjectsARB", "glGetHandleARB", "glGetInfoLogARB", "glGetObjectParameterfvARB", "glGetObjectParameterivARB", "glGetShaderSourceARB", "glGetUniformfvARB", "glGetUniformivARB", "glGetUniformLocationARB", "glLinkProgramARB", "glShaderSourceARB", "glUniform1fARB", "glUniform1fvARB", "glUniform1iARB", "glUniform1ivARB", "glUniform2fARB", "glUniform2fvARB", "glUniform2iARB", "glUniform2ivARB", "glUniform3fARB", "glUniform3fvARB", "glUniform3iARB", "glUniform3ivARB", "glUniform4fARB", "glUniform4fvARB", "glUniform4iARB", "glUniform4ivARB", "glUniformMatrix2fvARB", "glUniformMatrix3fvARB", "glUniformMatrix4fvARB", "glUseProgramObjectARB", "glValidateProgramARB" } },
    { GLextension::GL_ARB_shader_storage_buffer_object, { "glShaderStorageBlockBinding" } },
    { GLextension::GL_ARB_shader_subroutine, { "glGetActiveSubroutineName", "glGetActiveSubroutineUniformiv", "glGetActiveSubroutineUniformName", "glGetProgramStageiv", "glGetSubroutineIndex", "glGetSubroutineUniformLocation", "glGetUniformSubroutineuiv", "glUniformSubroutinesuiv" } },
    { GLextension::GL_ARB_shading_language_include, { "glCompileShaderIncludeARB", "glDeleteNamedStringARB", "glGetNamedStringARB", "glGetNamedStringivARB", "glIsNamedStringARB", "glNamedStringARB" } },
    { GLextension::GL_ARB_sparse_buffer, { "glBufferPageCommitmentARB", "glNamedBufferPageCommitmentARB", "glNamedBufferPageCommitmentEXT" } },
    { GLextension::GL_ARB_sparse_texture, { "glTexPageCommitmentARB" } },
    { GLextension::GL_ARB_sync, { "glClientWaitSync", "glDeleteSync", "glFenceSync", "glGetInteger64v", "glGetSynciv", "glIsSync", "glWaitSync" } },
    { GLextension::GL_ARB_tessellation_shader, { "glPatchParameterfv", "glPatchParameteri" } },
    { GLextension::GL_ARB_texture_barrier, { "glTextureBarrier" } },
    { GLextension::GL_ARB_texture_buffer_object, { "glTexBufferARB" } },
    { GLextension::GL_ARB_texture_buffer_range, { "glTexBufferRange" } },
    { GLextension::GL_ARB_texture_compression, { "glCompressedTexImage1DARB", "glCompressedTexImage2DARB", "glCompressedTexImage3DARB", "glCompressedTexSubImage1DARB", "glCompressedTexSubImage2DARB", "glCompressedTexSubImage3DARB", "glGetCompressedTexImageARB" } },
    { GLextension::GL_ARB_texture_multisample, { "glGetMultisamplefv", "glSampleMaski", "glTexImage2DMultisample", "glTexImage3DMultisample" } },
    { GLextension::GL_ARB_texture_storage, { "glTexStorage1D", "glTexStorage2D", "glTexStorage3D" } },
    { GLextension::GL_ARB_texture_storage_multisample, { "glTexStorage2DMultisample", "glTexStorage3DMultisample" } },
    { GLextension::GL_ARB_texture_view, { "glTextureView" } },
    { GLextension::GL_ARB_timer_query, { "glGetQueryObjecti64v", "glGetQueryObjectui64v", "glQueryCounter" } },
    { GLextension::GL_ARB_transform_feedback2, { "glBindTransformFeedback", "glDeleteTransformFeedbacks", "glDrawTransformFeedback", "glGenTransformFeedbacks", "glIsTransformFeedback", "glPauseTransformFeedback", "glResumeTransformFeedback" } },
    { GLextension::GL_ARB_transform_feedback3, { "glBeginQueryIndexed", "glDrawTransformFeedbackStream", "glEndQueryIndexed", "glGetQueryIndexediv" } },
    { GLextension::GL_ARB_transform_feedback_instanced, { "glDrawTransformFeedbackInstanced", "glDrawTransformFeedbackStreamInstanced" } },
    { GLextension::GL_ARB_transpose_matrix, { "glLoadTransposeMatrixdARB", "glLoadTransposeMatrixfARB", "glMultTransposeMatrixdARB", "glMultTransposeMatrixfARB" } },
    { GLextension::GL_ARB_uniform_buffer_object, { "glBindBufferBase", "glBindBufferRange", "glGetActiveUniformBlockiv", "glGetActiveUniformBlockName", "glGetActiveUniformName", "glGetActiveUniformsiv", "glGetIntegeri_v", "glGetUniformBlockIndex", "glGetUniformIndices", "glUniformBlockBinding" } },
    { GLextension::GL_ARB_vertex_array_object, { "glBindVertexArray", "glDeleteVertexArrays", "glGenVertexArrays", "glIsVertexArray" } },
    { GLextension::GL_ARB_vertex_attrib_64bit, { "glGetVertexAttribLdv", "glVertexAttribL1d", "glVertexAttribL1dv", "glVertexAttribL2d", "glVertexAttribL2dv", "glVertexAttribL3d", "glVertexAttribL3dv", "glVertexAttribL4d", "glVertexAttribL4dv", "glVertexAttribLPointer" } },
    { GLextension::GL_ARB_vertex_attrib_binding, { "glBindVertexBuffer", "glVertexAttribBinding", "glVertexAttribFormat", "glVertexAttribIFormat", "glVertexAttribLFormat", "glVertexBindingDivisor" } },
    { GLextension::GL_ARB_vertex_blend, { "glVertexBlendARB", "glWeightbvARB", "glWeightdvARB", "glWeightfvARB", "glWeightivARB", "glWeightPointerARB", "glWeightsvARB", "glWeightubvARB", "glWeightuivARB", "glWeightusvARB" } },
    { GLextension::GL_ARB_vertex_buffer_object, { "glBindBufferARB", "glBufferDataARB", "glBufferSubDataARB", "glDeleteBuffersARB", "glGenBuffersARB", "glGetBufferParameterivARB", "glGetBufferPointervARB", "glGetBufferSubDataARB", "glIsBufferARB", "glMapBufferARB", "glUnmapBufferARB" } },
    { GLextension::GL_ARB_vertex_program, { "glBindProgramARB", "glDeleteProgramsARB", "glDisableVertexAttribArrayARB", "glEnableVertexAttribArrayARB", "glGenProgramsARB", "glGetProgramEnvParameterdvARB", "glGetProgramEnvParameterfvARB", "glGetProgramivARB", "glGetProgramLocalParameterdvARB", "glGetProgramLocalParameterfvARB", "glGetProgramStringARB", "glGetVertexAttribdvARB", "glGetVertexAttribfvARB", "glGetVertexAttribivARB", "glGetVertexAttribPointervARB", "glIsProgramARB", "glProgramEnvParameter4dARB", "glProgramEnvParameter4dvARB", "glProgramEnvParameter4fARB", "glProgramEnvParameter4fvARB", "glProgramLocalParameter4dARB", "glProgramLocalParameter4dvARB", "glProgramLocalParameter4fARB", "glProgramLocalParameter4fvARB", "glProgramStringARB", "glVertexAttrib1dARB", "glVertexAttrib1dvARB", "glVertexAttrib1fARB", "glVertexAttrib1fvARB", "glVertexAttrib1sARB", "glVertexAttrib1svARB", "glVertexAttrib2dARB", "glVertexAttrib2dvARB", "glVertexAttrib2fARB", "glVertexAttrib2fvARB", "glVertexAttrib2sARB", "glVertexAttrib2svARB", "glVertexAttrib3dARB", "glVertexAttrib3dvARB", "glVertexAttrib3fARB", "glVertexAttrib3fvARB", "glVertexAttrib3sARB", "glVertexAttrib3svARB", "glVertexAttrib4bvARB", "glVertexAttrib4dARB", "glVertexAttrib4dvARB", "glVertexAttrib4fARB", "glVertexAttrib4fvARB", "glVertexAttrib4ivARB", "glVertexAttrib4NbvARB", "glVertexAttrib4NivARB", "glVertexAttrib4NsvARB", "glVertexAttrib4NubARB", "glVertexAttrib4NubvARB", "glVertexAttrib4NuivARB", "glVertexAttrib4NusvARB", "glVertexAttrib4sARB", "glVertexAttrib4svARB", "glVertexAttrib4ubvARB", "glVertexAttrib4uivARB", "glVertexAttrib4usvARB", "glVertexAttribPointerARB" } },
    { GLextension::GL_ARB_vertex_shader, { "glBindAttribLocationARB", "glDisableVertexAttribArrayARB", "glEnableVertexAttribArrayARB", "glGetActiveAttribARB", "glGetAttribLocationARB", "glGetVertexAttribdvARB", "glGetVertexAttribfvARB", "glGetVertexAttribivARB", "glGetVertexAttribPointervARB", "glVertexAttrib1dARB", "glVertexAttrib1dvARB", "glVertexAttrib1fARB", "glVertexAttrib1fvARB", "glVertexAttrib1sARB", "glVertexAttrib1svARB", "glVertexAttrib2dARB", "glVertexAttrib2dvARB", "glVertexAttrib2fARB", "glVertexAttrib2fvARB", "glVertexAttrib2sARB", "glVertexAttrib2svARB", "glVertexAttrib3dARB", "glVertexAttrib3dvARB", "glVertexAttrib3fARB", "glVertexAttrib3fvARB", "glVertexAttrib3sARB", "glVertexAttrib3svARB", "glVertexAttrib4bvARB", "glVertexAttrib4dARB", "glVertexAttrib4dvARB", "glVertexAttrib4fARB", "glVertexAttrib4fvARB", "glVertexAttrib4ivARB", "glVertexAttrib4NbvARB", "glVertexAttrib4NivARB", "glVertexAttrib4NsvARB", "glVertexAttrib4NubARB", "glVertexAttrib4NubvARB", "glVertexAttrib4NuivARB", "glVertexAttrib4NusvARB", "glVertexAttrib4sARB", "glVertexAttrib4svARB", "glVertexAttrib4ubvARB", "glVertexAttrib4uivARB", "glVertexAttrib4usvARB", "glVertexAttribPointerARB" } },
    { GLextension::GL_ARB_vertex_type_2_10_10_10_rev, { "glColorP3ui", "glColorP3uiv", "glColorP4ui", "glColorP4uiv", "glMultiTexCoordP1ui", "glMultiTexCoordP1uiv", "glMultiTexCoordP2ui", "glMultiTexCoordP2uiv", "glMultiTexCoordP3ui", "glMultiTexCoordP3uiv", "glMultiTexCoordP4ui", "glMultiTexCoordP4uiv", "glNormalP3ui", "glNormalP3uiv", "glSecondaryColorP3ui", "glSecondaryColorP3uiv", "glTexCoordP1ui", "glTexCoordP1uiv", "glTexCoordP2ui", "glTexCoordP2uiv", "glTexCoordP3ui", "glTexCoordP3uiv", "glTexCoordP4ui", "glTexCoordP4uiv", "glVertexAttribP1ui", "glVertexAttribP1uiv", "glVertexAttribP2ui", "glVertexAttribP2uiv", "glVertexAttribP3ui", "glVertexAttribP3uiv", "glVertexAttribP4ui", "glVertexAttribP4uiv", "glVertexP2ui", "glVertexP2uiv", "glVertexP3ui", "glVertexP3uiv", "glVertexP4ui", "glVertexP4uiv" } },
    { GLextension::GL_ARB_viewport_array, { "glDepthRangeArraydvNV", "glDepthRangeArrayv", "glDepthRangeIndexed", "glDepthRangeIndexeddNV", "glGetDoublei_v", "glGetFloati_v", "glScissorArrayv", "glScissorIndexed", "glScissorIndexedv", "glViewportArrayv", "glViewportIndexedf", "glViewportIndexedfv" } },
    { GLextension::GL_ARB_window_pos, { "glWindowPos2dARB", "glWindowPos2dvARB", "glWindowPos2fARB", "glWindowPos2fvARB", "glWindowPos2iARB", "glWindowPos2ivARB", "glWindowPos2sARB", "glWindowPos2svARB", "glWindowPos3dARB", "glWindowPos3dvARB", "glWindowPos3fARB", "glWindowPos3fvARB", "glWindowPos3iARB", "glWindowPos3ivARB", "glWindowPos3sARB", "glWindowPos3svARB" } },
    { GLextension::GL_ATI_draw_buffers, { "glDrawBuffersATI" } },
    { GLextension::GL_ATI_element_array, { "glDrawElementArrayATI", "glDrawRangeElementArrayATI", "glElementPointerATI" } },
    { GLextension::GL_ATI_envmap_bumpmap, { "glGetTexBumpParameterfvATI", "glGetTexBumpParameterivATI", "glTexBumpParameterfvATI", "glTexBumpParameterivATI" } },
    { GLextension::GL_ATI_fragment_shader, { "glAlphaFragmentOp1ATI", "glAlphaFragmentOp2ATI", "glAlphaFragmentOp3ATI", "glBeginFragmentShaderATI", "glBindFragmentShaderATI", "glColorFragmentOp1ATI", "glColorFragmentOp2ATI", "glColorFragmentOp3ATI", "glDeleteFragmentShaderATI", "glEndFragmentShaderATI", "glGenFragmentShadersATI", "glPassTexCoordATI", "glSampleMapATI", "glSetFragmentShaderConstantATI" } },
    { GLextension::GL_ATI_map_object_buffer, { "glMapObjectBufferATI", "glUnmapObjectBufferATI" } },
    { GLextension::GL_ATI_pn_triangles, { "glPNTrianglesfATI", "glPNTrianglesiATI" } },
    { GLextension::GL_ATI_separate_stencil, { "glStencilFuncSeparateATI", "glStencilOpSeparateATI" } },
    { GLextension::GL_ATI_vertex_array_object, { "glArrayObjectATI", "glFreeObjectBufferATI", "glGetArrayObjectfvATI", "glGetArrayObjectivATI", "glGetObjectBufferfvATI", "glGetObjectBufferivATI", "glGetVariantArrayObjectfvATI", "glGetVariantArrayObjectivATI", "glIsObjectBufferATI", "glNewObjectBufferATI", "glUpdateObjectBufferATI", "glVariantArrayObjectATI" } },
    { GLextension::GL_ATI_vertex_attrib_array_object, { "glGetVertexAttribArrayObjectfvATI", "glGetVertexAttribArrayObjectivATI", "glVertexAttribArrayObjectATI" } },
    { GLextension::GL_ATI_vertex_streams, { "glClientActiveVertexStreamATI", "glNormalStream3bATI", "glNormalStream3bvATI", "glNormalStream3dATI", "glNormalStream3dvATI", "glNormalStream3fATI", "glNormalStream3fvATI", "glNormalStream3iATI", "glNormalStream3ivATI", "glNormalStream3sATI", "glNormalStream3svATI", "glVertexBlendEnvfATI", "glVertexBlendEnviATI", "glVertexStream1dATI", "glVertexStream1dvATI", "glVertexStream1fATI", "glVertexStream1fvATI", "glVertexStream1iATI", "glVertexStream1ivATI", "glVertexStream1sATI", "glVertexStream1svATI", "glVertexStream2dATI", "glVertexStream2dvATI", "glVertexStream2fATI", "glVertexStream2fvATI", "glVertexStream2iATI", "glVertexStream2ivATI", "glVertexStream2sATI", "glVertexStream2svATI", "glVertexStream3dATI", "glVertexStream3dvATI", "glVertexStream3fATI", "glVertexStream3fvATI", "glVertexStream3iATI", "glVertexStream3ivATI", "glVertexStream3sATI", "glVertexStream3svATI", "glVertexStream4dATI", "glVertexStream4dvATI", "glVertexStream4fATI", "glVertexStream4fvATI", "glVertexStream4iATI", "glVertexStream4ivATI", "glVertexStream4sATI", "glVertexStream4svATI" } },
    { GLextension::GL_EXT_bindable_uniform, { "glGetUniformBufferSizeEXT", "glGetUniformOffsetEXT", "glUniformBufferEXT" } },
    { GLextension::GL_EXT_blend_color, { "glBlendColorEXT" } },
    { GLextension::GL_EXT_blend_equation_separate, { "glBlendEquationSeparateEXT" } },
    { GLextension::GL_EXT_blend_func_separate, { "glBlendFuncSeparateEXT" } },
    { GLextension::GL_EXT_blend_minmax, { "glBlendEquationEXT" } },
    { GLextension::GL_EXT_color_subtable, { "glColorSubTableEXT", "glCopyColorSubTableEXT" } },
    { GLextension::GL_EXT_compiled_vertex_array, { "glLockArraysEXT", "glUnlockArraysEXT" } },
    { GLextension::GL_EXT_convolution, { "glConvolutionFilter1DEXT", "glConvolutionFilter2DEXT", "glConvolutionParameterfEXT", "glConvolutionParameterfvEXT", "glConvolutionParameteriEXT", "glConvolutionParameterivEXT", "glCopyConvolutionFilter1DEXT", "glCopyConvolutionFilter2DEXT", "glGetConvolutionFilterEXT", "glGetConvolutionParameterfvEXT", "glGetConvolutionParameterivEXT", "glGetSeparableFilterEXT", "glSeparableFilter2DEXT" } },
    { GLextension::GL_EXT_coordinate_frame, { "glBinormal3bEXT", "glBinormal3bvEXT", "glBinormal3dEXT", "glBinormal3dvEXT", "glBinormal3fEXT", "glBinormal3fvEXT", "glBinormal3iEXT", "glBinormal3ivEXT", "glBinormal3sEXT", "glBinormal3svEXT", "glBinormalPointerEXT", "glTangent3bEXT", "glTangent3bvEXT", "glTangent3dEXT", "glTangent3dvEXT", "glTangent3fEXT", "glTangent3fvEXT", "glTangent3iEXT", "glTangent3ivEXT", "glTangent3sEXT", "glTangent3svEXT", "glTangentPointerEXT" } },
    { GLextension::GL_EXT_copy_texture, { "glCopyTexImage1DEXT", "glCopyTexImage2DEXT", "glCopyTexSubImage1DEXT", "glCopyTexSubImage2DEXT", "glCopyTexSubImage3DEXT" } },
    { GLextension::GL_EXT_cull_vertex, { "glCullParameterdvEXT", "glCullParameterfvEXT" } },
    { GLextension::GL_EXT_debug_label, { "glGetObjectLabelEXT", "glLabelObjectEXT" } },
    { GLextension::GL_EXT_debug_marker, { "glInsertEventMarkerEXT", "glPopGroupMarkerEXT", "glPushGroupMarkerEXT" } },
    { GLextension::GL_EXT_depth_bounds_test, { "glDepthBoundsEXT" } },
    { GLextension::GL_EXT_direct_state_access, { "glBindMultiTextureEXT", "glCheckNamedFramebufferStatusEXT", "glClearNamedBufferDataEXT", "glClearNamedBufferSubDataEXT", "glClientAttribDefaultEXT", "glCompressedMultiTexImage1DEXT", "glCompressedMultiTexImage2DEXT", "glCompressedMultiTexImage3DEXT", "glCompressedMultiTexSubImage1DEXT", "glCompressedMultiTexSubImage2DEXT", "glCompressedMultiTexSubImage3DEXT", "glCompressedTextureImage1DEXT", "glCompressedTextureImage2DEXT", "glCompressedTextureImage3DEXT", "glCompressedTextureSubImage1DEXT", "glCompressedTextureSubImage2DEXT", "glCompressedTextureSubImage3DEXT", "glCopyMultiTexImage1DEXT", "glCopyMultiTexImage2DEXT", "glCopyMultiTexSubImage1DEXT", "glCopyMultiTexSubImage2DEXT", "glCopyMultiTexSubImage3DEXT", "glCopyTextureImage1DEXT", "glCopyTextureImage2DEXT", "glCopyTextureSubImage1DEXT", "glCopyTextureSubImage2DEXT", "glCopyTextureSubImage3DEXT", "glDisableClientStateiEXT", "glDisableClientStateIndexedEXT", "glDisableIndexedEXT", "glDisableVertexArrayAttribEXT", "glDisableVertexArrayEXT", "glEnableClientStateiEXT", "glEnableClientStateIndexedEXT", "glEnableIndexedEXT", "glEnableVertexArrayAttribEXT", "glEnableVertexArrayEXT", "glFlushMappedNamedBufferRangeEXT", "glFramebufferDrawBufferEXT", "glFramebufferDrawBuffersEXT", "glFramebufferReadBufferEXT", "glGenerateMultiTexMipmapEXT", "glGenerateTextureMipmapEXT", "glGetBooleanIndexedvEXT", "glGetCompressedMultiTexImageEXT", "glGetCompressedTextureImageEXT", "glGetDoublei_vEXT", "glGetDoubleIndexedvEXT", "glGetFloati_vEXT", "glGetFloatIndexedvEXT", "glGetFramebufferParameterivEXT", "glGetIntegerIndexedvEXT", "glGetMultiTexEnvfvEXT", "glGetMultiTexEnvivEXT", "glGetMultiTexGendvEXT", "glGetMultiTexGenfvEXT", "glGetMultiTexGenivEXT", "glGetMultiTexImageEXT", "glGetMultiTexLevelParameterfvEXT", "glGetMultiTexLevelParameterivEXT", "glGetMultiTexParameterfvEXT", "glGetMultiTexParameterIivEXT", "glGetMultiTexParameterIuivEXT", "glGetMultiTexParameterivEXT", "glGetNamedBufferParameterivEXT", "glGetNamedBufferPointervEXT", "glGetNamedBufferSubDataEXT", "glGetNamedFramebufferAttachmentParameterivEXT", "glGetNamedFramebufferParameterivEXT", "glGetNamedProgramivEXT", "glGetNamedProgramLocalParameterdvEXT", "glGetNamedProgramLocalParameterfvEXT", "glGetNamedProgramLocalParameterIivEXT", "glGetNamedProgramLocalParameterIuivEXT", "glGetNamedProgramStringEXT", "glGetNamedRenderbufferParameterivEXT", "glGetPointeri_vEXT", "glGetPointerIndexedvEXT", "glGetTextureImageEXT", "glGetTextureLevelParameterfvEXT", "glGetTextureLevelParameterivEXT", "glGetTextureParameterfvEXT", "glGetTextureParameterIivEXT", "glGetTextureParameterIuivEXT", "glGetTextureParameterivEXT", "glGetVertexArrayIntegeri_vEXT", "glGetVertexArrayIntegervEXT", "glGetVertexArrayPointeri_vEXT", "glGetVertexArrayPointervEXT", "glIsEnabledIndexedEXT", "glMapNamedBufferEXT", "glMapNamedBufferRangeEXT", "glMatrixFrustumEXT", "glMatrixLoaddEXT", "glMatrixLoadfEXT", "glMatrixLoadIdentityEXT", "glMatrixLoadTransposedEXT", "glMatrixLoadTransposefEXT", "glMatrixMultdEXT", "glMatrixMultfEXT", "glMatrixMultTransposedEXT", "glMatrixMultTransposefEXT", "glMatrixOrthoEXT", "glMatrixPopEXT", "glMatrixPushEXT", "glMatrixRotatedEXT", "glMatrixRotatefEXT", "glMatrixScaledEXT", "glMatrixScalefEXT", "glMatrixTranslatedEXT", "glMatrixTranslatefEXT", "glMultiTexBufferEXT", "glMultiTexCoordPointerEXT", "glMultiTexEnvfEXT", "glMultiTexEnvfvEXT", "glMultiTexEnviEXT", "glMultiTexEnvivEXT", "glMultiTexGendEXT", "glMultiTexGendvEXT", "glMultiTexGenfEXT", "glMultiTexGenfvEXT", "glMultiTexGeniEXT", "glMultiTexGenivEXT", "glMultiTexImage1DEXT", "glMultiTexImage2DEXT", "glMultiTexImage3DEXT", "glMultiTexParameterfEXT", "glMultiTexParameterfvEXT", "glMultiTexParameteriEXT", "glMultiTexParameterIivEXT", "glMultiTexParameterIuivEXT", "glMultiTexParameterivEXT", "glMultiTexRenderbufferEXT", "glMultiTexSubImage1DEXT", "glMultiTexSubImage2DEXT", "glMultiTexSubImage3DEXT", "glNamedBufferDataEXT", "glNamedBufferStorageEXT", "glNamedBufferSubDataEXT", "glNamedCopyBufferSubDataEXT", "glNamedFramebufferParameteriEXT", "glNamedFramebufferRenderbufferEXT", "glNamedFramebufferTexture1DEXT", "glNamedFramebufferTexture2DEXT", "glNamedFramebufferTexture3DEXT", "glNamedFramebufferTextureEXT", "glNamedFramebufferTextureFaceEXT", "glNamedFramebufferTextureLayerEXT", "glNamedProgramLocalParameter4dEXT", "glNamedProgramLocalParameter4dvEXT", "glNamedProgramLocalParameter4fEXT", "glNamedProgramLocalParameter4fvEXT", "glNamedProgramLocalParameterI4iEXT", "glNamedProgramLocalParameterI4ivEXT", "glNamedProgramLocalParameterI4uiEXT", "glNamedProgramLocalParameterI4uivEXT", "glNamedProgramLocalParameters4fvEXT", "glNamedProgramLocalParametersI4ivEXT", "glNamedProgramLocalParametersI4uivEXT", "glNamedProgramStringEXT", "glNamedRenderbufferStorageEXT", "glNamedRenderbufferStorageMultisampleCoverageEXT", "glNamedRenderbufferStorageMultisampleEXT", "glProgramUniform1dEXT", "glProgramUniform1dvEXT", "glProgramUniform1fEXT", "glProgramUniform1fvEXT", "glProgramUniform1iEXT", "glProgramUniform1ivEXT", "glProgramUniform1uiEXT", "glProgramUniform1uivEXT", "glProgramUniform2dEXT", "glProgramUniform2dvEXT", "glProgramUniform2fEXT", "glProgramUniform2fvEXT", "glProgramUniform2iEXT", "glProgramUniform2ivEXT", "glProgramUniform2uiEXT", "glProgramUniform2uivEXT", "glProgramUniform3dEXT", "glProgramUniform3dvEXT", "glProgramUniform3fEXT", "glProgramUniform3fvEXT", "glProgramUniform3iEXT", "glProgramUniform3ivEXT", "glProgramUniform3uiEXT", "glProgramUniform3uivEXT", "glProgramUniform4dEXT", "glProgramUniform4dvEXT", "glProgramUniform4fEXT", "glProgramUniform4fvEXT", "glProgramUniform4iEXT", "glProgramUniform4ivEXT", "glProgramUniform4uiEXT", "glProgramUniform4uivEXT", "glProgramUniformMatrix2dvEXT", "glProgramUniformMatrix2fvEXT", "glProgramUniformMatrix2x3dvEXT", "glProgramUniformMatrix2x3fvEXT", "glProgramUniformMatrix2x4dvEXT", "glProgramUniformMatrix2x4fvEXT", "glProgramUniformMatrix3dvEXT", "glProgramUniformMatrix3fvEXT", "glProgramUniformMatrix3x2dvEXT", "glProgramUniformMatrix3x2fvEXT", "glProgramUniformMatrix3x4dvEXT", "glProgramUniformMatrix3x4fvEXT", "glProgramUniformMatrix4dvEXT", "glProgramUniformMatrix4fvEXT", "glProgramUniformMatrix4x2dvEXT", "glProgramUniformMatrix4x2fvEXT", "glProgramUniformMatrix4x3dvEXT", "glProgramUniformMatrix4x3fvEXT", "glPushClientAttribDefaultEXT", "glTextureBufferEXT", "glTextureBufferRangeEXT", "glTextureImage1DEXT", "glTextureImage2DEXT", "glTextureImage3DEXT", "glTexturePageCommitmentEXT", "glTextureParameterfEXT", "glTextureParameterfvEXT", "glTextureParameteriEXT", "glTextureParameterIivEXT", "glTextureParameterIuivEXT", "glTextureParameterivEXT", "glTextureRenderbufferEXT", "glTextureStorage1DEXT", "glTextureStorage2DEXT", "glTextureStorage2DMultisampleEXT", "glTextureStorage3DEXT", "glTextureStorage3DMultisampleEXT", "glTextureSubImage1DEXT", "glTextureSubImage2DEXT", "glTextureSubImage3DEXT", "glUnmapNamedBufferEXT", "glVertexArrayBindVertexBufferEXT", "glVertexArrayColorOffsetEXT", "glVertexArrayEdgeFlagOffsetEXT", "glVertexArrayFogCoordOffsetEXT", "glVertexArrayIndexOffsetEXT", "glVertexArrayMultiTexCoordOffsetEXT", "glVertexArrayNormalOffsetEXT", "glVertexArraySecondaryColorOffsetEXT", "glVertexArrayTexCoordOffsetEXT", "glVertexArrayVertexAttribBindingEXT", "glVertexArrayVertexAttribDivisorEXT", "glVertexArrayVertexAttribFormatEXT", "glVertexArrayVertexAttribIFormatEXT", "glVertexArrayVertexAttribIOffsetEXT", "glVertexArrayVertexAttribLFormatEXT", "glVertexArrayVertexAttribLOffsetEXT", "glVertexArrayVertexAttribOffsetEXT", "glVertexArrayVertexBindingDivisorEXT", "glVertexArrayVertexOffsetEXT" } },
    { GLextension::GL_EXT_draw_buffers2, { "glColorMaskIndexedEXT", "glDisableIndexedEXT", "glEnableIndexedEXT", "glGetBooleanIndexedvEXT", "glGetIntegerIndexedvEXT", "glIsEnabledIndexedEXT" } },
    { GLextension::GL_EXT_draw_instanced, { "glDrawArraysInstancedEXT", "glDrawElementsInstancedEXT" } },
    { GLextension::GL_EXT_draw_range_elements, { "glDrawRangeElementsEXT" } },
    { GLextension::GL_EXT_EGL_image_storage, { "glEGLImageTargetTexStorageEXT", "glEGLImageTargetTextureStorageEXT" } },
    { GLextension::GL_EXT_external_buffer, { "glBufferStorageExternalEXT", "glNamedBufferStorageExternalEXT" } },
    { GLextension::GL_EXT_fog_coord, { "glFogCoorddEXT", "glFogCoorddvEXT", "glFogCoordfEXT", "glFogCoordfvEXT", "glFogCoordPointerEXT" } },
    { GLextension::GL_EXT_framebuffer_blit, { "glBlitFramebufferEXT" } },
    { GLextension::GL_EXT_framebuffer_blit_layers, { "glBlitFramebufferLayerEXT", "glBlitFramebufferLayersEXT" } },
    { GLextension::GL_EXT_framebuffer_multisample, { "glRenderbufferStorageMultisampleEXT" } },
    { GLextension::GL_EXT_framebuffer_object, { "glBindFramebufferEXT", "glBindRenderbufferEXT", "glCheckFramebufferStatusEXT", "glDeleteFramebuffersEXT", "glDeleteRenderbuffersEXT", "glFramebufferRenderbufferEXT", "glFramebufferTexture1DEXT", "glFramebufferTexture2DEXT", "glFramebufferTexture3DEXT", "glGenerateMipmapEXT", "glGenFramebuffersEXT", "glGenRenderbuffersEXT", "glGetFramebufferAttachmentParameterivEXT", "glGetRenderbufferParameterivEXT", "glIsFramebufferEXT", "glIsRenderbufferEXT", "glRenderbufferStorageEXT" } },
    { GLextension::GL_EXT_geometry_shader4, { "glProgramParameteriEXT" } },
    { GLextension::GL_EXT_gpu_program_parameters, { "glProgramEnvParameters4fvEXT", "glProgramLocalParameters4fvEXT" } },
    { GLextension::GL_EXT_gpu_shader4, { "glBindFragDataLocationEXT", "glGetFragDataLocationEXT", "glGetUniformuivEXT", "glGetVertexAttribIivEXT", "glGetVertexAttribIuivEXT", "glUniform1uiEXT", "glUniform1uivEXT", "glUniform2uiEXT", "glUniform2uivEXT", "glUniform3uiEXT", "glUniform3uivEXT", "glUniform4uiEXT", "glUniform4uivEXT", "glVertexAttribI1iEXT", "glVertexAttribI1ivEXT", "glVertexAttribI1uiEXT", "glVertexAttribI1uivEXT", "glVertexAttribI2iEXT", "glVertexAttribI2ivEXT", "glVertexAttribI2uiEXT", "glVertexAttribI2uivEXT", "glVertexAttribI3iEXT", "glVertexAttribI3ivEXT", "glVertexAttribI3uiEXT", "glVertexAttribI3uivEXT", "glVertexAttribI4bvEXT", "glVertexAttribI4iEXT", "glVertexAttribI4ivEXT", "glVertexAttribI4svEXT", "glVertexAttribI4ubvEXT", "glVertexAttribI4uiEXT", "glVertexAttribI4uivEXT", "glVertexAttribI4usvEXT", "glVertexAttribIPointerEXT" } },
    { GLextension::GL_EXT_histogram, { "glGetHistogramEXT", "glGetHistogramParameterfvEXT", "glGetHistogramParameterivEXT", "glGetMinmaxEXT", "glGetMinmaxParameterfvEXT", "glGetMinmaxParameterivEXT", "glHistogramEXT", "glMinmaxEXT", "glResetHistogramEXT", "glResetMinmaxEXT" } },
    { GLextension::GL_EXT_index_func, { "glIndexFuncEXT" } },
    { GLextension::GL_EXT_index_material, { "glIndexMaterialEXT" } },
    { GLextension::GL_EXT_light_texture, { "glApplyTextureEXT", "glTextureLightEXT", "glTextureMaterialEXT" } },
    { GLextension::GL_EXT_memory_object, { "glBufferStorageMemEXT", "glCreateMemoryObjectsEXT", "glDeleteMemoryObjectsEXT", "glGetMemoryObjectParameterivEXT", "glGetUnsignedBytei_vEXT", "glGetUnsignedBytevEXT", "glIsMemoryObjectEXT", "glMemoryObjectParameterivEXT", "glNamedBufferStorageMemEXT", "glTexStorageMem1DEXT", "glTexStorageMem2DEXT", "glTexStorageMem2DMultisampleEXT", "glTexStorageMem3DEXT", "glTexStorageMem3DMultisampleEXT", "glTextureStorageMem1DEXT", "glTextureStorageMem2DEXT", "glTextureStorageMem2DMultisampleEXT", "glTextureStorageMem3DEXT", "glTextureStorageMem3DMultisampleEXT" } },
    { GLextension::GL_EXT_memory_object_fd, { "glImportMemoryFdEXT" } },
    { GLextension::GL_EXT_memory_object_win32, { "glImportMemoryWin32HandleEXT", "glImportMemoryWin32NameEXT" } },
    { GLextension::GL_EXT_multi_draw_arrays, { "glMultiDrawArraysEXT", "glMultiDrawElementsEXT" } },
    { GLextension::GL_EXT_multisample, { "glSampleMaskEXT", "glSamplePatternEXT" } },
    { GLextension::GL_EXT_paletted_texture, { "glColorTableEXT", "glGetColorTableEXT", "glGetColorTableParameterfvEXT", "glGetColorTableParameterivEXT" } },
    { GLextension::GL_EXT_pixel_transform, { "glGetPixelTransformParameterfvEXT", "glGetPixelTransformParameterivEXT", "glPixelTransformParameterfEXT", "glPixelTransformParameterfvEXT", "glPixelTransformParameteriEXT", "glPixelTransformParameterivEXT" } },
    { GLextension::GL_EXT_point_parameters, { "glPointParameterfEXT", "glPointParameterfvEXT" } },
    { GLextension::GL_EXT_polygon_offset, { "glPolygonOffsetEXT" } },
    { GLextension::GL_EXT_polygon_offset_clamp, { "glPolygonOffsetClampEXT" } },
    { GLextension::GL_EXT_provoking_vertex, { "glProvokingVertexEXT" } },
    { GLextension::GL_EXT_raster_multisample, { "glRasterSamplesEXT" } },
    { GLextension::GL_EXT_secondary_color, { "glSecondaryColor3bEXT", "glSecondaryColor3bvEXT", "glSecondaryColor3dEXT", "glSecondaryColor3dvEXT", "glSecondaryColor3fEXT", "glSecondaryColor3fvEXT", "glSecondaryColor3iEXT", "glSecondaryColor3ivEXT", "glSecondaryColor3sEXT", "glSecondaryColor3svEXT", "glSecondaryColor3ubEXT", "glSecondaryColor3ubvEXT", "glSecondaryColor3uiEXT", "glSecondaryColor3uivEXT", "glSecondaryColor3usEXT", "glSecondaryColor3usvEXT", "glSecondaryColorPointerEXT" } },
    { GLextension::GL_EXT_semaphore, { "glDeleteSemaphoresEXT", "glGenSemaphoresEXT", "glGetSemaphoreParameterui64vEXT", "glGetUnsignedBytei_vEXT", "glGetUnsignedBytevEXT", "glIsSemaphoreEXT", "glSemaphoreParameterui64vEXT", "glSignalSemaphoreEXT", "glWaitSemaphoreEXT" } },
    { GLextension::GL_EXT_semaphore_fd, { "glImportSemaphoreFdEXT" } },
    { GLextension::GL_EXT_semaphore_win32, { "glImportSemaphoreWin32HandleEXT", "glImportSemaphoreWin32NameEXT" } },
    { GLextension::GL_EXT_separate_shader_objects, { "glActiveProgramEXT", "glActiveShaderProgramEXT", "glBindProgramPipelineEXT", "glCreateShaderProgramEXT", "glCreateShaderProgramvEXT", "glDeleteProgramPipelinesEXT", "glGenProgramPipelinesEXT", "glGetProgramPipelineInfoLogEXT", "glGetProgramPipelineivEXT", "glIsProgramPipelineEXT", "glProgramParameteriEXT", "glProgramUniform1fEXT", "glProgramUniform1fvEXT", "glProgramUniform1iEXT", "glProgramUniform1ivEXT", "glProgramUniform1uiEXT", "glProgramUniform1uivEXT", "glProgramUniform2fEXT", "glProgramUniform2fvEXT", "glProgramUniform2iEXT", "glProgramUniform2ivEXT", "glProgramUniform2uiEXT", "glProgramUniform2uivEXT", "glProgramUniform3fEXT", "glProgramUniform3fvEXT", "glProgramUniform3iEXT", "glProgramUniform3ivEXT", "glProgramUniform3uiEXT", "glProgramUniform3uivEXT", "glProgramUniform4fEXT", "glProgramUniform4fvEXT", "glProgramUniform4iEXT", "glProgramUniform4ivEXT", "glProgramUniform4uiEXT", "glProgramUniform4uivEXT", "glProgramUniformMatrix2fvEXT", "glProgramUniformMatrix2x3fvEXT", "glProgramUniformMatrix2x4fvEXT", "glProgramUniformMatrix3fvEXT", "glProgramUniformMatrix3x2fvEXT", "glProgramUniformMatrix3x4fvEXT", "glProgramUniformMatrix4fvEXT", "glProgramUniformMatrix4x2fvEXT", "glProgramUniformMatrix4x3fvEXT", "glUseProgramStagesEXT", "glUseShaderProgramEXT", "glValidateProgramPipelineEXT" } },
    { GLextension::GL_EXT_shader_framebuffer_fetch_non_coherent, { "glFramebufferFetchBarrierEXT" } },
    { GLextension::GL_EXT_shader_image_load_store, { "glBindImageTextureEXT", "glMemoryBarrierEXT" } },
    { GLextension::GL_EXT_stencil_clear_tag, { "glStencilClearTagEXT" } },
    { GLextension::GL_EXT_stencil_two_side, { "glActiveStencilFaceEXT" } },
    { GLextension::GL_EXT_subtexture, { "glTexSubImage1DEXT", "glTexSubImage2DEXT" } },
    { GLextension::GL_EXT_texture3D, { "glTexImage3DEXT", "glTexSubImage3DEXT" } },
    { GLextension::GL_EXT_texture_array, { "glFramebufferTextureLayerEXT" } },
    { GLextension::GL_EXT_texture_buffer_object, { "glTexBufferEXT" } },
    { GLextension::GL_EXT_texture_integer, { "glClearColorIiEXT", "glClearColorIuiEXT", "glGetTexParameterIivEXT", "glGetTexParameterIuivEXT", "glTexParameterIivEXT", "glTexParameterIuivEXT" } },
    { GLextension::GL_EXT_texture_object, { "glAreTexturesResidentEXT", "glBindTextureEXT", "glDeleteTexturesEXT", "glGenTexturesEXT", "glIsTextureEXT", "glPrioritizeTexturesEXT" } },
    { GLextension::GL_EXT_texture_perturb_normal, { "glTextureNormalEXT" } },
    { GLextension::GL_EXT_texture_storage, { "glTexStorage1DEXT", "glTexStorage2DEXT", "glTexStorage3DEXT", "glTextureStorage1DEXT", "glTextureStorage2DEXT", "glTextureStorage3DEXT" } },
    { GLextension::GL_EXT_timer_query, { "glGetQueryObjecti64vEXT", "glGetQueryObjectui64vEXT" } },
    { GLextension::GL_EXT_transform_feedback, { "glBeginTransformFeedbackEXT", "glBindBufferBaseEXT", "glBindBufferOffsetEXT", "glBindBufferRangeEXT", "glEndTransformFeedbackEXT", "glGetTransformFeedbackVaryingEXT", "glTransformFeedbackVaryingsEXT" } },
    { GLextension::GL_EXT_vertex_array, { "glArrayElementEXT", "glColorPointerEXT", "glDrawArraysEXT", "glEdgeFlagPointerEXT", "glGetPointervEXT", "glIndexPointerEXT", "glNormalPointerEXT", "glTexCoordPointerEXT", "glVertexPointerEXT" } },
    { GLextension::GL_EXT_vertex_attrib_64bit, { "glGetVertexAttribLdvEXT", "glVertexAttribL1dEXT", "glVertexAttribL1dvEXT", "glVertexAttribL2dEXT", "glVertexAttribL2dvEXT", "glVertexAttribL3dEXT", "glVertexAttribL3dvEXT", "glVertexAttribL4dEXT", "glVertexAttribL4dvEXT", "glVertexAttribLPointerEXT" } },
    { GLextension::GL_EXT_vertex_shader, { "glBeginVertexShaderEXT", "glBindLightParameterEXT", "glBindMaterialParameterEXT", "glBindParameterEXT", "glBindTexGenParameterEXT", "glBindTextureUnitParameterEXT", "glBindVertexShaderEXT", "glDeleteVertexShaderEXT", "glDisableVariantClientStateEXT", "glEnableVariantClientStateEXT", "glEndVertexShaderEXT", "glExtractComponentEXT", "glGenSymbolsEXT", "glGenVertexShadersEXT", "glGetInvariantBooleanvEXT", "glGetInvariantFloatvEXT", "glGetInvariantIntegervEXT", "glGetLocalConstantBooleanvEXT", "glGetLocalConstantFloatvEXT", "glGetLocalConstantIntegervEXT", "glGetVariantBooleanvEXT", "glGetVariantFloatvEXT", "glGetVariantIntegervEXT", "glGetVariantPointervEXT", "glInsertComponentEXT", "glIsVariantEnabledEXT", "glSetInvariantEXT", "glSetLocalConstantEXT", "glShaderOp1EXT", "glShaderOp2EXT", "glShaderOp3EXT", "glSwizzleEXT", "glVariantbvEXT", "glVariantdvEXT", "glVariantfvEXT", "glVariantivEXT", "glVariantPointerEXT", "glVariantsvEXT", "glVariantubvEXT", "glVariantuivEXT", "glVariantusvEXT", "glWriteMaskEXT" } },
    { GLextension::GL_EXT_vertex_weighting, { "glVertexWeightfEXT", "glVertexWeightfvEXT", "glVertexWeightPointerEXT" } },
    { GLextension::GL_EXT_win32_keyed_mutex, { "glAcquireKeyedMutexWin32EXT", "glReleaseKeyedMutexWin32EXT" } },
    { GLextension::GL_EXT_window_rectangles, { "glWindowRectanglesEXT" } },
    { GLextension::GL_EXT_x11_sync_object, { "glImportSyncEXT" } },
    { GLextension::GL_GREMEDY_frame_terminator, { "glFrameTerminatorGREMEDY" } },
    { GLextension::GL_GREMEDY_string_marker, { "glStringMarkerGREMEDY" } },
    { GLextension::GL_HP_image_transform, { "glGetImageTransformParameterfvHP", "glGetImageTransformParameterivHP", "glImageTransformParameterfHP", "glImageTransformParameterfvHP", "glImageTransformParameteriHP", "glImageTransformParameterivHP" } },
    { GLextension::GL_IBM_multimode_draw_arrays, { "glMultiModeDrawArraysIBM", "glMultiModeDrawElementsIBM" } },
    { GLextension::GL_IBM_static_data, { "glFlushStaticDataIBM" } },
    { GLextension::GL_IBM_vertex_array_lists, { "glColorPointerListIBM", "glEdgeFlagPointerListIBM", "glFogCoordPointerListIBM", "glIndexPointerListIBM", "glNormalPointerListIBM", "glSecondaryColorPointerListIBM", "glTexCoordPointerListIBM", "glVertexPointerListIBM" } },
    { GLextension::GL_INGR_blend_func_separate, { "glBlendFuncSeparateINGR" } },
    { GLextension::GL_INTEL_framebuffer_CMAA, { "glApplyFramebufferAttachmentCMAAINTEL" } },
    { GLextension::GL_INTEL_map_texture, { "glMapTexture2DINTEL", "glSyncTextureINTEL", "glUnmapTexture2DINTEL" } },
    { GLextension::GL_INTEL_parallel_arrays, { "glColorPointervINTEL", "glNormalPointervINTEL", "glTexCoordPointervINTEL", "glVertexPointervINTEL" } },
    { GLextension::GL_INTEL_performance_query, { "glBeginPerfQueryINTEL", "glCreatePerfQueryINTEL", "glDeletePerfQueryINTEL", "glEndPerfQueryINTEL", "glGetFirstPerfQueryIdINTEL", "glGetNextPerfQueryIdINTEL", "glGetPerfCounterInfoINTEL", "glGetPerfQueryDataINTEL", "glGetPerfQueryIdByNameINTEL", "glGetPerfQueryInfoINTEL" } },
    { GLextension::GL_KHR_blend_equation_advanced, { "glBlendBarrierKHR" } },
    { GLextension::GL_KHR_debug, { "glDebugMessageCallback", "glDebugMessageCallbackKHR", "glDebugMessageControl", "glDebugMessageControlKHR", "glDebugMessageInsert", "glDebugMessageInsertKHR", "glGetDebugMessageLog", "glGetDebugMessageLogKHR", "glGetObjectLabel", "glGetObjectLabelKHR", "glGetObjectPtrLabel", "glGetObjectPtrLabelKHR", "glGetPointerv", "glGetPointervKHR", "glObjectLabel", "glObjectLabelKHR", "glObjectPtrLabel", "glObjectPtrLabelKHR", "glPopDebugGroup", "glPopDebugGroupKHR", "glPushDebugGroup", "glPushDebugGroupKHR" } },
    { GLextension::GL_KHR_parallel_shader_compile, { "glMaxShaderCompilerThreadsKHR" } },
    { GLextension::GL_KHR_robustness, { "glGetGraphicsResetStatus", "glGetGraphicsResetStatusKHR", "glGetnUniformfv", "glGetnUniformfvKHR", "glGetnUniformiv", "glGetnUniformivKHR", "glGetnUniformuiv", "glGetnUniformuivKHR", "glReadnPixels", "glReadnPixelsKHR" } },
    { GLextension::GL_MESA_framebuffer_flip_y, { "glFramebufferParameteriMESA", "glGetFramebufferParameterivMESA" } },
    { GLextension::GL_MESA_resize_buffers, { "glResizeBuffersMESA" } },
    { GLextension::GL_MESA_window_pos, { "glWindowPos2dMESA", "glWindowPos2dvMESA", "glWindowPos2fMESA", "glWindowPos2fvMESA", "glWindowPos2iMESA", "glWindowPos2ivMESA", "glWindowPos2sMESA", "glWindowPos2svMESA", "glWindowPos3dMESA", "glWindowPos3dvMESA", "glWindowPos3fMESA", "glWindowPos3fvMESA", "glWindowPos3iMESA", "glWindowPos3ivMESA", "glWindowPos3sMESA", "glWindowPos3svMESA", "glWindowPos4dMESA", "glWindowPos4dvMESA", "glWindowPos4fMESA", "glWindowPos4fvMESA", "glWindowPos4iMESA", "glWindowPos4ivMESA", "glWindowPos4sMESA", "glWindowPos4svMESA" } },
    { GLextension::GL_NV_alpha_to_coverage_dither_control, { "glAlphaToCoverageDitherControlNV" } },
    { GLextension::GL_NV_bindless_multi_draw_indirect, { "glMultiDrawArraysIndirectBindlessNV", "glMultiDrawElementsIndirectBindlessNV" } },
    { GLextension::GL_NV_bindless_multi_draw_indirect_count, { "glMultiDrawArraysIndirectBindlessCountNV", "glMultiDrawElementsIndirectBindlessCountNV" } },
    { GLextension::GL_NV_bindless_texture, { "glGetImageHandleNV", "glGetTextureHandleNV", "glGetTextureSamplerHandleNV", "glIsImageHandleResidentNV", "glIsTextureHandleResidentNV", "glMakeImageHandleNonResidentNV", "glMakeImageHandleResidentNV", "glMakeTextureHandleNonResidentNV", "glMakeTextureHandleResidentNV", "glProgramUniformHandleui64NV", "glProgramUniformHandleui64vNV", "glUniformHandleui64NV", "glUniformHandleui64vNV" } },
    { GLextension::GL_NV_blend_equation_advanced, { "glBlendBarrierNV", "glBlendParameteriNV" } },
    { GLextension::GL_NV_clip_space_w_scaling, { "glViewportPositionWScaleNV" } },
    { GLextension::GL_NV_command_list, { "glCallCommandListNV", "glCommandListSegmentsNV", "glCompileCommandListNV", "glCreateCommandListsNV", "glCreateStatesNV", "glDeleteCommandListsNV", "glDeleteStatesNV", "glDrawCommandsAddressNV", "glDrawCommandsNV", "glDrawCommandsStatesAddressNV", "glDrawCommandsStatesNV", "glGetCommandHeaderNV", "glGetStageIndexNV", "glIsCommandListNV", "glIsStateNV", "glListDrawCommandsStatesClientNV", "glStateCaptureNV" } },
    { GLextension::GL_NV_conditional_render, { "glBeginConditionalRenderNV", "glEndConditionalRenderNV" } },
    { GLextension::GL_NV_conservative_raster, { "glSubpixelPrecisionBiasNV" } },
    { GLextension::GL_NV_conservative_raster_dilate, { "glConservativeRasterParameterfNV" } },
    { GLextension::GL_NV_conservative_raster_pre_snap_triangles, { "glConservativeRasterParameteriNV" } },
    { GLextension::GL_NV_copy_image, { "glCopyImageSubDataNV" } },
    { GLextension::GL_NV_depth_buffer_float, { "glClearDepthdNV", "glDepthBoundsdNV", "glDepthRangedNV" } },
    { GLextension::GL_NV_draw_texture, { "glDrawTextureNV" } },
    { GLextension::GL_NV_draw_vulkan_image, { "glDrawVkImageNV", "glGetVkProcAddrNV", "glSignalVkFenceNV", "glSignalVkSemaphoreNV", "glWaitVkSemaphoreNV" } },
    { GLextension::GL_NV_evaluators, { "glEvalMapsNV", "glGetMapAttribParameterfvNV", "glGetMapAttribParameterivNV", "glGetMapControlPointsNV", "glGetMapParameterfvNV", "glGetMapParameterivNV", "glMapControlPointsNV", "glMapParameterfvNV", "glMapParameterivNV" } },
    { GLextension::GL_NV_explicit_multisample, { "glGetMultisamplefvNV", "glSampleMaskIndexedNV", "glTexRenderbufferNV" } },
    { GLextension::GL_NV_fence, { "glDeleteFencesNV", "glFinishFenceNV", "glGenFencesNV", "glGetFenceivNV", "glIsFenceNV", "glSetFenceNV", "glTestFenceNV" } },
    { GLextension::GL_NV_fragment_coverage_to_color, { "glFragmentCoverageColorNV" } },
    { GLextension::GL_NV_fragment_program, { "glGetProgramNamedParameterdvNV", "glGetProgramNamedParameterfvNV", "glProgramNamedParameter4dNV", "glProgramNamedParameter4dvNV", "glProgramNamedParameter4fNV", "glProgramNamedParameter4fvNV" } },
    { GLextension::GL_NV_framebuffer_mixed_samples, { "glCoverageModulationNV", "glCoverageModulationTableNV", "glGetCoverageModulationTableNV", "glRasterSamplesEXT" } },
    { GLextension::GL_NV_framebuffer_multisample_coverage, { "glRenderbufferStorageMultisampleCoverageNV" } },
    { GLextension::GL_NV_geometry_program4, { "glFramebufferTextureEXT", "glFramebufferTextureFaceEXT", "glFramebufferTextureLayerEXT", "glProgramVertexLimitNV" } },
    { GLextension::GL_NV_gpu_multicast, { "glMulticastBarrierNV", "glMulticastBlitFramebufferNV", "glMulticastBufferSubDataNV", "glMulticastCopyBufferSubDataNV", "glMulticastCopyImageSubDataNV", "glMulticastFramebufferSampleLocationsfvNV", "glMulticastGetQueryObjecti64vNV", "glMulticastGetQueryObjectivNV", "glMulticastGetQueryObjectui64vNV", "glMulticastGetQueryObjectuivNV", "glMulticastWaitSyncNV", "glRenderGpuMaskNV" } },
    { GLextension::GL_NV_gpu_program4, { "glGetProgramEnvParameterIivNV", "glGetProgramEnvParameterIuivNV", "glGetProgramLocalParameterIivNV", "glGetProgramLocalParameterIuivNV", "glProgramEnvParameterI4iNV", "glProgramEnvParameterI4ivNV", "glProgramEnvParameterI4uiNV", "glProgramEnvParameterI4uivNV", "glProgramEnvParametersI4ivNV", "glProgramEnvParametersI4uivNV", "glProgramLocalParameterI4iNV", "glProgramLocalParameterI4ivNV", "glProgramLocalParameterI4uiNV", "glProgramLocalParameterI4uivNV", "glProgramLocalParametersI4ivNV", "glProgramLocalParametersI4uivNV" } },
    { GLextension::GL_NV_gpu_program5, { "glGetProgramSubroutineParameteruivNV", "glProgramSubroutineParametersuivNV" } },
    { GLextension::GL_NV_gpu_shader5, { "glGetUniformi64vNV", "glProgramUniform1i64NV", "glProgramUniform1i64vNV", "glProgramUniform1ui64NV", "glProgramUniform1ui64vNV", "glProgramUniform2i64NV", "glProgramUniform2i64vNV", "glProgramUniform2ui64NV", "glProgramUniform2ui64vNV", "glProgramUniform3i64NV", "glProgramUniform3i64vNV", "glProgramUniform3ui64NV", "glProgramUniform3ui64vNV", "glProgramUniform4i64NV", "glProgramUniform4i64vNV", "glProgramUniform4ui64NV", "glProgramUniform4ui64vNV", "glUniform1i64NV", "glUniform1i64vNV", "glUniform1ui64NV", "glUniform1ui64vNV", "glUniform2i64NV", "glUniform2i64vNV", "glUniform2ui64NV", "glUniform2ui64vNV", "glUniform3i64NV", "glUniform3i64vNV", "glUniform3ui64NV", "glUniform3ui64vNV", "glUniform4i64NV", "glUniform4i64vNV", "glUniform4ui64NV", "glUniform4ui64vNV" } },
    { GLextension::GL_NV_half_float, { "glColor3hNV", "glColor3hvNV", "glColor4hNV", "glColor4hvNV", "glFogCoordhNV", "glFogCoordhvNV", "glMultiTexCoord1hNV", "glMultiTexCoord1hvNV", "glMultiTexCoord2hNV", "glMultiTexCoord2hvNV", "glMultiTexCoord3hNV", "glMultiTexCoord3hvNV", "glMultiTexCoord4hNV", "glMultiTexCoord4hvNV", "glNormal3hNV", "glNormal3hvNV", "glSecondaryColor3hNV", "glSecondaryColor3hvNV", "glTexCoord1hNV", "glTexCoord1hvNV", "glTexCoord2hNV", "glTexCoord2hvNV", "glTexCoord3hNV", "glTexCoord3hvNV", "glTexCoord4hNV", "glTexCoord4hvNV", "glVertex2hNV", "glVertex2hvNV", "glVertex3hNV", "glVertex3hvNV", "glVertex4hNV", "glVertex4hvNV", "glVertexAttrib1hNV", "glVertexAttrib1hvNV", "glVertexAttrib2hNV", "glVertexAttrib2hvNV", "glVertexAttrib3hNV", "glVertexAttrib3hvNV", "glVertexAttrib4hNV", "glVertexAttrib4hvNV", "glVertexAttribs1hvNV", "glVertexAttribs2hvNV", "glVertexAttribs3hvNV", "glVertexAttribs4hvNV", "glVertexWeighthNV", "glVertexWeighthvNV" } },
    { GLextension::GL_NV_internalformat_sample_query, { "glGetInternalformatSampleivNV" } },
    { GLextension::GL_NV_memory_attachment, { "glBufferAttachMemoryNV", "glGetMemoryObjectDetachedResourcesuivNV", "glNamedBufferAttachMemoryNV", "glResetMemoryObjectParameterNV", "glTexAttachMemoryNV", "glTextureAttachMemoryNV" } },
    { GLextension::GL_NV_memory_object_sparse, { "glBufferPageCommitmentMemNV", "glNamedBufferPageCommitmentMemNV", "glTexPageCommitmentMemNV", "glTexturePageCommitmentMemNV" } },
    { GLextension::GL_NV_mesh_shader, { "glDrawMeshTasksIndirectNV", "glDrawMeshTasksNV", "glMultiDrawMeshTasksIndirectCountNV", "glMultiDrawMeshTasksIndirectNV" } },
    { GLextension::GL_NV_occlusion_query, { "glBeginOcclusionQueryNV", "glDeleteOcclusionQueriesNV", "glEndOcclusionQueryNV", "glGenOcclusionQueriesNV", "glGetOcclusionQueryivNV", "glGetOcclusionQueryuivNV", "glIsOcclusionQueryNV" } },
    { GLextension::GL_NV_parameter_buffer_object, { "glProgramBufferParametersfvNV", "glProgramBufferParametersIivNV", "glProgramBufferParametersIuivNV" } },
    { GLextension::GL_NV_path_rendering, { "glCopyPathNV", "glCoverFillPathInstancedNV", "glCoverFillPathNV", "glCoverStrokePathInstancedNV", "glCoverStrokePathNV", "glDeletePathsNV", "glGenPathsNV", "glGetPathColorGenfvNV", "glGetPathColorGenivNV", "glGetPathCommandsNV", "glGetPathCoordsNV", "glGetPathDashArrayNV", "glGetPathLengthNV", "glGetPathMetricRangeNV", "glGetPathMetricsNV", "glGetPathParameterfvNV", "glGetPathParameterivNV", "glGetPathSpacingNV", "glGetPathTexGenfvNV", "glGetPathTexGenivNV", "glGetProgramResourcefvNV", "glInterpolatePathsNV", "glIsPathNV", "glIsPointInFillPathNV", "glIsPointInStrokePathNV", "glMatrixFrustumEXT", "glMatrixLoad3x2fNV", "glMatrixLoad3x3fNV", "glMatrixLoaddEXT", "glMatrixLoadfEXT", "glMatrixLoadIdentityEXT", "glMatrixLoadTranspose3x3fNV", "glMatrixLoadTransposedEXT", "glMatrixLoadTransposefEXT", "glMatrixMult3x2fNV", "glMatrixMult3x3fNV", "glMatrixMultdEXT", "glMatrixMultfEXT", "glMatrixMultTranspose3x3fNV", "glMatrixMultTransposedEXT", "glMatrixMultTransposefEXT", "glMatrixOrthoEXT", "glMatrixPopEXT", "glMatrixPushEXT", "glMatrixRotatedEXT", "glMatrixRotatefEXT", "glMatrixScaledEXT", "glMatrixScalefEXT", "glMatrixTranslatedEXT", "glMatrixTranslatefEXT", "glPathColorGenNV", "glPathCommandsNV", "glPathCoordsNV", "glPathCoverDepthFuncNV", "glPathDashArrayNV", "glPathFogGenNV", "glPathGlyphIndexArrayNV", "glPathGlyphIndexRangeNV", "glPathGlyphRangeNV", "glPathGlyphsNV", "glPathMemoryGlyphIndexArrayNV", "glPathParameterfNV", "glPathParameterfvNV", "glPathParameteriNV", "glPathParameterivNV", "glPathStencilDepthOffsetNV", "glPathStencilFuncNV", "glPathStringNV", "glPathSubCommandsNV", "glPathSubCoordsNV", "glPathTexGenNV", "glPointAlongPathNV", "glProgramPathFragmentInputGenNV", "glStencilFillPathInstancedNV", "glStencilFillPathNV", "glStencilStrokePathInstancedNV", "glStencilStrokePathNV", "glStencilThenCoverFillPathInstancedNV", "glStencilThenCoverFillPathNV", "glStencilThenCoverStrokePathInstancedNV", "glStencilThenCoverStrokePathNV", "glTransformPathNV", "glWeightPathsNV" } },
    { GLextension::GL_NV_pixel_data_range, { "glFlushPixelDataRangeNV", "glPixelDataRangeNV" } },
    { GLextension::GL_NV_point_sprite, { "glPointParameteriNV", "glPointParameterivNV" } },
    { GLextension::GL_NV_present_video, { "glGetVideoi64vNV", "glGetVideoivNV", "glGetVideoui64vNV", "glGetVideouivNV", "glPresentFrameDualFillNV", "glPresentFrameKeyedNV" } },
    { GLextension::GL_NV_primitive_restart, { "glPrimitiveRestartIndexNV", "glPrimitiveRestartNV" } },
    { GLextension::GL_NV_query_resource, { "glQueryResourceNV" } },
    { GLextension::GL_NV_query_resource_tag, { "glDeleteQueryResourceTagNV", "glGenQueryResourceTagNV", "glQueryResourceTagNV" } },
    { GLextension::GL_NV_register_combiners, { "glCombinerInputNV", "glCombinerOutputNV", "glCombinerParameterfNV", "glCombinerParameterfvNV", "glCombinerParameteriNV", "glCombinerParameterivNV", "glFinalCombinerInputNV", "glGetCombinerInputParameterfvNV", "glGetCombinerInputParameterivNV", "glGetCombinerOutputParameterfvNV", "glGetCombinerOutputParameterivNV", "glGetFinalCombinerInputParameterfvNV", "glGetFinalCombinerInputParameterivNV" } },
    { GLextension::GL_NV_register_combiners2, { "glCombinerStageParameterfvNV", "glGetCombinerStageParameterfvNV" } },
    { GLextension::GL_NV_sample_locations, { "glFramebufferSampleLocationsfvNV", "glNamedFramebufferSampleLocationsfvNV", "glResolveDepthValuesNV" } },
    { GLextension::GL_NV_scissor_exclusive, { "glScissorExclusiveArrayvNV", "glScissorExclusiveNV" } },
    { GLextension::GL_NV_shader_buffer_load, { "glGetBufferParameterui64vNV", "glGetIntegerui64vNV", "glGetNamedBufferParameterui64vNV", "glGetUniformui64vNV", "glIsBufferResidentNV", "glIsNamedBufferResidentNV", "glMakeBufferNonResidentNV", "glMakeBufferResidentNV", "glMakeNamedBufferNonResidentNV", "glMakeNamedBufferResidentNV", "glProgramUniformui64NV", "glProgramUniformui64vNV", "glUniformui64NV", "glUniformui64vNV" } },
    { GLextension::GL_NV_shading_rate_image, { "glBindShadingRateImageNV", "glGetShadingRateImagePaletteNV", "glGetShadingRateSampleLocationivNV", "glShadingRateImageBarrierNV", "glShadingRateImagePaletteNV", "glShadingRateSampleOrderCustomNV", "glShadingRateSampleOrderNV" } },
    { GLextension::GL_NV_texture_barrier, { "glTextureBarrierNV" } },
    { GLextension::GL_NV_texture_multisample, { "glTexImage2DMultisampleCoverageNV", "glTexImage3DMultisampleCoverageNV", "glTextureImage2DMultisampleCoverageNV", "glTextureImage2DMultisampleNV", "glTextureImage3DMultisampleCoverageNV", "glTextureImage3DMultisampleNV" } },
    { GLextension::GL_NV_timeline_semaphore, { "glCreateSemaphoresNV", "glGetSemaphoreParameterivNV", "glSemaphoreParameterivNV" } },
    { GLextension::GL_NV_transform_feedback, { "glActiveVaryingNV", "glBeginTransformFeedbackNV", "glBindBufferBaseNV", "glBindBufferOffsetNV", "glBindBufferRangeNV", "glEndTransformFeedbackNV", "glGetActiveVaryingNV", "glGetTransformFeedbackVaryingNV", "glGetVaryingLocationNV", "glTransformFeedbackAttribsNV", "glTransformFeedbackStreamAttribsNV", "glTransformFeedbackVaryingsNV" } },
    { GLextension::GL_NV_transform_feedback2, { "glBindTransformFeedbackNV", "glDeleteTransformFeedbacksNV", "glDrawTransformFeedbackNV", "glGenTransformFeedbacksNV", "glIsTransformFeedbackNV", "glPauseTransformFeedbackNV", "glResumeTransformFeedbackNV" } },
    { GLextension::GL_NV_vdpau_interop, { "glVDPAUFiniNV", "glVDPAUGetSurfaceivNV", "glVDPAUInitNV", "glVDPAUIsSurfaceNV", "glVDPAUMapSurfacesNV", "glVDPAURegisterOutputSurfaceNV", "glVDPAURegisterVideoSurfaceNV", "glVDPAUSurfaceAccessNV", "glVDPAUUnmapSurfacesNV", "glVDPAUUnregisterSurfaceNV" } },
    { GLextension::GL_NV_vdpau_interop2, { "glVDPAURegisterVideoSurfaceWithPictureStructureNV" } },
    { GLextension::GL_NV_vertex_array_range, { "glFlushVertexArrayRangeNV", "glVertexArrayRangeNV" } },
    { GLextension::GL_NV_vertex_attrib_integer_64bit, { "glGetVertexAttribLi64vNV", "glGetVertexAttribLui64vNV", "glVertexAttribL1i64NV", "glVertexAttribL1i64vNV", "glVertexAttribL1ui64NV", "glVertexAttribL1ui64vNV", "glVertexAttribL2i64NV", "glVertexAttribL2i64vNV", "glVertexAttribL2ui64NV", "glVertexAttribL2ui64vNV", "glVertexAttribL3i64NV", "glVertexAttribL3i64vNV", "glVertexAttribL3ui64NV", "glVertexAttribL3ui64vNV", "glVertexAttribL4i64NV", "glVertexAttribL4i64vNV", "glVertexAttribL4ui64NV", "glVertexAttribL4ui64vNV", "glVertexAttribLFormatNV" } },
    { GLextension::GL_NV_vertex_buffer_unified_memory, { "glBufferAddressRangeNV", "glColorFormatNV", "glEdgeFlagFormatNV", "glFogCoordFormatNV", "glGetIntegerui64i_vNV", "glIndexFormatNV", "glNormalFormatNV", "glSecondaryColorFormatNV", "glTexCoordFormatNV", "glVertexAttribFormatNV", "glVertexAttribIFormatNV", "glVertexFormatNV" } },
    { GLextension::GL_NV_vertex_program, { "glAreProgramsResidentNV", "glBindProgramNV", "glDeleteProgramsNV", "glExecuteProgramNV", "glGenProgramsNV", "glGetProgramivNV", "glGetProgramParameterdvNV", "glGetProgramParameterfvNV", "glGetProgramStringNV", "glGetTrackMatrixivNV", "glGetVertexAttribdvNV", "glGetVertexAttribfvNV", "glGetVertexAttribivNV", "glGetVertexAttribPointervNV", "glIsProgramNV", "glLoadProgramNV", "glProgramParameter4dNV", "glProgramParameter4dvNV", "glProgramParameter4fNV", "glProgramParameter4fvNV", "glProgramParameters4dvNV", "glProgramParameters4fvNV", "glRequestResidentProgramsNV", "glTrackMatrixNV", "glVertexAttrib1dNV", "glVertexAttrib1dvNV", "glVertexAttrib1fNV", "glVertexAttrib1fvNV", "glVertexAttrib1sNV", "glVertexAttrib1svNV", "glVertexAttrib2dNV", "glVertexAttrib2dvNV", "glVertexAttrib2fNV", "glVertexAttrib2fvNV", "glVertexAttrib2sNV", "glVertexAttrib2svNV", "glVertexAttrib3dNV", "glVertexAttrib3dvNV", "glVertexAttrib3fNV", "glVertexAttrib3fvNV", "glVertexAttrib3sNV", "glVertexAttrib3svNV", "glVertexAttrib4dNV", "glVertexAttrib4dvNV", "glVertexAttrib4fNV", "glVertexAttrib4fvNV", "glVertexAttrib4sNV", "glVertexAttrib4svNV", "glVertexAttrib4ubNV", "glVertexAttrib4ubvNV", "glVertexAttribPointerNV", "glVertexAttribs1dvNV", "glVertexAttribs1fvNV", "glVertexAttribs1svNV", "glVertexAttribs2dvNV", "glVertexAttribs2fvNV", "glVertexAttribs2svNV", "glVertexAttribs3dvNV", "glVertexAttribs3fvNV", "glVertexAttribs3svNV", "glVertexAttribs4dvNV", "glVertexAttribs4fvNV", "glVertexAttribs4svNV", "glVertexAttribs4ubvNV" } },
    { GLextension::GL_NV_vertex_program4, { "glGetVertexAttribIivEXT", "glGetVertexAttribIuivEXT", "glVertexAttribI1iEXT", "glVertexAttribI1ivEXT", "glVertexAttribI1uiEXT", "glVertexAttribI1uivEXT", "glVertexAttribI2iEXT", "glVertexAttribI2ivEXT", "glVertexAttribI2uiEXT", "glVertexAttribI2uivEXT", "glVertexAttribI3iEXT", "glVertexAttribI3ivEXT", "glVertexAttribI3uiEXT", "glVertexAttribI3uivEXT", "glVertexAttribI4bvEXT", "glVertexAttribI4iEXT", "glVertexAttribI4ivEXT", "glVertexAttribI4svEXT", "glVertexAttribI4ubvEXT", "glVertexAttribI4uiEXT", "glVertexAttribI4uivEXT", "glVertexAttribI4usvEXT", "glVertexAttribIPointerEXT" } },
    { GLextension::GL_NV_video_capture, { "glBeginVideoCaptureNV", "glBindVideoCaptureStreamBufferNV", "glBindVideoCaptureStreamTextureNV", "glEndVideoCaptureNV", "glGetVideoCaptureivNV", "glGetVideoCaptureStreamdvNV", "glGetVideoCaptureStreamfvNV", "glGetVideoCaptureStreamivNV", "glVideoCaptureNV", "glVideoCaptureStreamParameterdvNV", "glVideoCaptureStreamParameterfvNV", "glVideoCaptureStreamParameterivNV" } },
    { GLextension::GL_NV_viewport_swizzle, { "glViewportSwizzleNV" } },
    { GLextension::GL_NVX_conditional_render, { "glBeginConditionalRenderNVX", "glEndConditionalRenderNVX" } },
    { GLextension::GL_NVX_gpu_multicast2, { "glAsyncCopyBufferSubDataNVX", "glAsyncCopyImageSubDataNVX", "glMulticastScissorArrayvNVX", "glMulticastViewportArrayvNVX", "glMulticastViewportPositionWScaleNVX", "glUploadGpuMaskNVX" } },
    { GLextension::GL_NVX_linked_gpu_multicast, { "glLGPUCopyImageSubDataNVX", "glLGPUInterlockNVX", "glLGPUNamedBufferSubDataNVX" } },
    { GLextension::GL_NVX_progress_fence, { "glClientWaitSemaphoreui64NVX", "glCreateProgressFenceNVX", "glSignalSemaphoreui64NVX", "glWaitSemaphoreui64NVX" } },
    { GLextension::GL_OES_byte_coordinates, { "glMultiTexCoord1bOES", "glMultiTexCoord1bvOES", "glMultiTexCoord2bOES", "glMultiTexCoord2bvOES", "glMultiTexCoord3bOES", "glMultiTexCoord3bvOES", "glMultiTexCoord4bOES", "glMultiTexCoord4bvOES", "glTexCoord1bOES", "glTexCoord1bvOES", "glTexCoord2bOES", "glTexCoord2bvOES", "glTexCoord3bOES", "glTexCoord3bvOES", "glTexCoord4bOES", "glTexCoord4bvOES", "glVertex2bOES", "glVertex2bvOES", "glVertex3bOES", "glVertex3bvOES", "glVertex4bOES", "glVertex4bvOES" } },
    { GLextension::GL_OES_fixed_point, { "glAccumxOES", "glAlphaFuncxOES", "glBitmapxOES", "glBlendColorxOES", "glClearAccumxOES", "glClearColorxOES", "glClearDepthxOES", "glClipPlanexOES", "glColor3xOES", "glColor3xvOES", "glColor4xOES", "glColor4xvOES", "glConvolutionParameterxOES", "glConvolutionParameterxvOES", "glDepthRangexOES", "glEvalCoord1xOES", "glEvalCoord1xvOES", "glEvalCoord2xOES", "glEvalCoord2xvOES", "glFeedbackBufferxOES", "glFogxOES", "glFogxvOES", "glFrustumxOES", "glGetClipPlanexOES", "glGetConvolutionParameterxvOES", "glGetFixedvOES", "glGetHistogramParameterxvOES", "glGetLightxOES", "glGetLightxvOES", "glGetMapxvOES", "glGetMaterialxOES", "glGetMaterialxvOES", "glGetPixelMapxv", "glGetTexEnvxvOES", "glGetTexGenxvOES", "glGetTexLevelParameterxvOES", "glGetTexParameterxvOES", "glIndexxOES", "glIndexxvOES", "glLightModelxOES", "glLightModelxvOES", "glLightxOES", "glLightxvOES", "glLineWidthxOES", "glLoadMatrixxOES", "glLoadTransposeMatrixxOES", "glMap1xOES", "glMap2xOES", "glMapGrid1xOES", "glMapGrid2xOES", "glMaterialxOES", "glMaterialxvOES", "glMultiTexCoord1xOES", "glMultiTexCoord1xvOES", "glMultiTexCoord2xOES", "glMultiTexCoord2xvOES", "glMultiTexCoord3xOES", "glMultiTexCoord3xvOES", "glMultiTexCoord4xOES", "glMultiTexCoord4xvOES", "glMultMatrixxOES", "glMultTransposeMatrixxOES", "glNormal3xOES", "glNormal3xvOES", "glOrthoxOES", "glPassThroughxOES", "glPixelMapx", "glPixelStorex", "glPixelTransferxOES", "glPixelZoomxOES", "glPointParameterxOES", "glPointParameterxvOES", "glPointSizexOES", "glPolygonOffsetxOES", "glPrioritizeTexturesxOES", "glRasterPos2xOES", "glRasterPos2xvOES", "glRasterPos3xOES", "glRasterPos3xvOES", "glRasterPos4xOES", "glRasterPos4xvOES", "glRectxOES", "glRectxvOES", "glRotatexOES", "glSampleCoveragexOES", "glScalexOES", "glTexCoord1xOES", "glTexCoord1xvOES", "glTexCoord2xOES", "glTexCoord2xvOES", "glTexCoord3xOES", "glTexCoord3xvOES", "glTexCoord4xOES", "glTexCoord4xvOES", "glTexEnvxOES", "glTexEnvxvOES", "glTexGenxOES", "glTexGenxvOES", "glTexParameterxOES", "glTexParameterxvOES", "glTranslatexOES", "glVertex2xOES", "glVertex2xvOES", "glVertex3xOES", "glVertex3xvOES", "glVertex4xOES", "glVertex4xvOES" } },
    { GLextension::GL_OES_query_matrix, { "glQueryMatrixxOES" } },
    { GLextension::GL_OES_single_precision, { "glClearDepthfOES", "glClipPlanefOES", "glDepthRangefOES", "glFrustumfOES", "glGetClipPlanefOES", "glOrthofOES" } },
    { GLextension::GL_OVR_multiview, { "glFramebufferTextureMultiviewOVR", "glNamedFramebufferTextureMultiviewOVR" } },
    { GLextension::GL_PGI_misc_hints, { "glHintPGI" } },
    { GLextension::GL_SGI_color_table, { "glColorTableParameterfvSGI", "glColorTableParameterivSGI", "glColorTableSGI", "glCopyColorTableSGI", "glGetColorTableParameterfvSGI", "glGetColorTableParameterivSGI", "glGetColorTableSGI" } },
    { GLextension::GL_SGIS_detail_texture, { "glDetailTexFuncSGIS", "glGetDetailTexFuncSGIS" } },
    { GLextension::GL_SGIS_fog_function, { "glFogFuncSGIS", "glGetFogFuncSGIS" } },
    { GLextension::GL_SGIS_multisample, { "glSampleMaskSGIS", "glSamplePatternSGIS" } },
    { GLextension::GL_SGIS_pixel_texture, { "glGetPixelTexGenParameterfvSGIS", "glGetPixelTexGenParameterivSGIS", "glPixelTexGenParameterfSGIS", "glPixelTexGenParameterfvSGIS", "glPixelTexGenParameteriSGIS", "glPixelTexGenParameterivSGIS" } },
    { GLextension::GL_SGIS_point_parameters, { "glPointParameterfSGIS", "glPointParameterfvSGIS" } },
    { GLextension::GL_SGIS_sharpen_texture, { "glGetSharpenTexFuncSGIS", "glSharpenTexFuncSGIS" } },
    { GLextension::GL_SGIS_texture4D, { "glTexImage4DSGIS", "glTexSubImage4DSGIS" } },
    { GLextension::GL_SGIS_texture_color_mask, { "glTextureColorMaskSGIS" } },
    { GLextension::GL_SGIS_texture_filter4, { "glGetTexFilterFuncSGIS", "glTexFilterFuncSGIS" } },
    { GLextension::GL_SGIX_async, { "glAsyncMarkerSGIX", "glDeleteAsyncMarkersSGIX", "glFinishAsyncSGIX", "glGenAsyncMarkersSGIX", "glIsAsyncMarkerSGIX", "glPollAsyncSGIX" } },
    { GLextension::GL_SGIX_flush_raster, { "glFlushRasterSGIX" } },
    { GLextension::GL_SGIX_fragment_lighting, { "glFragmentColorMaterialSGIX", "glFragmentLightfSGIX", "glFragmentLightfvSGIX", "glFragmentLightiSGIX", "glFragmentLightivSGIX", "glFragmentLightModelfSGIX", "glFragmentLightModelfvSGIX", "glFragmentLightModeliSGIX", "glFragmentLightModelivSGIX", "glFragmentMaterialfSGIX", "glFragmentMaterialfvSGIX", "glFragmentMaterialiSGIX", "glFragmentMaterialivSGIX", "glGetFragmentLightfvSGIX", "glGetFragmentLightivSGIX", "glGetFragmentMaterialfvSGIX", "glGetFragmentMaterialivSGIX", "glLightEnviSGIX" } },
    { GLextension::GL_SGIX_framezoom, { "glFrameZoomSGIX" } },
    { GLextension::GL_SGIX_igloo_interface, { "glIglooInterfaceSGIX" } },
    { GLextension::GL_SGIX_instruments, { "glGetInstrumentsSGIX", "glInstrumentsBufferSGIX", "glPollInstrumentsSGIX", "glReadInstrumentsSGIX", "glStartInstrumentsSGIX", "glStopInstrumentsSGIX" } },
    { GLextension::GL_SGIX_list_priority, { "glGetListParameterfvSGIX", "glGetListParameterivSGIX", "glListParameterfSGIX", "glListParameterfvSGIX", "glListParameteriSGIX", "glListParameterivSGIX" } },
    { GLextension::GL_SGIX_pixel_texture, { "glPixelTexGenSGIX" } },
    { GLextension::GL_SGIX_polynomial_ffd, { "glDeformationMap3dSGIX", "glDeformationMap3fSGIX", "glDeformSGIX", "glLoadIdentityDeformationMapSGIX" } },
    { GLextension::GL_SGIX_reference_plane, { "glReferencePlaneSGIX" } },
    { GLextension::GL_SGIX_sprite, { "glSpriteParameterfSGIX", "glSpriteParameterfvSGIX", "glSpriteParameteriSGIX", "glSpriteParameterivSGIX" } },
    { GLextension::GL_SGIX_tag_sample_buffer, { "glTagSampleBufferSGIX" } },
    { GLextension::GL_SUN_global_alpha, { "glGlobalAlphaFactorbSUN", "glGlobalAlphaFactordSUN", "glGlobalAlphaFactorfSUN", "glGlobalAlphaFactoriSUN", "glGlobalAlphaFactorsSUN", "glGlobalAlphaFactorubSUN", "glGlobalAlphaFactoruiSUN", "glGlobalAlphaFactorusSUN" } },
    { GLextension::GL_SUN_mesh_array, { "glDrawMeshArraysSUN" } },
    { GLextension::GL_SUN_triangle_list, { "glReplacementCodePointerSUN", "glReplacementCodeubSUN", "glReplacementCodeubvSUN", "glReplacementCodeuiSUN", "glReplacementCodeuivSUN", "glReplacementCodeusSUN", "glReplacementCodeusvSUN" } },
    { GLextension::GL_SUN_vertex, { "glColor3fVertex3fSUN", "glColor3fVertex3fvSUN", "glColor4fNormal3fVertex3fSUN", "glColor4fNormal3fVertex3fvSUN", "glColor4ubVertex2fSUN", "glColor4ubVertex2fvSUN", "glColor4ubVertex3fSUN", "glColor4ubVertex3fvSUN", "glNormal3fVertex3fSUN", "glNormal3fVertex3fvSUN", "glReplacementCodeuiColor3fVertex3fSUN", "glReplacementCodeuiColor3fVertex3fvSUN", "glReplacementCodeuiColor4fNormal3fVertex3fSUN", "glReplacementCodeuiColor4fNormal3fVertex3fvSUN", "glReplacementCodeuiColor4ubVertex3fSUN", "glReplacementCodeuiColor4ubVertex3fvSUN", "glReplacementCodeuiNormal3fVertex3fSUN", "glReplacementCodeuiNormal3fVertex3fvSUN", "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN", "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN", "glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN", "glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN", "glReplacementCodeuiTexCoord2fVertex3fSUN", "glReplacementCodeuiTexCoord2fVertex3fvSUN", "glReplacementCodeuiVertex3fSUN", "glReplacementCodeuiVertex3fvSUN", "glTexCoord2fColor3fVertex3fSUN", "glTexCoord2fColor3fVertex3fvSUN", "glTexCoord2fColor4fNormal3fVertex3fSUN", "glTexCoord2fColor4fNormal3fVertex3fvSUN", "glTexCoord2fColor4ubVertex3fSUN", "glTexCoord2fColor4ubVertex3fvSUN", "glTexCoord2fNormal3fVertex3fSUN", "glTexCoord2fNormal3fVertex3fvSUN", "glTexCoord2fVertex3fSUN", "glTexCoord2fVertex3fvSUN", "glTexCoord4fColor4fNormal3fVertex4fSUN", "glTexCoord4fColor4fNormal3fVertex4fvSUN", "glTexCoord4fVertex4fSUN", "glTexCoord4fVertex4fvSUN" } },
    { GLextension::GL_SUNX_constant_data, { "glFinishTextureSUNX" } },
};


} } // namespace glbinding::aux