# getDirectoryToWatchFailedLookupLocationNodeModulesInfileNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Posix root: /

## RootDirForResolution: /

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /folderAtRoot

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /folderAtRoot/folder1

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                             | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4                                                             | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                     | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users/username

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users/username/folderAtRoot

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                              | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2                                                              | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2                                                              | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2                                                              | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                                      | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3                                                      | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3                                                      | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                              | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                              | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                      | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user/username

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user/username/folderAtRoot

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                                       | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3                                                       | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3                                                       | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                               | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                               | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                       | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr/username

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr/username/folderAtRoot

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home/username

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home/username/folderAtRoot

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2                                                               | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                                       | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3                                                       | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3                                                       | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                               | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                               | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                       | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /workspaces

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /workspaces/folderAtRoot

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

## RootDirForResolution: /workspaces/folderAtRoot/folder1

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2                                                                  | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2                                                                  | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2                                                                  | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2                                                                  | true      |                                                                                                           |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3                                                          | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3                                                          | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3                                                          | true      |                                                                                                           |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                                  | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                                  | true      |                                                                                                           |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                          | true      |                                                                                                           |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                  | getDirectoryToWatchFailedLookupLocation                                                                   | Recursive | Location if not symlink                                                                                   |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | --------- | --------------------------------------------------------------------------------------------------------- |
| /node_modules/somefile.d.ts                                                                               |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/node_modules/somefile.d.ts                                                          |                                                                                                           |           |                                                                                                           |
| /folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                        | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                | true      |                                                                                                           |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                        | true      |                                                                                                           |
| /users/node_modules/somefile.d.ts                                                                         |                                                                                                           |           |                                                                                                           |
| /users/username/node_modules/somefile.d.ts                                                                |                                                                                                           |           |                                                                                                           |
| /users/username/folderAtRoot/node_modules/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                         | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                 | true      |                                                                                                           |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                         | true      |                                                                                                           |
| /user/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /user/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /user/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /usr/node_modules/somefile.d.ts                                                                           |                                                                                                           |           |                                                                                                           |
| /usr/username/node_modules/somefile.d.ts                                                                  |                                                                                                           |           |                                                                                                           |
| /usr/username/folderAtRoot/node_modules/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                           | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                   | true      |                                                                                                           |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                           | true      |                                                                                                           |
| /home/node_modules/somefile.d.ts                                                                          |                                                                                                           |           |                                                                                                           |
| /home/username/node_modules/somefile.d.ts                                                                 |                                                                                                           |           |                                                                                                           |
| /home/username/folderAtRoot/node_modules/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                          | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                  | true      |                                                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                          | true      |                                                                                                           |
| /workspaces/node_modules/somefile.d.ts                                                                    |                                                                                                           |           |                                                                                                           |
| /workspaces/folderAtRoot/node_modules/somefile.d.ts                                                       | /workspaces/folderAtRoot/node_modules                                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/node_modules/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1/node_modules                                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                             | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                     | true      |                                                                                                           |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                             | true      |                                                                                                           |

