# getDirectoryToWatchFailedLookupLocationInfile

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Posix root: /

## RootDirForResolution: /

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1                                                         | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1                                                           | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1                                                          | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot                                                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot/folder1                                                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1                                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1                                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1                                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1                                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /somefile.d.ts                                                                               |                                                                                              |           |                                                                                              |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |                                                                                              |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |                                                                                              |
| /users/somefile.d.ts                                                                         |                                                                                              |           |                                                                                              |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |                                                                                              |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |                                                                                              |
| /user/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |                                                                                              |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |                                                                                              |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |                                                                                              |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |                                                                                              |
| /home/somefile.d.ts                                                                          |                                                                                              |           |                                                                                              |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |                                                                                              |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |                                                                                              |
| /workspaces/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /workspaces/folderAtRoot/somefile.d.ts                                                       | /workspaces/folderAtRoot                                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/somefile.d.ts                                               | /workspaces/folderAtRoot/folder1                                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | /workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                              |

