# getDirectoryToWatchFailedLookupLocationFromTypeRoot

When watched typeRoot handler is invoked, this method determines the directory for which the failedLookupLocation would need to be invalidated.
Since this is invoked only when watching default typeRoot and is used to handle flaky directory watchers, this is used as a fail safe where if failed lookup starts with returned directory we will invalidate that resolution.

## Testing for Dos root: c:/

## RootDirForResolution: c:/

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/folderAtRoot

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/folderAtRoot/folder1

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1                                                                    |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1                                                                    |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1                                                                    |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1                                                                    |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1                                                                    |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2                                                            |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2                                                            |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2                                                            |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2                                                            |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3                                                    |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3                                                    |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3                                                    |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4                                            |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4                                            |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                    |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users/username

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users/username/folderAtRoot

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1                                                     |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1                                                     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1                                                     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1                                                     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1                                                     |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2                                             |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2                                             |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2                                             |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2                                             |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3                                     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3                                     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3                                     |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                             |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                             |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                     |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user/username

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username                                                                           |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username                                                                           |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username                                                                           |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username                                                                           |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username                                                                           |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username                                                                           |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username                                                                           |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user/username/folderAtRoot

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot                                                              |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot                                                              |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot                                                              |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot                                                              |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot                                                              |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot                                                              |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1                                                      |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1                                                      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1                                                      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1                                                      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1                                                      |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2                                              |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2                                              |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2                                              |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2                                              |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3                                      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3                                      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3                                      |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                      |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr/username

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username                                                                            |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username                                                                            |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username                                                                            |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username                                                                            |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username                                                                            |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username                                                                            |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username                                                                            |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr/username/folderAtRoot

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot                                                               |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot                                                               |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot                                                               |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot                                                               |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot                                                               |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot                                                               |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1                                                       |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1                                                       |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1                                                       |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1                                                       |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1                                                       |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2                                               |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2                                               |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2                                               |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2                                               |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                               |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                               |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                       |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home/username

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username                                                                           |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username                                                                           |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username                                                                           |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username                                                                           |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username                                                                           |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username                                                                           |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username                                                                           |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home/username/folderAtRoot

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot                                                              |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot                                                              |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot                                                              |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot                                                              |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot                                                              |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot                                                              |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1                                                      |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1                                                      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1                                                      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1                                                      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1                                                      |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2                                              |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2                                              |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2                                              |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2                                              |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3                                      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3                                      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3                                      |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                      |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/workspaces

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: c:/workspaces/folderAtRoot

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot                                                                 |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot                                                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot                                                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot                                                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot                                                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot                                                                 |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1                                                         |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1                                                         |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1                                                         |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1                                                         |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1                                                         |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2                                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2                                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2                                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2                                                 |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                         |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                         |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                         |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                 |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                 |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                  | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                        |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ |
| c:/folderAtRoot/node_modules/@types                                                        | c:/folderAtRoot/node_modules                                                               |
| c:/folderAtRoot/folder1/node_modules/@types                                                | c:/folderAtRoot/folder1/node_modules                                                       |
| c:/folderAtRoot/folder1/folder2/node_modules/@types                                        | c:/folderAtRoot/folder1/folder2/node_modules                                               |
| c:/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | c:/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | c:/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| c:/users/username/folderAtRoot/node_modules/@types                                         | c:/users/username/folderAtRoot/node_modules                                                |
| c:/users/username/folderAtRoot/folder1/node_modules/@types                                 | c:/users/username/folderAtRoot/folder1/node_modules                                        |
| c:/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | c:/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | c:/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| c:/user/node_modules/@types                                                                | c:/user/node_modules                                                                       |
| c:/user/username/node_modules/@types                                                       | c:/user/username/node_modules                                                              |
| c:/user/username/folderAtRoot/node_modules/@types                                          | c:/user/username/folderAtRoot/node_modules                                                 |
| c:/user/username/folderAtRoot/folder1/node_modules/@types                                  | c:/user/username/folderAtRoot/folder1/node_modules                                         |
| c:/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/usr/node_modules/@types                                                                 | c:/usr/node_modules                                                                        |
| c:/usr/username/node_modules/@types                                                        | c:/usr/username/node_modules                                                               |
| c:/usr/username/folderAtRoot/node_modules/@types                                           | c:/usr/username/folderAtRoot/node_modules                                                  |
| c:/usr/username/folderAtRoot/folder1/node_modules/@types                                   | c:/usr/username/folderAtRoot/folder1/node_modules                                          |
| c:/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | c:/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| c:/home/node_modules/@types                                                                | c:/home/node_modules                                                                       |
| c:/home/username/node_modules/@types                                                       | c:/home/username/node_modules                                                              |
| c:/home/username/folderAtRoot/node_modules/@types                                          | c:/home/username/folderAtRoot/node_modules                                                 |
| c:/home/username/folderAtRoot/folder1/node_modules/@types                                  | c:/home/username/folderAtRoot/folder1/node_modules                                         |
| c:/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | c:/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | c:/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| c:/workspaces/node_modules/@types                                                          | c:/workspaces/node_modules                                                                 |
| c:/workspaces/folderAtRoot/node_modules/@types                                             | c:/workspaces/folderAtRoot/node_modules                                                    |
| c:/workspaces/folderAtRoot/folder1/node_modules/@types                                     | c:/workspaces/folderAtRoot/folder1/node_modules                                            |
| c:/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | c:/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         |

