# getDirectoryToWatchFailedLookupLocationAtTypesIndir

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Posix root: /

## RootDirForResolution: /

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2                                                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2                                                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2                                                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2                                                                     |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3                                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3                                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3                                                             |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2                                                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2                                                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2                                                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2                                                                      |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3                                                              |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2                                                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2                                                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2                                                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2                                                                       |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2                                                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2                                                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2                                                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2                                                                      |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3                                                              |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /workspaces

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /workspaces/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: /workspaces/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2                                                                         |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2                                                                         |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2                                                                         |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2                                                                         |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3                                                                 |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3                                                                 |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3                                                                 |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                                         |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                                         |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                 |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive | Location if not symlink                                                                                          |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------------------------- |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |                                                                                                                  |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | /folderAtRoot/folder1/folder2/node_modules                                                                       |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |                                                                                                                  |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |                                                                                                                  |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | /users/username/folderAtRoot/node_modules                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | /users/username/folderAtRoot/folder1/node_modules                                                                |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /user/username/folderAtRoot/node_modules                                                                         |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /user/username/folderAtRoot/folder1/node_modules                                                                 |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |                                                                                                                  |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |                                                                                                                  |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | /usr/username/folderAtRoot/node_modules                                                                          |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | /usr/username/folderAtRoot/folder1/node_modules                                                                  |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |                                                                                                                  |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |                                                                                                                  |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | /home/username/folderAtRoot/node_modules                                                                         |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | /home/username/folderAtRoot/folder1/node_modules                                                                 |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| /workspaces/node_modules/@types/dir/somefile.d.ts                                                                |                                                                                                                  |           |                                                                                                                  |
| /workspaces/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                   | /workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | /workspaces/folderAtRoot/node_modules                                                                            |
| /workspaces/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                           | /workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | /workspaces/folderAtRoot/folder1/node_modules                                                                    |
| /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                   | /workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | /workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                           | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                   | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts           | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

