; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -verify-machineinstrs -mtriple=riscv32 -mattr=+m,+v,+f,+d,+zvfh,+zvfbfmin < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=riscv64 -mattr=+m,+v,+f,+d,+zvfh,+zvfbfmin < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=riscv32 -mattr=+m,+v,+f,+d,+zvfhmin,+zvfbfmin < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=riscv64 -mattr=+m,+v,+f,+d,+zvfhmin,+zvfbfmin < %s | FileCheck %s

define <1 x bfloat> @vector_compress_v1bf16(<1 x bfloat> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <1 x bfloat> @llvm.experimental.vector.compress.v1bf16(<1 x bfloat> %v, <1 x i1> %mask, <1 x bfloat> undef)
  ret <1 x bfloat> %ret
}

define <1 x bfloat> @vector_compress_v1bf16_passthru(<1 x bfloat> %passthru, <1 x bfloat> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <1 x bfloat> @llvm.experimental.vector.compress.v1bf16(<1 x bfloat> %v, <1 x i1> %mask, <1 x bfloat> %passthru)
  ret <1 x bfloat> %ret
}

define <2 x bfloat> @vector_compress_v2bf16(<2 x bfloat> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <2 x bfloat> @llvm.experimental.vector.compress.v2bf16(<2 x bfloat> %v, <2 x i1> %mask, <2 x bfloat> undef)
  ret <2 x bfloat> %ret
}

define <2 x bfloat> @vector_compress_v2bf16_passthru(<2 x bfloat> %passthru, <2 x bfloat> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <2 x bfloat> @llvm.experimental.vector.compress.v2bf16(<2 x bfloat> %v, <2 x i1> %mask, <2 x bfloat> %passthru)
  ret <2 x bfloat> %ret
}

define <4 x bfloat> @vector_compress_v4bf16(<4 x bfloat> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <4 x bfloat> @llvm.experimental.vector.compress.v4bf16(<4 x bfloat> %v, <4 x i1> %mask, <4 x bfloat> undef)
  ret <4 x bfloat> %ret
}

define <4 x bfloat> @vector_compress_v4bf16_passthru(<4 x bfloat> %passthru, <4 x bfloat> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <4 x bfloat> @llvm.experimental.vector.compress.v4bf16(<4 x bfloat> %v, <4 x i1> %mask, <4 x bfloat> %passthru)
  ret <4 x bfloat> %ret
}

define <8 x bfloat> @vector_compress_v8bf16(<8 x bfloat> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <8 x bfloat> @llvm.experimental.vector.compress.v8bf16(<8 x bfloat> %v, <8 x i1> %mask, <8 x bfloat> undef)
  ret <8 x bfloat> %ret
}

define <8 x bfloat> @vector_compress_v8bf16_passthru(<8 x bfloat> %passthru, <8 x bfloat> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <8 x bfloat> @llvm.experimental.vector.compress.v8bf16(<8 x bfloat> %v, <8 x i1> %mask, <8 x bfloat> %passthru)
  ret <8 x bfloat> %ret
}

define <1 x half> @vector_compress_v1f16(<1 x half> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <1 x half> @llvm.experimental.vector.compress.v1f16(<1 x half> %v, <1 x i1> %mask, <1 x half> undef)
  ret <1 x half> %ret
}

define <1 x half> @vector_compress_v1f16_passthru(<1 x half> %passthru, <1 x half> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <1 x half> @llvm.experimental.vector.compress.v1f16(<1 x half> %v, <1 x i1> %mask, <1 x half> %passthru)
  ret <1 x half> %ret
}

define <2 x half> @vector_compress_v2f16(<2 x half> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <2 x half> @llvm.experimental.vector.compress.v2f16(<2 x half> %v, <2 x i1> %mask, <2 x half> undef)
  ret <2 x half> %ret
}

define <2 x half> @vector_compress_v2f16_passthru(<2 x half> %passthru, <2 x half> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <2 x half> @llvm.experimental.vector.compress.v2f16(<2 x half> %v, <2 x i1> %mask, <2 x half> %passthru)
  ret <2 x half> %ret
}

define <4 x half> @vector_compress_v4f16(<4 x half> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <4 x half> @llvm.experimental.vector.compress.v4f16(<4 x half> %v, <4 x i1> %mask, <4 x half> undef)
  ret <4 x half> %ret
}

define <4 x half> @vector_compress_v4f16_passthru(<4 x half> %passthru, <4 x half> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <4 x half> @llvm.experimental.vector.compress.v4f16(<4 x half> %v, <4 x i1> %mask, <4 x half> %passthru)
  ret <4 x half> %ret
}

define <8 x half> @vector_compress_v8f16(<8 x half> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <8 x half> @llvm.experimental.vector.compress.v8f16(<8 x half> %v, <8 x i1> %mask, <8 x half> undef)
  ret <8 x half> %ret
}

define <8 x half> @vector_compress_v8f16_passthru(<8 x half> %passthru, <8 x half> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <8 x half> @llvm.experimental.vector.compress.v8f16(<8 x half> %v, <8 x i1> %mask, <8 x half> %passthru)
  ret <8 x half> %ret
}

define <1 x float> @vector_compress_v1f32(<1 x float> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <1 x float> @llvm.experimental.vector.compress.v1f32(<1 x float> %v, <1 x i1> %mask, <1 x float> undef)
  ret <1 x float> %ret
}

define <1 x float> @vector_compress_v1f32_passthru(<1 x float> %passthru, <1 x float> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <1 x float> @llvm.experimental.vector.compress.v1f32(<1 x float> %v, <1 x i1> %mask, <1 x float> %passthru)
  ret <1 x float> %ret
}

define <2 x float> @vector_compress_v2f32(<2 x float> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <2 x float> @llvm.experimental.vector.compress.v2f32(<2 x float> %v, <2 x i1> %mask, <2 x float> undef)
  ret <2 x float> %ret
}

define <2 x float> @vector_compress_v2f32_passthru(<2 x float> %passthru, <2 x float> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <2 x float> @llvm.experimental.vector.compress.v2f32(<2 x float> %v, <2 x i1> %mask, <2 x float> %passthru)
  ret <2 x float> %ret
}

define <4 x float> @vector_compress_v4f32(<4 x float> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <4 x float> @llvm.experimental.vector.compress.v4f32(<4 x float> %v, <4 x i1> %mask, <4 x float> undef)
  ret <4 x float> %ret
}

define <4 x float> @vector_compress_v4f32_passthru(<4 x float> %passthru, <4 x float> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <4 x float> @llvm.experimental.vector.compress.v4f32(<4 x float> %v, <4 x i1> %mask, <4 x float> %passthru)
  ret <4 x float> %ret
}

define <8 x float> @vector_compress_v8f32(<8 x float> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <8 x float> @llvm.experimental.vector.compress.v8f32(<8 x float> %v, <8 x i1> %mask, <8 x float> undef)
  ret <8 x float> %ret
}

define <8 x float> @vector_compress_v8f32_passthru(<8 x float> %passthru, <8 x float> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <8 x float> @llvm.experimental.vector.compress.v8f32(<8 x float> %v, <8 x i1> %mask, <8 x float> %passthru)
  ret <8 x float> %ret
}

define <1 x double> @vector_compress_v1f64(<1 x double> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <1 x double> @llvm.experimental.vector.compress.v1f64(<1 x double> %v, <1 x i1> %mask, <1 x double> undef)
  ret <1 x double> %ret
}

define <1 x double> @vector_compress_v1f64_passthru(<1 x double> %passthru, <1 x double> %v, <1 x i1> %mask) {
; CHECK-LABEL: vector_compress_v1f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <1 x double> @llvm.experimental.vector.compress.v1f64(<1 x double> %v, <1 x i1> %mask, <1 x double> %passthru)
  ret <1 x double> %ret
}

define <2 x double> @vector_compress_v2f64(<2 x double> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <2 x double> @llvm.experimental.vector.compress.v2f64(<2 x double> %v, <2 x i1> %mask, <2 x double> undef)
  ret <2 x double> %ret
}

define <2 x double> @vector_compress_v2f64_passthru(<2 x double> %passthru, <2 x double> %v, <2 x i1> %mask) {
; CHECK-LABEL: vector_compress_v2f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <2 x double> @llvm.experimental.vector.compress.v2f64(<2 x double> %v, <2 x i1> %mask, <2 x double> %passthru)
  ret <2 x double> %ret
}

define <4 x double> @vector_compress_v4f64(<4 x double> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <4 x double> @llvm.experimental.vector.compress.v4f64(<4 x double> %v, <4 x i1> %mask, <4 x double> undef)
  ret <4 x double> %ret
}

define <4 x double> @vector_compress_v4f64_passthru(<4 x double> %passthru, <4 x double> %v, <4 x i1> %mask) {
; CHECK-LABEL: vector_compress_v4f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <4 x double> @llvm.experimental.vector.compress.v4f64(<4 x double> %v, <4 x i1> %mask, <4 x double> %passthru)
  ret <4 x double> %ret
}

define <8 x double> @vector_compress_v8f64(<8 x double> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <8 x double> @llvm.experimental.vector.compress.v8f64(<8 x double> %v, <8 x i1> %mask, <8 x double> undef)
  ret <8 x double> %ret
}

define <8 x double> @vector_compress_v8f64_passthru(<8 x double> %passthru, <8 x double> %v, <8 x i1> %mask) {
; CHECK-LABEL: vector_compress_v8f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <8 x double> @llvm.experimental.vector.compress.v8f64(<8 x double> %v, <8 x i1> %mask, <8 x double> %passthru)
  ret <8 x double> %ret
}
