; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals --global-value-regex "![0-9]+" --version 2
; Test -hwasan-with-ifunc flag.
;
; RUN: opt -passes=hwasan -S < %s | \
; RUN:     FileCheck %s
; RUN: opt -passes=hwasan -S -hwasan-with-ifunc=0 -hwasan-with-tls=1 -hwasan-record-stack-history=instr < %s | \
; RUN:     FileCheck %s --check-prefixes=NOIFUNC-TLS-HISTORY
; RUN: opt -passes=hwasan -S -hwasan-with-ifunc=0 -hwasan-with-tls=1 -hwasan-record-stack-history=none < %s | \
; RUN:     FileCheck %s --check-prefixes=NOIFUNC-TLS-NOHISTORY
; RUN: opt -passes=hwasan -S -hwasan-with-ifunc=0 -hwasan-with-tls=0 < %s | \
; RUN:     FileCheck %s --check-prefixes=NOIFUNC-NOTLS
; RUN: opt -passes=hwasan -S -hwasan-with-ifunc=1  -hwasan-with-tls=0 < %s | \
; RUN:     FileCheck %s --check-prefixes=IFUNC-NOTLS
; RUN: opt -passes=hwasan -S -mtriple=aarch64-fuchsia < %s | \
; RUN:     FileCheck %s --check-prefixes=FUCHSIA
; RUN: opt -passes=hwasan -S -mtriple=aarch64-fuchsia -hwasan-record-stack-history=libcall < %s | \
; RUN:     FileCheck %s --check-prefixes=FUCHSIA-LIBCALL

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64--linux-android22"


define i32 @test_load(ptr %a) sanitize_hwaddress {
; First instrumentation in the function must be to load the dynamic shadow
; address into a local variable.
; "store i64" is only used to update stack history (this input IR intentionally does not use any i64)
; W/o any allocas, the history is not updated, even if it is enabled explicitly with -hwasan-record-stack-history=1
; CHECK-LABEL: define i32 @test_load
; CHECK-SAME: (ptr [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr @__hwasan_shadow)
; CHECK-NEXT:    call void @llvm.hwasan.check.memaccess(ptr [[DOTHWASAN_SHADOW]], ptr [[A]], i32 2)
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    ret i32 [[X]]
;
; NOIFUNC-TLS-HISTORY-LABEL: define i32 @test_load
; NOIFUNC-TLS-HISTORY-SAME: (ptr [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; NOIFUNC-TLS-HISTORY-NEXT:  entry:
; NOIFUNC-TLS-HISTORY-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr @__hwasan_shadow)
; NOIFUNC-TLS-HISTORY-NEXT:    call void @llvm.hwasan.check.memaccess(ptr [[DOTHWASAN_SHADOW]], ptr [[A]], i32 2)
; NOIFUNC-TLS-HISTORY-NEXT:    [[X:%.*]] = load i32, ptr [[A]], align 4
; NOIFUNC-TLS-HISTORY-NEXT:    ret i32 [[X]]
;
; NOIFUNC-TLS-NOHISTORY-LABEL: define i32 @test_load
; NOIFUNC-TLS-NOHISTORY-SAME: (ptr [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; NOIFUNC-TLS-NOHISTORY-NEXT:  entry:
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr @__hwasan_shadow)
; NOIFUNC-TLS-NOHISTORY-NEXT:    call void @llvm.hwasan.check.memaccess(ptr [[DOTHWASAN_SHADOW]], ptr [[A]], i32 2)
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[X:%.*]] = load i32, ptr [[A]], align 4
; NOIFUNC-TLS-NOHISTORY-NEXT:    ret i32 [[X]]
;
; NOIFUNC-NOTLS-LABEL: define i32 @test_load
; NOIFUNC-NOTLS-SAME: (ptr [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; NOIFUNC-NOTLS-NEXT:  entry:
; NOIFUNC-NOTLS-NEXT:    [[TMP0:%.*]] = load ptr, ptr @__hwasan_shadow_memory_dynamic_address, align 8
; NOIFUNC-NOTLS-NEXT:    call void @llvm.hwasan.check.memaccess(ptr [[TMP0]], ptr [[A]], i32 2)
; NOIFUNC-NOTLS-NEXT:    [[X:%.*]] = load i32, ptr [[A]], align 4
; NOIFUNC-NOTLS-NEXT:    ret i32 [[X]]
;
; IFUNC-NOTLS-LABEL: define i32 @test_load
; IFUNC-NOTLS-SAME: (ptr [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; IFUNC-NOTLS-NEXT:  entry:
; IFUNC-NOTLS-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr @__hwasan_shadow)
; IFUNC-NOTLS-NEXT:    call void @llvm.hwasan.check.memaccess(ptr [[DOTHWASAN_SHADOW]], ptr [[A]], i32 2)
; IFUNC-NOTLS-NEXT:    [[X:%.*]] = load i32, ptr [[A]], align 4
; IFUNC-NOTLS-NEXT:    ret i32 [[X]]
;
; FUCHSIA-LABEL: define i32 @test_load
; FUCHSIA-SAME: (ptr [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; FUCHSIA-NEXT:  entry:
; FUCHSIA-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; FUCHSIA-NEXT:    call void @llvm.hwasan.check.memaccess.shortgranules.fixedshadow(ptr [[A]], i32 2, i64 0)
; FUCHSIA-NEXT:    [[X:%.*]] = load i32, ptr [[A]], align 4
; FUCHSIA-NEXT:    ret i32 [[X]]
;
; FUCHSIA-LIBCALL-LABEL: define i32 @test_load
; FUCHSIA-LIBCALL-SAME: (ptr [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; FUCHSIA-LIBCALL-NEXT:  entry:
; FUCHSIA-LIBCALL-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; FUCHSIA-LIBCALL-NEXT:    call void @llvm.hwasan.check.memaccess.shortgranules.fixedshadow(ptr [[A]], i32 2, i64 0)
; FUCHSIA-LIBCALL-NEXT:    [[X:%.*]] = load i32, ptr [[A]], align 4
; FUCHSIA-LIBCALL-NEXT:    ret i32 [[X]]
;
entry:
  %x = load i32, ptr %a, align 4
  ret i32 %x
}

declare void @use(ptr %p)

define void @test_alloca() sanitize_hwaddress {
; First instrumentation in the function must be to load the dynamic shadow
; address into a local variable.
; When watching stack history, all code paths attempt to get PC and SP and mix them together.
; CHECK-LABEL: define void @test_alloca
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @llvm.thread.pointer()
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr i8, ptr [[TMP0]], i32 48
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 8
; CHECK-NEXT:    [[TMP3:%.*]] = ashr i64 [[TMP2]], 3
; CHECK-NEXT:    [[TMP4:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; CHECK-NEXT:    [[TMP5:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; CHECK-NEXT:    [[TMP6:%.*]] = ptrtoint ptr [[TMP5]] to i64
; CHECK-NEXT:    [[TMP7:%.*]] = shl i64 [[TMP6]], 44
; CHECK-NEXT:    [[TMP8:%.*]] = or i64 [[TMP4]], [[TMP7]]
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    store i64 [[TMP8]], ptr [[TMP9]], align 8
; CHECK-NEXT:    [[TMP10:%.*]] = ashr i64 [[TMP2]], 56
; CHECK-NEXT:    [[TMP11:%.*]] = shl nuw nsw i64 [[TMP10]], 12
; CHECK-NEXT:    [[TMP12:%.*]] = xor i64 [[TMP11]], -1
; CHECK-NEXT:    [[TMP13:%.*]] = add i64 [[TMP2]], 8
; CHECK-NEXT:    [[TMP14:%.*]] = and i64 [[TMP13]], [[TMP12]]
; CHECK-NEXT:    store i64 [[TMP14]], ptr [[TMP1]], align 8
; CHECK-NEXT:    [[TMP15:%.*]] = or i64 [[TMP2]], 4294967295
; CHECK-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP15]], 1
; CHECK-NEXT:    [[TMP16:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; CHECK-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP6]], 56
; CHECK-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; CHECK-NEXT:    [[TMP17:%.*]] = xor i64 [[TMP3]], 0
; CHECK-NEXT:    [[TMP18:%.*]] = ptrtoint ptr [[X]] to i64
; CHECK-NEXT:    [[TMP19:%.*]] = and i64 [[TMP18]], 72057594037927935
; CHECK-NEXT:    [[TMP20:%.*]] = shl i64 [[TMP17]], 56
; CHECK-NEXT:    [[TMP21:%.*]] = or i64 [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP21]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = trunc i64 [[TMP17]] to i8
; CHECK-NEXT:    [[TMP23:%.*]] = ptrtoint ptr [[X]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = and i64 [[TMP23]], 72057594037927935
; CHECK-NEXT:    [[TMP25:%.*]] = lshr i64 [[TMP24]], 4
; CHECK-NEXT:    [[TMP26:%.*]] = getelementptr i8, ptr [[TMP16]], i64 [[TMP25]]
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP26]], i8 [[TMP22]], i64 1, i1 false)
; CHECK-NEXT:    call void @use(ptr [[X_HWASAN]])
; CHECK-NEXT:    [[TMP27:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; CHECK-NEXT:    [[TMP28:%.*]] = ptrtoint ptr [[X]] to i64
; CHECK-NEXT:    [[TMP29:%.*]] = and i64 [[TMP28]], 72057594037927935
; CHECK-NEXT:    [[TMP30:%.*]] = lshr i64 [[TMP29]], 4
; CHECK-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP16]], i64 [[TMP30]]
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP31]], i8 [[TMP27]], i64 1, i1 false)
; CHECK-NEXT:    ret void
;
; NOIFUNC-TLS-HISTORY-LABEL: define void @test_alloca
; NOIFUNC-TLS-HISTORY-SAME: () #[[ATTR0]] {
; NOIFUNC-TLS-HISTORY-NEXT:  entry:
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP0:%.*]] = call ptr @llvm.thread.pointer()
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP1:%.*]] = getelementptr i8, ptr [[TMP0]], i32 48
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 8
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP3:%.*]] = ashr i64 [[TMP2]], 3
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP4:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP5:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP6:%.*]] = ptrtoint ptr [[TMP5]] to i64
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP7:%.*]] = shl i64 [[TMP6]], 44
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP8:%.*]] = or i64 [[TMP4]], [[TMP7]]
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP2]] to ptr
; NOIFUNC-TLS-HISTORY-NEXT:    store i64 [[TMP8]], ptr [[TMP9]], align 8
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP10:%.*]] = ashr i64 [[TMP2]], 56
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP11:%.*]] = shl nuw nsw i64 [[TMP10]], 12
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP12:%.*]] = xor i64 [[TMP11]], -1
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP13:%.*]] = add i64 [[TMP2]], 8
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP14:%.*]] = and i64 [[TMP13]], [[TMP12]]
; NOIFUNC-TLS-HISTORY-NEXT:    store i64 [[TMP14]], ptr [[TMP1]], align 8
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP15:%.*]] = or i64 [[TMP2]], 4294967295
; NOIFUNC-TLS-HISTORY-NEXT:    [[HWASAN_SHADOW:%.*]] = add i64 [[TMP15]], 1
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP16:%.*]] = inttoptr i64 [[HWASAN_SHADOW]] to ptr
; NOIFUNC-TLS-HISTORY-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP6]], 56
; NOIFUNC-TLS-HISTORY-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP17:%.*]] = xor i64 [[TMP3]], 0
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP18:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP19:%.*]] = and i64 [[TMP18]], 72057594037927935
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP20:%.*]] = shl i64 [[TMP17]], 56
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP21:%.*]] = or i64 [[TMP19]], [[TMP20]]
; NOIFUNC-TLS-HISTORY-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP21]] to ptr
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP22:%.*]] = trunc i64 [[TMP17]] to i8
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP23:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP24:%.*]] = and i64 [[TMP23]], 72057594037927935
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP25:%.*]] = lshr i64 [[TMP24]], 4
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP26:%.*]] = getelementptr i8, ptr [[TMP16]], i64 [[TMP25]]
; NOIFUNC-TLS-HISTORY-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP26]], i8 [[TMP22]], i64 1, i1 false)
; NOIFUNC-TLS-HISTORY-NEXT:    call void @use(ptr [[X_HWASAN]])
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP27:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP28:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP29:%.*]] = and i64 [[TMP28]], 72057594037927935
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP30:%.*]] = lshr i64 [[TMP29]], 4
; NOIFUNC-TLS-HISTORY-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP16]], i64 [[TMP30]]
; NOIFUNC-TLS-HISTORY-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP31]], i8 [[TMP27]], i64 1, i1 false)
; NOIFUNC-TLS-HISTORY-NEXT:    ret void
;
; NOIFUNC-TLS-NOHISTORY-LABEL: define void @test_alloca
; NOIFUNC-TLS-NOHISTORY-SAME: () #[[ATTR0]] {
; NOIFUNC-TLS-NOHISTORY-NEXT:  entry:
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr @__hwasan_shadow)
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP0:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[TMP0]] to i64
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 20
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[HWASAN_STACK_BASE_TAG:%.*]] = xor i64 [[TMP1]], [[TMP2]]
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP1]], 56
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP3:%.*]] = xor i64 [[HWASAN_STACK_BASE_TAG]], 0
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 72057594037927935
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP6:%.*]] = shl i64 [[TMP3]], 56
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP7:%.*]] = or i64 [[TMP5]], [[TMP6]]
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP7]] to ptr
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP8:%.*]] = trunc i64 [[TMP3]] to i8
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP10:%.*]] = and i64 [[TMP9]], 72057594037927935
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP11:%.*]] = lshr i64 [[TMP10]], 4
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[DOTHWASAN_SHADOW]], i64 [[TMP11]]
; NOIFUNC-TLS-NOHISTORY-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP12]], i8 [[TMP8]], i64 1, i1 false)
; NOIFUNC-TLS-NOHISTORY-NEXT:    call void @use(ptr [[X_HWASAN]])
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP13:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP14:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], 72057594037927935
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP16:%.*]] = lshr i64 [[TMP15]], 4
; NOIFUNC-TLS-NOHISTORY-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[DOTHWASAN_SHADOW]], i64 [[TMP16]]
; NOIFUNC-TLS-NOHISTORY-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP17]], i8 [[TMP13]], i64 1, i1 false)
; NOIFUNC-TLS-NOHISTORY-NEXT:    ret void
;
; NOIFUNC-NOTLS-LABEL: define void @test_alloca
; NOIFUNC-NOTLS-SAME: () #[[ATTR0]] {
; NOIFUNC-NOTLS-NEXT:  entry:
; NOIFUNC-NOTLS-NEXT:    [[TMP0:%.*]] = load ptr, ptr @__hwasan_shadow_memory_dynamic_address, align 8
; NOIFUNC-NOTLS-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; NOIFUNC-NOTLS-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; NOIFUNC-NOTLS-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP2]], 20
; NOIFUNC-NOTLS-NEXT:    [[HWASAN_STACK_BASE_TAG:%.*]] = xor i64 [[TMP2]], [[TMP3]]
; NOIFUNC-NOTLS-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP2]], 56
; NOIFUNC-NOTLS-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; NOIFUNC-NOTLS-NEXT:    [[TMP4:%.*]] = xor i64 [[HWASAN_STACK_BASE_TAG]], 0
; NOIFUNC-NOTLS-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-NOTLS-NEXT:    [[TMP6:%.*]] = and i64 [[TMP5]], 72057594037927935
; NOIFUNC-NOTLS-NEXT:    [[TMP7:%.*]] = shl i64 [[TMP4]], 56
; NOIFUNC-NOTLS-NEXT:    [[TMP8:%.*]] = or i64 [[TMP6]], [[TMP7]]
; NOIFUNC-NOTLS-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP8]] to ptr
; NOIFUNC-NOTLS-NEXT:    [[TMP9:%.*]] = trunc i64 [[TMP4]] to i8
; NOIFUNC-NOTLS-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-NOTLS-NEXT:    [[TMP11:%.*]] = and i64 [[TMP10]], 72057594037927935
; NOIFUNC-NOTLS-NEXT:    [[TMP12:%.*]] = lshr i64 [[TMP11]], 4
; NOIFUNC-NOTLS-NEXT:    [[TMP13:%.*]] = getelementptr i8, ptr [[TMP0]], i64 [[TMP12]]
; NOIFUNC-NOTLS-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP13]], i8 [[TMP9]], i64 1, i1 false)
; NOIFUNC-NOTLS-NEXT:    call void @use(ptr [[X_HWASAN]])
; NOIFUNC-NOTLS-NEXT:    [[TMP14:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; NOIFUNC-NOTLS-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[X]] to i64
; NOIFUNC-NOTLS-NEXT:    [[TMP16:%.*]] = and i64 [[TMP15]], 72057594037927935
; NOIFUNC-NOTLS-NEXT:    [[TMP17:%.*]] = lshr i64 [[TMP16]], 4
; NOIFUNC-NOTLS-NEXT:    [[TMP18:%.*]] = getelementptr i8, ptr [[TMP0]], i64 [[TMP17]]
; NOIFUNC-NOTLS-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP18]], i8 [[TMP14]], i64 1, i1 false)
; NOIFUNC-NOTLS-NEXT:    ret void
;
; IFUNC-NOTLS-LABEL: define void @test_alloca
; IFUNC-NOTLS-SAME: () #[[ATTR0]] {
; IFUNC-NOTLS-NEXT:  entry:
; IFUNC-NOTLS-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr @__hwasan_shadow)
; IFUNC-NOTLS-NEXT:    [[TMP0:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; IFUNC-NOTLS-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[TMP0]] to i64
; IFUNC-NOTLS-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 20
; IFUNC-NOTLS-NEXT:    [[HWASAN_STACK_BASE_TAG:%.*]] = xor i64 [[TMP1]], [[TMP2]]
; IFUNC-NOTLS-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP1]], 56
; IFUNC-NOTLS-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; IFUNC-NOTLS-NEXT:    [[TMP3:%.*]] = xor i64 [[HWASAN_STACK_BASE_TAG]], 0
; IFUNC-NOTLS-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[X]] to i64
; IFUNC-NOTLS-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 72057594037927935
; IFUNC-NOTLS-NEXT:    [[TMP6:%.*]] = shl i64 [[TMP3]], 56
; IFUNC-NOTLS-NEXT:    [[TMP7:%.*]] = or i64 [[TMP5]], [[TMP6]]
; IFUNC-NOTLS-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP7]] to ptr
; IFUNC-NOTLS-NEXT:    [[TMP8:%.*]] = trunc i64 [[TMP3]] to i8
; IFUNC-NOTLS-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[X]] to i64
; IFUNC-NOTLS-NEXT:    [[TMP10:%.*]] = and i64 [[TMP9]], 72057594037927935
; IFUNC-NOTLS-NEXT:    [[TMP11:%.*]] = lshr i64 [[TMP10]], 4
; IFUNC-NOTLS-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[DOTHWASAN_SHADOW]], i64 [[TMP11]]
; IFUNC-NOTLS-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP12]], i8 [[TMP8]], i64 1, i1 false)
; IFUNC-NOTLS-NEXT:    call void @use(ptr [[X_HWASAN]])
; IFUNC-NOTLS-NEXT:    [[TMP13:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; IFUNC-NOTLS-NEXT:    [[TMP14:%.*]] = ptrtoint ptr [[X]] to i64
; IFUNC-NOTLS-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], 72057594037927935
; IFUNC-NOTLS-NEXT:    [[TMP16:%.*]] = lshr i64 [[TMP15]], 4
; IFUNC-NOTLS-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[DOTHWASAN_SHADOW]], i64 [[TMP16]]
; IFUNC-NOTLS-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP17]], i8 [[TMP13]], i64 1, i1 false)
; IFUNC-NOTLS-NEXT:    ret void
;
; FUCHSIA-LABEL: define void @test_alloca
; FUCHSIA-SAME: () #[[ATTR0]] personality ptr @__hwasan_personality_thunk {
; FUCHSIA-NEXT:  entry:
; FUCHSIA-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; FUCHSIA-NEXT:    [[TMP0:%.*]] = load i64, ptr @__hwasan_tls, align 8
; FUCHSIA-NEXT:    [[TMP1:%.*]] = ashr i64 [[TMP0]], 3
; FUCHSIA-NEXT:    [[TMP2:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; FUCHSIA-NEXT:    [[TMP3:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; FUCHSIA-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[TMP3]] to i64
; FUCHSIA-NEXT:    [[TMP5:%.*]] = shl i64 [[TMP4]], 44
; FUCHSIA-NEXT:    [[TMP6:%.*]] = or i64 [[TMP2]], [[TMP5]]
; FUCHSIA-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP0]] to ptr
; FUCHSIA-NEXT:    store i64 [[TMP6]], ptr [[TMP7]], align 8
; FUCHSIA-NEXT:    [[TMP8:%.*]] = ashr i64 [[TMP0]], 56
; FUCHSIA-NEXT:    [[TMP9:%.*]] = shl nuw nsw i64 [[TMP8]], 12
; FUCHSIA-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], -1
; FUCHSIA-NEXT:    [[TMP11:%.*]] = add i64 [[TMP0]], 8
; FUCHSIA-NEXT:    [[TMP12:%.*]] = and i64 [[TMP11]], [[TMP10]]
; FUCHSIA-NEXT:    store i64 [[TMP12]], ptr @__hwasan_tls, align 8
; FUCHSIA-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP4]], 56
; FUCHSIA-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; FUCHSIA-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP1]], 0
; FUCHSIA-NEXT:    [[TMP14:%.*]] = ptrtoint ptr [[X]] to i64
; FUCHSIA-NEXT:    [[TMP15:%.*]] = and i64 [[TMP14]], 72057594037927935
; FUCHSIA-NEXT:    [[TMP16:%.*]] = shl i64 [[TMP13]], 56
; FUCHSIA-NEXT:    [[TMP17:%.*]] = or i64 [[TMP15]], [[TMP16]]
; FUCHSIA-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP17]] to ptr
; FUCHSIA-NEXT:    [[TMP18:%.*]] = trunc i64 [[TMP13]] to i8
; FUCHSIA-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[X]] to i64
; FUCHSIA-NEXT:    [[TMP20:%.*]] = and i64 [[TMP19]], 72057594037927935
; FUCHSIA-NEXT:    [[TMP21:%.*]] = lshr i64 [[TMP20]], 4
; FUCHSIA-NEXT:    [[TMP22:%.*]] = inttoptr i64 [[TMP21]] to ptr
; FUCHSIA-NEXT:    [[TMP23:%.*]] = getelementptr i8, ptr [[TMP22]], i32 0
; FUCHSIA-NEXT:    store i8 4, ptr [[TMP23]], align 1
; FUCHSIA-NEXT:    [[TMP24:%.*]] = getelementptr i8, ptr [[X]], i32 15
; FUCHSIA-NEXT:    store i8 [[TMP18]], ptr [[TMP24]], align 1
; FUCHSIA-NEXT:    call void @use(ptr [[X_HWASAN]])
; FUCHSIA-NEXT:    [[TMP25:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; FUCHSIA-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[X]] to i64
; FUCHSIA-NEXT:    [[TMP27:%.*]] = and i64 [[TMP26]], 72057594037927935
; FUCHSIA-NEXT:    [[TMP28:%.*]] = lshr i64 [[TMP27]], 4
; FUCHSIA-NEXT:    [[TMP29:%.*]] = inttoptr i64 [[TMP28]] to ptr
; FUCHSIA-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP29]], i8 [[TMP25]], i64 1, i1 false)
; FUCHSIA-NEXT:    ret void
;
; FUCHSIA-LIBCALL-LABEL: define void @test_alloca
; FUCHSIA-LIBCALL-SAME: () #[[ATTR0]] personality ptr @__hwasan_personality_thunk {
; FUCHSIA-LIBCALL-NEXT:  entry:
; FUCHSIA-LIBCALL-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; FUCHSIA-LIBCALL-NEXT:    [[TMP0:%.*]] = call i64 @llvm.read_register.i64(metadata [[META1:![0-9]+]])
; FUCHSIA-LIBCALL-NEXT:    [[TMP1:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; FUCHSIA-LIBCALL-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[TMP1]] to i64
; FUCHSIA-LIBCALL-NEXT:    [[TMP3:%.*]] = shl i64 [[TMP2]], 44
; FUCHSIA-LIBCALL-NEXT:    [[TMP4:%.*]] = or i64 [[TMP0]], [[TMP3]]
; FUCHSIA-LIBCALL-NEXT:    call void @__hwasan_add_frame_record(i64 [[TMP4]])
; FUCHSIA-LIBCALL-NEXT:    [[TMP5:%.*]] = lshr i64 [[TMP2]], 20
; FUCHSIA-LIBCALL-NEXT:    [[HWASAN_STACK_BASE_TAG:%.*]] = xor i64 [[TMP2]], [[TMP5]]
; FUCHSIA-LIBCALL-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP2]], 56
; FUCHSIA-LIBCALL-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; FUCHSIA-LIBCALL-NEXT:    [[TMP6:%.*]] = xor i64 [[HWASAN_STACK_BASE_TAG]], 0
; FUCHSIA-LIBCALL-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[X]] to i64
; FUCHSIA-LIBCALL-NEXT:    [[TMP8:%.*]] = and i64 [[TMP7]], 72057594037927935
; FUCHSIA-LIBCALL-NEXT:    [[TMP9:%.*]] = shl i64 [[TMP6]], 56
; FUCHSIA-LIBCALL-NEXT:    [[TMP10:%.*]] = or i64 [[TMP8]], [[TMP9]]
; FUCHSIA-LIBCALL-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP10]] to ptr
; FUCHSIA-LIBCALL-NEXT:    [[TMP11:%.*]] = trunc i64 [[TMP6]] to i8
; FUCHSIA-LIBCALL-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[X]] to i64
; FUCHSIA-LIBCALL-NEXT:    [[TMP13:%.*]] = and i64 [[TMP12]], 72057594037927935
; FUCHSIA-LIBCALL-NEXT:    [[TMP14:%.*]] = lshr i64 [[TMP13]], 4
; FUCHSIA-LIBCALL-NEXT:    [[TMP15:%.*]] = inttoptr i64 [[TMP14]] to ptr
; FUCHSIA-LIBCALL-NEXT:    [[TMP16:%.*]] = getelementptr i8, ptr [[TMP15]], i32 0
; FUCHSIA-LIBCALL-NEXT:    store i8 4, ptr [[TMP16]], align 1
; FUCHSIA-LIBCALL-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[X]], i32 15
; FUCHSIA-LIBCALL-NEXT:    store i8 [[TMP11]], ptr [[TMP17]], align 1
; FUCHSIA-LIBCALL-NEXT:    call void @use(ptr [[X_HWASAN]])
; FUCHSIA-LIBCALL-NEXT:    [[TMP18:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; FUCHSIA-LIBCALL-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[X]] to i64
; FUCHSIA-LIBCALL-NEXT:    [[TMP20:%.*]] = and i64 [[TMP19]], 72057594037927935
; FUCHSIA-LIBCALL-NEXT:    [[TMP21:%.*]] = lshr i64 [[TMP20]], 4
; FUCHSIA-LIBCALL-NEXT:    [[TMP22:%.*]] = inttoptr i64 [[TMP21]] to ptr
; FUCHSIA-LIBCALL-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP22]], i8 [[TMP18]], i64 1, i1 false)
; FUCHSIA-LIBCALL-NEXT:    ret void
;
entry:
  %x = alloca i32, align 4
  call void @use(ptr %x)
  ret void
}

