; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVKB
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVKB

define void @bswap_v8i16(ptr %x, ptr %y) {
; CHECK-LABEL: bswap_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
;
; ZVKB-LABEL: bswap_v8i16:
; ZVKB:       # %bb.0:
; ZVKB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVKB-NEXT:    vle16.v v8, (a0)
; ZVKB-NEXT:    vrev8.v v8, v8
; ZVKB-NEXT:    vse16.v v8, (a0)
; ZVKB-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %b = load <8 x i16>, ptr %y
  %c = call <8 x i16> @llvm.bswap.v8i16(<8 x i16> %a)
  store <8 x i16> %c, ptr %x
  ret void
}
declare <8 x i16> @llvm.bswap.v8i16(<8 x i16>)

define void @bswap_v4i32(ptr %x, ptr %y) {
; CHECK-LABEL: bswap_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addi a1, a1, -256
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vsrl.vi v10, v8, 24
; CHECK-NEXT:    vor.vv v9, v9, v10
; CHECK-NEXT:    vand.vx v10, v8, a1
; CHECK-NEXT:    vsll.vi v10, v10, 8
; CHECK-NEXT:    vsll.vi v8, v8, 24
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
;
; ZVKB-LABEL: bswap_v4i32:
; ZVKB:       # %bb.0:
; ZVKB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZVKB-NEXT:    vle32.v v8, (a0)
; ZVKB-NEXT:    vrev8.v v8, v8
; ZVKB-NEXT:    vse32.v v8, (a0)
; ZVKB-NEXT:    ret
  %a = load <4 x i32>, ptr %x
  %b = load <4 x i32>, ptr %y
  %c = call <4 x i32> @llvm.bswap.v4i32(<4 x i32> %a)
  store <4 x i32> %c, ptr %x
  ret void
}
declare <4 x i32> @llvm.bswap.v4i32(<4 x i32>)

define void @bswap_v2i64(ptr %x, ptr %y) {
; RV32-LABEL: bswap_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsrl.vx v9, v8, a1
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v10, v8, a2
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v10, v10, a3
; RV32-NEXT:    vor.vv v9, v10, v9
; RV32-NEXT:    vsrl.vi v10, v8, 24
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vlse64.v v11, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v10, v10, a4
; RV32-NEXT:    vsrl.vi v12, v8, 8
; RV32-NEXT:    vand.vv v12, v12, v11
; RV32-NEXT:    vor.vv v10, v12, v10
; RV32-NEXT:    vor.vv v9, v10, v9
; RV32-NEXT:    vsll.vx v10, v8, a1
; RV32-NEXT:    vand.vx v12, v8, a3
; RV32-NEXT:    vsll.vx v12, v12, a2
; RV32-NEXT:    vor.vv v10, v10, v12
; RV32-NEXT:    vand.vx v12, v8, a4
; RV32-NEXT:    vsll.vi v12, v12, 24
; RV32-NEXT:    vand.vv v8, v8, v11
; RV32-NEXT:    vsll.vi v8, v8, 8
; RV32-NEXT:    vor.vv v8, v12, v8
; RV32-NEXT:    vor.vv v8, v10, v8
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: bswap_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    li a1, 56
; RV64-NEXT:    vsrl.vx v9, v8, a1
; RV64-NEXT:    li a2, 40
; RV64-NEXT:    vsrl.vx v10, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v10, v10, a3
; RV64-NEXT:    vor.vv v9, v10, v9
; RV64-NEXT:    vsrl.vi v10, v8, 24
; RV64-NEXT:    lui a4, 4080
; RV64-NEXT:    vand.vx v10, v10, a4
; RV64-NEXT:    vsrl.vi v11, v8, 8
; RV64-NEXT:    li a5, 255
; RV64-NEXT:    slli a5, a5, 24
; RV64-NEXT:    vand.vx v11, v11, a5
; RV64-NEXT:    vor.vv v10, v11, v10
; RV64-NEXT:    vor.vv v9, v10, v9
; RV64-NEXT:    vand.vx v10, v8, a5
; RV64-NEXT:    vsll.vi v10, v10, 8
; RV64-NEXT:    vand.vx v11, v8, a4
; RV64-NEXT:    vsll.vi v11, v11, 24
; RV64-NEXT:    vor.vv v10, v11, v10
; RV64-NEXT:    vsll.vx v11, v8, a1
; RV64-NEXT:    vand.vx v8, v8, a3
; RV64-NEXT:    vsll.vx v8, v8, a2
; RV64-NEXT:    vor.vv v8, v11, v8
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
;
; ZVKB-LABEL: bswap_v2i64:
; ZVKB:       # %bb.0:
; ZVKB-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; ZVKB-NEXT:    vle64.v v8, (a0)
; ZVKB-NEXT:    vrev8.v v8, v8
; ZVKB-NEXT:    vse64.v v8, (a0)
; ZVKB-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %b = load <2 x i64>, ptr %y
  %c = call <2 x i64> @llvm.bswap.v2i64(<2 x i64> %a)
  store <2 x i64> %c, ptr %x
  ret void
}
declare <2 x i64> @llvm.bswap.v2i64(<2 x i64>)

define void @bswap_v16i16(ptr %x, ptr %y) {
; CHECK-LABEL: bswap_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsrl.vi v10, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
;
; ZVKB-LABEL: bswap_v16i16:
; ZVKB:       # %bb.0:
; ZVKB-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVKB-NEXT:    vle16.v v8, (a0)
; ZVKB-NEXT:    vrev8.v v8, v8
; ZVKB-NEXT:    vse16.v v8, (a0)
; ZVKB-NEXT:    ret
  %a = load <16 x i16>, ptr %x
  %b = load <16 x i16>, ptr %y
  %c = call <16 x i16> @llvm.bswap.v16i16(<16 x i16> %a)
  store <16 x i16> %c, ptr %x
  ret void
}
declare <16 x i16> @llvm.bswap.v16i16(<16 x i16>)

define void @bswap_v8i32(ptr %x, ptr %y) {
; CHECK-LABEL: bswap_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsrl.vi v10, v8, 8
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addi a1, a1, -256
; CHECK-NEXT:    vand.vx v10, v10, a1
; CHECK-NEXT:    vsrl.vi v12, v8, 24
; CHECK-NEXT:    vor.vv v10, v10, v12
; CHECK-NEXT:    vand.vx v12, v8, a1
; CHECK-NEXT:    vsll.vi v12, v12, 8
; CHECK-NEXT:    vsll.vi v8, v8, 24
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
;
; ZVKB-LABEL: bswap_v8i32:
; ZVKB:       # %bb.0:
; ZVKB-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; ZVKB-NEXT:    vle32.v v8, (a0)
; ZVKB-NEXT:    vrev8.v v8, v8
; ZVKB-NEXT:    vse32.v v8, (a0)
; ZVKB-NEXT:    ret
  %a = load <8 x i32>, ptr %x
  %b = load <8 x i32>, ptr %y
  %c = call <8 x i32> @llvm.bswap.v8i32(<8 x i32> %a)
  store <8 x i32> %c, ptr %x
  ret void
}
declare <8 x i32> @llvm.bswap.v8i32(<8 x i32>)

define void @bswap_v4i64(ptr %x, ptr %y) {
; RV32-LABEL: bswap_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsrl.vx v10, v8, a1
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v12, v8, a2
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v12, v12, a3
; RV32-NEXT:    vor.vv v10, v12, v10
; RV32-NEXT:    vsrl.vi v12, v8, 24
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vlse64.v v14, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v12, v12, a4
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vand.vv v16, v16, v14
; RV32-NEXT:    vor.vv v12, v16, v12
; RV32-NEXT:    vor.vv v10, v12, v10
; RV32-NEXT:    vsll.vx v12, v8, a1
; RV32-NEXT:    vand.vx v16, v8, a3
; RV32-NEXT:    vsll.vx v16, v16, a2
; RV32-NEXT:    vor.vv v12, v12, v16
; RV32-NEXT:    vand.vx v16, v8, a4
; RV32-NEXT:    vsll.vi v16, v16, 24
; RV32-NEXT:    vand.vv v8, v8, v14
; RV32-NEXT:    vsll.vi v8, v8, 8
; RV32-NEXT:    vor.vv v8, v16, v8
; RV32-NEXT:    vor.vv v8, v12, v8
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: bswap_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    li a1, 56
; RV64-NEXT:    vsrl.vx v10, v8, a1
; RV64-NEXT:    li a2, 40
; RV64-NEXT:    vsrl.vx v12, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v12, v12, a3
; RV64-NEXT:    vor.vv v10, v12, v10
; RV64-NEXT:    vsrl.vi v12, v8, 24
; RV64-NEXT:    lui a4, 4080
; RV64-NEXT:    vand.vx v12, v12, a4
; RV64-NEXT:    vsrl.vi v14, v8, 8
; RV64-NEXT:    li a5, 255
; RV64-NEXT:    slli a5, a5, 24
; RV64-NEXT:    vand.vx v14, v14, a5
; RV64-NEXT:    vor.vv v12, v14, v12
; RV64-NEXT:    vor.vv v10, v12, v10
; RV64-NEXT:    vand.vx v12, v8, a5
; RV64-NEXT:    vsll.vi v12, v12, 8
; RV64-NEXT:    vand.vx v14, v8, a4
; RV64-NEXT:    vsll.vi v14, v14, 24
; RV64-NEXT:    vor.vv v12, v14, v12
; RV64-NEXT:    vsll.vx v14, v8, a1
; RV64-NEXT:    vand.vx v8, v8, a3
; RV64-NEXT:    vsll.vx v8, v8, a2
; RV64-NEXT:    vor.vv v8, v14, v8
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
;
; ZVKB-LABEL: bswap_v4i64:
; ZVKB:       # %bb.0:
; ZVKB-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; ZVKB-NEXT:    vle64.v v8, (a0)
; ZVKB-NEXT:    vrev8.v v8, v8
; ZVKB-NEXT:    vse64.v v8, (a0)
; ZVKB-NEXT:    ret
  %a = load <4 x i64>, ptr %x
  %b = load <4 x i64>, ptr %y
  %c = call <4 x i64> @llvm.bswap.v4i64(<4 x i64> %a)
  store <4 x i64> %c, ptr %x
  ret void
}
declare <4 x i64> @llvm.bswap.v4i64(<4 x i64>)
