; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -verify-machineinstrs -o - %s | FileCheck -check-prefix=SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -verify-machineinstrs -o - %s | FileCheck -check-prefix=GISEL %s

define <2 x i128> @v_sdiv_v2i128_vv(<2 x i128> %lhs, <2 x i128> %rhs) {
; SDAG-LABEL: v_sdiv_v2i128_vv:
; SDAG:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-NEXT:    v_ashrrev_i32_e32 v26, 31, v3
; SDAG-NEXT:    v_ashrrev_i32_e32 v27, 31, v11
; SDAG-NEXT:    v_sub_i32_e32 v16, vcc, 0, v0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    s_mov_b64 s[10:11], 0x7f
; SDAG-NEXT:    v_mov_b32_e32 v28, v26
; SDAG-NEXT:    v_mov_b32_e32 v29, v27
; SDAG-NEXT:    v_subb_u32_e32 v17, vcc, 0, v1, vcc
; SDAG-NEXT:    v_subb_u32_e32 v18, vcc, 0, v2, vcc
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v1, v17, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, v0, v16, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v0, vcc, 0, v3, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v2, v2, v18, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v1, v16
; SDAG-NEXT:    v_ffbh_u32_e32 v18, v17
; SDAG-NEXT:    v_cndmask_b32_e64 v3, v3, v0, s[4:5]
; SDAG-NEXT:    v_sub_i32_e32 v20, vcc, 0, v8
; SDAG-NEXT:    v_or_b32_e32 v0, v16, v2
; SDAG-NEXT:    v_ffbh_u32_e32 v21, v2
; SDAG-NEXT:    v_add_i32_e64 v22, s[4:5], 32, v1
; SDAG-NEXT:    v_subb_u32_e32 v23, vcc, 0, v9, vcc
; SDAG-NEXT:    v_or_b32_e32 v1, v17, v3
; SDAG-NEXT:    v_add_i32_e64 v21, s[4:5], 32, v21
; SDAG-NEXT:    v_min_u32_e32 v18, v22, v18
; SDAG-NEXT:    v_ffbh_u32_e32 v22, v3
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[10:11]
; SDAG-NEXT:    v_cndmask_b32_e64 v30, v9, v23, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v9, vcc, 0, v10, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v31, v8, v20, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[0:1]
; SDAG-NEXT:    v_min_u32_e32 v1, v21, v22
; SDAG-NEXT:    v_add_i32_e64 v8, s[8:9], 64, v18
; SDAG-NEXT:    v_addc_u32_e64 v18, s[8:9], 0, 0, s[8:9]
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, 0, v11, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v0, v10, v9, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v9, v31
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, v18, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v18, v8, v1, vcc
; SDAG-NEXT:    v_ffbh_u32_e32 v21, v30
; SDAG-NEXT:    v_cndmask_b32_e64 v1, v11, v20, s[4:5]
; SDAG-NEXT:    v_or_b32_e32 v8, v31, v0
; SDAG-NEXT:    v_ffbh_u32_e32 v11, v0
; SDAG-NEXT:    v_add_i32_e32 v20, vcc, 32, v9
; SDAG-NEXT:    v_or_b32_e32 v9, v30, v1
; SDAG-NEXT:    v_add_i32_e32 v11, vcc, 32, v11
; SDAG-NEXT:    v_min_u32_e32 v20, v20, v21
; SDAG-NEXT:    v_ffbh_u32_e32 v21, v1
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; SDAG-NEXT:    v_min_u32_e32 v8, v11, v21
; SDAG-NEXT:    v_add_i32_e64 v9, s[4:5], 64, v20
; SDAG-NEXT:    v_addc_u32_e64 v11, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; SDAG-NEXT:    v_cndmask_b32_e64 v11, v11, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; SDAG-NEXT:    v_sub_i32_e32 v8, vcc, v8, v18
; SDAG-NEXT:    v_subb_u32_e32 v9, vcc, v11, v10, vcc
; SDAG-NEXT:    v_xor_b32_e32 v10, 0x7f, v8
; SDAG-NEXT:    v_subbrev_u32_e32 v18, vcc, 0, v19, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[10:11], v[8:9]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v19, vcc, 0, v19, vcc
; SDAG-NEXT:    v_or_b32_e32 v10, v10, v18
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_cndmask_b32_e64 v21, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v11, v9, v19
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_cndmask_b32_e32 v20, v21, v20, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; SDAG-NEXT:    v_and_b32_e32 v10, 1, v20
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v10
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, v3, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v21, v2, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v22, v17, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v23, v16, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB0_6
; SDAG-NEXT:  ; %bb.1: ; %udiv-bb15
; SDAG-NEXT:    v_add_i32_e32 v32, vcc, 1, v8
; SDAG-NEXT:    v_sub_i32_e64 v20, s[4:5], 63, v8
; SDAG-NEXT:    v_mov_b32_e32 v10, 0
; SDAG-NEXT:    v_mov_b32_e32 v11, 0
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, 0, v9, vcc
; SDAG-NEXT:    v_lshl_b64 v[20:21], v[16:17], v20
; SDAG-NEXT:    v_addc_u32_e32 v34, vcc, 0, v18, vcc
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, 0, v19, vcc
; SDAG-NEXT:    v_or_b32_e32 v18, v32, v34
; SDAG-NEXT:    v_sub_i32_e32 v24, vcc, 0x7f, v8
; SDAG-NEXT:    v_or_b32_e32 v19, v33, v35
; SDAG-NEXT:    v_lshl_b64 v[8:9], v[2:3], v24
; SDAG-NEXT:    v_sub_i32_e32 v25, vcc, 64, v24
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[16:17], v24
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_lshr_b64 v[18:19], v[16:17], v25
; SDAG-NEXT:    v_or_b32_e32 v9, v9, v19
; SDAG-NEXT:    v_or_b32_e32 v8, v8, v18
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v24
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v21, v9, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v20, v8, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v21, 0, v23, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, 0, v22, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v24
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v9, v3, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v8, v2, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB0_5
; SDAG-NEXT:  ; %bb.2: ; %udiv-preheader4
; SDAG-NEXT:    v_lshr_b64 v[10:11], v[16:17], v32
; SDAG-NEXT:    v_sub_i32_e32 v37, vcc, 64, v32
; SDAG-NEXT:    v_subrev_i32_e32 v48, vcc, 64, v32
; SDAG-NEXT:    v_lshr_b64 v[24:25], v[2:3], v32
; SDAG-NEXT:    v_add_i32_e32 v36, vcc, -1, v31
; SDAG-NEXT:    s_mov_b64 s[10:11], 0
; SDAG-NEXT:    v_mov_b32_e32 v22, 0
; SDAG-NEXT:    v_mov_b32_e32 v23, 0
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    v_lshl_b64 v[38:39], v[2:3], v37
; SDAG-NEXT:    v_lshr_b64 v[2:3], v[2:3], v48
; SDAG-NEXT:    v_addc_u32_e32 v37, vcc, -1, v30, vcc
; SDAG-NEXT:    v_or_b32_e32 v11, v11, v39
; SDAG-NEXT:    v_or_b32_e32 v10, v10, v38
; SDAG-NEXT:    v_addc_u32_e32 v38, vcc, -1, v0, vcc
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v32
; SDAG-NEXT:    v_cndmask_b32_e64 v3, v3, v11, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v2, v2, v10, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v25, 0, v25, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v24, 0, v24, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v39, vcc, -1, v1, vcc
; SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v32
; SDAG-NEXT:    v_cndmask_b32_e32 v3, v3, v17, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v2, v2, v16, vcc
; SDAG-NEXT:    v_mov_b32_e32 v11, 0
; SDAG-NEXT:  .LBB0_3: ; %udiv-do-while3
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[24:25], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v10, 31, v3
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v24, 31, v9
; SDAG-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v25, 31, v21
; SDAG-NEXT:    v_lshl_b64 v[20:21], v[20:21], 1
; SDAG-NEXT:    v_or_b32_e32 v16, v16, v10
; SDAG-NEXT:    v_or_b32_e32 v2, v2, v24
; SDAG-NEXT:    v_or_b32_e32 v8, v8, v25
; SDAG-NEXT:    v_or_b32_e32 v9, v19, v9
; SDAG-NEXT:    v_sub_i32_e32 v10, vcc, v36, v2
; SDAG-NEXT:    v_or_b32_e32 v8, v18, v8
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v37, v3, vcc
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v38, v16, vcc
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v39, v17, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v24, 31, v10
; SDAG-NEXT:    v_and_b32_e32 v25, v24, v31
; SDAG-NEXT:    v_and_b32_e32 v48, v24, v30
; SDAG-NEXT:    v_and_b32_e32 v49, v24, v0
; SDAG-NEXT:    v_and_b32_e32 v10, 1, v24
; SDAG-NEXT:    v_and_b32_e32 v50, v24, v1
; SDAG-NEXT:    v_sub_i32_e32 v2, vcc, v2, v25
; SDAG-NEXT:    v_subb_u32_e32 v3, vcc, v3, v48, vcc
; SDAG-NEXT:    v_subb_u32_e32 v24, vcc, v16, v49, vcc
; SDAG-NEXT:    v_subb_u32_e32 v25, vcc, v17, v50, vcc
; SDAG-NEXT:    v_add_i32_e32 v32, vcc, -1, v32
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, -1, v33, vcc
; SDAG-NEXT:    v_addc_u32_e32 v34, vcc, -1, v34, vcc
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, -1, v35, vcc
; SDAG-NEXT:    v_or_b32_e32 v16, v32, v34
; SDAG-NEXT:    v_or_b32_e32 v17, v33, v35
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; SDAG-NEXT:    v_or_b32_e32 v21, v23, v21
; SDAG-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; SDAG-NEXT:    v_or_b32_e32 v20, v22, v20
; SDAG-NEXT:    v_mov_b32_e32 v23, v11
; SDAG-NEXT:    v_mov_b32_e32 v22, v10
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; SDAG-NEXT:    s_cbranch_execnz .LBB0_3
; SDAG-NEXT:  ; %bb.4: ; %Flow13
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:  .LBB0_5: ; %Flow14
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_lshl_b64 v[0:1], v[8:9], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v8, 31, v21
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[20:21], 1
; SDAG-NEXT:    v_or_b32_e32 v0, v0, v8
; SDAG-NEXT:    v_or_b32_e32 v20, v19, v1
; SDAG-NEXT:    v_or_b32_e32 v22, v11, v3
; SDAG-NEXT:    v_or_b32_e32 v21, v18, v0
; SDAG-NEXT:    v_or_b32_e32 v23, v10, v2
; SDAG-NEXT:  .LBB0_6: ; %Flow16
; SDAG-NEXT:    s_or_b64 exec, exec, s[6:7]
; SDAG-NEXT:    v_ashrrev_i32_e32 v16, 31, v7
; SDAG-NEXT:    v_ashrrev_i32_e32 v17, 31, v15
; SDAG-NEXT:    v_sub_i32_e32 v0, vcc, 0, v4
; SDAG-NEXT:    v_mov_b32_e32 v9, 0
; SDAG-NEXT:    s_mov_b64 s[10:11], 0x7f
; SDAG-NEXT:    v_mov_b32_e32 v18, v16
; SDAG-NEXT:    v_mov_b32_e32 v19, v17
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, 0, v5, vcc
; SDAG-NEXT:    v_subb_u32_e32 v8, vcc, 0, v6, vcc
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[6:7]
; SDAG-NEXT:    v_cndmask_b32_e64 v3, v5, v1, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v2, v4, v0, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v0, vcc, 0, v7, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v4, v6, v8, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v1, v2
; SDAG-NEXT:    v_ffbh_u32_e32 v6, v3
; SDAG-NEXT:    v_cndmask_b32_e64 v5, v7, v0, s[4:5]
; SDAG-NEXT:    v_sub_i32_e32 v7, vcc, 0, v12
; SDAG-NEXT:    v_or_b32_e32 v0, v2, v4
; SDAG-NEXT:    v_ffbh_u32_e32 v8, v4
; SDAG-NEXT:    v_add_i32_e64 v10, s[4:5], 32, v1
; SDAG-NEXT:    v_subb_u32_e32 v11, vcc, 0, v13, vcc
; SDAG-NEXT:    v_or_b32_e32 v1, v3, v5
; SDAG-NEXT:    v_add_i32_e64 v8, s[4:5], 32, v8
; SDAG-NEXT:    v_ffbh_u32_e32 v30, v5
; SDAG-NEXT:    v_min_u32_e32 v6, v10, v6
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, 0, v14, vcc
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[14:15]
; SDAG-NEXT:    v_cndmask_b32_e64 v24, v13, v11, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v25, v12, v7, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[0:1]
; SDAG-NEXT:    v_min_u32_e32 v1, v8, v30
; SDAG-NEXT:    v_add_i32_e64 v6, s[8:9], 64, v6
; SDAG-NEXT:    v_addc_u32_e64 v7, s[8:9], 0, 0, s[8:9]
; SDAG-NEXT:    v_subb_u32_e32 v8, vcc, 0, v15, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v0, v14, v10, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v10, v25
; SDAG-NEXT:    v_ffbh_u32_e32 v11, v24
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v12, v7, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v13, v6, v1, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v1, v15, v8, s[4:5]
; SDAG-NEXT:    v_or_b32_e32 v6, v25, v0
; SDAG-NEXT:    v_ffbh_u32_e32 v8, v0
; SDAG-NEXT:    v_add_i32_e32 v10, vcc, 32, v10
; SDAG-NEXT:    v_or_b32_e32 v7, v24, v1
; SDAG-NEXT:    v_add_i32_e32 v8, vcc, 32, v8
; SDAG-NEXT:    v_ffbh_u32_e32 v14, v1
; SDAG-NEXT:    v_min_u32_e32 v10, v10, v11
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; SDAG-NEXT:    v_min_u32_e32 v6, v8, v14
; SDAG-NEXT:    v_add_i32_e64 v7, s[4:5], 64, v10
; SDAG-NEXT:    v_addc_u32_e64 v8, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v8, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v6, v7, v6, vcc
; SDAG-NEXT:    v_sub_i32_e32 v6, vcc, v6, v13
; SDAG-NEXT:    v_subb_u32_e32 v7, vcc, v8, v12, vcc
; SDAG-NEXT:    v_xor_b32_e32 v10, 0x7f, v6
; SDAG-NEXT:    v_subbrev_u32_e32 v8, vcc, 0, v9, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[10:11], v[6:7]
; SDAG-NEXT:    v_cndmask_b32_e64 v12, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v9, vcc, 0, v9, vcc
; SDAG-NEXT:    v_or_b32_e32 v10, v10, v8
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; SDAG-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v11, v7, v9
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; SDAG-NEXT:    v_cndmask_b32_e32 v12, v13, v12, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; SDAG-NEXT:    v_and_b32_e32 v10, 1, v12
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v10
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v13, v5, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v11, v4, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v14, v3, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, v2, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB0_12
; SDAG-NEXT:  ; %bb.7: ; %udiv-bb1
; SDAG-NEXT:    v_add_i32_e32 v30, vcc, 1, v6
; SDAG-NEXT:    v_sub_i32_e64 v12, s[4:5], 63, v6
; SDAG-NEXT:    v_mov_b32_e32 v10, 0
; SDAG-NEXT:    v_mov_b32_e32 v11, 0
; SDAG-NEXT:    v_addc_u32_e32 v31, vcc, 0, v7, vcc
; SDAG-NEXT:    v_lshl_b64 v[12:13], v[2:3], v12
; SDAG-NEXT:    v_addc_u32_e32 v32, vcc, 0, v8, vcc
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, 0, v9, vcc
; SDAG-NEXT:    v_or_b32_e32 v7, v30, v32
; SDAG-NEXT:    v_sub_i32_e32 v9, vcc, 0x7f, v6
; SDAG-NEXT:    v_or_b32_e32 v8, v31, v33
; SDAG-NEXT:    v_lshl_b64 v[14:15], v[4:5], v9
; SDAG-NEXT:    v_sub_i32_e32 v6, vcc, 64, v9
; SDAG-NEXT:    v_lshl_b64 v[34:35], v[2:3], v9
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[7:8]
; SDAG-NEXT:    v_lshr_b64 v[6:7], v[2:3], v6
; SDAG-NEXT:    v_or_b32_e32 v7, v15, v7
; SDAG-NEXT:    v_or_b32_e32 v6, v14, v6
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v9
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v13, v7, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v12, v12, v6, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v7, 0, v35, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v6, 0, v34, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v9
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v8, v5, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v12, v4, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v12, 0
; SDAG-NEXT:    v_mov_b32_e32 v13, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB0_11
; SDAG-NEXT:  ; %bb.8: ; %udiv-preheader
; SDAG-NEXT:    v_lshr_b64 v[10:11], v[2:3], v30
; SDAG-NEXT:    v_sub_i32_e32 v35, vcc, 64, v30
; SDAG-NEXT:    v_subrev_i32_e32 v36, vcc, 64, v30
; SDAG-NEXT:    v_lshr_b64 v[37:38], v[4:5], v30
; SDAG-NEXT:    v_add_i32_e32 v34, vcc, -1, v25
; SDAG-NEXT:    s_mov_b64 s[10:11], 0
; SDAG-NEXT:    v_mov_b32_e32 v14, 0
; SDAG-NEXT:    v_mov_b32_e32 v15, 0
; SDAG-NEXT:    v_mov_b32_e32 v12, 0
; SDAG-NEXT:    v_mov_b32_e32 v13, 0
; SDAG-NEXT:    v_lshl_b64 v[48:49], v[4:5], v35
; SDAG-NEXT:    v_lshr_b64 v[4:5], v[4:5], v36
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, -1, v24, vcc
; SDAG-NEXT:    v_or_b32_e32 v11, v11, v49
; SDAG-NEXT:    v_or_b32_e32 v10, v10, v48
; SDAG-NEXT:    v_addc_u32_e32 v36, vcc, -1, v0, vcc
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v30
; SDAG-NEXT:    v_cndmask_b32_e64 v11, v5, v11, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, v4, v10, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v5, 0, v38, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, v37, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v37, vcc, -1, v1, vcc
; SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v30
; SDAG-NEXT:    v_cndmask_b32_e32 v3, v11, v3, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc
; SDAG-NEXT:    v_mov_b32_e32 v11, 0
; SDAG-NEXT:  .LBB0_9: ; %udiv-do-while
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshl_b64 v[4:5], v[4:5], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v10, 31, v3
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v38, 31, v9
; SDAG-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v39, 31, v7
; SDAG-NEXT:    v_lshl_b64 v[6:7], v[6:7], 1
; SDAG-NEXT:    v_or_b32_e32 v4, v4, v10
; SDAG-NEXT:    v_or_b32_e32 v2, v2, v38
; SDAG-NEXT:    v_or_b32_e32 v8, v8, v39
; SDAG-NEXT:    v_or_b32_e32 v9, v13, v9
; SDAG-NEXT:    v_or_b32_e32 v7, v15, v7
; SDAG-NEXT:    v_or_b32_e32 v8, v12, v8
; SDAG-NEXT:    v_sub_i32_e32 v10, vcc, v34, v2
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v35, v3, vcc
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v36, v4, vcc
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v37, v5, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v15, 31, v10
; SDAG-NEXT:    v_and_b32_e32 v10, 1, v15
; SDAG-NEXT:    v_and_b32_e32 v38, v15, v1
; SDAG-NEXT:    v_and_b32_e32 v39, v15, v0
; SDAG-NEXT:    v_and_b32_e32 v48, v15, v24
; SDAG-NEXT:    v_and_b32_e32 v15, v15, v25
; SDAG-NEXT:    v_sub_i32_e32 v2, vcc, v2, v15
; SDAG-NEXT:    v_subb_u32_e32 v3, vcc, v3, v48, vcc
; SDAG-NEXT:    v_subb_u32_e32 v4, vcc, v4, v39, vcc
; SDAG-NEXT:    v_subb_u32_e32 v5, vcc, v5, v38, vcc
; SDAG-NEXT:    v_add_i32_e32 v30, vcc, -1, v30
; SDAG-NEXT:    v_addc_u32_e32 v31, vcc, -1, v31, vcc
; SDAG-NEXT:    v_addc_u32_e32 v32, vcc, -1, v32, vcc
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, -1, v33, vcc
; SDAG-NEXT:    v_or_b32_e32 v39, v31, v33
; SDAG-NEXT:    v_or_b32_e32 v38, v30, v32
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[38:39]
; SDAG-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; SDAG-NEXT:    v_or_b32_e32 v6, v14, v6
; SDAG-NEXT:    v_mov_b32_e32 v15, v11
; SDAG-NEXT:    v_mov_b32_e32 v14, v10
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; SDAG-NEXT:    s_cbranch_execnz .LBB0_9
; SDAG-NEXT:  ; %bb.10: ; %Flow
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:  .LBB0_11: ; %Flow11
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_lshl_b64 v[0:1], v[8:9], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v4, 31, v7
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[6:7], 1
; SDAG-NEXT:    v_or_b32_e32 v0, v0, v4
; SDAG-NEXT:    v_or_b32_e32 v13, v13, v1
; SDAG-NEXT:    v_or_b32_e32 v14, v11, v3
; SDAG-NEXT:    v_or_b32_e32 v11, v12, v0
; SDAG-NEXT:    v_or_b32_e32 v10, v10, v2
; SDAG-NEXT:  .LBB0_12: ; %Flow12
; SDAG-NEXT:    s_or_b64 exec, exec, s[6:7]
; SDAG-NEXT:    v_xor_b32_e32 v3, v29, v28
; SDAG-NEXT:    v_xor_b32_e32 v2, v27, v26
; SDAG-NEXT:    v_xor_b32_e32 v7, v19, v18
; SDAG-NEXT:    v_xor_b32_e32 v6, v17, v16
; SDAG-NEXT:    v_xor_b32_e32 v4, v20, v3
; SDAG-NEXT:    v_xor_b32_e32 v5, v21, v2
; SDAG-NEXT:    v_xor_b32_e32 v1, v22, v3
; SDAG-NEXT:    v_xor_b32_e32 v0, v23, v2
; SDAG-NEXT:    v_xor_b32_e32 v8, v13, v7
; SDAG-NEXT:    v_xor_b32_e32 v9, v11, v6
; SDAG-NEXT:    v_xor_b32_e32 v11, v14, v7
; SDAG-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; SDAG-NEXT:    v_subb_u32_e32 v2, vcc, v5, v2, vcc
; SDAG-NEXT:    v_subb_u32_e32 v3, vcc, v4, v3, vcc
; SDAG-NEXT:    v_xor_b32_e32 v4, v10, v6
; SDAG-NEXT:    v_sub_i32_e32 v4, vcc, v4, v6
; SDAG-NEXT:    v_subb_u32_e32 v5, vcc, v11, v7, vcc
; SDAG-NEXT:    v_subb_u32_e32 v6, vcc, v9, v6, vcc
; SDAG-NEXT:    v_subb_u32_e32 v7, vcc, v8, v7, vcc
; SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-LABEL: v_sdiv_v2i128_vv:
; GISEL:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_ashrrev_i32_e32 v24, 31, v3
; GISEL-NEXT:    v_ashrrev_i32_e32 v25, 31, v11
; GISEL-NEXT:    v_mov_b32_e32 v20, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v21, 0
; GISEL-NEXT:    v_xor_b32_e32 v0, v24, v0
; GISEL-NEXT:    v_xor_b32_e32 v1, v24, v1
; GISEL-NEXT:    v_xor_b32_e32 v2, v24, v2
; GISEL-NEXT:    v_xor_b32_e32 v3, v24, v3
; GISEL-NEXT:    v_xor_b32_e32 v8, v25, v8
; GISEL-NEXT:    v_xor_b32_e32 v9, v25, v9
; GISEL-NEXT:    v_xor_b32_e32 v10, v25, v10
; GISEL-NEXT:    v_xor_b32_e32 v11, v25, v11
; GISEL-NEXT:    v_sub_i32_e32 v16, vcc, v0, v24
; GISEL-NEXT:    v_subb_u32_e32 v17, vcc, v1, v24, vcc
; GISEL-NEXT:    v_sub_i32_e64 v26, s[4:5], v8, v25
; GISEL-NEXT:    v_subb_u32_e64 v27, s[4:5], v9, v25, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v18, vcc, v2, v24, vcc
; GISEL-NEXT:    v_subb_u32_e32 v19, vcc, v3, v24, vcc
; GISEL-NEXT:    v_subb_u32_e64 v10, vcc, v10, v25, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v11, vcc, v11, v25, vcc
; GISEL-NEXT:    v_ffbh_u32_e32 v8, v27
; GISEL-NEXT:    v_ffbh_u32_e32 v9, v26
; GISEL-NEXT:    v_ffbh_u32_e32 v22, v17
; GISEL-NEXT:    v_ffbh_u32_e32 v23, v16
; GISEL-NEXT:    v_or_b32_e32 v0, v26, v10
; GISEL-NEXT:    v_or_b32_e32 v1, v27, v11
; GISEL-NEXT:    v_or_b32_e32 v2, v16, v18
; GISEL-NEXT:    v_or_b32_e32 v3, v17, v19
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, 32, v9
; GISEL-NEXT:    v_ffbh_u32_e32 v28, v11
; GISEL-NEXT:    v_ffbh_u32_e32 v29, v10
; GISEL-NEXT:    v_add_i32_e32 v23, vcc, 32, v23
; GISEL-NEXT:    v_ffbh_u32_e32 v30, v19
; GISEL-NEXT:    v_ffbh_u32_e32 v31, v18
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[2:3]
; GISEL-NEXT:    v_min_u32_e32 v0, v8, v9
; GISEL-NEXT:    v_add_i32_e64 v1, s[6:7], 32, v29
; GISEL-NEXT:    v_min_u32_e32 v2, v22, v23
; GISEL-NEXT:    v_add_i32_e64 v3, s[6:7], 32, v31
; GISEL-NEXT:    v_add_i32_e64 v0, s[6:7], 64, v0
; GISEL-NEXT:    v_min_u32_e32 v1, v28, v1
; GISEL-NEXT:    v_add_i32_e64 v2, s[6:7], 64, v2
; GISEL-NEXT:    v_min_u32_e32 v3, v30, v3
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v22, 0, 1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GISEL-NEXT:    v_subb_u32_e64 v1, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v2, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v3, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[0:1], v[20:21]
; GISEL-NEXT:    v_cndmask_b32_e64 v20, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v8, 0x7f, v0
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e64 v21, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v8, v8, v2
; GISEL-NEXT:    v_or_b32_e32 v9, v1, v3
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e32 v20, v21, v20, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v9, v22, v20
; GISEL-NEXT:    v_and_b32_e32 v20, 1, v9
; GISEL-NEXT:    v_or_b32_e32 v8, v9, v8
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GISEL-NEXT:    v_cndmask_b32_e64 v20, v16, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v22, 1, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v21, v17, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v8, v18, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v9, v19, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v22
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB0_6
; GISEL-NEXT:  ; %bb.1: ; %udiv-bb15
; GISEL-NEXT:    v_add_i32_e32 v28, vcc, 1, v0
; GISEL-NEXT:    v_addc_u32_e64 v29, s[4:5], 0, v1, vcc
; GISEL-NEXT:    v_sub_i32_e32 v32, vcc, 0x7f, v0
; GISEL-NEXT:    v_addc_u32_e64 v30, vcc, 0, v2, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v31, vcc, 0, v3, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v20, s[4:5], 64, v32
; GISEL-NEXT:    v_sub_i32_e64 v8, s[4:5], 64, v32
; GISEL-NEXT:    v_lshl_b64 v[0:1], v[16:17], v32
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[18:19], v32
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[8:9], v[16:17], v8
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[16:17], v20
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v32
; GISEL-NEXT:    v_cndmask_b32_e32 v20, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v21, 0, v1, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v8, v2
; GISEL-NEXT:    v_or_b32_e32 v1, v9, v3
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v22, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v23, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v32
; GISEL-NEXT:    v_cndmask_b32_e32 v8, v0, v18, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v9, v1, v19, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v0, s8
; GISEL-NEXT:    v_mov_b32_e32 v1, s9
; GISEL-NEXT:    v_mov_b32_e32 v2, s10
; GISEL-NEXT:    v_mov_b32_e32 v3, s11
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[14:15], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB0_5
; GISEL-NEXT:  ; %bb.2: ; %udiv-preheader4
; GISEL-NEXT:    v_subrev_i32_e32 v34, vcc, 64, v28
; GISEL-NEXT:    v_sub_i32_e32 v22, vcc, 64, v28
; GISEL-NEXT:    v_lshr_b64 v[0:1], v[18:19], v28
; GISEL-NEXT:    v_lshr_b64 v[2:3], v[16:17], v28
; GISEL-NEXT:    v_add_i32_e32 v32, vcc, -1, v26
; GISEL-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v28
; GISEL-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v28
; GISEL-NEXT:    v_addc_u32_e32 v33, vcc, -1, v27, vcc
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[18:19], v22
; GISEL-NEXT:    v_lshr_b64 v[36:37], v[18:19], v34
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_cndmask_b32_e64 v18, 0, v0, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v19, 0, v1, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v34, vcc, -1, v10, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v2, v22
; GISEL-NEXT:    v_or_b32_e32 v1, v3, v23
; GISEL-NEXT:    v_addc_u32_e32 v35, vcc, -1, v11, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v0, v36, v0, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v1, v37, v1, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v22, v0, v16, s[6:7]
; GISEL-NEXT:    v_cndmask_b32_e64 v23, v1, v17, s[6:7]
; GISEL-NEXT:    v_mov_b32_e32 v17, 0
; GISEL-NEXT:    v_mov_b32_e32 v0, s8
; GISEL-NEXT:    v_mov_b32_e32 v1, s9
; GISEL-NEXT:    v_mov_b32_e32 v2, s10
; GISEL-NEXT:    v_mov_b32_e32 v3, s11
; GISEL-NEXT:  .LBB0_3: ; %udiv-do-while3
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshrrev_b32_e32 v16, 31, v21
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[20:21], 1
; GISEL-NEXT:    v_lshl_b64 v[36:37], v[22:23], 1
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[18:19], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v22, 31, v23
; GISEL-NEXT:    v_lshrrev_b32_e32 v23, 31, v9
; GISEL-NEXT:    v_add_i32_e32 v28, vcc, -1, v28
; GISEL-NEXT:    v_addc_u32_e32 v29, vcc, -1, v29, vcc
; GISEL-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; GISEL-NEXT:    v_or_b32_e32 v20, v0, v2
; GISEL-NEXT:    v_or_b32_e32 v21, v1, v3
; GISEL-NEXT:    v_or_b32_e32 v2, v18, v22
; GISEL-NEXT:    v_or_b32_e32 v3, v36, v23
; GISEL-NEXT:    v_addc_u32_e32 v30, vcc, -1, v30, vcc
; GISEL-NEXT:    v_addc_u32_e32 v31, vcc, -1, v31, vcc
; GISEL-NEXT:    v_or_b32_e32 v8, v8, v16
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v32, v3
; GISEL-NEXT:    v_subb_u32_e32 v0, vcc, v33, v37, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v28, v30
; GISEL-NEXT:    v_or_b32_e32 v1, v29, v31
; GISEL-NEXT:    v_subb_u32_e32 v16, vcc, v34, v2, vcc
; GISEL-NEXT:    v_subb_u32_e32 v16, vcc, v35, v19, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_ashrrev_i32_e32 v0, 31, v16
; GISEL-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GISEL-NEXT:    v_and_b32_e32 v1, v0, v26
; GISEL-NEXT:    v_and_b32_e32 v18, v0, v27
; GISEL-NEXT:    v_and_b32_e32 v16, 1, v0
; GISEL-NEXT:    v_and_b32_e32 v36, v0, v10
; GISEL-NEXT:    v_and_b32_e32 v0, v0, v11
; GISEL-NEXT:    v_sub_i32_e32 v22, vcc, v3, v1
; GISEL-NEXT:    v_subb_u32_e32 v23, vcc, v37, v18, vcc
; GISEL-NEXT:    v_subb_u32_e32 v18, vcc, v2, v36, vcc
; GISEL-NEXT:    v_subb_u32_e32 v19, vcc, v19, v0, vcc
; GISEL-NEXT:    v_mov_b32_e32 v0, v16
; GISEL-NEXT:    v_mov_b32_e32 v1, v17
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GISEL-NEXT:    s_cbranch_execnz .LBB0_3
; GISEL-NEXT:  ; %bb.4: ; %Flow13
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:  .LBB0_5: ; %Flow14
; GISEL-NEXT:    s_or_b64 exec, exec, s[14:15]
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[20:21], 1
; GISEL-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v10, 31, v21
; GISEL-NEXT:    v_or_b32_e32 v8, v8, v10
; GISEL-NEXT:    v_or_b32_e32 v20, v0, v2
; GISEL-NEXT:    v_or_b32_e32 v21, v1, v3
; GISEL-NEXT:  .LBB0_6: ; %Flow16
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_ashrrev_i32_e32 v18, 31, v7
; GISEL-NEXT:    v_ashrrev_i32_e32 v19, 31, v15
; GISEL-NEXT:    v_mov_b32_e32 v10, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v11, 0
; GISEL-NEXT:    v_xor_b32_e32 v0, v18, v4
; GISEL-NEXT:    v_xor_b32_e32 v1, v18, v5
; GISEL-NEXT:    v_xor_b32_e32 v2, v18, v6
; GISEL-NEXT:    v_xor_b32_e32 v3, v18, v7
; GISEL-NEXT:    v_xor_b32_e32 v4, v19, v12
; GISEL-NEXT:    v_xor_b32_e32 v5, v19, v13
; GISEL-NEXT:    v_xor_b32_e32 v14, v19, v14
; GISEL-NEXT:    v_xor_b32_e32 v15, v19, v15
; GISEL-NEXT:    v_sub_i32_e32 v6, vcc, v0, v18
; GISEL-NEXT:    v_subb_u32_e32 v7, vcc, v1, v18, vcc
; GISEL-NEXT:    v_sub_i32_e64 v22, s[4:5], v4, v19
; GISEL-NEXT:    v_subb_u32_e64 v23, s[4:5], v5, v19, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v12, vcc, v2, v18, vcc
; GISEL-NEXT:    v_subb_u32_e32 v13, vcc, v3, v18, vcc
; GISEL-NEXT:    v_subb_u32_e64 v4, vcc, v14, v19, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v5, vcc, v15, v19, vcc
; GISEL-NEXT:    v_ffbh_u32_e32 v14, v23
; GISEL-NEXT:    v_ffbh_u32_e32 v15, v22
; GISEL-NEXT:    v_ffbh_u32_e32 v16, v7
; GISEL-NEXT:    v_ffbh_u32_e32 v17, v6
; GISEL-NEXT:    v_or_b32_e32 v0, v22, v4
; GISEL-NEXT:    v_or_b32_e32 v1, v23, v5
; GISEL-NEXT:    v_or_b32_e32 v2, v6, v12
; GISEL-NEXT:    v_or_b32_e32 v3, v7, v13
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, 32, v15
; GISEL-NEXT:    v_ffbh_u32_e32 v26, v5
; GISEL-NEXT:    v_ffbh_u32_e32 v27, v4
; GISEL-NEXT:    v_add_i32_e32 v17, vcc, 32, v17
; GISEL-NEXT:    v_ffbh_u32_e32 v28, v13
; GISEL-NEXT:    v_ffbh_u32_e32 v29, v12
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[2:3]
; GISEL-NEXT:    v_min_u32_e32 v0, v14, v15
; GISEL-NEXT:    v_add_i32_e64 v1, s[6:7], 32, v27
; GISEL-NEXT:    v_min_u32_e32 v2, v16, v17
; GISEL-NEXT:    v_add_i32_e64 v3, s[6:7], 32, v29
; GISEL-NEXT:    v_add_i32_e64 v0, s[6:7], 64, v0
; GISEL-NEXT:    v_min_u32_e32 v1, v26, v1
; GISEL-NEXT:    v_add_i32_e64 v2, s[6:7], 64, v2
; GISEL-NEXT:    v_min_u32_e32 v3, v28, v3
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[4:5]
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[12:13]
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GISEL-NEXT:    v_subb_u32_e64 v1, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v2, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v3, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[0:1], v[10:11]
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v10, 0x7f, v0
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e64 v16, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v10, v10, v2
; GISEL-NEXT:    v_or_b32_e32 v11, v1, v3
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e32 v15, v16, v15, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v11, v14, v15
; GISEL-NEXT:    v_and_b32_e32 v14, 1, v11
; GISEL-NEXT:    v_or_b32_e32 v10, v11, v10
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, v6, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v16, 1, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v15, v7, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v10, v12, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v11, v13, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB0_12
; GISEL-NEXT:  ; %bb.7: ; %udiv-bb1
; GISEL-NEXT:    v_add_i32_e32 v26, vcc, 1, v0
; GISEL-NEXT:    v_addc_u32_e64 v27, s[4:5], 0, v1, vcc
; GISEL-NEXT:    v_sub_i32_e32 v30, vcc, 0x7f, v0
; GISEL-NEXT:    v_addc_u32_e64 v28, vcc, 0, v2, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v29, vcc, 0, v3, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v14, s[4:5], 64, v30
; GISEL-NEXT:    v_sub_i32_e64 v10, s[4:5], 64, v30
; GISEL-NEXT:    v_lshl_b64 v[0:1], v[6:7], v30
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[12:13], v30
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[10:11], v[6:7], v10
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[6:7], v14
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v30
; GISEL-NEXT:    v_cndmask_b32_e32 v14, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v15, 0, v1, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v10, v2
; GISEL-NEXT:    v_or_b32_e32 v1, v11, v3
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v30
; GISEL-NEXT:    v_cndmask_b32_e32 v10, v0, v12, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v11, v1, v13, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v0, s8
; GISEL-NEXT:    v_mov_b32_e32 v1, s9
; GISEL-NEXT:    v_mov_b32_e32 v2, s10
; GISEL-NEXT:    v_mov_b32_e32 v3, s11
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[8:9], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB0_11
; GISEL-NEXT:  ; %bb.8: ; %udiv-preheader
; GISEL-NEXT:    v_subrev_i32_e32 v32, vcc, 64, v26
; GISEL-NEXT:    v_sub_i32_e32 v16, vcc, 64, v26
; GISEL-NEXT:    v_lshr_b64 v[0:1], v[12:13], v26
; GISEL-NEXT:    v_lshr_b64 v[2:3], v[6:7], v26
; GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GISEL-NEXT:    v_add_i32_e32 v30, vcc, -1, v22
; GISEL-NEXT:    v_addc_u32_e32 v31, vcc, -1, v23, vcc
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[12:13], v16
; GISEL-NEXT:    v_lshr_b64 v[12:13], v[12:13], v32
; GISEL-NEXT:    v_addc_u32_e32 v32, vcc, -1, v4, vcc
; GISEL-NEXT:    v_addc_u32_e32 v33, vcc, -1, v5, vcc
; GISEL-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v16
; GISEL-NEXT:    v_or_b32_e32 v3, v3, v17
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v12, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v13, v3, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v16, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v17, 0, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v12, v2, v6, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v13, v3, v7, vcc
; GISEL-NEXT:    v_mov_b32_e32 v7, 0
; GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-NEXT:    v_mov_b32_e32 v2, s6
; GISEL-NEXT:    v_mov_b32_e32 v3, s7
; GISEL-NEXT:  .LBB0_9: ; %udiv-do-while
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[12:13], 1
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v6, 31, v13
; GISEL-NEXT:    v_lshrrev_b32_e32 v34, 31, v11
; GISEL-NEXT:    v_lshl_b64 v[12:13], v[14:15], 1
; GISEL-NEXT:    v_lshl_b64 v[10:11], v[10:11], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v14, 31, v15
; GISEL-NEXT:    v_add_i32_e32 v26, vcc, -1, v26
; GISEL-NEXT:    v_addc_u32_e32 v27, vcc, -1, v27, vcc
; GISEL-NEXT:    v_or_b32_e32 v16, v16, v6
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v34
; GISEL-NEXT:    v_or_b32_e32 v10, v10, v14
; GISEL-NEXT:    v_or_b32_e32 v14, v0, v12
; GISEL-NEXT:    v_or_b32_e32 v15, v1, v13
; GISEL-NEXT:    v_addc_u32_e32 v28, vcc, -1, v28, vcc
; GISEL-NEXT:    v_addc_u32_e32 v29, vcc, -1, v29, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v30, v2
; GISEL-NEXT:    v_subb_u32_e32 v0, vcc, v31, v3, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v26, v28
; GISEL-NEXT:    v_or_b32_e32 v1, v27, v29
; GISEL-NEXT:    v_subb_u32_e32 v6, vcc, v32, v16, vcc
; GISEL-NEXT:    v_subb_u32_e32 v6, vcc, v33, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_ashrrev_i32_e32 v0, 31, v6
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v6, 1, v0
; GISEL-NEXT:    v_and_b32_e32 v12, v0, v22
; GISEL-NEXT:    v_and_b32_e32 v13, v0, v23
; GISEL-NEXT:    v_and_b32_e32 v34, v0, v4
; GISEL-NEXT:    v_and_b32_e32 v35, v0, v5
; GISEL-NEXT:    v_mov_b32_e32 v0, v6
; GISEL-NEXT:    v_mov_b32_e32 v1, v7
; GISEL-NEXT:    v_sub_i32_e32 v12, vcc, v2, v12
; GISEL-NEXT:    v_subb_u32_e32 v13, vcc, v3, v13, vcc
; GISEL-NEXT:    v_subb_u32_e32 v16, vcc, v16, v34, vcc
; GISEL-NEXT:    v_subb_u32_e32 v17, vcc, v17, v35, vcc
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GISEL-NEXT:    s_cbranch_execnz .LBB0_9
; GISEL-NEXT:  ; %bb.10: ; %Flow
; GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GISEL-NEXT:  .LBB0_11: ; %Flow11
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[14:15], 1
; GISEL-NEXT:    v_lshl_b64 v[10:11], v[10:11], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v4, 31, v15
; GISEL-NEXT:    v_or_b32_e32 v10, v10, v4
; GISEL-NEXT:    v_or_b32_e32 v14, v0, v2
; GISEL-NEXT:    v_or_b32_e32 v15, v1, v3
; GISEL-NEXT:  .LBB0_12: ; %Flow12
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    v_xor_b32_e32 v3, v25, v24
; GISEL-NEXT:    v_xor_b32_e32 v7, v19, v18
; GISEL-NEXT:    v_xor_b32_e32 v0, v20, v3
; GISEL-NEXT:    v_xor_b32_e32 v1, v21, v3
; GISEL-NEXT:    v_xor_b32_e32 v2, v8, v3
; GISEL-NEXT:    v_xor_b32_e32 v6, v9, v3
; GISEL-NEXT:    v_xor_b32_e32 v4, v14, v7
; GISEL-NEXT:    v_xor_b32_e32 v5, v15, v7
; GISEL-NEXT:    v_xor_b32_e32 v8, v10, v7
; GISEL-NEXT:    v_xor_b32_e32 v9, v11, v7
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v3
; GISEL-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; GISEL-NEXT:    v_sub_i32_e64 v4, s[4:5], v4, v7
; GISEL-NEXT:    v_subb_u32_e64 v5, s[4:5], v5, v7, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v2, vcc, v2, v3, vcc
; GISEL-NEXT:    v_subb_u32_e32 v3, vcc, v6, v3, vcc
; GISEL-NEXT:    v_subb_u32_e64 v6, vcc, v8, v7, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v7, vcc, v9, v7, vcc
; GISEL-NEXT:    s_setpc_b64 s[30:31]
  %shl = sdiv <2 x i128> %lhs, %rhs
  ret <2 x i128> %shl
}

define <2 x i128> @v_udiv_v2i128_vv(<2 x i128> %lhs, <2 x i128> %rhs) {
; SDAG-LABEL: v_udiv_v2i128_vv:
; SDAG:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-NEXT:    v_or_b32_e32 v17, v9, v11
; SDAG-NEXT:    v_or_b32_e32 v16, v8, v10
; SDAG-NEXT:    v_or_b32_e32 v19, v1, v3
; SDAG-NEXT:    v_or_b32_e32 v18, v0, v2
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v10
; SDAG-NEXT:    v_ffbh_u32_e32 v21, v11
; SDAG-NEXT:    v_ffbh_u32_e32 v22, v8
; SDAG-NEXT:    v_ffbh_u32_e32 v23, v9
; SDAG-NEXT:    v_ffbh_u32_e32 v24, v2
; SDAG-NEXT:    v_ffbh_u32_e32 v25, v3
; SDAG-NEXT:    v_ffbh_u32_e32 v26, v0
; SDAG-NEXT:    v_ffbh_u32_e32 v27, v1
; SDAG-NEXT:    v_mov_b32_e32 v28, 0
; SDAG-NEXT:    s_mov_b64 s[8:9], 0x7f
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[18:19]
; SDAG-NEXT:    v_add_i32_e64 v16, s[6:7], 32, v20
; SDAG-NEXT:    v_add_i32_e64 v17, s[6:7], 32, v22
; SDAG-NEXT:    v_add_i32_e64 v18, s[6:7], 32, v24
; SDAG-NEXT:    v_add_i32_e64 v19, s[6:7], 32, v26
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[4:5]
; SDAG-NEXT:    v_min_u32_e32 v16, v16, v21
; SDAG-NEXT:    v_min_u32_e32 v17, v17, v23
; SDAG-NEXT:    v_min_u32_e32 v18, v18, v25
; SDAG-NEXT:    v_min_u32_e32 v19, v19, v27
; SDAG-NEXT:    v_add_i32_e32 v17, vcc, 64, v17
; SDAG-NEXT:    v_addc_u32_e64 v20, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_add_i32_e32 v19, vcc, 64, v19
; SDAG-NEXT:    v_addc_u32_e64 v21, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, v20, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v16, v17, v16, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v21, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; SDAG-NEXT:    v_sub_i32_e32 v23, vcc, v16, v18
; SDAG-NEXT:    v_subb_u32_e32 v24, vcc, v20, v17, vcc
; SDAG-NEXT:    v_xor_b32_e32 v16, 0x7f, v23
; SDAG-NEXT:    v_subbrev_u32_e32 v25, vcc, 0, v28, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[8:9], v[23:24]
; SDAG-NEXT:    v_cndmask_b32_e64 v18, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v26, vcc, 0, v28, vcc
; SDAG-NEXT:    v_or_b32_e32 v16, v16, v25
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[25:26]
; SDAG-NEXT:    v_cndmask_b32_e64 v19, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v17, v24, v26
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[25:26]
; SDAG-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[16:17]
; SDAG-NEXT:    v_and_b32_e32 v16, 1, v18
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v16
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, v3, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v2, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v18, v1, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v19, v0, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[8:9], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB1_6
; SDAG-NEXT:  ; %bb.1: ; %udiv-bb15
; SDAG-NEXT:    v_add_i32_e32 v18, vcc, 1, v23
; SDAG-NEXT:    v_sub_i32_e64 v16, s[4:5], 63, v23
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:    v_mov_b32_e32 v22, 0
; SDAG-NEXT:    v_addc_u32_e32 v27, vcc, 0, v24, vcc
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[0:1], v16
; SDAG-NEXT:    v_addc_u32_e32 v28, vcc, 0, v25, vcc
; SDAG-NEXT:    v_addc_u32_e32 v29, vcc, 0, v26, vcc
; SDAG-NEXT:    v_or_b32_e32 v19, v18, v28
; SDAG-NEXT:    v_sub_i32_e32 v30, vcc, 0x7f, v23
; SDAG-NEXT:    v_or_b32_e32 v20, v27, v29
; SDAG-NEXT:    v_lshl_b64 v[23:24], v[2:3], v30
; SDAG-NEXT:    v_sub_i32_e32 v31, vcc, 64, v30
; SDAG-NEXT:    v_lshl_b64 v[25:26], v[0:1], v30
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[19:20]
; SDAG-NEXT:    v_lshr_b64 v[19:20], v[0:1], v31
; SDAG-NEXT:    v_or_b32_e32 v20, v24, v20
; SDAG-NEXT:    v_or_b32_e32 v19, v23, v19
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v30
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v17, v20, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, v16, v19, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v24, 0, v26, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v23, 0, v25, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v30
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v17, v3, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, v16, v2, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    v_mov_b32_e32 v20, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[10:11], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB1_5
; SDAG-NEXT:  ; %bb.2: ; %udiv-preheader4
; SDAG-NEXT:    v_lshr_b64 v[21:22], v[0:1], v18
; SDAG-NEXT:    v_sub_i32_e32 v31, vcc, 64, v18
; SDAG-NEXT:    v_subrev_i32_e32 v36, vcc, 64, v18
; SDAG-NEXT:    v_lshr_b64 v[32:33], v[2:3], v18
; SDAG-NEXT:    v_add_i32_e32 v30, vcc, -1, v8
; SDAG-NEXT:    s_mov_b64 s[12:13], 0
; SDAG-NEXT:    v_mov_b32_e32 v25, 0
; SDAG-NEXT:    v_mov_b32_e32 v26, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    v_mov_b32_e32 v20, 0
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v18
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v18
; SDAG-NEXT:    v_lshl_b64 v[34:35], v[2:3], v31
; SDAG-NEXT:    v_lshr_b64 v[36:37], v[2:3], v36
; SDAG-NEXT:    v_addc_u32_e32 v31, vcc, -1, v9, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v3, 0, v33, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, v32, s[4:5]
; SDAG-NEXT:    v_or_b32_e32 v22, v22, v35
; SDAG-NEXT:    v_or_b32_e32 v21, v21, v34
; SDAG-NEXT:    v_addc_u32_e32 v32, vcc, -1, v10, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v22, v37, v22, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v21, v36, v21, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, -1, v11, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v1, v22, v1, s[6:7]
; SDAG-NEXT:    v_cndmask_b32_e64 v0, v21, v0, s[6:7]
; SDAG-NEXT:    v_mov_b32_e32 v22, 0
; SDAG-NEXT:  .LBB1_3: ; %udiv-do-while3
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshrrev_b32_e32 v21, 31, v24
; SDAG-NEXT:    v_lshl_b64 v[23:24], v[23:24], 1
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v34, 31, v1
; SDAG-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v35, 31, v17
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; SDAG-NEXT:    v_or_b32_e32 v24, v26, v24
; SDAG-NEXT:    v_or_b32_e32 v23, v25, v23
; SDAG-NEXT:    v_or_b32_e32 v2, v2, v34
; SDAG-NEXT:    v_or_b32_e32 v0, v0, v35
; SDAG-NEXT:    v_or_b32_e32 v16, v16, v21
; SDAG-NEXT:    v_sub_i32_e32 v21, vcc, v30, v0
; SDAG-NEXT:    v_subb_u32_e32 v21, vcc, v31, v1, vcc
; SDAG-NEXT:    v_subb_u32_e32 v21, vcc, v32, v2, vcc
; SDAG-NEXT:    v_subb_u32_e32 v21, vcc, v33, v3, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v21, 31, v21
; SDAG-NEXT:    v_and_b32_e32 v25, v21, v8
; SDAG-NEXT:    v_and_b32_e32 v26, v21, v9
; SDAG-NEXT:    v_and_b32_e32 v34, v21, v10
; SDAG-NEXT:    v_and_b32_e32 v35, v21, v11
; SDAG-NEXT:    v_and_b32_e32 v21, 1, v21
; SDAG-NEXT:    v_sub_i32_e32 v0, vcc, v0, v25
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, v1, v26, vcc
; SDAG-NEXT:    v_subb_u32_e32 v2, vcc, v2, v34, vcc
; SDAG-NEXT:    v_subb_u32_e32 v3, vcc, v3, v35, vcc
; SDAG-NEXT:    v_add_i32_e32 v18, vcc, -1, v18
; SDAG-NEXT:    v_addc_u32_e32 v27, vcc, -1, v27, vcc
; SDAG-NEXT:    v_addc_u32_e32 v28, vcc, -1, v28, vcc
; SDAG-NEXT:    v_addc_u32_e32 v29, vcc, -1, v29, vcc
; SDAG-NEXT:    v_or_b32_e32 v25, v18, v28
; SDAG-NEXT:    v_or_b32_e32 v26, v27, v29
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[25:26]
; SDAG-NEXT:    v_or_b32_e32 v17, v20, v17
; SDAG-NEXT:    s_or_b64 s[12:13], vcc, s[12:13]
; SDAG-NEXT:    v_or_b32_e32 v16, v19, v16
; SDAG-NEXT:    v_mov_b32_e32 v26, v22
; SDAG-NEXT:    v_mov_b32_e32 v25, v21
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[12:13]
; SDAG-NEXT:    s_cbranch_execnz .LBB1_3
; SDAG-NEXT:  ; %bb.4: ; %Flow13
; SDAG-NEXT:    s_or_b64 exec, exec, s[12:13]
; SDAG-NEXT:  .LBB1_5: ; %Flow14
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:    v_lshl_b64 v[0:1], v[16:17], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v8, 31, v24
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[23:24], 1
; SDAG-NEXT:    v_or_b32_e32 v0, v0, v8
; SDAG-NEXT:    v_or_b32_e32 v16, v20, v1
; SDAG-NEXT:    v_or_b32_e32 v18, v22, v3
; SDAG-NEXT:    v_or_b32_e32 v17, v19, v0
; SDAG-NEXT:    v_or_b32_e32 v19, v21, v2
; SDAG-NEXT:  .LBB1_6: ; %Flow16
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_or_b32_e32 v1, v13, v15
; SDAG-NEXT:    v_or_b32_e32 v0, v12, v14
; SDAG-NEXT:    v_or_b32_e32 v3, v5, v7
; SDAG-NEXT:    v_or_b32_e32 v2, v4, v6
; SDAG-NEXT:    v_ffbh_u32_e32 v8, v14
; SDAG-NEXT:    v_ffbh_u32_e32 v9, v15
; SDAG-NEXT:    v_ffbh_u32_e32 v10, v12
; SDAG-NEXT:    v_ffbh_u32_e32 v11, v13
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v6
; SDAG-NEXT:    v_ffbh_u32_e32 v21, v7
; SDAG-NEXT:    v_ffbh_u32_e32 v22, v4
; SDAG-NEXT:    v_ffbh_u32_e32 v23, v5
; SDAG-NEXT:    v_mov_b32_e32 v24, 0
; SDAG-NEXT:    s_mov_b64 s[8:9], 0x7f
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[2:3]
; SDAG-NEXT:    v_add_i32_e64 v0, s[6:7], 32, v8
; SDAG-NEXT:    v_add_i32_e64 v1, s[6:7], 32, v10
; SDAG-NEXT:    v_add_i32_e64 v2, s[6:7], 32, v20
; SDAG-NEXT:    v_add_i32_e64 v3, s[6:7], 32, v22
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[4:5]
; SDAG-NEXT:    v_min_u32_e32 v0, v0, v9
; SDAG-NEXT:    v_min_u32_e32 v1, v1, v11
; SDAG-NEXT:    v_min_u32_e32 v2, v2, v21
; SDAG-NEXT:    v_min_u32_e32 v3, v3, v23
; SDAG-NEXT:    v_add_i32_e32 v1, vcc, 64, v1
; SDAG-NEXT:    v_addc_u32_e64 v8, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_add_i32_e32 v3, vcc, 64, v3
; SDAG-NEXT:    v_addc_u32_e64 v9, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[14:15]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v8, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; SDAG-NEXT:    v_cndmask_b32_e64 v1, v9, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; SDAG-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, v8, v1, vcc
; SDAG-NEXT:    v_xor_b32_e32 v8, 0x7f, v0
; SDAG-NEXT:    v_subbrev_u32_e32 v2, vcc, 0, v24, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[8:9], v[0:1]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v3, vcc, 0, v24, vcc
; SDAG-NEXT:    v_or_b32_e32 v8, v8, v2
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v9, v1, v3
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e32 v10, v11, v10, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; SDAG-NEXT:    v_and_b32_e32 v8, 1, v10
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v8
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v7, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v6, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, v5, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v11, v4, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB1_12
; SDAG-NEXT:  ; %bb.7: ; %udiv-bb1
; SDAG-NEXT:    v_add_i32_e32 v8, vcc, 1, v0
; SDAG-NEXT:    v_sub_i32_e64 v9, s[4:5], 63, v0
; SDAG-NEXT:    v_mov_b32_e32 v20, 0
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:    v_addc_u32_e32 v11, vcc, 0, v1, vcc
; SDAG-NEXT:    v_lshl_b64 v[9:10], v[4:5], v9
; SDAG-NEXT:    v_addc_u32_e32 v24, vcc, 0, v2, vcc
; SDAG-NEXT:    v_addc_u32_e32 v25, vcc, 0, v3, vcc
; SDAG-NEXT:    v_or_b32_e32 v1, v8, v24
; SDAG-NEXT:    v_sub_i32_e32 v3, vcc, 0x7f, v0
; SDAG-NEXT:    v_or_b32_e32 v2, v11, v25
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[6:7], v3
; SDAG-NEXT:    v_sub_i32_e32 v0, vcc, 64, v3
; SDAG-NEXT:    v_lshl_b64 v[26:27], v[4:5], v3
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[1:2]
; SDAG-NEXT:    v_lshr_b64 v[0:1], v[4:5], v0
; SDAG-NEXT:    v_or_b32_e32 v1, v23, v1
; SDAG-NEXT:    v_or_b32_e32 v0, v22, v0
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v3
; SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v1, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v9, v0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, v27, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, v26, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v3
; SDAG-NEXT:    v_cndmask_b32_e64 v3, v2, v7, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v2, v9, v6, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v9, 0
; SDAG-NEXT:    v_mov_b32_e32 v10, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB1_11
; SDAG-NEXT:  ; %bb.8: ; %udiv-preheader
; SDAG-NEXT:    v_lshr_b64 v[20:21], v[4:5], v8
; SDAG-NEXT:    v_sub_i32_e32 v27, vcc, 64, v8
; SDAG-NEXT:    v_subrev_i32_e32 v28, vcc, 64, v8
; SDAG-NEXT:    v_lshr_b64 v[29:30], v[6:7], v8
; SDAG-NEXT:    v_add_i32_e32 v26, vcc, -1, v12
; SDAG-NEXT:    s_mov_b64 s[10:11], 0
; SDAG-NEXT:    v_mov_b32_e32 v22, 0
; SDAG-NEXT:    v_mov_b32_e32 v23, 0
; SDAG-NEXT:    v_mov_b32_e32 v9, 0
; SDAG-NEXT:    v_mov_b32_e32 v10, 0
; SDAG-NEXT:    v_lshl_b64 v[31:32], v[6:7], v27
; SDAG-NEXT:    v_lshr_b64 v[6:7], v[6:7], v28
; SDAG-NEXT:    v_addc_u32_e32 v27, vcc, -1, v13, vcc
; SDAG-NEXT:    v_or_b32_e32 v21, v21, v32
; SDAG-NEXT:    v_or_b32_e32 v20, v20, v31
; SDAG-NEXT:    v_addc_u32_e32 v28, vcc, -1, v14, vcc
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v8
; SDAG-NEXT:    v_cndmask_b32_e64 v21, v7, v21, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, v6, v20, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v7, 0, v30, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v6, 0, v29, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v29, vcc, -1, v15, vcc
; SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v8
; SDAG-NEXT:    v_cndmask_b32_e32 v5, v21, v5, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v4, v20, v4, vcc
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:  .LBB1_9: ; %udiv-do-while
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshl_b64 v[6:7], v[6:7], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v20, 31, v5
; SDAG-NEXT:    v_lshl_b64 v[4:5], v[4:5], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v30, 31, v3
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v31, 31, v1
; SDAG-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; SDAG-NEXT:    v_or_b32_e32 v6, v6, v20
; SDAG-NEXT:    v_or_b32_e32 v4, v4, v30
; SDAG-NEXT:    v_or_b32_e32 v2, v2, v31
; SDAG-NEXT:    v_or_b32_e32 v3, v10, v3
; SDAG-NEXT:    v_or_b32_e32 v1, v23, v1
; SDAG-NEXT:    v_or_b32_e32 v2, v9, v2
; SDAG-NEXT:    v_sub_i32_e32 v20, vcc, v26, v4
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, v27, v5, vcc
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, v28, v6, vcc
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, v29, v7, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v23, 31, v20
; SDAG-NEXT:    v_and_b32_e32 v20, 1, v23
; SDAG-NEXT:    v_and_b32_e32 v30, v23, v15
; SDAG-NEXT:    v_and_b32_e32 v31, v23, v14
; SDAG-NEXT:    v_and_b32_e32 v32, v23, v13
; SDAG-NEXT:    v_and_b32_e32 v23, v23, v12
; SDAG-NEXT:    v_sub_i32_e32 v4, vcc, v4, v23
; SDAG-NEXT:    v_subb_u32_e32 v5, vcc, v5, v32, vcc
; SDAG-NEXT:    v_subb_u32_e32 v6, vcc, v6, v31, vcc
; SDAG-NEXT:    v_subb_u32_e32 v7, vcc, v7, v30, vcc
; SDAG-NEXT:    v_add_i32_e32 v8, vcc, -1, v8
; SDAG-NEXT:    v_addc_u32_e32 v11, vcc, -1, v11, vcc
; SDAG-NEXT:    v_addc_u32_e32 v24, vcc, -1, v24, vcc
; SDAG-NEXT:    v_addc_u32_e32 v25, vcc, -1, v25, vcc
; SDAG-NEXT:    v_or_b32_e32 v31, v11, v25
; SDAG-NEXT:    v_or_b32_e32 v30, v8, v24
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[30:31]
; SDAG-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; SDAG-NEXT:    v_or_b32_e32 v0, v22, v0
; SDAG-NEXT:    v_mov_b32_e32 v23, v21
; SDAG-NEXT:    v_mov_b32_e32 v22, v20
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; SDAG-NEXT:    s_cbranch_execnz .LBB1_9
; SDAG-NEXT:  ; %bb.10: ; %Flow
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:  .LBB1_11: ; %Flow11
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v4, 31, v1
; SDAG-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; SDAG-NEXT:    v_or_b32_e32 v2, v2, v4
; SDAG-NEXT:    v_or_b32_e32 v8, v10, v3
; SDAG-NEXT:    v_or_b32_e32 v10, v21, v1
; SDAG-NEXT:    v_or_b32_e32 v9, v9, v2
; SDAG-NEXT:    v_or_b32_e32 v11, v20, v0
; SDAG-NEXT:  .LBB1_12: ; %Flow12
; SDAG-NEXT:    s_or_b64 exec, exec, s[6:7]
; SDAG-NEXT:    v_mov_b32_e32 v0, v19
; SDAG-NEXT:    v_mov_b32_e32 v1, v18
; SDAG-NEXT:    v_mov_b32_e32 v2, v17
; SDAG-NEXT:    v_mov_b32_e32 v3, v16
; SDAG-NEXT:    v_mov_b32_e32 v4, v11
; SDAG-NEXT:    v_mov_b32_e32 v5, v10
; SDAG-NEXT:    v_mov_b32_e32 v6, v9
; SDAG-NEXT:    v_mov_b32_e32 v7, v8
; SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-LABEL: v_udiv_v2i128_vv:
; GISEL:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    v_mov_b32_e32 v16, v2
; GISEL-NEXT:    v_mov_b32_e32 v17, v3
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_or_b32_e32 v2, v8, v10
; GISEL-NEXT:    v_or_b32_e32 v3, v9, v11
; GISEL-NEXT:    v_or_b32_e32 v18, v0, v16
; GISEL-NEXT:    v_or_b32_e32 v19, v1, v17
; GISEL-NEXT:    v_ffbh_u32_e32 v20, v9
; GISEL-NEXT:    v_ffbh_u32_e32 v21, v8
; GISEL-NEXT:    v_ffbh_u32_e32 v22, v11
; GISEL-NEXT:    v_ffbh_u32_e32 v23, v10
; GISEL-NEXT:    v_ffbh_u32_e32 v26, v1
; GISEL-NEXT:    v_ffbh_u32_e32 v27, v0
; GISEL-NEXT:    v_ffbh_u32_e32 v28, v17
; GISEL-NEXT:    v_ffbh_u32_e32 v29, v16
; GISEL-NEXT:    v_mov_b32_e32 v24, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v25, 0
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[18:19]
; GISEL-NEXT:    v_add_i32_e64 v2, s[6:7], 32, v21
; GISEL-NEXT:    v_add_i32_e64 v3, s[6:7], 32, v23
; GISEL-NEXT:    v_add_i32_e64 v18, s[6:7], 32, v27
; GISEL-NEXT:    v_add_i32_e64 v19, s[6:7], 32, v29
; GISEL-NEXT:    v_min_u32_e32 v2, v20, v2
; GISEL-NEXT:    v_min_u32_e32 v3, v22, v3
; GISEL-NEXT:    v_min_u32_e32 v18, v26, v18
; GISEL-NEXT:    v_min_u32_e32 v19, v28, v19
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v26, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v2, vcc, 64, v2
; GISEL-NEXT:    v_add_i32_e32 v18, vcc, 64, v18
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v19, v18, vcc
; GISEL-NEXT:    v_sub_i32_e32 v20, vcc, v2, v3
; GISEL-NEXT:    v_subb_u32_e64 v21, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v22, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v23, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[20:21], v[24:25]
; GISEL-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v2, 0x7f, v20
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[22:23]
; GISEL-NEXT:    v_cndmask_b32_e64 v19, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v22
; GISEL-NEXT:    v_or_b32_e32 v3, v21, v23
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[22:23]
; GISEL-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v3, v26, v18
; GISEL-NEXT:    v_and_b32_e32 v18, 1, v3
; GISEL-NEXT:    v_or_b32_e32 v2, v3, v2
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GISEL-NEXT:    v_cndmask_b32_e64 v18, v0, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v24, 1, v2
; GISEL-NEXT:    v_cndmask_b32_e64 v19, v1, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v2, v16, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v3, v17, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v24
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB1_6
; GISEL-NEXT:  ; %bb.1: ; %udiv-bb15
; GISEL-NEXT:    v_add_i32_e32 v26, vcc, 1, v20
; GISEL-NEXT:    v_addc_u32_e64 v27, s[4:5], 0, v21, vcc
; GISEL-NEXT:    v_sub_i32_e32 v30, vcc, 0x7f, v20
; GISEL-NEXT:    v_addc_u32_e64 v28, vcc, 0, v22, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v29, vcc, 0, v23, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v22, s[4:5], 64, v30
; GISEL-NEXT:    v_sub_i32_e64 v20, s[4:5], 64, v30
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[0:1], v30
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[16:17], v30
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[20:21], v[0:1], v20
; GISEL-NEXT:    v_lshl_b64 v[24:25], v[0:1], v22
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v30
; GISEL-NEXT:    v_cndmask_b32_e32 v22, 0, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v23, 0, v3, vcc
; GISEL-NEXT:    v_or_b32_e32 v2, v20, v18
; GISEL-NEXT:    v_or_b32_e32 v3, v21, v19
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v24, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v25, v3, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v30
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v2, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v3, v17, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v21, s11
; GISEL-NEXT:    v_mov_b32_e32 v20, s10
; GISEL-NEXT:    v_mov_b32_e32 v19, s9
; GISEL-NEXT:    v_mov_b32_e32 v18, s8
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[8:9], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB1_5
; GISEL-NEXT:  ; %bb.2: ; %udiv-preheader4
; GISEL-NEXT:    v_subrev_i32_e32 v32, vcc, 64, v26
; GISEL-NEXT:    v_sub_i32_e32 v24, vcc, 64, v26
; GISEL-NEXT:    v_lshr_b64 v[18:19], v[16:17], v26
; GISEL-NEXT:    v_lshr_b64 v[20:21], v[0:1], v26
; GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GISEL-NEXT:    v_add_i32_e32 v30, vcc, -1, v8
; GISEL-NEXT:    v_addc_u32_e32 v31, vcc, -1, v9, vcc
; GISEL-NEXT:    v_lshl_b64 v[24:25], v[16:17], v24
; GISEL-NEXT:    v_lshr_b64 v[16:17], v[16:17], v32
; GISEL-NEXT:    v_addc_u32_e32 v32, vcc, -1, v10, vcc
; GISEL-NEXT:    v_addc_u32_e32 v33, vcc, -1, v11, vcc
; GISEL-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GISEL-NEXT:    v_or_b32_e32 v20, v20, v24
; GISEL-NEXT:    v_or_b32_e32 v21, v21, v25
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v20, v16, v20, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v21, v17, v21, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v16, 0, v18, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v17, 0, v19, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v24, v20, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v25, v21, v1, vcc
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    v_mov_b32_e32 v21, s7
; GISEL-NEXT:    v_mov_b32_e32 v20, s6
; GISEL-NEXT:    v_mov_b32_e32 v19, s5
; GISEL-NEXT:    v_mov_b32_e32 v18, s4
; GISEL-NEXT:  .LBB1_3: ; %udiv-do-while3
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshrrev_b32_e32 v34, 31, v23
; GISEL-NEXT:    v_lshl_b64 v[20:21], v[22:23], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v0, 31, v25
; GISEL-NEXT:    v_lshl_b64 v[24:25], v[24:25], 1
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v35, 31, v3
; GISEL-NEXT:    v_add_i32_e32 v26, vcc, -1, v26
; GISEL-NEXT:    v_addc_u32_e32 v27, vcc, -1, v27, vcc
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GISEL-NEXT:    v_or_b32_e32 v22, v18, v20
; GISEL-NEXT:    v_or_b32_e32 v23, v19, v21
; GISEL-NEXT:    v_or_b32_e32 v16, v16, v0
; GISEL-NEXT:    v_or_b32_e32 v20, v24, v35
; GISEL-NEXT:    v_addc_u32_e32 v28, vcc, -1, v28, vcc
; GISEL-NEXT:    v_addc_u32_e32 v29, vcc, -1, v29, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v30, v20
; GISEL-NEXT:    v_subb_u32_e32 v0, vcc, v31, v25, vcc
; GISEL-NEXT:    v_or_b32_e32 v18, v26, v28
; GISEL-NEXT:    v_or_b32_e32 v19, v27, v29
; GISEL-NEXT:    v_subb_u32_e32 v0, vcc, v32, v16, vcc
; GISEL-NEXT:    v_subb_u32_e32 v0, vcc, v33, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; GISEL-NEXT:    v_ashrrev_i32_e32 v0, 31, v0
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v18, v0, v8
; GISEL-NEXT:    v_and_b32_e32 v19, v0, v9
; GISEL-NEXT:    v_and_b32_e32 v21, v0, v10
; GISEL-NEXT:    v_and_b32_e32 v35, v0, v11
; GISEL-NEXT:    v_and_b32_e32 v0, 1, v0
; GISEL-NEXT:    v_sub_i32_e32 v24, vcc, v20, v18
; GISEL-NEXT:    v_subb_u32_e32 v25, vcc, v25, v19, vcc
; GISEL-NEXT:    v_subb_u32_e32 v16, vcc, v16, v21, vcc
; GISEL-NEXT:    v_subb_u32_e32 v17, vcc, v17, v35, vcc
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v34
; GISEL-NEXT:    v_mov_b32_e32 v19, v1
; GISEL-NEXT:    v_mov_b32_e32 v18, v0
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GISEL-NEXT:    s_cbranch_execnz .LBB1_3
; GISEL-NEXT:  ; %bb.4: ; %Flow13
; GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GISEL-NEXT:  .LBB1_5: ; %Flow14
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:    v_lshl_b64 v[0:1], v[22:23], 1
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v8, 31, v23
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v8
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v0
; GISEL-NEXT:    v_or_b32_e32 v19, v19, v1
; GISEL-NEXT:  .LBB1_6: ; %Flow16
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_or_b32_e32 v0, v12, v14
; GISEL-NEXT:    v_or_b32_e32 v1, v13, v15
; GISEL-NEXT:    v_or_b32_e32 v8, v4, v6
; GISEL-NEXT:    v_or_b32_e32 v9, v5, v7
; GISEL-NEXT:    v_ffbh_u32_e32 v16, v13
; GISEL-NEXT:    v_ffbh_u32_e32 v17, v12
; GISEL-NEXT:    v_ffbh_u32_e32 v20, v15
; GISEL-NEXT:    v_ffbh_u32_e32 v21, v14
; GISEL-NEXT:    v_ffbh_u32_e32 v22, v5
; GISEL-NEXT:    v_ffbh_u32_e32 v23, v4
; GISEL-NEXT:    v_ffbh_u32_e32 v24, v7
; GISEL-NEXT:    v_ffbh_u32_e32 v25, v6
; GISEL-NEXT:    v_mov_b32_e32 v10, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v11, 0
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[8:9]
; GISEL-NEXT:    v_add_i32_e64 v0, s[6:7], 32, v17
; GISEL-NEXT:    v_add_i32_e64 v1, s[6:7], 32, v21
; GISEL-NEXT:    v_add_i32_e64 v8, s[6:7], 32, v23
; GISEL-NEXT:    v_add_i32_e64 v9, s[6:7], 32, v25
; GISEL-NEXT:    v_min_u32_e32 v0, v16, v0
; GISEL-NEXT:    v_min_u32_e32 v1, v20, v1
; GISEL-NEXT:    v_min_u32_e32 v8, v22, v8
; GISEL-NEXT:    v_min_u32_e32 v9, v24, v9
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v20, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v0, vcc, 64, v0
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, 64, v8
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v8, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GISEL-NEXT:    v_subb_u32_e64 v1, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v16, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v17, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[0:1], v[10:11]
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v8, 0x7f, v0
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[16:17]
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v8, v8, v16
; GISEL-NEXT:    v_or_b32_e32 v9, v1, v17
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; GISEL-NEXT:    v_cndmask_b32_e32 v10, v11, v10, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v9, v20, v10
; GISEL-NEXT:    v_and_b32_e32 v10, 1, v9
; GISEL-NEXT:    v_or_b32_e32 v8, v9, v8
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v10, v4, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v20, 1, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v11, v5, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v8, v6, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v9, v7, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB1_12
; GISEL-NEXT:  ; %bb.7: ; %udiv-bb1
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, 1, v0
; GISEL-NEXT:    v_addc_u32_e64 v11, s[4:5], 0, v1, vcc
; GISEL-NEXT:    v_sub_i32_e32 v26, vcc, 0x7f, v0
; GISEL-NEXT:    v_addc_u32_e64 v24, vcc, 0, v16, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v25, vcc, 0, v17, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v9, s[4:5], 64, v26
; GISEL-NEXT:    v_sub_i32_e64 v10, s[4:5], 64, v26
; GISEL-NEXT:    v_lshl_b64 v[0:1], v[4:5], v26
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[6:7], v26
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[20:21], v[4:5], v10
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[4:5], v9
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v9, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v10, 0, v1, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v20, v16
; GISEL-NEXT:    v_or_b32_e32 v1, v21, v17
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v22, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v23, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v23, s11
; GISEL-NEXT:    v_mov_b32_e32 v22, s10
; GISEL-NEXT:    v_mov_b32_e32 v21, s9
; GISEL-NEXT:    v_mov_b32_e32 v20, s8
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[8:9], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB1_11
; GISEL-NEXT:  ; %bb.8: ; %udiv-preheader
; GISEL-NEXT:    v_subrev_i32_e32 v28, vcc, 64, v8
; GISEL-NEXT:    v_sub_i32_e32 v22, vcc, 64, v8
; GISEL-NEXT:    v_lshr_b64 v[16:17], v[6:7], v8
; GISEL-NEXT:    v_lshr_b64 v[20:21], v[4:5], v8
; GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GISEL-NEXT:    v_add_i32_e32 v26, vcc, -1, v12
; GISEL-NEXT:    v_addc_u32_e32 v27, vcc, -1, v13, vcc
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[6:7], v22
; GISEL-NEXT:    v_lshr_b64 v[6:7], v[6:7], v28
; GISEL-NEXT:    v_addc_u32_e32 v28, vcc, -1, v14, vcc
; GISEL-NEXT:    v_addc_u32_e32 v29, vcc, -1, v15, vcc
; GISEL-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GISEL-NEXT:    v_or_b32_e32 v20, v20, v22
; GISEL-NEXT:    v_or_b32_e32 v21, v21, v23
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v8
; GISEL-NEXT:    v_cndmask_b32_e32 v6, v6, v20, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v7, v7, v21, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v16, 0, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v17, 0, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v8
; GISEL-NEXT:    v_cndmask_b32_e32 v6, v6, v4, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v7, v7, v5, vcc
; GISEL-NEXT:    v_mov_b32_e32 v5, 0
; GISEL-NEXT:    v_mov_b32_e32 v23, s7
; GISEL-NEXT:    v_mov_b32_e32 v22, s6
; GISEL-NEXT:    v_mov_b32_e32 v21, s5
; GISEL-NEXT:    v_mov_b32_e32 v20, s4
; GISEL-NEXT:  .LBB1_9: ; %udiv-do-while
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[6:7], 1
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v4, 31, v7
; GISEL-NEXT:    v_lshrrev_b32_e32 v30, 31, v1
; GISEL-NEXT:    v_lshl_b64 v[6:7], v[9:10], 1
; GISEL-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v9, 31, v10
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, -1, v8
; GISEL-NEXT:    v_addc_u32_e32 v11, vcc, -1, v11, vcc
; GISEL-NEXT:    v_or_b32_e32 v16, v16, v4
; GISEL-NEXT:    v_or_b32_e32 v22, v22, v30
; GISEL-NEXT:    v_or_b32_e32 v0, v0, v9
; GISEL-NEXT:    v_or_b32_e32 v9, v20, v6
; GISEL-NEXT:    v_or_b32_e32 v10, v21, v7
; GISEL-NEXT:    v_addc_u32_e32 v24, vcc, -1, v24, vcc
; GISEL-NEXT:    v_addc_u32_e32 v25, vcc, -1, v25, vcc
; GISEL-NEXT:    v_sub_i32_e32 v4, vcc, v26, v22
; GISEL-NEXT:    v_subb_u32_e32 v4, vcc, v27, v23, vcc
; GISEL-NEXT:    v_or_b32_e32 v6, v8, v24
; GISEL-NEXT:    v_or_b32_e32 v7, v11, v25
; GISEL-NEXT:    v_subb_u32_e32 v4, vcc, v28, v16, vcc
; GISEL-NEXT:    v_subb_u32_e32 v4, vcc, v29, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GISEL-NEXT:    v_ashrrev_i32_e32 v6, 31, v4
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v4, 1, v6
; GISEL-NEXT:    v_and_b32_e32 v7, v6, v12
; GISEL-NEXT:    v_and_b32_e32 v30, v6, v13
; GISEL-NEXT:    v_and_b32_e32 v31, v6, v14
; GISEL-NEXT:    v_and_b32_e32 v32, v6, v15
; GISEL-NEXT:    v_mov_b32_e32 v21, v5
; GISEL-NEXT:    v_mov_b32_e32 v20, v4
; GISEL-NEXT:    v_sub_i32_e32 v6, vcc, v22, v7
; GISEL-NEXT:    v_subb_u32_e32 v7, vcc, v23, v30, vcc
; GISEL-NEXT:    v_subb_u32_e32 v16, vcc, v16, v31, vcc
; GISEL-NEXT:    v_subb_u32_e32 v17, vcc, v17, v32, vcc
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GISEL-NEXT:    s_cbranch_execnz .LBB1_9
; GISEL-NEXT:  ; %bb.10: ; %Flow
; GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GISEL-NEXT:  .LBB1_11: ; %Flow11
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:    v_lshl_b64 v[4:5], v[9:10], 1
; GISEL-NEXT:    v_lshl_b64 v[8:9], v[0:1], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v0, 31, v10
; GISEL-NEXT:    v_or_b32_e32 v8, v8, v0
; GISEL-NEXT:    v_or_b32_e32 v10, v20, v4
; GISEL-NEXT:    v_or_b32_e32 v11, v21, v5
; GISEL-NEXT:  .LBB1_12: ; %Flow12
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    v_mov_b32_e32 v0, v18
; GISEL-NEXT:    v_mov_b32_e32 v1, v19
; GISEL-NEXT:    v_mov_b32_e32 v4, v10
; GISEL-NEXT:    v_mov_b32_e32 v5, v11
; GISEL-NEXT:    v_mov_b32_e32 v6, v8
; GISEL-NEXT:    v_mov_b32_e32 v7, v9
; GISEL-NEXT:    s_setpc_b64 s[30:31]
  %shl = udiv <2 x i128> %lhs, %rhs
  ret <2 x i128> %shl
}

define <2 x i128> @v_srem_v2i128_vv(<2 x i128> %lhs, <2 x i128> %rhs) {
; SDAG-LABEL: v_srem_v2i128_vv:
; SDAG:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; SDAG-NEXT:    v_ashrrev_i32_e32 v28, 31, v3
; SDAG-NEXT:    v_sub_i32_e32 v16, vcc, 0, v0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    s_mov_b64 s[10:11], 0x7f
; SDAG-NEXT:    v_mov_b32_e32 v29, v28
; SDAG-NEXT:    v_subb_u32_e32 v17, vcc, 0, v1, vcc
; SDAG-NEXT:    v_subb_u32_e32 v18, vcc, 0, v2, vcc
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v1, v17, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, v0, v16, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, 0, v3, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v0, v2, v18, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v18, v16
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v17
; SDAG-NEXT:    v_cndmask_b32_e64 v1, v3, v1, s[4:5]
; SDAG-NEXT:    v_sub_i32_e32 v21, vcc, 0, v8
; SDAG-NEXT:    v_or_b32_e32 v2, v16, v0
; SDAG-NEXT:    v_ffbh_u32_e32 v22, v0
; SDAG-NEXT:    v_add_i32_e64 v18, s[4:5], 32, v18
; SDAG-NEXT:    v_subb_u32_e32 v23, vcc, 0, v9, vcc
; SDAG-NEXT:    v_or_b32_e32 v3, v17, v1
; SDAG-NEXT:    v_add_i32_e64 v22, s[4:5], 32, v22
; SDAG-NEXT:    v_ffbh_u32_e32 v24, v1
; SDAG-NEXT:    v_min_u32_e32 v18, v18, v20
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, 0, v10, vcc
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[10:11]
; SDAG-NEXT:    v_cndmask_b32_e64 v30, v9, v23, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v31, v8, v21, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[2:3]
; SDAG-NEXT:    v_min_u32_e32 v3, v22, v24
; SDAG-NEXT:    v_add_i32_e64 v8, s[8:9], 64, v18
; SDAG-NEXT:    v_addc_u32_e64 v9, s[8:9], 0, 0, s[8:9]
; SDAG-NEXT:    v_subb_u32_e32 v18, vcc, 0, v11, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v2, v10, v20, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v10, v31
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v30
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; SDAG-NEXT:    v_cndmask_b32_e64 v21, v9, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v22, v8, v3, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v3, v11, v18, s[4:5]
; SDAG-NEXT:    v_or_b32_e32 v8, v31, v2
; SDAG-NEXT:    v_ffbh_u32_e32 v11, v2
; SDAG-NEXT:    v_add_i32_e32 v10, vcc, 32, v10
; SDAG-NEXT:    v_or_b32_e32 v9, v30, v3
; SDAG-NEXT:    v_add_i32_e32 v11, vcc, 32, v11
; SDAG-NEXT:    v_ffbh_u32_e32 v18, v3
; SDAG-NEXT:    v_min_u32_e32 v10, v10, v20
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; SDAG-NEXT:    v_min_u32_e32 v8, v11, v18
; SDAG-NEXT:    v_add_i32_e64 v9, s[4:5], 64, v10
; SDAG-NEXT:    v_addc_u32_e64 v10, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, v10, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; SDAG-NEXT:    v_sub_i32_e32 v8, vcc, v8, v22
; SDAG-NEXT:    v_subb_u32_e32 v9, vcc, v10, v21, vcc
; SDAG-NEXT:    v_xor_b32_e32 v10, 0x7f, v8
; SDAG-NEXT:    v_subbrev_u32_e32 v18, vcc, 0, v19, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[10:11], v[8:9]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v19, vcc, 0, v19, vcc
; SDAG-NEXT:    v_or_b32_e32 v10, v10, v18
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_cndmask_b32_e64 v21, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v11, v9, v19
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_cndmask_b32_e32 v20, v21, v20, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; SDAG-NEXT:    v_and_b32_e32 v10, 1, v20
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v10
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v35, v1, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v32, v0, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v27, v17, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v33, v16, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB2_6
; SDAG-NEXT:  ; %bb.1: ; %udiv-bb15
; SDAG-NEXT:    v_add_i32_e32 v32, vcc, 1, v8
; SDAG-NEXT:    v_sub_i32_e64 v20, s[4:5], 63, v8
; SDAG-NEXT:    v_mov_b32_e32 v10, 0
; SDAG-NEXT:    v_mov_b32_e32 v11, 0
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, 0, v9, vcc
; SDAG-NEXT:    v_lshl_b64 v[20:21], v[16:17], v20
; SDAG-NEXT:    v_addc_u32_e32 v34, vcc, 0, v18, vcc
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, 0, v19, vcc
; SDAG-NEXT:    v_or_b32_e32 v18, v32, v34
; SDAG-NEXT:    v_sub_i32_e32 v24, vcc, 0x7f, v8
; SDAG-NEXT:    v_or_b32_e32 v19, v33, v35
; SDAG-NEXT:    v_lshl_b64 v[8:9], v[0:1], v24
; SDAG-NEXT:    v_sub_i32_e32 v25, vcc, 64, v24
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[16:17], v24
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_lshr_b64 v[18:19], v[16:17], v25
; SDAG-NEXT:    v_or_b32_e32 v9, v9, v19
; SDAG-NEXT:    v_or_b32_e32 v8, v8, v18
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v24
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v21, v9, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v20, v8, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v21, 0, v23, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, 0, v22, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v24
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v9, v1, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v8, v0, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB2_5
; SDAG-NEXT:  ; %bb.2: ; %udiv-preheader4
; SDAG-NEXT:    v_lshr_b64 v[10:11], v[16:17], v32
; SDAG-NEXT:    v_sub_i32_e32 v26, vcc, 64, v32
; SDAG-NEXT:    v_subrev_i32_e32 v37, vcc, 64, v32
; SDAG-NEXT:    v_lshr_b64 v[24:25], v[0:1], v32
; SDAG-NEXT:    v_add_i32_e32 v36, vcc, -1, v31
; SDAG-NEXT:    s_mov_b64 s[10:11], 0
; SDAG-NEXT:    v_mov_b32_e32 v22, 0
; SDAG-NEXT:    v_mov_b32_e32 v23, 0
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    v_lshl_b64 v[26:27], v[0:1], v26
; SDAG-NEXT:    v_lshr_b64 v[48:49], v[0:1], v37
; SDAG-NEXT:    v_addc_u32_e32 v37, vcc, -1, v30, vcc
; SDAG-NEXT:    v_or_b32_e32 v11, v11, v27
; SDAG-NEXT:    v_or_b32_e32 v10, v10, v26
; SDAG-NEXT:    v_addc_u32_e32 v38, vcc, -1, v2, vcc
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v32
; SDAG-NEXT:    v_cndmask_b32_e64 v11, v49, v11, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, v48, v10, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v27, 0, v25, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v26, 0, v24, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v39, vcc, -1, v3, vcc
; SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v32
; SDAG-NEXT:    v_cndmask_b32_e32 v25, v11, v17, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v24, v10, v16, vcc
; SDAG-NEXT:    v_mov_b32_e32 v11, 0
; SDAG-NEXT:  .LBB2_3: ; %udiv-do-while3
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshl_b64 v[26:27], v[26:27], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v10, 31, v25
; SDAG-NEXT:    v_lshl_b64 v[24:25], v[24:25], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v48, 31, v9
; SDAG-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v49, 31, v21
; SDAG-NEXT:    v_lshl_b64 v[20:21], v[20:21], 1
; SDAG-NEXT:    v_or_b32_e32 v26, v26, v10
; SDAG-NEXT:    v_or_b32_e32 v24, v24, v48
; SDAG-NEXT:    v_or_b32_e32 v8, v8, v49
; SDAG-NEXT:    v_or_b32_e32 v9, v19, v9
; SDAG-NEXT:    v_sub_i32_e32 v10, vcc, v36, v24
; SDAG-NEXT:    v_or_b32_e32 v8, v18, v8
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v37, v25, vcc
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v38, v26, vcc
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, v39, v27, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v10, 31, v10
; SDAG-NEXT:    v_and_b32_e32 v48, v10, v31
; SDAG-NEXT:    v_and_b32_e32 v49, v10, v30
; SDAG-NEXT:    v_and_b32_e32 v50, v10, v2
; SDAG-NEXT:    v_and_b32_e32 v51, v10, v3
; SDAG-NEXT:    v_and_b32_e32 v10, 1, v10
; SDAG-NEXT:    v_sub_i32_e32 v24, vcc, v24, v48
; SDAG-NEXT:    v_subb_u32_e32 v25, vcc, v25, v49, vcc
; SDAG-NEXT:    v_subb_u32_e32 v26, vcc, v26, v50, vcc
; SDAG-NEXT:    v_subb_u32_e32 v27, vcc, v27, v51, vcc
; SDAG-NEXT:    v_add_i32_e32 v32, vcc, -1, v32
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, -1, v33, vcc
; SDAG-NEXT:    v_addc_u32_e32 v34, vcc, -1, v34, vcc
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, -1, v35, vcc
; SDAG-NEXT:    v_or_b32_e32 v48, v32, v34
; SDAG-NEXT:    v_or_b32_e32 v49, v33, v35
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[48:49]
; SDAG-NEXT:    v_or_b32_e32 v21, v23, v21
; SDAG-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; SDAG-NEXT:    v_or_b32_e32 v20, v22, v20
; SDAG-NEXT:    v_mov_b32_e32 v23, v11
; SDAG-NEXT:    v_mov_b32_e32 v22, v10
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; SDAG-NEXT:    s_cbranch_execnz .LBB2_3
; SDAG-NEXT:  ; %bb.4: ; %Flow13
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:  .LBB2_5: ; %Flow14
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v22, 31, v21
; SDAG-NEXT:    v_lshl_b64 v[20:21], v[20:21], 1
; SDAG-NEXT:    v_or_b32_e32 v8, v8, v22
; SDAG-NEXT:    v_or_b32_e32 v35, v19, v9
; SDAG-NEXT:    v_or_b32_e32 v27, v11, v21
; SDAG-NEXT:    v_or_b32_e32 v32, v18, v8
; SDAG-NEXT:    v_or_b32_e32 v33, v10, v20
; SDAG-NEXT:  .LBB2_6: ; %Flow16
; SDAG-NEXT:    s_or_b64 exec, exec, s[6:7]
; SDAG-NEXT:    v_ashrrev_i32_e32 v26, 31, v7
; SDAG-NEXT:    v_sub_i32_e32 v8, vcc, 0, v4
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    s_mov_b64 s[10:11], 0x7f
; SDAG-NEXT:    v_mov_b32_e32 v34, v26
; SDAG-NEXT:    v_subb_u32_e32 v9, vcc, 0, v5, vcc
; SDAG-NEXT:    v_subb_u32_e32 v10, vcc, 0, v6, vcc
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[6:7]
; SDAG-NEXT:    v_cndmask_b32_e64 v9, v5, v9, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v8, v4, v8, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v5, vcc, 0, v7, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v4, v6, v10, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v10, v8
; SDAG-NEXT:    v_ffbh_u32_e32 v11, v9
; SDAG-NEXT:    v_cndmask_b32_e64 v5, v7, v5, s[4:5]
; SDAG-NEXT:    v_sub_i32_e32 v19, vcc, 0, v12
; SDAG-NEXT:    v_or_b32_e32 v6, v8, v4
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v4
; SDAG-NEXT:    v_add_i32_e64 v10, s[4:5], 32, v10
; SDAG-NEXT:    v_subb_u32_e32 v21, vcc, 0, v13, vcc
; SDAG-NEXT:    v_or_b32_e32 v7, v9, v5
; SDAG-NEXT:    v_add_i32_e64 v20, s[4:5], 32, v20
; SDAG-NEXT:    v_ffbh_u32_e32 v22, v5
; SDAG-NEXT:    v_min_u32_e32 v10, v10, v11
; SDAG-NEXT:    v_subb_u32_e32 v11, vcc, 0, v14, vcc
; SDAG-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[14:15]
; SDAG-NEXT:    v_cndmask_b32_e64 v36, v13, v21, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v37, v12, v19, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[6:7]
; SDAG-NEXT:    v_min_u32_e32 v7, v20, v22
; SDAG-NEXT:    v_add_i32_e64 v10, s[8:9], 64, v10
; SDAG-NEXT:    v_addc_u32_e64 v12, s[8:9], 0, 0, s[8:9]
; SDAG-NEXT:    v_subb_u32_e32 v13, vcc, 0, v15, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v6, v14, v11, s[4:5]
; SDAG-NEXT:    v_ffbh_u32_e32 v11, v37
; SDAG-NEXT:    v_ffbh_u32_e32 v14, v36
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v12, v12, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v19, v10, v7, vcc
; SDAG-NEXT:    v_cndmask_b32_e64 v7, v15, v13, s[4:5]
; SDAG-NEXT:    v_or_b32_e32 v10, v37, v6
; SDAG-NEXT:    v_ffbh_u32_e32 v13, v6
; SDAG-NEXT:    v_add_i32_e32 v15, vcc, 32, v11
; SDAG-NEXT:    v_or_b32_e32 v11, v36, v7
; SDAG-NEXT:    v_add_i32_e32 v13, vcc, 32, v13
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v7
; SDAG-NEXT:    v_min_u32_e32 v14, v15, v14
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; SDAG-NEXT:    v_min_u32_e32 v10, v13, v20
; SDAG-NEXT:    v_add_i32_e64 v11, s[4:5], 64, v14
; SDAG-NEXT:    v_addc_u32_e64 v13, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; SDAG-NEXT:    v_cndmask_b32_e64 v13, v13, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v10, v11, v10, vcc
; SDAG-NEXT:    v_sub_i32_e32 v10, vcc, v10, v19
; SDAG-NEXT:    v_subb_u32_e32 v11, vcc, v13, v12, vcc
; SDAG-NEXT:    v_xor_b32_e32 v14, 0x7f, v10
; SDAG-NEXT:    v_subbrev_u32_e32 v12, vcc, 0, v18, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[10:11], v[10:11]
; SDAG-NEXT:    v_cndmask_b32_e64 v19, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v13, vcc, 0, v18, vcc
; SDAG-NEXT:    v_or_b32_e32 v14, v14, v12
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[12:13]
; SDAG-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v15, v11, v13
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[12:13]
; SDAG-NEXT:    v_cndmask_b32_e32 v18, v18, v19, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[14:15]
; SDAG-NEXT:    v_and_b32_e32 v14, 1, v18
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v14
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v19, v5, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v18, v4, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v15, v9, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v14, v8, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB2_12
; SDAG-NEXT:  ; %bb.7: ; %udiv-bb1
; SDAG-NEXT:    v_add_i32_e32 v38, vcc, 1, v10
; SDAG-NEXT:    v_sub_i32_e64 v18, s[4:5], 63, v10
; SDAG-NEXT:    v_mov_b32_e32 v14, 0
; SDAG-NEXT:    v_mov_b32_e32 v15, 0
; SDAG-NEXT:    v_addc_u32_e32 v39, vcc, 0, v11, vcc
; SDAG-NEXT:    v_lshl_b64 v[18:19], v[8:9], v18
; SDAG-NEXT:    v_addc_u32_e32 v48, vcc, 0, v12, vcc
; SDAG-NEXT:    v_addc_u32_e32 v49, vcc, 0, v13, vcc
; SDAG-NEXT:    v_or_b32_e32 v11, v38, v48
; SDAG-NEXT:    v_sub_i32_e32 v13, vcc, 0x7f, v10
; SDAG-NEXT:    v_or_b32_e32 v12, v39, v49
; SDAG-NEXT:    v_lshl_b64 v[20:21], v[4:5], v13
; SDAG-NEXT:    v_sub_i32_e32 v10, vcc, 64, v13
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[8:9], v13
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[11:12]
; SDAG-NEXT:    v_lshr_b64 v[10:11], v[8:9], v10
; SDAG-NEXT:    v_or_b32_e32 v11, v21, v11
; SDAG-NEXT:    v_or_b32_e32 v10, v20, v10
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v13
; SDAG-NEXT:    v_cndmask_b32_e64 v12, v19, v11, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v18, v18, v10, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v11, 0, v23, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v10, 0, v22, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v13
; SDAG-NEXT:    v_cndmask_b32_e64 v13, v12, v5, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v12, v18, v4, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB2_11
; SDAG-NEXT:  ; %bb.8: ; %udiv-preheader
; SDAG-NEXT:    v_lshr_b64 v[14:15], v[8:9], v38
; SDAG-NEXT:    v_sub_i32_e32 v24, vcc, 64, v38
; SDAG-NEXT:    v_subrev_i32_e32 v51, vcc, 64, v38
; SDAG-NEXT:    v_lshr_b64 v[22:23], v[4:5], v38
; SDAG-NEXT:    v_add_i32_e32 v50, vcc, -1, v37
; SDAG-NEXT:    s_mov_b64 s[10:11], 0
; SDAG-NEXT:    v_mov_b32_e32 v20, 0
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    v_lshl_b64 v[24:25], v[4:5], v24
; SDAG-NEXT:    v_lshr_b64 v[53:54], v[4:5], v51
; SDAG-NEXT:    v_addc_u32_e32 v51, vcc, -1, v36, vcc
; SDAG-NEXT:    v_or_b32_e32 v15, v15, v25
; SDAG-NEXT:    v_or_b32_e32 v14, v14, v24
; SDAG-NEXT:    v_addc_u32_e32 v52, vcc, -1, v6, vcc
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v38
; SDAG-NEXT:    v_cndmask_b32_e64 v15, v54, v15, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v14, v53, v14, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v25, 0, v23, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v24, 0, v22, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v53, vcc, -1, v7, vcc
; SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v38
; SDAG-NEXT:    v_cndmask_b32_e32 v23, v15, v9, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v22, v14, v8, vcc
; SDAG-NEXT:    v_mov_b32_e32 v15, 0
; SDAG-NEXT:  .LBB2_9: ; %udiv-do-while
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshl_b64 v[24:25], v[24:25], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v14, 31, v23
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[22:23], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v54, 31, v13
; SDAG-NEXT:    v_lshl_b64 v[12:13], v[12:13], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v55, 31, v11
; SDAG-NEXT:    v_lshl_b64 v[10:11], v[10:11], 1
; SDAG-NEXT:    v_or_b32_e32 v24, v24, v14
; SDAG-NEXT:    v_or_b32_e32 v22, v22, v54
; SDAG-NEXT:    v_or_b32_e32 v12, v12, v55
; SDAG-NEXT:    v_or_b32_e32 v13, v19, v13
; SDAG-NEXT:    v_or_b32_e32 v11, v21, v11
; SDAG-NEXT:    v_or_b32_e32 v12, v18, v12
; SDAG-NEXT:    v_sub_i32_e32 v14, vcc, v50, v22
; SDAG-NEXT:    v_subb_u32_e32 v14, vcc, v51, v23, vcc
; SDAG-NEXT:    v_subb_u32_e32 v14, vcc, v52, v24, vcc
; SDAG-NEXT:    v_subb_u32_e32 v14, vcc, v53, v25, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v21, 31, v14
; SDAG-NEXT:    v_and_b32_e32 v14, 1, v21
; SDAG-NEXT:    v_and_b32_e32 v54, v21, v7
; SDAG-NEXT:    v_and_b32_e32 v55, v21, v6
; SDAG-NEXT:    v_and_b32_e32 v40, v21, v36
; SDAG-NEXT:    v_and_b32_e32 v21, v21, v37
; SDAG-NEXT:    v_sub_i32_e32 v22, vcc, v22, v21
; SDAG-NEXT:    v_subb_u32_e32 v23, vcc, v23, v40, vcc
; SDAG-NEXT:    v_subb_u32_e32 v24, vcc, v24, v55, vcc
; SDAG-NEXT:    v_subb_u32_e32 v25, vcc, v25, v54, vcc
; SDAG-NEXT:    v_add_i32_e32 v38, vcc, -1, v38
; SDAG-NEXT:    v_addc_u32_e32 v39, vcc, -1, v39, vcc
; SDAG-NEXT:    v_addc_u32_e32 v48, vcc, -1, v48, vcc
; SDAG-NEXT:    v_addc_u32_e32 v49, vcc, -1, v49, vcc
; SDAG-NEXT:    v_or_b32_e32 v55, v39, v49
; SDAG-NEXT:    v_or_b32_e32 v54, v38, v48
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[54:55]
; SDAG-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; SDAG-NEXT:    v_or_b32_e32 v10, v20, v10
; SDAG-NEXT:    v_mov_b32_e32 v21, v15
; SDAG-NEXT:    v_mov_b32_e32 v20, v14
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; SDAG-NEXT:    s_cbranch_execnz .LBB2_9
; SDAG-NEXT:  ; %bb.10: ; %Flow
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:  .LBB2_11: ; %Flow11
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_lshl_b64 v[12:13], v[12:13], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v20, 31, v11
; SDAG-NEXT:    v_lshl_b64 v[10:11], v[10:11], 1
; SDAG-NEXT:    v_or_b32_e32 v12, v12, v20
; SDAG-NEXT:    v_or_b32_e32 v19, v19, v13
; SDAG-NEXT:    v_or_b32_e32 v15, v15, v11
; SDAG-NEXT:    v_or_b32_e32 v18, v18, v12
; SDAG-NEXT:    v_or_b32_e32 v14, v14, v10
; SDAG-NEXT:  .LBB2_12: ; %Flow12
; SDAG-NEXT:    s_or_b64 exec, exec, s[6:7]
; SDAG-NEXT:    v_mul_lo_u32 v12, v33, v3
; SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v33, v2, 0
; SDAG-NEXT:    v_mul_lo_u32 v24, v27, v2
; SDAG-NEXT:    v_mul_lo_u32 v35, v35, v31
; SDAG-NEXT:    v_mul_lo_u32 v38, v32, v30
; SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v31, v33, 0
; SDAG-NEXT:    v_mov_b32_e32 v13, 0
; SDAG-NEXT:    v_mul_lo_u32 v25, v14, v7
; SDAG-NEXT:    v_mad_u64_u32 v[20:21], s[4:5], v14, v6, 0
; SDAG-NEXT:    v_mul_lo_u32 v39, v15, v6
; SDAG-NEXT:    v_mul_lo_u32 v19, v19, v37
; SDAG-NEXT:    v_mul_lo_u32 v48, v18, v36
; SDAG-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v37, v14, 0
; SDAG-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; SDAG-NEXT:    v_mov_b32_e32 v12, v3
; SDAG-NEXT:    v_mad_u64_u32 v[22:23], s[4:5], v30, v33, v[12:13]
; SDAG-NEXT:    v_sub_i32_e32 v12, vcc, v16, v2
; SDAG-NEXT:    v_add_i32_e64 v16, s[4:5], v21, v25
; SDAG-NEXT:    v_add_i32_e64 v11, s[4:5], v11, v24
; SDAG-NEXT:    v_mov_b32_e32 v24, v23
; SDAG-NEXT:    v_mov_b32_e32 v23, v13
; SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v31, v27, v[22:23]
; SDAG-NEXT:    v_xor_b32_e32 v33, v12, v28
; SDAG-NEXT:    v_add_i32_e64 v21, s[4:5], v16, v39
; SDAG-NEXT:    v_mov_b32_e32 v12, v7
; SDAG-NEXT:    v_mad_u64_u32 v[22:23], s[4:5], v36, v14, v[12:13]
; SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v32, v31, v[10:11]
; SDAG-NEXT:    v_add_i32_e64 v24, s[4:5], v24, v3
; SDAG-NEXT:    v_addc_u32_e64 v25, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v7, vcc, v17, v2, vcc
; SDAG-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v18, v37, v[20:21]
; SDAG-NEXT:    v_mov_b32_e32 v14, v23
; SDAG-NEXT:    v_mov_b32_e32 v23, v13
; SDAG-NEXT:    v_mad_u64_u32 v[12:13], s[4:5], v37, v15, v[22:23]
; SDAG-NEXT:    v_add_i32_e64 v11, s[4:5], v35, v11
; SDAG-NEXT:    v_mad_u64_u32 v[16:17], s[4:5], v30, v27, v[24:25]
; SDAG-NEXT:    v_xor_b32_e32 v7, v7, v29
; SDAG-NEXT:    v_add_i32_e64 v3, s[4:5], v19, v3
; SDAG-NEXT:    v_add_i32_e64 v13, s[4:5], v14, v13
; SDAG-NEXT:    v_addc_u32_e64 v14, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v18, v12
; SDAG-NEXT:    v_add_i32_e64 v19, s[4:5], v38, v11
; SDAG-NEXT:    v_add_i32_e64 v3, s[4:5], v48, v3
; SDAG-NEXT:    v_mad_u64_u32 v[11:12], s[4:5], v36, v15, v[13:14]
; SDAG-NEXT:    v_add_i32_e64 v10, s[4:5], v16, v10
; SDAG-NEXT:    v_addc_u32_e64 v13, s[4:5], v17, v19, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v0, vcc, v0, v10, vcc
; SDAG-NEXT:    v_add_i32_e64 v10, s[4:5], v11, v2
; SDAG-NEXT:    v_addc_u32_e64 v11, s[4:5], v12, v3, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, v1, v13, vcc
; SDAG-NEXT:    v_xor_b32_e32 v2, v0, v28
; SDAG-NEXT:    v_xor_b32_e32 v3, v1, v29
; SDAG-NEXT:    v_sub_i32_e32 v0, vcc, v33, v28
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, v7, v29, vcc
; SDAG-NEXT:    v_subb_u32_e32 v2, vcc, v2, v28, vcc
; SDAG-NEXT:    v_subb_u32_e32 v3, vcc, v3, v29, vcc
; SDAG-NEXT:    v_sub_i32_e32 v6, vcc, v8, v6
; SDAG-NEXT:    v_subb_u32_e32 v7, vcc, v9, v18, vcc
; SDAG-NEXT:    v_xor_b32_e32 v6, v6, v26
; SDAG-NEXT:    v_subb_u32_e32 v4, vcc, v4, v10, vcc
; SDAG-NEXT:    v_xor_b32_e32 v7, v7, v34
; SDAG-NEXT:    v_subb_u32_e32 v5, vcc, v5, v11, vcc
; SDAG-NEXT:    v_xor_b32_e32 v8, v4, v26
; SDAG-NEXT:    v_xor_b32_e32 v9, v5, v34
; SDAG-NEXT:    v_sub_i32_e32 v4, vcc, v6, v26
; SDAG-NEXT:    v_subb_u32_e32 v5, vcc, v7, v34, vcc
; SDAG-NEXT:    v_subb_u32_e32 v6, vcc, v8, v26, vcc
; SDAG-NEXT:    v_subb_u32_e32 v7, vcc, v9, v34, vcc
; SDAG-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-LABEL: v_srem_v2i128_vv:
; GISEL:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_ashrrev_i32_e32 v28, 31, v3
; GISEL-NEXT:    v_ashrrev_i32_e32 v20, 31, v11
; GISEL-NEXT:    v_mov_b32_e32 v18, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v19, 0
; GISEL-NEXT:    v_xor_b32_e32 v0, v0, v28
; GISEL-NEXT:    v_xor_b32_e32 v1, v1, v28
; GISEL-NEXT:    v_xor_b32_e32 v2, v2, v28
; GISEL-NEXT:    v_xor_b32_e32 v3, v3, v28
; GISEL-NEXT:    v_xor_b32_e32 v8, v8, v20
; GISEL-NEXT:    v_xor_b32_e32 v9, v9, v20
; GISEL-NEXT:    v_xor_b32_e32 v10, v10, v20
; GISEL-NEXT:    v_xor_b32_e32 v11, v11, v20
; GISEL-NEXT:    v_sub_i32_e32 v16, vcc, v0, v28
; GISEL-NEXT:    v_subb_u32_e32 v17, vcc, v1, v28, vcc
; GISEL-NEXT:    v_sub_i32_e64 v30, s[4:5], v8, v20
; GISEL-NEXT:    v_subb_u32_e64 v29, s[4:5], v9, v20, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v8, vcc, v2, v28, vcc
; GISEL-NEXT:    v_subb_u32_e32 v9, vcc, v3, v28, vcc
; GISEL-NEXT:    v_subb_u32_e64 v10, vcc, v10, v20, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v11, vcc, v11, v20, vcc
; GISEL-NEXT:    v_ffbh_u32_e32 v20, v29
; GISEL-NEXT:    v_ffbh_u32_e32 v21, v30
; GISEL-NEXT:    v_ffbh_u32_e32 v22, v17
; GISEL-NEXT:    v_ffbh_u32_e32 v23, v16
; GISEL-NEXT:    v_or_b32_e32 v0, v30, v10
; GISEL-NEXT:    v_or_b32_e32 v1, v29, v11
; GISEL-NEXT:    v_or_b32_e32 v2, v16, v8
; GISEL-NEXT:    v_or_b32_e32 v3, v17, v9
; GISEL-NEXT:    v_add_i32_e32 v21, vcc, 32, v21
; GISEL-NEXT:    v_ffbh_u32_e32 v24, v11
; GISEL-NEXT:    v_ffbh_u32_e32 v25, v10
; GISEL-NEXT:    v_add_i32_e32 v23, vcc, 32, v23
; GISEL-NEXT:    v_ffbh_u32_e32 v26, v9
; GISEL-NEXT:    v_ffbh_u32_e32 v27, v8
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[2:3]
; GISEL-NEXT:    v_min_u32_e32 v0, v20, v21
; GISEL-NEXT:    v_add_i32_e64 v1, s[6:7], 32, v25
; GISEL-NEXT:    v_min_u32_e32 v2, v22, v23
; GISEL-NEXT:    v_add_i32_e64 v3, s[6:7], 32, v27
; GISEL-NEXT:    v_add_i32_e64 v0, s[6:7], 64, v0
; GISEL-NEXT:    v_min_u32_e32 v1, v24, v1
; GISEL-NEXT:    v_add_i32_e64 v2, s[6:7], 64, v2
; GISEL-NEXT:    v_min_u32_e32 v3, v26, v3
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v20, 0, 1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GISEL-NEXT:    v_subb_u32_e64 v1, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v2, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v3, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[0:1], v[18:19]
; GISEL-NEXT:    v_cndmask_b32_e64 v21, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v18, 0x7f, v0
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e64 v22, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v2
; GISEL-NEXT:    v_or_b32_e32 v19, v1, v3
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e32 v21, v22, v21, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; GISEL-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v19, v20, v21
; GISEL-NEXT:    v_and_b32_e32 v20, 1, v19
; GISEL-NEXT:    v_or_b32_e32 v18, v19, v18
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GISEL-NEXT:    v_cndmask_b32_e64 v31, v16, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v20, 1, v18
; GISEL-NEXT:    v_cndmask_b32_e64 v32, v17, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v18, v8, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v19, v9, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB2_6
; GISEL-NEXT:  ; %bb.1: ; %udiv-bb15
; GISEL-NEXT:    v_add_i32_e32 v31, vcc, 1, v0
; GISEL-NEXT:    v_addc_u32_e64 v32, s[4:5], 0, v1, vcc
; GISEL-NEXT:    v_sub_i32_e32 v24, vcc, 0x7f, v0
; GISEL-NEXT:    v_addc_u32_e64 v33, vcc, 0, v2, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v34, vcc, 0, v3, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v20, s[4:5], 64, v24
; GISEL-NEXT:    v_sub_i32_e64 v18, s[4:5], 64, v24
; GISEL-NEXT:    v_lshl_b64 v[0:1], v[16:17], v24
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[8:9], v24
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[18:19], v[16:17], v18
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[16:17], v20
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v24
; GISEL-NEXT:    v_cndmask_b32_e32 v20, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v21, 0, v1, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v18, v2
; GISEL-NEXT:    v_or_b32_e32 v1, v19, v3
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v22, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v23, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v24
; GISEL-NEXT:    v_cndmask_b32_e32 v18, v0, v8, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v19, v1, v9, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v0, s8
; GISEL-NEXT:    v_mov_b32_e32 v1, s9
; GISEL-NEXT:    v_mov_b32_e32 v2, s10
; GISEL-NEXT:    v_mov_b32_e32 v3, s11
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[8:9], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB2_5
; GISEL-NEXT:  ; %bb.2: ; %udiv-preheader4
; GISEL-NEXT:    v_subrev_i32_e32 v24, vcc, 64, v31
; GISEL-NEXT:    v_sub_i32_e32 v22, vcc, 64, v31
; GISEL-NEXT:    v_lshr_b64 v[0:1], v[8:9], v31
; GISEL-NEXT:    v_lshr_b64 v[2:3], v[16:17], v31
; GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GISEL-NEXT:    v_add_i32_e32 v35, vcc, -1, v30
; GISEL-NEXT:    v_addc_u32_e32 v36, vcc, -1, v29, vcc
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[8:9], v22
; GISEL-NEXT:    v_lshr_b64 v[24:25], v[8:9], v24
; GISEL-NEXT:    v_addc_u32_e32 v37, vcc, -1, v10, vcc
; GISEL-NEXT:    v_addc_u32_e32 v38, vcc, -1, v11, vcc
; GISEL-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v22
; GISEL-NEXT:    v_or_b32_e32 v3, v3, v23
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v31
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v24, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v25, v3, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v26, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v27, 0, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v31
; GISEL-NEXT:    v_cndmask_b32_e32 v24, v2, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v25, v3, v17, vcc
; GISEL-NEXT:    v_mov_b32_e32 v23, 0
; GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-NEXT:    v_mov_b32_e32 v2, s6
; GISEL-NEXT:    v_mov_b32_e32 v3, s7
; GISEL-NEXT:  .LBB2_3: ; %udiv-do-while3
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[20:21], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v22, 31, v21
; GISEL-NEXT:    v_lshl_b64 v[48:49], v[24:25], 1
; GISEL-NEXT:    v_lshl_b64 v[26:27], v[26:27], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v24, 31, v25
; GISEL-NEXT:    v_lshrrev_b32_e32 v25, 31, v19
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[18:19], 1
; GISEL-NEXT:    v_add_i32_e32 v31, vcc, -1, v31
; GISEL-NEXT:    v_addc_u32_e32 v32, vcc, -1, v32, vcc
; GISEL-NEXT:    v_or_b32_e32 v20, v0, v2
; GISEL-NEXT:    v_or_b32_e32 v21, v1, v3
; GISEL-NEXT:    v_or_b32_e32 v2, v26, v24
; GISEL-NEXT:    v_or_b32_e32 v3, v48, v25
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v22
; GISEL-NEXT:    v_addc_u32_e32 v33, vcc, -1, v33, vcc
; GISEL-NEXT:    v_addc_u32_e32 v34, vcc, -1, v34, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v35, v3
; GISEL-NEXT:    v_subb_u32_e32 v0, vcc, v36, v49, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v31, v33
; GISEL-NEXT:    v_or_b32_e32 v1, v32, v34
; GISEL-NEXT:    v_subb_u32_e32 v22, vcc, v37, v2, vcc
; GISEL-NEXT:    v_subb_u32_e32 v22, vcc, v38, v27, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_ashrrev_i32_e32 v0, 31, v22
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v22, 1, v0
; GISEL-NEXT:    v_and_b32_e32 v1, v0, v30
; GISEL-NEXT:    v_and_b32_e32 v25, v0, v29
; GISEL-NEXT:    v_and_b32_e32 v26, v0, v10
; GISEL-NEXT:    v_and_b32_e32 v0, v0, v11
; GISEL-NEXT:    v_sub_i32_e32 v24, vcc, v3, v1
; GISEL-NEXT:    v_subb_u32_e32 v25, vcc, v49, v25, vcc
; GISEL-NEXT:    v_subb_u32_e32 v26, vcc, v2, v26, vcc
; GISEL-NEXT:    v_subb_u32_e32 v27, vcc, v27, v0, vcc
; GISEL-NEXT:    v_mov_b32_e32 v0, v22
; GISEL-NEXT:    v_mov_b32_e32 v1, v23
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GISEL-NEXT:    s_cbranch_execnz .LBB2_3
; GISEL-NEXT:  ; %bb.4: ; %Flow13
; GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GISEL-NEXT:  .LBB2_5: ; %Flow14
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[20:21], 1
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[18:19], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v20, 31, v21
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v20
; GISEL-NEXT:    v_or_b32_e32 v31, v0, v2
; GISEL-NEXT:    v_or_b32_e32 v32, v1, v3
; GISEL-NEXT:  .LBB2_6: ; %Flow16
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_ashrrev_i32_e32 v33, 31, v7
; GISEL-NEXT:    v_ashrrev_i32_e32 v0, 31, v15
; GISEL-NEXT:    v_mov_b32_e32 v2, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v3, 0
; GISEL-NEXT:    v_xor_b32_e32 v1, v4, v33
; GISEL-NEXT:    v_xor_b32_e32 v4, v5, v33
; GISEL-NEXT:    v_xor_b32_e32 v5, v6, v33
; GISEL-NEXT:    v_xor_b32_e32 v7, v7, v33
; GISEL-NEXT:    v_xor_b32_e32 v6, v12, v0
; GISEL-NEXT:    v_xor_b32_e32 v20, v13, v0
; GISEL-NEXT:    v_xor_b32_e32 v14, v14, v0
; GISEL-NEXT:    v_xor_b32_e32 v15, v15, v0
; GISEL-NEXT:    v_sub_i32_e32 v12, vcc, v1, v33
; GISEL-NEXT:    v_subb_u32_e32 v13, vcc, v4, v33, vcc
; GISEL-NEXT:    v_sub_i32_e64 v35, s[4:5], v6, v0
; GISEL-NEXT:    v_subb_u32_e64 v34, s[4:5], v20, v0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v6, vcc, v5, v33, vcc
; GISEL-NEXT:    v_subb_u32_e32 v7, vcc, v7, v33, vcc
; GISEL-NEXT:    v_subb_u32_e64 v4, vcc, v14, v0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v5, vcc, v15, v0, vcc
; GISEL-NEXT:    v_ffbh_u32_e32 v20, v34
; GISEL-NEXT:    v_ffbh_u32_e32 v21, v35
; GISEL-NEXT:    v_ffbh_u32_e32 v22, v13
; GISEL-NEXT:    v_ffbh_u32_e32 v23, v12
; GISEL-NEXT:    v_or_b32_e32 v0, v35, v4
; GISEL-NEXT:    v_or_b32_e32 v1, v34, v5
; GISEL-NEXT:    v_or_b32_e32 v14, v12, v6
; GISEL-NEXT:    v_or_b32_e32 v15, v13, v7
; GISEL-NEXT:    v_add_i32_e32 v21, vcc, 32, v21
; GISEL-NEXT:    v_ffbh_u32_e32 v24, v5
; GISEL-NEXT:    v_ffbh_u32_e32 v25, v4
; GISEL-NEXT:    v_add_i32_e32 v23, vcc, 32, v23
; GISEL-NEXT:    v_ffbh_u32_e32 v26, v7
; GISEL-NEXT:    v_ffbh_u32_e32 v27, v6
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[14:15]
; GISEL-NEXT:    v_min_u32_e32 v0, v20, v21
; GISEL-NEXT:    v_add_i32_e64 v1, s[6:7], 32, v25
; GISEL-NEXT:    v_min_u32_e32 v14, v22, v23
; GISEL-NEXT:    v_add_i32_e64 v15, s[6:7], 32, v27
; GISEL-NEXT:    v_add_i32_e64 v0, s[6:7], 64, v0
; GISEL-NEXT:    v_min_u32_e32 v1, v24, v1
; GISEL-NEXT:    v_add_i32_e64 v14, s[6:7], 64, v14
; GISEL-NEXT:    v_min_u32_e32 v15, v26, v15
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v20, 0, 1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[4:5]
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v15, v14, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GISEL-NEXT:    v_subb_u32_e64 v1, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v14, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v15, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[0:1], v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e64 v21, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v2, 0x7f, v0
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[14:15]
; GISEL-NEXT:    v_cndmask_b32_e64 v22, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v14
; GISEL-NEXT:    v_or_b32_e32 v3, v1, v15
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GISEL-NEXT:    v_cndmask_b32_e32 v21, v22, v21, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v3, v20, v21
; GISEL-NEXT:    v_and_b32_e32 v20, 1, v3
; GISEL-NEXT:    v_or_b32_e32 v2, v3, v2
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GISEL-NEXT:    v_cndmask_b32_e64 v20, v12, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v22, 1, v2
; GISEL-NEXT:    v_cndmask_b32_e64 v21, v13, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v22
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB2_12
; GISEL-NEXT:  ; %bb.7: ; %udiv-bb1
; GISEL-NEXT:    v_add_i32_e32 v36, vcc, 1, v0
; GISEL-NEXT:    v_addc_u32_e64 v37, s[4:5], 0, v1, vcc
; GISEL-NEXT:    v_sub_i32_e32 v24, vcc, 0x7f, v0
; GISEL-NEXT:    v_addc_u32_e64 v38, vcc, 0, v14, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v39, vcc, 0, v15, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v20, s[4:5], 64, v24
; GISEL-NEXT:    v_sub_i32_e64 v14, s[4:5], 64, v24
; GISEL-NEXT:    v_lshl_b64 v[0:1], v[12:13], v24
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[6:7], v24
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[14:15], v[12:13], v14
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[12:13], v20
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v24
; GISEL-NEXT:    v_cndmask_b32_e32 v20, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v21, 0, v1, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v14, v2
; GISEL-NEXT:    v_or_b32_e32 v1, v15, v3
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v22, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v23, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v24
; GISEL-NEXT:    v_cndmask_b32_e32 v14, v0, v6, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v15, v1, v7, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v0, s8
; GISEL-NEXT:    v_mov_b32_e32 v1, s9
; GISEL-NEXT:    v_mov_b32_e32 v2, s10
; GISEL-NEXT:    v_mov_b32_e32 v3, s11
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[8:9], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB2_11
; GISEL-NEXT:  ; %bb.8: ; %udiv-preheader
; GISEL-NEXT:    v_subrev_i32_e32 v24, vcc, 64, v36
; GISEL-NEXT:    v_sub_i32_e32 v22, vcc, 64, v36
; GISEL-NEXT:    v_lshr_b64 v[0:1], v[6:7], v36
; GISEL-NEXT:    v_lshr_b64 v[2:3], v[12:13], v36
; GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GISEL-NEXT:    v_add_i32_e32 v48, vcc, -1, v35
; GISEL-NEXT:    v_addc_u32_e32 v49, vcc, -1, v34, vcc
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[6:7], v22
; GISEL-NEXT:    v_lshr_b64 v[24:25], v[6:7], v24
; GISEL-NEXT:    v_addc_u32_e32 v50, vcc, -1, v4, vcc
; GISEL-NEXT:    v_addc_u32_e32 v51, vcc, -1, v5, vcc
; GISEL-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v22
; GISEL-NEXT:    v_or_b32_e32 v3, v3, v23
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v36
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v24, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v25, v3, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v26, 0, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v27, 0, v1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v36
; GISEL-NEXT:    v_cndmask_b32_e32 v24, v2, v12, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v25, v3, v13, vcc
; GISEL-NEXT:    v_mov_b32_e32 v23, 0
; GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-NEXT:    v_mov_b32_e32 v2, s6
; GISEL-NEXT:    v_mov_b32_e32 v3, s7
; GISEL-NEXT:  .LBB2_9: ; %udiv-do-while
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[20:21], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v22, 31, v21
; GISEL-NEXT:    v_lshl_b64 v[52:53], v[24:25], 1
; GISEL-NEXT:    v_lshl_b64 v[26:27], v[26:27], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v24, 31, v25
; GISEL-NEXT:    v_lshrrev_b32_e32 v25, 31, v15
; GISEL-NEXT:    v_lshl_b64 v[14:15], v[14:15], 1
; GISEL-NEXT:    v_add_i32_e32 v36, vcc, -1, v36
; GISEL-NEXT:    v_addc_u32_e32 v37, vcc, -1, v37, vcc
; GISEL-NEXT:    v_or_b32_e32 v20, v0, v2
; GISEL-NEXT:    v_or_b32_e32 v21, v1, v3
; GISEL-NEXT:    v_or_b32_e32 v2, v26, v24
; GISEL-NEXT:    v_or_b32_e32 v3, v52, v25
; GISEL-NEXT:    v_or_b32_e32 v14, v14, v22
; GISEL-NEXT:    v_addc_u32_e32 v38, vcc, -1, v38, vcc
; GISEL-NEXT:    v_addc_u32_e32 v39, vcc, -1, v39, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v48, v3
; GISEL-NEXT:    v_subb_u32_e32 v0, vcc, v49, v53, vcc
; GISEL-NEXT:    v_or_b32_e32 v0, v36, v38
; GISEL-NEXT:    v_or_b32_e32 v1, v37, v39
; GISEL-NEXT:    v_subb_u32_e32 v22, vcc, v50, v2, vcc
; GISEL-NEXT:    v_subb_u32_e32 v22, vcc, v51, v27, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GISEL-NEXT:    v_ashrrev_i32_e32 v0, 31, v22
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v22, 1, v0
; GISEL-NEXT:    v_and_b32_e32 v1, v0, v35
; GISEL-NEXT:    v_and_b32_e32 v25, v0, v34
; GISEL-NEXT:    v_and_b32_e32 v26, v0, v4
; GISEL-NEXT:    v_and_b32_e32 v52, v0, v5
; GISEL-NEXT:    v_sub_i32_e32 v24, vcc, v3, v1
; GISEL-NEXT:    v_subb_u32_e32 v25, vcc, v53, v25, vcc
; GISEL-NEXT:    v_mov_b32_e32 v0, v22
; GISEL-NEXT:    v_mov_b32_e32 v1, v23
; GISEL-NEXT:    v_subb_u32_e32 v26, vcc, v2, v26, vcc
; GISEL-NEXT:    v_subb_u32_e32 v27, vcc, v27, v52, vcc
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GISEL-NEXT:    s_cbranch_execnz .LBB2_9
; GISEL-NEXT:  ; %bb.10: ; %Flow
; GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GISEL-NEXT:  .LBB2_11: ; %Flow11
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[20:21], 1
; GISEL-NEXT:    v_lshl_b64 v[2:3], v[14:15], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v14, 31, v21
; GISEL-NEXT:    v_or_b32_e32 v2, v2, v14
; GISEL-NEXT:    v_or_b32_e32 v20, v0, v22
; GISEL-NEXT:    v_or_b32_e32 v21, v1, v23
; GISEL-NEXT:  .LBB2_12: ; %Flow12
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], v30, v31, 0
; GISEL-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v30, v18, 0
; GISEL-NEXT:    v_mul_lo_u32 v24, v30, v19
; GISEL-NEXT:    v_mul_lo_u32 v25, v29, v18
; GISEL-NEXT:    v_mad_u64_u32 v[18:19], s[4:5], v35, v20, 0
; GISEL-NEXT:    v_mad_u64_u32 v[22:23], s[4:5], v35, v2, 0
; GISEL-NEXT:    v_mul_lo_u32 v26, v35, v3
; GISEL-NEXT:    v_mul_lo_u32 v27, v34, v2
; GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v29, v32, v[14:15]
; GISEL-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v34, v21, v[22:23]
; GISEL-NEXT:    v_mov_b32_e32 v22, v19
; GISEL-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v10, v31, v[2:3]
; GISEL-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v4, v20, v[14:15]
; GISEL-NEXT:    v_mad_u64_u32 v[1:2], vcc, v30, v32, v[1:2]
; GISEL-NEXT:    v_mov_b32_e32 v23, v14
; GISEL-NEXT:    v_mad_u64_u32 v[22:23], s[4:5], v35, v21, v[22:23]
; GISEL-NEXT:    v_mad_u64_u32 v[1:2], s[6:7], v29, v31, v[1:2]
; GISEL-NEXT:    v_addc_u32_e64 v3, s[6:7], v3, v24, s[6:7]
; GISEL-NEXT:    v_mad_u64_u32 v[22:23], s[6:7], v34, v20, v[22:23]
; GISEL-NEXT:    v_addc_u32_e64 v14, s[6:7], v15, v26, s[6:7]
; GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v25, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v16, v0
; GISEL-NEXT:    v_subb_u32_e32 v1, vcc, v17, v1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v15, v0, v28
; GISEL-NEXT:    v_addc_u32_e64 v0, s[4:5], v14, v27, s[4:5]
; GISEL-NEXT:    v_sub_i32_e64 v12, s[4:5], v12, v18
; GISEL-NEXT:    v_subb_u32_e64 v14, s[4:5], v13, v22, s[4:5]
; GISEL-NEXT:    v_xor_b32_e32 v16, v12, v33
; GISEL-NEXT:    v_mad_u64_u32 v[12:13], s[6:7], v10, v32, v[3:4]
; GISEL-NEXT:    v_xor_b32_e32 v1, v1, v28
; GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[6:7], v4, v21, v[0:1]
; GISEL-NEXT:    v_xor_b32_e32 v14, v14, v33
; GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[6:7], v11, v31, v[12:13]
; GISEL-NEXT:    v_sub_i32_e64 v0, s[6:7], v15, v28
; GISEL-NEXT:    v_subb_u32_e64 v1, s[6:7], v1, v28, s[6:7]
; GISEL-NEXT:    v_mad_u64_u32 v[3:4], s[8:9], v5, v20, v[3:4]
; GISEL-NEXT:    v_sub_i32_e64 v4, s[8:9], v16, v33
; GISEL-NEXT:    v_subb_u32_e64 v5, s[8:9], v14, v33, s[8:9]
; GISEL-NEXT:    v_subb_u32_e32 v2, vcc, v8, v2, vcc
; GISEL-NEXT:    v_subb_u32_e32 v8, vcc, v9, v10, vcc
; GISEL-NEXT:    v_xor_b32_e32 v2, v2, v28
; GISEL-NEXT:    v_subb_u32_e64 v6, vcc, v6, v23, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v3, vcc, v7, v3, vcc
; GISEL-NEXT:    v_xor_b32_e32 v6, v6, v33
; GISEL-NEXT:    v_xor_b32_e32 v7, v8, v28
; GISEL-NEXT:    v_xor_b32_e32 v8, v3, v33
; GISEL-NEXT:    v_subb_u32_e64 v2, vcc, v2, v28, s[6:7]
; GISEL-NEXT:    v_subb_u32_e32 v3, vcc, v7, v28, vcc
; GISEL-NEXT:    v_subb_u32_e64 v6, vcc, v6, v33, s[8:9]
; GISEL-NEXT:    v_subb_u32_e32 v7, vcc, v8, v33, vcc
; GISEL-NEXT:    s_setpc_b64 s[30:31]
  %shl = srem <2 x i128> %lhs, %rhs
  ret <2 x i128> %shl
}

define <2 x i128> @v_urem_v2i128_vv(<2 x i128> %lhs, <2 x i128> %rhs) {
; SDAG-LABEL: v_urem_v2i128_vv:
; SDAG:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-NEXT:    v_or_b32_e32 v17, v9, v11
; SDAG-NEXT:    v_or_b32_e32 v16, v8, v10
; SDAG-NEXT:    v_or_b32_e32 v19, v1, v3
; SDAG-NEXT:    v_or_b32_e32 v18, v0, v2
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v10
; SDAG-NEXT:    v_ffbh_u32_e32 v21, v11
; SDAG-NEXT:    v_ffbh_u32_e32 v22, v8
; SDAG-NEXT:    v_ffbh_u32_e32 v23, v9
; SDAG-NEXT:    v_ffbh_u32_e32 v24, v2
; SDAG-NEXT:    v_ffbh_u32_e32 v25, v3
; SDAG-NEXT:    v_ffbh_u32_e32 v26, v0
; SDAG-NEXT:    v_ffbh_u32_e32 v27, v1
; SDAG-NEXT:    v_mov_b32_e32 v28, 0
; SDAG-NEXT:    s_mov_b64 s[8:9], 0x7f
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[18:19]
; SDAG-NEXT:    v_add_i32_e64 v16, s[6:7], 32, v20
; SDAG-NEXT:    v_add_i32_e64 v17, s[6:7], 32, v22
; SDAG-NEXT:    v_add_i32_e64 v18, s[6:7], 32, v24
; SDAG-NEXT:    v_add_i32_e64 v19, s[6:7], 32, v26
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[4:5]
; SDAG-NEXT:    v_min_u32_e32 v16, v16, v21
; SDAG-NEXT:    v_min_u32_e32 v17, v17, v23
; SDAG-NEXT:    v_min_u32_e32 v18, v18, v25
; SDAG-NEXT:    v_min_u32_e32 v19, v19, v27
; SDAG-NEXT:    v_add_i32_e32 v17, vcc, 64, v17
; SDAG-NEXT:    v_addc_u32_e64 v20, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_add_i32_e32 v19, vcc, 64, v19
; SDAG-NEXT:    v_addc_u32_e64 v21, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, v20, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v16, v17, v16, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v21, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; SDAG-NEXT:    v_sub_i32_e32 v16, vcc, v16, v18
; SDAG-NEXT:    v_subb_u32_e32 v17, vcc, v20, v17, vcc
; SDAG-NEXT:    v_xor_b32_e32 v18, 0x7f, v16
; SDAG-NEXT:    v_subbrev_u32_e32 v20, vcc, 0, v28, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[8:9], v[16:17]
; SDAG-NEXT:    v_cndmask_b32_e64 v22, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v21, vcc, 0, v28, vcc
; SDAG-NEXT:    v_or_b32_e32 v18, v18, v20
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[20:21]
; SDAG-NEXT:    v_cndmask_b32_e64 v23, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v19, v17, v21
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[20:21]
; SDAG-NEXT:    v_cndmask_b32_e32 v22, v23, v22, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_and_b32_e32 v18, 1, v22
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v18
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v33, v3, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v31, v2, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v30, v1, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v32, v0, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB3_6
; SDAG-NEXT:  ; %bb.1: ; %udiv-bb15
; SDAG-NEXT:    v_add_i32_e32 v30, vcc, 1, v16
; SDAG-NEXT:    v_sub_i32_e64 v22, s[4:5], 63, v16
; SDAG-NEXT:    v_mov_b32_e32 v18, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    v_addc_u32_e32 v31, vcc, 0, v17, vcc
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[0:1], v22
; SDAG-NEXT:    v_addc_u32_e32 v32, vcc, 0, v20, vcc
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, 0, v21, vcc
; SDAG-NEXT:    v_or_b32_e32 v20, v30, v32
; SDAG-NEXT:    v_sub_i32_e32 v26, vcc, 0x7f, v16
; SDAG-NEXT:    v_or_b32_e32 v21, v31, v33
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[2:3], v26
; SDAG-NEXT:    v_sub_i32_e32 v27, vcc, 64, v26
; SDAG-NEXT:    v_lshl_b64 v[24:25], v[0:1], v26
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[20:21]
; SDAG-NEXT:    v_lshr_b64 v[20:21], v[0:1], v27
; SDAG-NEXT:    v_or_b32_e32 v17, v17, v21
; SDAG-NEXT:    v_or_b32_e32 v16, v16, v20
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v26
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v23, v17, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, v22, v16, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v23, 0, v25, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v22, 0, v24, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v26
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v17, v3, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, v16, v2, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v20, 0
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB3_5
; SDAG-NEXT:  ; %bb.2: ; %udiv-preheader4
; SDAG-NEXT:    v_lshr_b64 v[18:19], v[0:1], v30
; SDAG-NEXT:    v_sub_i32_e32 v28, vcc, 64, v30
; SDAG-NEXT:    v_subrev_i32_e32 v35, vcc, 64, v30
; SDAG-NEXT:    v_lshr_b64 v[26:27], v[2:3], v30
; SDAG-NEXT:    v_add_i32_e32 v34, vcc, -1, v8
; SDAG-NEXT:    s_mov_b64 s[10:11], 0
; SDAG-NEXT:    v_mov_b32_e32 v24, 0
; SDAG-NEXT:    v_mov_b32_e32 v25, 0
; SDAG-NEXT:    v_mov_b32_e32 v20, 0
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:    v_lshl_b64 v[28:29], v[2:3], v28
; SDAG-NEXT:    v_lshr_b64 v[37:38], v[2:3], v35
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, -1, v9, vcc
; SDAG-NEXT:    v_or_b32_e32 v19, v19, v29
; SDAG-NEXT:    v_or_b32_e32 v18, v18, v28
; SDAG-NEXT:    v_addc_u32_e32 v36, vcc, -1, v10, vcc
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v30
; SDAG-NEXT:    v_cndmask_b32_e64 v19, v38, v19, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v18, v37, v18, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v29, 0, v27, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v28, 0, v26, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v37, vcc, -1, v11, vcc
; SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v30
; SDAG-NEXT:    v_cndmask_b32_e32 v27, v19, v1, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v26, v18, v0, vcc
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:  .LBB3_3: ; %udiv-do-while3
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshl_b64 v[28:29], v[28:29], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v18, 31, v27
; SDAG-NEXT:    v_lshl_b64 v[26:27], v[26:27], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v38, 31, v17
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v39, 31, v23
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[22:23], 1
; SDAG-NEXT:    v_or_b32_e32 v28, v28, v18
; SDAG-NEXT:    v_or_b32_e32 v26, v26, v38
; SDAG-NEXT:    v_or_b32_e32 v16, v16, v39
; SDAG-NEXT:    v_or_b32_e32 v17, v21, v17
; SDAG-NEXT:    v_sub_i32_e32 v18, vcc, v34, v26
; SDAG-NEXT:    v_or_b32_e32 v16, v20, v16
; SDAG-NEXT:    v_subb_u32_e32 v18, vcc, v35, v27, vcc
; SDAG-NEXT:    v_subb_u32_e32 v18, vcc, v36, v28, vcc
; SDAG-NEXT:    v_subb_u32_e32 v18, vcc, v37, v29, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v38, 31, v18
; SDAG-NEXT:    v_and_b32_e32 v39, v38, v8
; SDAG-NEXT:    v_and_b32_e32 v48, v38, v9
; SDAG-NEXT:    v_and_b32_e32 v49, v38, v10
; SDAG-NEXT:    v_and_b32_e32 v18, 1, v38
; SDAG-NEXT:    v_and_b32_e32 v38, v38, v11
; SDAG-NEXT:    v_sub_i32_e32 v26, vcc, v26, v39
; SDAG-NEXT:    v_subb_u32_e32 v27, vcc, v27, v48, vcc
; SDAG-NEXT:    v_subb_u32_e32 v28, vcc, v28, v49, vcc
; SDAG-NEXT:    v_subb_u32_e32 v29, vcc, v29, v38, vcc
; SDAG-NEXT:    v_add_i32_e32 v30, vcc, -1, v30
; SDAG-NEXT:    v_addc_u32_e32 v31, vcc, -1, v31, vcc
; SDAG-NEXT:    v_addc_u32_e32 v32, vcc, -1, v32, vcc
; SDAG-NEXT:    v_addc_u32_e32 v33, vcc, -1, v33, vcc
; SDAG-NEXT:    v_or_b32_e32 v38, v30, v32
; SDAG-NEXT:    v_or_b32_e32 v39, v31, v33
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[38:39]
; SDAG-NEXT:    v_or_b32_e32 v23, v25, v23
; SDAG-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; SDAG-NEXT:    v_or_b32_e32 v22, v24, v22
; SDAG-NEXT:    v_mov_b32_e32 v25, v19
; SDAG-NEXT:    v_mov_b32_e32 v24, v18
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; SDAG-NEXT:    s_cbranch_execnz .LBB3_3
; SDAG-NEXT:  ; %bb.4: ; %Flow13
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:  .LBB3_5: ; %Flow14
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v24, 31, v23
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[22:23], 1
; SDAG-NEXT:    v_or_b32_e32 v16, v16, v24
; SDAG-NEXT:    v_or_b32_e32 v33, v21, v17
; SDAG-NEXT:    v_or_b32_e32 v30, v19, v23
; SDAG-NEXT:    v_or_b32_e32 v31, v20, v16
; SDAG-NEXT:    v_or_b32_e32 v32, v18, v22
; SDAG-NEXT:  .LBB3_6: ; %Flow16
; SDAG-NEXT:    s_or_b64 exec, exec, s[6:7]
; SDAG-NEXT:    v_or_b32_e32 v17, v13, v15
; SDAG-NEXT:    v_or_b32_e32 v16, v12, v14
; SDAG-NEXT:    v_or_b32_e32 v19, v5, v7
; SDAG-NEXT:    v_or_b32_e32 v18, v4, v6
; SDAG-NEXT:    v_ffbh_u32_e32 v20, v14
; SDAG-NEXT:    v_ffbh_u32_e32 v21, v15
; SDAG-NEXT:    v_ffbh_u32_e32 v22, v12
; SDAG-NEXT:    v_ffbh_u32_e32 v23, v13
; SDAG-NEXT:    v_ffbh_u32_e32 v24, v6
; SDAG-NEXT:    v_ffbh_u32_e32 v25, v7
; SDAG-NEXT:    v_ffbh_u32_e32 v26, v4
; SDAG-NEXT:    v_ffbh_u32_e32 v27, v5
; SDAG-NEXT:    v_mov_b32_e32 v28, 0
; SDAG-NEXT:    s_mov_b64 s[8:9], 0x7f
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; SDAG-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[18:19]
; SDAG-NEXT:    v_add_i32_e64 v16, s[6:7], 32, v20
; SDAG-NEXT:    v_add_i32_e64 v17, s[6:7], 32, v22
; SDAG-NEXT:    v_add_i32_e64 v18, s[6:7], 32, v24
; SDAG-NEXT:    v_add_i32_e64 v19, s[6:7], 32, v26
; SDAG-NEXT:    s_or_b64 s[6:7], vcc, s[4:5]
; SDAG-NEXT:    v_min_u32_e32 v16, v16, v21
; SDAG-NEXT:    v_min_u32_e32 v17, v17, v23
; SDAG-NEXT:    v_min_u32_e32 v18, v18, v25
; SDAG-NEXT:    v_min_u32_e32 v19, v19, v27
; SDAG-NEXT:    v_add_i32_e32 v17, vcc, 64, v17
; SDAG-NEXT:    v_addc_u32_e64 v20, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_add_i32_e32 v19, vcc, 64, v19
; SDAG-NEXT:    v_addc_u32_e64 v21, s[4:5], 0, 0, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[14:15]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, v20, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v16, v17, v16, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; SDAG-NEXT:    v_cndmask_b32_e64 v17, v21, 0, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; SDAG-NEXT:    v_sub_i32_e32 v16, vcc, v16, v18
; SDAG-NEXT:    v_subb_u32_e32 v17, vcc, v20, v17, vcc
; SDAG-NEXT:    v_xor_b32_e32 v20, 0x7f, v16
; SDAG-NEXT:    v_subbrev_u32_e32 v18, vcc, 0, v28, vcc
; SDAG-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[8:9], v[16:17]
; SDAG-NEXT:    v_cndmask_b32_e64 v22, 0, 1, s[4:5]
; SDAG-NEXT:    v_subbrev_u32_e32 v19, vcc, 0, v28, vcc
; SDAG-NEXT:    v_or_b32_e32 v20, v20, v18
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_cndmask_b32_e64 v23, 0, 1, vcc
; SDAG-NEXT:    v_or_b32_e32 v21, v17, v19
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; SDAG-NEXT:    v_cndmask_b32_e32 v22, v23, v22, vcc
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[20:21]
; SDAG-NEXT:    v_and_b32_e32 v20, 1, v22
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v20
; SDAG-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v23, v7, 0, s[4:5]
; SDAG-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; SDAG-NEXT:    v_cndmask_b32_e64 v22, v6, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v21, v5, 0, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, v4, 0, s[4:5]
; SDAG-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; SDAG-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB3_12
; SDAG-NEXT:  ; %bb.7: ; %udiv-bb1
; SDAG-NEXT:    v_add_i32_e32 v34, vcc, 1, v16
; SDAG-NEXT:    v_sub_i32_e64 v22, s[4:5], 63, v16
; SDAG-NEXT:    v_mov_b32_e32 v20, 0
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, 0, v17, vcc
; SDAG-NEXT:    v_lshl_b64 v[22:23], v[4:5], v22
; SDAG-NEXT:    v_addc_u32_e32 v36, vcc, 0, v18, vcc
; SDAG-NEXT:    v_addc_u32_e32 v37, vcc, 0, v19, vcc
; SDAG-NEXT:    v_or_b32_e32 v17, v34, v36
; SDAG-NEXT:    v_sub_i32_e32 v19, vcc, 0x7f, v16
; SDAG-NEXT:    v_or_b32_e32 v18, v35, v37
; SDAG-NEXT:    v_lshl_b64 v[24:25], v[6:7], v19
; SDAG-NEXT:    v_sub_i32_e32 v16, vcc, 64, v19
; SDAG-NEXT:    v_lshl_b64 v[26:27], v[4:5], v19
; SDAG-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[17:18]
; SDAG-NEXT:    v_lshr_b64 v[16:17], v[4:5], v16
; SDAG-NEXT:    v_or_b32_e32 v17, v25, v17
; SDAG-NEXT:    v_or_b32_e32 v16, v24, v16
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v19
; SDAG-NEXT:    v_cndmask_b32_e64 v18, v23, v17, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v22, v22, v16, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v17, 0, v27, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v16, 0, v26, s[4:5]
; SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v19
; SDAG-NEXT:    v_cndmask_b32_e64 v19, v18, v7, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v18, v22, v6, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v22, 0
; SDAG-NEXT:    v_mov_b32_e32 v23, 0
; SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SDAG-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; SDAG-NEXT:    s_cbranch_execz .LBB3_11
; SDAG-NEXT:  ; %bb.8: ; %udiv-preheader
; SDAG-NEXT:    v_lshr_b64 v[20:21], v[4:5], v34
; SDAG-NEXT:    v_sub_i32_e32 v28, vcc, 64, v34
; SDAG-NEXT:    v_subrev_i32_e32 v39, vcc, 64, v34
; SDAG-NEXT:    v_lshr_b64 v[26:27], v[6:7], v34
; SDAG-NEXT:    v_add_i32_e32 v38, vcc, -1, v12
; SDAG-NEXT:    s_mov_b64 s[10:11], 0
; SDAG-NEXT:    v_mov_b32_e32 v24, 0
; SDAG-NEXT:    v_mov_b32_e32 v25, 0
; SDAG-NEXT:    v_mov_b32_e32 v22, 0
; SDAG-NEXT:    v_mov_b32_e32 v23, 0
; SDAG-NEXT:    v_lshl_b64 v[28:29], v[6:7], v28
; SDAG-NEXT:    v_lshr_b64 v[49:50], v[6:7], v39
; SDAG-NEXT:    v_addc_u32_e32 v39, vcc, -1, v13, vcc
; SDAG-NEXT:    v_or_b32_e32 v21, v21, v29
; SDAG-NEXT:    v_or_b32_e32 v20, v20, v28
; SDAG-NEXT:    v_addc_u32_e32 v48, vcc, -1, v14, vcc
; SDAG-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v34
; SDAG-NEXT:    v_cndmask_b32_e64 v21, v50, v21, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v20, v49, v20, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v29, 0, v27, s[4:5]
; SDAG-NEXT:    v_cndmask_b32_e64 v28, 0, v26, s[4:5]
; SDAG-NEXT:    v_addc_u32_e32 v49, vcc, -1, v15, vcc
; SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v34
; SDAG-NEXT:    v_cndmask_b32_e32 v27, v21, v5, vcc
; SDAG-NEXT:    v_cndmask_b32_e32 v26, v20, v4, vcc
; SDAG-NEXT:    v_mov_b32_e32 v21, 0
; SDAG-NEXT:  .LBB3_9: ; %udiv-do-while
; SDAG-NEXT:    ; =>This Inner Loop Header: Depth=1
; SDAG-NEXT:    v_lshl_b64 v[28:29], v[28:29], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v20, 31, v27
; SDAG-NEXT:    v_lshl_b64 v[26:27], v[26:27], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v50, 31, v19
; SDAG-NEXT:    v_lshl_b64 v[18:19], v[18:19], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v51, 31, v17
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; SDAG-NEXT:    v_or_b32_e32 v28, v28, v20
; SDAG-NEXT:    v_or_b32_e32 v26, v26, v50
; SDAG-NEXT:    v_or_b32_e32 v18, v18, v51
; SDAG-NEXT:    v_or_b32_e32 v19, v23, v19
; SDAG-NEXT:    v_or_b32_e32 v17, v25, v17
; SDAG-NEXT:    v_or_b32_e32 v18, v22, v18
; SDAG-NEXT:    v_sub_i32_e32 v20, vcc, v38, v26
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, v39, v27, vcc
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, v48, v28, vcc
; SDAG-NEXT:    v_subb_u32_e32 v20, vcc, v49, v29, vcc
; SDAG-NEXT:    v_ashrrev_i32_e32 v25, 31, v20
; SDAG-NEXT:    v_and_b32_e32 v20, 1, v25
; SDAG-NEXT:    v_and_b32_e32 v50, v25, v15
; SDAG-NEXT:    v_and_b32_e32 v51, v25, v14
; SDAG-NEXT:    v_and_b32_e32 v52, v25, v13
; SDAG-NEXT:    v_and_b32_e32 v25, v25, v12
; SDAG-NEXT:    v_sub_i32_e32 v26, vcc, v26, v25
; SDAG-NEXT:    v_subb_u32_e32 v27, vcc, v27, v52, vcc
; SDAG-NEXT:    v_subb_u32_e32 v28, vcc, v28, v51, vcc
; SDAG-NEXT:    v_subb_u32_e32 v29, vcc, v29, v50, vcc
; SDAG-NEXT:    v_add_i32_e32 v34, vcc, -1, v34
; SDAG-NEXT:    v_addc_u32_e32 v35, vcc, -1, v35, vcc
; SDAG-NEXT:    v_addc_u32_e32 v36, vcc, -1, v36, vcc
; SDAG-NEXT:    v_addc_u32_e32 v37, vcc, -1, v37, vcc
; SDAG-NEXT:    v_or_b32_e32 v51, v35, v37
; SDAG-NEXT:    v_or_b32_e32 v50, v34, v36
; SDAG-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[50:51]
; SDAG-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; SDAG-NEXT:    v_or_b32_e32 v16, v24, v16
; SDAG-NEXT:    v_mov_b32_e32 v25, v21
; SDAG-NEXT:    v_mov_b32_e32 v24, v20
; SDAG-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; SDAG-NEXT:    s_cbranch_execnz .LBB3_9
; SDAG-NEXT:  ; %bb.10: ; %Flow
; SDAG-NEXT:    s_or_b64 exec, exec, s[10:11]
; SDAG-NEXT:  .LBB3_11: ; %Flow11
; SDAG-NEXT:    s_or_b64 exec, exec, s[8:9]
; SDAG-NEXT:    v_lshl_b64 v[18:19], v[18:19], 1
; SDAG-NEXT:    v_lshrrev_b32_e32 v24, 31, v17
; SDAG-NEXT:    v_lshl_b64 v[16:17], v[16:17], 1
; SDAG-NEXT:    v_or_b32_e32 v18, v18, v24
; SDAG-NEXT:    v_or_b32_e32 v23, v23, v19
; SDAG-NEXT:    v_or_b32_e32 v21, v21, v17
; SDAG-NEXT:    v_or_b32_e32 v22, v22, v18
; SDAG-NEXT:    v_or_b32_e32 v20, v20, v16
; SDAG-NEXT:  .LBB3_12: ; %Flow12
; SDAG-NEXT:    s_or_b64 exec, exec, s[6:7]
; SDAG-NEXT:    v_mul_lo_u32 v18, v32, v11
; SDAG-NEXT:    v_mad_u64_u32 v[16:17], s[4:5], v32, v10, 0
; SDAG-NEXT:    v_mul_lo_u32 v28, v30, v10
; SDAG-NEXT:    v_mul_lo_u32 v29, v33, v8
; SDAG-NEXT:    v_mul_lo_u32 v33, v31, v9
; SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v8, v32, 0
; SDAG-NEXT:    v_mov_b32_e32 v19, 0
; SDAG-NEXT:    v_mul_lo_u32 v34, v20, v15
; SDAG-NEXT:    v_mad_u64_u32 v[24:25], s[4:5], v20, v14, 0
; SDAG-NEXT:    v_mul_lo_u32 v35, v21, v14
; SDAG-NEXT:    v_mul_lo_u32 v23, v23, v12
; SDAG-NEXT:    v_mul_lo_u32 v36, v22, v13
; SDAG-NEXT:    v_mad_u64_u32 v[14:15], s[4:5], v12, v20, 0
; SDAG-NEXT:    v_add_i32_e32 v17, vcc, v17, v18
; SDAG-NEXT:    v_mov_b32_e32 v18, v11
; SDAG-NEXT:    v_mad_u64_u32 v[26:27], s[4:5], v9, v32, v[18:19]
; SDAG-NEXT:    v_sub_i32_e32 v0, vcc, v0, v10
; SDAG-NEXT:    v_add_i32_e64 v18, s[4:5], v25, v34
; SDAG-NEXT:    v_add_i32_e64 v17, s[4:5], v17, v28
; SDAG-NEXT:    v_mov_b32_e32 v28, v27
; SDAG-NEXT:    v_mov_b32_e32 v27, v19
; SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v8, v30, v[26:27]
; SDAG-NEXT:    v_add_i32_e64 v25, s[4:5], v18, v35
; SDAG-NEXT:    v_mov_b32_e32 v18, v15
; SDAG-NEXT:    v_mad_u64_u32 v[26:27], s[4:5], v13, v20, v[18:19]
; SDAG-NEXT:    v_mad_u64_u32 v[15:16], s[4:5], v31, v8, v[16:17]
; SDAG-NEXT:    v_mov_b32_e32 v8, v11
; SDAG-NEXT:    v_add_i32_e64 v17, s[4:5], v28, v8
; SDAG-NEXT:    v_addc_u32_e64 v18, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    v_mov_b32_e32 v8, v10
; SDAG-NEXT:    v_subb_u32_e32 v1, vcc, v1, v8, vcc
; SDAG-NEXT:    v_mad_u64_u32 v[10:11], s[4:5], v22, v12, v[24:25]
; SDAG-NEXT:    v_mov_b32_e32 v22, v27
; SDAG-NEXT:    v_mov_b32_e32 v27, v19
; SDAG-NEXT:    v_mad_u64_u32 v[19:20], s[4:5], v12, v21, v[26:27]
; SDAG-NEXT:    v_add_i32_e64 v16, s[4:5], v29, v16
; SDAG-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v9, v30, v[17:18]
; SDAG-NEXT:    v_add_i32_e64 v17, s[4:5], v23, v11
; SDAG-NEXT:    v_mov_b32_e32 v11, v20
; SDAG-NEXT:    v_add_i32_e64 v11, s[4:5], v22, v11
; SDAG-NEXT:    v_addc_u32_e64 v12, s[4:5], 0, 0, s[4:5]
; SDAG-NEXT:    v_add_i32_e64 v16, s[4:5], v33, v16
; SDAG-NEXT:    v_add_i32_e64 v17, s[4:5], v36, v17
; SDAG-NEXT:    v_mad_u64_u32 v[11:12], s[4:5], v13, v21, v[11:12]
; SDAG-NEXT:    v_add_i32_e64 v8, s[4:5], v8, v15
; SDAG-NEXT:    v_addc_u32_e64 v9, s[4:5], v9, v16, s[4:5]
; SDAG-NEXT:    v_subb_u32_e32 v2, vcc, v2, v8, vcc
; SDAG-NEXT:    v_subb_u32_e32 v3, vcc, v3, v9, vcc
; SDAG-NEXT:    v_add_i32_e32 v8, vcc, v11, v10
; SDAG-NEXT:    v_addc_u32_e32 v9, vcc, v12, v17, vcc
; SDAG-NEXT:    v_mov_b32_e32 v10, v19
; SDAG-NEXT:    v_sub_i32_e32 v4, vcc, v4, v14
; SDAG-NEXT:    v_subb_u32_e32 v5, vcc, v5, v10, vcc
; SDAG-NEXT:    v_subb_u32_e32 v6, vcc, v6, v8, vcc
; SDAG-NEXT:    v_subb_u32_e32 v7, vcc, v7, v9, vcc
; SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-LABEL: v_urem_v2i128_vv:
; GISEL:       ; %bb.0: ; %_udiv-special-cases_udiv-special-cases
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_or_b32_e32 v16, v8, v10
; GISEL-NEXT:    v_or_b32_e32 v17, v9, v11
; GISEL-NEXT:    v_or_b32_e32 v18, v0, v2
; GISEL-NEXT:    v_or_b32_e32 v19, v1, v3
; GISEL-NEXT:    v_ffbh_u32_e32 v22, v9
; GISEL-NEXT:    v_ffbh_u32_e32 v23, v8
; GISEL-NEXT:    v_ffbh_u32_e32 v24, v11
; GISEL-NEXT:    v_ffbh_u32_e32 v25, v10
; GISEL-NEXT:    v_ffbh_u32_e32 v26, v1
; GISEL-NEXT:    v_ffbh_u32_e32 v27, v0
; GISEL-NEXT:    v_ffbh_u32_e32 v28, v3
; GISEL-NEXT:    v_ffbh_u32_e32 v29, v2
; GISEL-NEXT:    v_mov_b32_e32 v20, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v21, 0
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[18:19]
; GISEL-NEXT:    v_add_i32_e64 v16, s[6:7], 32, v23
; GISEL-NEXT:    v_add_i32_e64 v17, s[6:7], 32, v25
; GISEL-NEXT:    v_add_i32_e64 v18, s[6:7], 32, v27
; GISEL-NEXT:    v_add_i32_e64 v19, s[6:7], 32, v29
; GISEL-NEXT:    v_min_u32_e32 v16, v22, v16
; GISEL-NEXT:    v_min_u32_e32 v17, v24, v17
; GISEL-NEXT:    v_min_u32_e32 v18, v26, v18
; GISEL-NEXT:    v_min_u32_e32 v19, v28, v19
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v22, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v16, vcc, 64, v16
; GISEL-NEXT:    v_add_i32_e32 v18, vcc, 64, v18
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GISEL-NEXT:    v_cndmask_b32_e32 v16, v17, v16, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GISEL-NEXT:    v_cndmask_b32_e32 v17, v19, v18, vcc
; GISEL-NEXT:    v_sub_i32_e32 v16, vcc, v16, v17
; GISEL-NEXT:    v_subb_u32_e64 v17, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v18, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v19, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[16:17], v[20:21]
; GISEL-NEXT:    v_cndmask_b32_e64 v23, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v20, 0x7f, v16
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[18:19]
; GISEL-NEXT:    v_cndmask_b32_e64 v24, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v20, v20, v18
; GISEL-NEXT:    v_or_b32_e32 v21, v17, v19
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; GISEL-NEXT:    v_cndmask_b32_e32 v23, v24, v23, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[20:21]
; GISEL-NEXT:    v_cndmask_b32_e64 v20, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v21, v22, v23
; GISEL-NEXT:    v_and_b32_e32 v22, 1, v21
; GISEL-NEXT:    v_or_b32_e32 v20, v21, v20
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v22
; GISEL-NEXT:    v_cndmask_b32_e64 v32, v0, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v22, 1, v20
; GISEL-NEXT:    v_cndmask_b32_e64 v33, v1, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v20, v2, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v21, v3, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v22
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB3_6
; GISEL-NEXT:  ; %bb.1: ; %udiv-bb15
; GISEL-NEXT:    v_add_i32_e32 v30, vcc, 1, v16
; GISEL-NEXT:    v_addc_u32_e64 v31, s[4:5], 0, v17, vcc
; GISEL-NEXT:    v_sub_i32_e32 v26, vcc, 0x7f, v16
; GISEL-NEXT:    v_addc_u32_e64 v32, vcc, 0, v18, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v33, vcc, 0, v19, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v22, s[4:5], 64, v26
; GISEL-NEXT:    v_sub_i32_e64 v20, s[4:5], 64, v26
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[0:1], v26
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[2:3], v26
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[20:21], v[0:1], v20
; GISEL-NEXT:    v_lshl_b64 v[24:25], v[0:1], v22
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v22, 0, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v23, 0, v17, vcc
; GISEL-NEXT:    v_or_b32_e32 v16, v20, v18
; GISEL-NEXT:    v_or_b32_e32 v17, v21, v19
; GISEL-NEXT:    v_cndmask_b32_e32 v16, v24, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v17, v25, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v26
; GISEL-NEXT:    v_cndmask_b32_e32 v20, v16, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v21, v17, v3, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v19, s11
; GISEL-NEXT:    v_mov_b32_e32 v18, s10
; GISEL-NEXT:    v_mov_b32_e32 v17, s9
; GISEL-NEXT:    v_mov_b32_e32 v16, s8
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[8:9], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB3_5
; GISEL-NEXT:  ; %bb.2: ; %udiv-preheader4
; GISEL-NEXT:    v_subrev_i32_e32 v26, vcc, 64, v30
; GISEL-NEXT:    v_sub_i32_e32 v24, vcc, 64, v30
; GISEL-NEXT:    v_lshr_b64 v[16:17], v[2:3], v30
; GISEL-NEXT:    v_lshr_b64 v[18:19], v[0:1], v30
; GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GISEL-NEXT:    v_add_i32_e32 v34, vcc, -1, v8
; GISEL-NEXT:    v_addc_u32_e32 v35, vcc, -1, v9, vcc
; GISEL-NEXT:    v_lshl_b64 v[24:25], v[2:3], v24
; GISEL-NEXT:    v_lshr_b64 v[26:27], v[2:3], v26
; GISEL-NEXT:    v_addc_u32_e32 v36, vcc, -1, v10, vcc
; GISEL-NEXT:    v_addc_u32_e32 v37, vcc, -1, v11, vcc
; GISEL-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v24
; GISEL-NEXT:    v_or_b32_e32 v19, v19, v25
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v30
; GISEL-NEXT:    v_cndmask_b32_e32 v18, v26, v18, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v19, v27, v19, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v28, 0, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v29, 0, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v30
; GISEL-NEXT:    v_cndmask_b32_e32 v26, v18, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v27, v19, v1, vcc
; GISEL-NEXT:    v_mov_b32_e32 v25, 0
; GISEL-NEXT:    v_mov_b32_e32 v19, s7
; GISEL-NEXT:    v_mov_b32_e32 v18, s6
; GISEL-NEXT:    v_mov_b32_e32 v17, s5
; GISEL-NEXT:    v_mov_b32_e32 v16, s4
; GISEL-NEXT:  .LBB3_3: ; %udiv-do-while3
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[22:23], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v24, 31, v23
; GISEL-NEXT:    v_lshl_b64 v[38:39], v[26:27], 1
; GISEL-NEXT:    v_lshl_b64 v[28:29], v[28:29], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v26, 31, v27
; GISEL-NEXT:    v_lshrrev_b32_e32 v27, 31, v21
; GISEL-NEXT:    v_lshl_b64 v[20:21], v[20:21], 1
; GISEL-NEXT:    v_add_i32_e32 v30, vcc, -1, v30
; GISEL-NEXT:    v_addc_u32_e32 v31, vcc, -1, v31, vcc
; GISEL-NEXT:    v_or_b32_e32 v22, v16, v18
; GISEL-NEXT:    v_or_b32_e32 v23, v17, v19
; GISEL-NEXT:    v_or_b32_e32 v18, v28, v26
; GISEL-NEXT:    v_or_b32_e32 v19, v38, v27
; GISEL-NEXT:    v_or_b32_e32 v20, v20, v24
; GISEL-NEXT:    v_addc_u32_e32 v32, vcc, -1, v32, vcc
; GISEL-NEXT:    v_addc_u32_e32 v33, vcc, -1, v33, vcc
; GISEL-NEXT:    v_sub_i32_e32 v16, vcc, v34, v19
; GISEL-NEXT:    v_subb_u32_e32 v16, vcc, v35, v39, vcc
; GISEL-NEXT:    v_or_b32_e32 v16, v30, v32
; GISEL-NEXT:    v_or_b32_e32 v17, v31, v33
; GISEL-NEXT:    v_subb_u32_e32 v24, vcc, v36, v18, vcc
; GISEL-NEXT:    v_subb_u32_e32 v24, vcc, v37, v29, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; GISEL-NEXT:    v_ashrrev_i32_e32 v16, 31, v24
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v24, 1, v16
; GISEL-NEXT:    v_and_b32_e32 v17, v16, v8
; GISEL-NEXT:    v_and_b32_e32 v27, v16, v9
; GISEL-NEXT:    v_and_b32_e32 v28, v16, v10
; GISEL-NEXT:    v_and_b32_e32 v16, v16, v11
; GISEL-NEXT:    v_sub_i32_e32 v26, vcc, v19, v17
; GISEL-NEXT:    v_subb_u32_e32 v27, vcc, v39, v27, vcc
; GISEL-NEXT:    v_subb_u32_e32 v28, vcc, v18, v28, vcc
; GISEL-NEXT:    v_subb_u32_e32 v29, vcc, v29, v16, vcc
; GISEL-NEXT:    v_mov_b32_e32 v16, v24
; GISEL-NEXT:    v_mov_b32_e32 v17, v25
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GISEL-NEXT:    s_cbranch_execnz .LBB3_3
; GISEL-NEXT:  ; %bb.4: ; %Flow13
; GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GISEL-NEXT:  .LBB3_5: ; %Flow14
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[22:23], 1
; GISEL-NEXT:    v_lshl_b64 v[20:21], v[20:21], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v22, 31, v23
; GISEL-NEXT:    v_or_b32_e32 v20, v20, v22
; GISEL-NEXT:    v_or_b32_e32 v32, v16, v18
; GISEL-NEXT:    v_or_b32_e32 v33, v17, v19
; GISEL-NEXT:  .LBB3_6: ; %Flow16
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    s_mov_b64 s[8:9], 0
; GISEL-NEXT:    v_or_b32_e32 v16, v12, v14
; GISEL-NEXT:    v_or_b32_e32 v17, v13, v15
; GISEL-NEXT:    v_or_b32_e32 v18, v4, v6
; GISEL-NEXT:    v_or_b32_e32 v19, v5, v7
; GISEL-NEXT:    v_ffbh_u32_e32 v22, v13
; GISEL-NEXT:    v_ffbh_u32_e32 v23, v12
; GISEL-NEXT:    v_ffbh_u32_e32 v26, v15
; GISEL-NEXT:    v_ffbh_u32_e32 v27, v14
; GISEL-NEXT:    v_ffbh_u32_e32 v28, v5
; GISEL-NEXT:    v_ffbh_u32_e32 v29, v4
; GISEL-NEXT:    v_ffbh_u32_e32 v30, v7
; GISEL-NEXT:    v_ffbh_u32_e32 v31, v6
; GISEL-NEXT:    v_mov_b32_e32 v24, 0x7f
; GISEL-NEXT:    v_mov_b32_e32 v25, 0
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; GISEL-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[18:19]
; GISEL-NEXT:    v_add_i32_e64 v16, s[6:7], 32, v23
; GISEL-NEXT:    v_add_i32_e64 v17, s[6:7], 32, v27
; GISEL-NEXT:    v_add_i32_e64 v18, s[6:7], 32, v29
; GISEL-NEXT:    v_add_i32_e64 v19, s[6:7], 32, v31
; GISEL-NEXT:    v_min_u32_e32 v16, v22, v16
; GISEL-NEXT:    v_min_u32_e32 v17, v26, v17
; GISEL-NEXT:    v_min_u32_e32 v18, v28, v18
; GISEL-NEXT:    v_min_u32_e32 v19, v30, v19
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v26, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v16, vcc, 64, v16
; GISEL-NEXT:    v_add_i32_e32 v18, vcc, 64, v18
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GISEL-NEXT:    v_cndmask_b32_e32 v16, v17, v16, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GISEL-NEXT:    v_cndmask_b32_e32 v17, v19, v18, vcc
; GISEL-NEXT:    v_sub_i32_e32 v16, vcc, v16, v17
; GISEL-NEXT:    v_subb_u32_e64 v17, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_subb_u32_e64 v22, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_subb_u32_e64 v23, s[4:5], 0, 0, s[4:5]
; GISEL-NEXT:    v_cmp_gt_u64_e32 vcc, v[16:17], v[24:25]
; GISEL-NEXT:    v_cndmask_b32_e64 v24, 0, 1, vcc
; GISEL-NEXT:    v_xor_b32_e32 v18, 0x7f, v16
; GISEL-NEXT:    v_cmp_lt_u64_e32 vcc, 0, v[22:23]
; GISEL-NEXT:    v_cndmask_b32_e64 v25, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v22
; GISEL-NEXT:    v_or_b32_e32 v19, v17, v23
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[22:23]
; GISEL-NEXT:    v_cndmask_b32_e32 v24, v25, v24, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; GISEL-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; GISEL-NEXT:    v_or_b32_e32 v19, v26, v24
; GISEL-NEXT:    v_and_b32_e32 v24, 1, v19
; GISEL-NEXT:    v_or_b32_e32 v18, v19, v18
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v24
; GISEL-NEXT:    v_cndmask_b32_e64 v24, v4, 0, vcc
; GISEL-NEXT:    v_and_b32_e32 v26, 1, v18
; GISEL-NEXT:    v_cndmask_b32_e64 v25, v5, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v18, v6, 0, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v19, v7, 0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v26
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], s[4:5]
; GISEL-NEXT:    s_cbranch_execz .LBB3_12
; GISEL-NEXT:  ; %bb.7: ; %udiv-bb1
; GISEL-NEXT:    v_add_i32_e32 v34, vcc, 1, v16
; GISEL-NEXT:    v_addc_u32_e64 v35, s[4:5], 0, v17, vcc
; GISEL-NEXT:    v_sub_i32_e32 v28, vcc, 0x7f, v16
; GISEL-NEXT:    v_addc_u32_e64 v36, vcc, 0, v22, s[4:5]
; GISEL-NEXT:    v_addc_u32_e32 v37, vcc, 0, v23, vcc
; GISEL-NEXT:    v_subrev_i32_e64 v24, s[4:5], 64, v28
; GISEL-NEXT:    v_sub_i32_e64 v22, s[4:5], 64, v28
; GISEL-NEXT:    v_lshl_b64 v[16:17], v[4:5], v28
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[6:7], v28
; GISEL-NEXT:    s_xor_b64 s[4:5], vcc, -1
; GISEL-NEXT:    v_lshr_b64 v[22:23], v[4:5], v22
; GISEL-NEXT:    v_lshl_b64 v[26:27], v[4:5], v24
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v28
; GISEL-NEXT:    v_cndmask_b32_e32 v24, 0, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v25, 0, v17, vcc
; GISEL-NEXT:    v_or_b32_e32 v16, v22, v18
; GISEL-NEXT:    v_or_b32_e32 v17, v23, v19
; GISEL-NEXT:    v_cndmask_b32_e32 v16, v26, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v17, v27, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v28
; GISEL-NEXT:    v_cndmask_b32_e32 v22, v16, v6, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v23, v17, v7, vcc
; GISEL-NEXT:    s_mov_b64 s[10:11], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v19, s11
; GISEL-NEXT:    v_mov_b32_e32 v18, s10
; GISEL-NEXT:    v_mov_b32_e32 v17, s9
; GISEL-NEXT:    v_mov_b32_e32 v16, s8
; GISEL-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GISEL-NEXT:    s_xor_b64 s[8:9], exec, s[6:7]
; GISEL-NEXT:    s_cbranch_execz .LBB3_11
; GISEL-NEXT:  ; %bb.8: ; %udiv-preheader
; GISEL-NEXT:    v_subrev_i32_e32 v28, vcc, 64, v34
; GISEL-NEXT:    v_sub_i32_e32 v26, vcc, 64, v34
; GISEL-NEXT:    v_lshr_b64 v[16:17], v[6:7], v34
; GISEL-NEXT:    v_lshr_b64 v[18:19], v[4:5], v34
; GISEL-NEXT:    s_mov_b64 s[4:5], 0
; GISEL-NEXT:    v_add_i32_e32 v38, vcc, -1, v12
; GISEL-NEXT:    v_addc_u32_e32 v39, vcc, -1, v13, vcc
; GISEL-NEXT:    v_lshl_b64 v[26:27], v[6:7], v26
; GISEL-NEXT:    v_lshr_b64 v[28:29], v[6:7], v28
; GISEL-NEXT:    v_addc_u32_e32 v48, vcc, -1, v14, vcc
; GISEL-NEXT:    v_addc_u32_e32 v49, vcc, -1, v15, vcc
; GISEL-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v26
; GISEL-NEXT:    v_or_b32_e32 v19, v19, v27
; GISEL-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v34
; GISEL-NEXT:    v_cndmask_b32_e32 v18, v28, v18, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v19, v29, v19, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v30, 0, v16, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v31, 0, v17, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v34
; GISEL-NEXT:    v_cndmask_b32_e32 v28, v18, v4, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v29, v19, v5, vcc
; GISEL-NEXT:    v_mov_b32_e32 v27, 0
; GISEL-NEXT:    v_mov_b32_e32 v19, s7
; GISEL-NEXT:    v_mov_b32_e32 v18, s6
; GISEL-NEXT:    v_mov_b32_e32 v17, s5
; GISEL-NEXT:    v_mov_b32_e32 v16, s4
; GISEL-NEXT:  .LBB3_9: ; %udiv-do-while
; GISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[24:25], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v26, 31, v25
; GISEL-NEXT:    v_lshl_b64 v[50:51], v[28:29], 1
; GISEL-NEXT:    v_lshl_b64 v[30:31], v[30:31], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v28, 31, v29
; GISEL-NEXT:    v_lshrrev_b32_e32 v29, 31, v23
; GISEL-NEXT:    v_lshl_b64 v[22:23], v[22:23], 1
; GISEL-NEXT:    v_add_i32_e32 v34, vcc, -1, v34
; GISEL-NEXT:    v_addc_u32_e32 v35, vcc, -1, v35, vcc
; GISEL-NEXT:    v_or_b32_e32 v24, v16, v18
; GISEL-NEXT:    v_or_b32_e32 v25, v17, v19
; GISEL-NEXT:    v_or_b32_e32 v18, v30, v28
; GISEL-NEXT:    v_or_b32_e32 v19, v50, v29
; GISEL-NEXT:    v_or_b32_e32 v22, v22, v26
; GISEL-NEXT:    v_addc_u32_e32 v36, vcc, -1, v36, vcc
; GISEL-NEXT:    v_addc_u32_e32 v37, vcc, -1, v37, vcc
; GISEL-NEXT:    v_sub_i32_e32 v16, vcc, v38, v19
; GISEL-NEXT:    v_subb_u32_e32 v16, vcc, v39, v51, vcc
; GISEL-NEXT:    v_or_b32_e32 v16, v34, v36
; GISEL-NEXT:    v_or_b32_e32 v17, v35, v37
; GISEL-NEXT:    v_subb_u32_e32 v26, vcc, v48, v18, vcc
; GISEL-NEXT:    v_subb_u32_e32 v26, vcc, v49, v31, vcc
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; GISEL-NEXT:    v_ashrrev_i32_e32 v16, 31, v26
; GISEL-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v26, 1, v16
; GISEL-NEXT:    v_and_b32_e32 v17, v16, v12
; GISEL-NEXT:    v_and_b32_e32 v29, v16, v13
; GISEL-NEXT:    v_and_b32_e32 v30, v16, v14
; GISEL-NEXT:    v_and_b32_e32 v50, v16, v15
; GISEL-NEXT:    v_sub_i32_e32 v28, vcc, v19, v17
; GISEL-NEXT:    v_subb_u32_e32 v29, vcc, v51, v29, vcc
; GISEL-NEXT:    v_mov_b32_e32 v16, v26
; GISEL-NEXT:    v_mov_b32_e32 v17, v27
; GISEL-NEXT:    v_subb_u32_e32 v30, vcc, v18, v30, vcc
; GISEL-NEXT:    v_subb_u32_e32 v31, vcc, v31, v50, vcc
; GISEL-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GISEL-NEXT:    s_cbranch_execnz .LBB3_9
; GISEL-NEXT:  ; %bb.10: ; %Flow
; GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GISEL-NEXT:  .LBB3_11: ; %Flow11
; GISEL-NEXT:    s_or_b64 exec, exec, s[8:9]
; GISEL-NEXT:    v_lshl_b64 v[26:27], v[24:25], 1
; GISEL-NEXT:    v_lshl_b64 v[18:19], v[22:23], 1
; GISEL-NEXT:    v_lshrrev_b32_e32 v22, 31, v25
; GISEL-NEXT:    v_or_b32_e32 v18, v18, v22
; GISEL-NEXT:    v_or_b32_e32 v24, v16, v26
; GISEL-NEXT:    v_or_b32_e32 v25, v17, v27
; GISEL-NEXT:  .LBB3_12: ; %Flow12
; GISEL-NEXT:    s_or_b64 exec, exec, s[12:13]
; GISEL-NEXT:    v_mad_u64_u32 v[16:17], s[4:5], v8, v32, 0
; GISEL-NEXT:    v_mad_u64_u32 v[22:23], s[4:5], v8, v20, 0
; GISEL-NEXT:    v_mul_lo_u32 v28, v8, v21
; GISEL-NEXT:    v_mul_lo_u32 v29, v9, v20
; GISEL-NEXT:    v_mad_u64_u32 v[20:21], s[4:5], v12, v24, 0
; GISEL-NEXT:    v_mad_u64_u32 v[26:27], s[4:5], v12, v18, 0
; GISEL-NEXT:    v_mul_lo_u32 v30, v12, v19
; GISEL-NEXT:    v_mul_lo_u32 v31, v13, v18
; GISEL-NEXT:    v_mad_u64_u32 v[18:19], s[4:5], v9, v33, v[22:23]
; GISEL-NEXT:    v_mad_u64_u32 v[22:23], s[4:5], v13, v25, v[26:27]
; GISEL-NEXT:    v_mad_u64_u32 v[18:19], s[4:5], v10, v32, v[18:19]
; GISEL-NEXT:    v_mad_u64_u32 v[22:23], s[4:5], v14, v24, v[22:23]
; GISEL-NEXT:    v_mad_u64_u32 v[17:18], vcc, v8, v33, v[17:18]
; GISEL-NEXT:    v_mad_u64_u32 v[21:22], s[4:5], v12, v25, v[21:22]
; GISEL-NEXT:    v_mad_u64_u32 v[8:9], s[6:7], v9, v32, v[17:18]
; GISEL-NEXT:    v_addc_u32_e64 v17, s[6:7], v19, v28, s[6:7]
; GISEL-NEXT:    v_mad_u64_u32 v[12:13], s[6:7], v13, v24, v[21:22]
; GISEL-NEXT:    v_addc_u32_e64 v18, s[6:7], v23, v30, s[6:7]
; GISEL-NEXT:    v_addc_u32_e32 v17, vcc, v17, v29, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v16
; GISEL-NEXT:    v_subb_u32_e32 v1, vcc, v1, v8, vcc
; GISEL-NEXT:    v_addc_u32_e64 v8, s[4:5], v18, v31, s[4:5]
; GISEL-NEXT:    v_sub_i32_e64 v4, s[4:5], v4, v20
; GISEL-NEXT:    v_subb_u32_e64 v5, s[4:5], v5, v12, s[4:5]
; GISEL-NEXT:    v_mad_u64_u32 v[16:17], s[6:7], v10, v33, v[17:18]
; GISEL-NEXT:    v_mad_u64_u32 v[18:19], s[6:7], v14, v25, v[8:9]
; GISEL-NEXT:    v_mad_u64_u32 v[10:11], s[6:7], v11, v32, v[16:17]
; GISEL-NEXT:    v_mad_u64_u32 v[11:12], s[6:7], v15, v24, v[18:19]
; GISEL-NEXT:    v_subb_u32_e32 v2, vcc, v2, v9, vcc
; GISEL-NEXT:    v_subb_u32_e32 v3, vcc, v3, v10, vcc
; GISEL-NEXT:    v_subb_u32_e64 v6, vcc, v6, v13, s[4:5]
; GISEL-NEXT:    v_subb_u32_e32 v7, vcc, v7, v11, vcc
; GISEL-NEXT:    s_setpc_b64 s[30:31]
  %shl = urem <2 x i128> %lhs, %rhs
  ret <2 x i128> %shl
}
