; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+x87,-sse2,-sse | FileCheck %s --check-prefixes=X64,SDAG-X64-ISEL
; RUN: llc < %s -mtriple=x86_64-- -mattr=+x87,-sse2,-sse -fast-isel | FileCheck %s --check-prefixes=X64,FAST-X64-ISEL
; RUN: llc < %s -mtriple=x86_64-- -mattr=+x87,-sse2,-sse -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=X64,GISEL-X64-ISEL
; RUN: llc < %s -mtriple=i686-- -mattr=+x87,-sse2,-sse | FileCheck %s --check-prefixes=X86,SDAG-X86-ISEL
; RUN: llc < %s -mtriple=i686-- -mattr=+x87,-sse2,-sse -fast-isel | FileCheck %s --check-prefixes=X86,FAST-X86-ISEL
; RUN: llc < %s -mtriple=i686-- -mattr=+x87,-sse2,-sse -global-isel -global-isel-abort=0 | FileCheck %s --check-prefixes=X86,GISEL-X86-ISEL

define void @test_float_abs(ptr %argptr)   {
; SDAG-X64-ISEL-LABEL: test_float_abs:
; SDAG-X64-ISEL:       # %bb.0:
; SDAG-X64-ISEL-NEXT:    andb $127, 3(%rdi)
; SDAG-X64-ISEL-NEXT:    retq
;
; FAST-X64-ISEL-LABEL: test_float_abs:
; FAST-X64-ISEL:       # %bb.0:
; FAST-X64-ISEL-NEXT:    andb $127, 3(%rdi)
; FAST-X64-ISEL-NEXT:    retq
;
; GISEL-X64-ISEL-LABEL: test_float_abs:
; GISEL-X64-ISEL:       # %bb.0:
; GISEL-X64-ISEL-NEXT:    andl $2147483647, (%rdi) # imm = 0x7FFFFFFF
; GISEL-X64-ISEL-NEXT:    retq
;
; SDAG-X86-ISEL-LABEL: test_float_abs:
; SDAG-X86-ISEL:       # %bb.0:
; SDAG-X86-ISEL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-ISEL-NEXT:    andb $127, 3(%eax)
; SDAG-X86-ISEL-NEXT:    retl
;
; FAST-X86-ISEL-LABEL: test_float_abs:
; FAST-X86-ISEL:       # %bb.0:
; FAST-X86-ISEL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-ISEL-NEXT:    andb $127, 3(%eax)
; FAST-X86-ISEL-NEXT:    retl
;
; GISEL-X86-ISEL-LABEL: test_float_abs:
; GISEL-X86-ISEL:       # %bb.0:
; GISEL-X86-ISEL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-ISEL-NEXT:    andl $2147483647, (%eax) # imm = 0x7FFFFFFF
; GISEL-X86-ISEL-NEXT:    retl
     %arg = load  float, float* %argptr
     %abs = tail call float @llvm.fabs.f32(float %arg)
     store float %abs, ptr %argptr
     ret void
 }

define void @test_double_abs(ptr %argptr)  {
; SDAG-X64-ISEL-LABEL: test_double_abs:
; SDAG-X64-ISEL:       # %bb.0:
; SDAG-X64-ISEL-NEXT:    andb $127, 7(%rdi)
; SDAG-X64-ISEL-NEXT:    retq
;
; FAST-X64-ISEL-LABEL: test_double_abs:
; FAST-X64-ISEL:       # %bb.0:
; FAST-X64-ISEL-NEXT:    andb $127, 7(%rdi)
; FAST-X64-ISEL-NEXT:    retq
;
; GISEL-X64-ISEL-LABEL: test_double_abs:
; GISEL-X64-ISEL:       # %bb.0:
; GISEL-X64-ISEL-NEXT:    movabsq $9223372036854775807, %rax # imm = 0x7FFFFFFFFFFFFFFF
; GISEL-X64-ISEL-NEXT:    andq %rax, (%rdi)
; GISEL-X64-ISEL-NEXT:    retq
;
; X86-LABEL: test_double_abs:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    fldl (%eax)
; X86-NEXT:    fabs
; X86-NEXT:    fstpl (%eax)
; X86-NEXT:    retl
    %arg = load double, double* %argptr
    %abs = tail call double @llvm.fabs.f64(double %arg)
    store double %abs, double* %argptr
    ret void
}

define x86_fp80 @test_x86_fp80_abs(x86_fp80 %arg) {
; X64-LABEL: test_x86_fp80_abs:
; X64:       # %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fabs
; X64-NEXT:    retq
;
; X86-LABEL: test_x86_fp80_abs:
; X86:       # %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fabs
; X86-NEXT:    retl
  %abs = tail call x86_fp80 @llvm.fabs.f80(x86_fp80 %arg)
  ret x86_fp80 %abs
}
