// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/alpha/webhook/v1alpha1/event.proto

package webhookv1alpha1

import (
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// EventRequest is the request payload that will be sent to the customer
// that is subscribed to webhook events in the BSR.
type EventRequest struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Event   v1alpha1.WebhookEvent  `protobuf:"varint,1,opt,name=event,proto3,enum=buf.alpha.registry.v1alpha1.WebhookEvent"`
	xxx_hidden_Payload *EventPayload          `protobuf:"bytes,2,opt,name=payload,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *EventRequest) Reset() {
	*x = EventRequest{}
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventRequest) ProtoMessage() {}

func (x *EventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EventRequest) GetEvent() v1alpha1.WebhookEvent {
	if x != nil {
		return x.xxx_hidden_Event
	}
	return v1alpha1.WebhookEvent(0)
}

func (x *EventRequest) GetPayload() *EventPayload {
	if x != nil {
		return x.xxx_hidden_Payload
	}
	return nil
}

func (x *EventRequest) SetEvent(v v1alpha1.WebhookEvent) {
	x.xxx_hidden_Event = v
}

func (x *EventRequest) SetPayload(v *EventPayload) {
	x.xxx_hidden_Payload = v
}

func (x *EventRequest) HasPayload() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Payload != nil
}

func (x *EventRequest) ClearPayload() {
	x.xxx_hidden_Payload = nil
}

type EventRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The webhook event that was triggered. This event is the same one that is
	// registered when creating a webhook in the BSR.
	Event v1alpha1.WebhookEvent
	// The event payload of the event was triggered.
	Payload *EventPayload
}

func (b0 EventRequest_builder) Build() *EventRequest {
	m0 := &EventRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Event = b.Event
	x.xxx_hidden_Payload = b.Payload
	return m0
}

// EventPayload contains the actual event payload for all possible
// webhook event types.
type EventPayload struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Payload isEventPayload_Payload `protobuf_oneof:"payload"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *EventPayload) Reset() {
	*x = EventPayload{}
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventPayload) ProtoMessage() {}

func (x *EventPayload) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EventPayload) GetRepositoryPush() *RepositoryPushEvent {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*eventPayload_RepositoryPush); ok {
			return x.RepositoryPush
		}
	}
	return nil
}

func (x *EventPayload) SetRepositoryPush(v *RepositoryPushEvent) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &eventPayload_RepositoryPush{v}
}

func (x *EventPayload) HasPayload() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Payload != nil
}

func (x *EventPayload) HasRepositoryPush() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*eventPayload_RepositoryPush)
	return ok
}

func (x *EventPayload) ClearPayload() {
	x.xxx_hidden_Payload = nil
}

func (x *EventPayload) ClearRepositoryPush() {
	if _, ok := x.xxx_hidden_Payload.(*eventPayload_RepositoryPush); ok {
		x.xxx_hidden_Payload = nil
	}
}

const EventPayload_Payload_not_set_case case_EventPayload_Payload = 0
const EventPayload_RepositoryPush_case case_EventPayload_Payload = 1

func (x *EventPayload) WhichPayload() case_EventPayload_Payload {
	if x == nil {
		return EventPayload_Payload_not_set_case
	}
	switch x.xxx_hidden_Payload.(type) {
	case *eventPayload_RepositoryPush:
		return EventPayload_RepositoryPush_case
	default:
		return EventPayload_Payload_not_set_case
	}
}

type EventPayload_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Payload:
	RepositoryPush *RepositoryPushEvent
	// -- end of xxx_hidden_Payload
}

func (b0 EventPayload_builder) Build() *EventPayload {
	m0 := &EventPayload{}
	b, x := &b0, m0
	_, _ = b, x
	if b.RepositoryPush != nil {
		x.xxx_hidden_Payload = &eventPayload_RepositoryPush{b.RepositoryPush}
	}
	return m0
}

type case_EventPayload_Payload protoreflect.FieldNumber

func (x case_EventPayload_Payload) String() string {
	md := file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isEventPayload_Payload interface {
	isEventPayload_Payload()
}

type eventPayload_RepositoryPush struct {
	RepositoryPush *RepositoryPushEvent `protobuf:"bytes,1,opt,name=repository_push,json=repositoryPush,proto3,oneof"`
}

func (*eventPayload_RepositoryPush) isEventPayload_Payload() {}

// EventResponse is the empty response payload from the customer to Buf.
type EventResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EventResponse) Reset() {
	*x = EventResponse{}
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventResponse) ProtoMessage() {}

func (x *EventResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type EventResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 EventResponse_builder) Build() *EventResponse {
	m0 := &EventResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// Payload for the event WEBHOOK_EVENT_REPOSITORY_PUSH.
type RepositoryPushEvent struct {
	state                       protoimpl.MessageState     `protogen:"opaque.v1"`
	xxx_hidden_EventTime        *timestamppb.Timestamp     `protobuf:"bytes,1,opt,name=event_time,json=eventTime,proto3"`
	xxx_hidden_RepositoryCommit *v1alpha1.RepositoryCommit `protobuf:"bytes,2,opt,name=repository_commit,json=repositoryCommit,proto3"`
	xxx_hidden_Repository       *v1alpha1.Repository       `protobuf:"bytes,3,opt,name=repository,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *RepositoryPushEvent) Reset() {
	*x = RepositoryPushEvent{}
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryPushEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryPushEvent) ProtoMessage() {}

func (x *RepositoryPushEvent) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryPushEvent) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_EventTime
	}
	return nil
}

func (x *RepositoryPushEvent) GetRepositoryCommit() *v1alpha1.RepositoryCommit {
	if x != nil {
		return x.xxx_hidden_RepositoryCommit
	}
	return nil
}

func (x *RepositoryPushEvent) GetRepository() *v1alpha1.Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *RepositoryPushEvent) SetEventTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_EventTime = v
}

func (x *RepositoryPushEvent) SetRepositoryCommit(v *v1alpha1.RepositoryCommit) {
	x.xxx_hidden_RepositoryCommit = v
}

func (x *RepositoryPushEvent) SetRepository(v *v1alpha1.Repository) {
	x.xxx_hidden_Repository = v
}

func (x *RepositoryPushEvent) HasEventTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_EventTime != nil
}

func (x *RepositoryPushEvent) HasRepositoryCommit() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RepositoryCommit != nil
}

func (x *RepositoryPushEvent) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *RepositoryPushEvent) ClearEventTime() {
	x.xxx_hidden_EventTime = nil
}

func (x *RepositoryPushEvent) ClearRepositoryCommit() {
	x.xxx_hidden_RepositoryCommit = nil
}

func (x *RepositoryPushEvent) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

type RepositoryPushEvent_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The timestamp of the commit push.
	EventTime *timestamppb.Timestamp
	// The repository commit that was pushed.
	RepositoryCommit *v1alpha1.RepositoryCommit
	// The repository that was pushed.
	Repository *v1alpha1.Repository
}

func (b0 RepositoryPushEvent_builder) Build() *RepositoryPushEvent {
	m0 := &RepositoryPushEvent{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_EventTime = b.EventTime
	x.xxx_hidden_RepositoryCommit = b.RepositoryCommit
	x.xxx_hidden_Repository = b.Repository
	return m0
}

var File_buf_alpha_webhook_v1alpha1_event_proto protoreflect.FileDescriptor

const file_buf_alpha_webhook_v1alpha1_event_proto_rawDesc = "" +
	"\n" +
	"&buf/alpha/webhook/v1alpha1/event.proto\x12\x1abuf.alpha.webhook.v1alpha1\x1a,buf/alpha/registry/v1alpha1/repository.proto\x1a3buf/alpha/registry/v1alpha1/repository_commit.proto\x1a)buf/alpha/registry/v1alpha1/webhook.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\x93\x01\n" +
	"\fEventRequest\x12?\n" +
	"\x05event\x18\x01 \x01(\x0e2).buf.alpha.registry.v1alpha1.WebhookEventR\x05event\x12B\n" +
	"\apayload\x18\x02 \x01(\v2(.buf.alpha.webhook.v1alpha1.EventPayloadR\apayload\"u\n" +
	"\fEventPayload\x12Z\n" +
	"\x0frepository_push\x18\x01 \x01(\v2/.buf.alpha.webhook.v1alpha1.RepositoryPushEventH\x00R\x0erepositoryPushB\t\n" +
	"\apayload\"\x0f\n" +
	"\rEventResponse\"\xf5\x01\n" +
	"\x13RepositoryPushEvent\x129\n" +
	"\n" +
	"event_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\teventTime\x12Z\n" +
	"\x11repository_commit\x18\x02 \x01(\v2-.buf.alpha.registry.v1alpha1.RepositoryCommitR\x10repositoryCommit\x12G\n" +
	"\n" +
	"repository\x18\x03 \x01(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\n" +
	"repository2l\n" +
	"\fEventService\x12\\\n" +
	"\x05Event\x12(.buf.alpha.webhook.v1alpha1.EventRequest\x1a).buf.alpha.webhook.v1alpha1.EventResponseB\x90\x02\n" +
	"\x1ecom.buf.alpha.webhook.v1alpha1B\n" +
	"EventProtoP\x01ZWgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/webhook/v1alpha1;webhookv1alpha1\xa2\x02\x03BAW\xaa\x02\x1aBuf.Alpha.Webhook.V1alpha1\xca\x02\x1aBuf\\Alpha\\Webhook\\V1alpha1\xe2\x02&Buf\\Alpha\\Webhook\\V1alpha1\\GPBMetadata\xea\x02\x1dBuf::Alpha::Webhook::V1alpha1b\x06proto3"

var file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_buf_alpha_webhook_v1alpha1_event_proto_goTypes = []any{
	(*EventRequest)(nil),              // 0: buf.alpha.webhook.v1alpha1.EventRequest
	(*EventPayload)(nil),              // 1: buf.alpha.webhook.v1alpha1.EventPayload
	(*EventResponse)(nil),             // 2: buf.alpha.webhook.v1alpha1.EventResponse
	(*RepositoryPushEvent)(nil),       // 3: buf.alpha.webhook.v1alpha1.RepositoryPushEvent
	(v1alpha1.WebhookEvent)(0),        // 4: buf.alpha.registry.v1alpha1.WebhookEvent
	(*timestamppb.Timestamp)(nil),     // 5: google.protobuf.Timestamp
	(*v1alpha1.RepositoryCommit)(nil), // 6: buf.alpha.registry.v1alpha1.RepositoryCommit
	(*v1alpha1.Repository)(nil),       // 7: buf.alpha.registry.v1alpha1.Repository
}
var file_buf_alpha_webhook_v1alpha1_event_proto_depIdxs = []int32{
	4, // 0: buf.alpha.webhook.v1alpha1.EventRequest.event:type_name -> buf.alpha.registry.v1alpha1.WebhookEvent
	1, // 1: buf.alpha.webhook.v1alpha1.EventRequest.payload:type_name -> buf.alpha.webhook.v1alpha1.EventPayload
	3, // 2: buf.alpha.webhook.v1alpha1.EventPayload.repository_push:type_name -> buf.alpha.webhook.v1alpha1.RepositoryPushEvent
	5, // 3: buf.alpha.webhook.v1alpha1.RepositoryPushEvent.event_time:type_name -> google.protobuf.Timestamp
	6, // 4: buf.alpha.webhook.v1alpha1.RepositoryPushEvent.repository_commit:type_name -> buf.alpha.registry.v1alpha1.RepositoryCommit
	7, // 5: buf.alpha.webhook.v1alpha1.RepositoryPushEvent.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	0, // 6: buf.alpha.webhook.v1alpha1.EventService.Event:input_type -> buf.alpha.webhook.v1alpha1.EventRequest
	2, // 7: buf.alpha.webhook.v1alpha1.EventService.Event:output_type -> buf.alpha.webhook.v1alpha1.EventResponse
	7, // [7:8] is the sub-list for method output_type
	6, // [6:7] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_buf_alpha_webhook_v1alpha1_event_proto_init() }
func file_buf_alpha_webhook_v1alpha1_event_proto_init() {
	if File_buf_alpha_webhook_v1alpha1_event_proto != nil {
		return
	}
	file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes[1].OneofWrappers = []any{
		(*eventPayload_RepositoryPush)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_webhook_v1alpha1_event_proto_rawDesc), len(file_buf_alpha_webhook_v1alpha1_event_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_webhook_v1alpha1_event_proto_goTypes,
		DependencyIndexes: file_buf_alpha_webhook_v1alpha1_event_proto_depIdxs,
		MessageInfos:      file_buf_alpha_webhook_v1alpha1_event_proto_msgTypes,
	}.Build()
	File_buf_alpha_webhook_v1alpha1_event_proto = out.File
	file_buf_alpha_webhook_v1alpha1_event_proto_goTypes = nil
	file_buf_alpha_webhook_v1alpha1_event_proto_depIdxs = nil
}
