/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.utils;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.DMatch;
import org.opencv.core.KeyPoint;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfDMatch;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Point;
import org.opencv.core.Point3;
import org.opencv.core.Rect;
import org.opencv.core.Rect2d;
import org.opencv.core.RotatedRect;
import org.opencv.core.Size;

public class Converters {
    public static Mat vector_Point_to_Mat(List<Point> list) {
        return Converters.vector_Point_to_Mat(list, 4);
    }

    public static Mat vector_Point2f_to_Mat(List<Point> list) {
        return Converters.vector_Point_to_Mat(list, 5);
    }

    public static Mat vector_Point2d_to_Mat(List<Point> list) {
        return Converters.vector_Point_to_Mat(list, 6);
    }

    public static Mat vector_Point_to_Mat(List<Point> list, int n) {
        Mat mat;
        block9: {
            block8: {
                int n2;
                int n3 = n2 = list != null ? list.size() : 0;
                if (n2 <= 0) break block8;
                switch (n) {
                    case 4: {
                        mat = new Mat(n2, 1, CvType.CV_32SC2);
                        int[] nArray = new int[n2 * 2];
                        for (int i = 0; i < n2; ++i) {
                            Point point = list.get(i);
                            nArray[i * 2] = (int)point.x;
                            nArray[i * 2 + 1] = (int)point.y;
                        }
                        mat.put(0, 0, nArray);
                        break block9;
                    }
                    case 5: {
                        mat = new Mat(n2, 1, CvType.CV_32FC2);
                        float[] fArray = new float[n2 * 2];
                        for (int i = 0; i < n2; ++i) {
                            Point point = list.get(i);
                            fArray[i * 2] = (float)point.x;
                            fArray[i * 2 + 1] = (float)point.y;
                        }
                        mat.put(0, 0, fArray);
                        break block9;
                    }
                    case 6: {
                        mat = new Mat(n2, 1, CvType.CV_64FC2);
                        double[] dArray = new double[n2 * 2];
                        for (int i = 0; i < n2; ++i) {
                            Point point = list.get(i);
                            dArray[i * 2] = point.x;
                            dArray[i * 2 + 1] = point.y;
                        }
                        mat.put(0, 0, dArray);
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("'typeDepth' can be CV_32S, CV_32F or CV_64F");
                    }
                }
            }
            mat = new Mat();
        }
        return mat;
    }

    public static Mat vector_Point3i_to_Mat(List<Point3> list) {
        return Converters.vector_Point3_to_Mat(list, 4);
    }

    public static Mat vector_Point3f_to_Mat(List<Point3> list) {
        return Converters.vector_Point3_to_Mat(list, 5);
    }

    public static Mat vector_Point3d_to_Mat(List<Point3> list) {
        return Converters.vector_Point3_to_Mat(list, 6);
    }

    public static Mat vector_Point3_to_Mat(List<Point3> list, int n) {
        Mat mat;
        block9: {
            block8: {
                int n2;
                int n3 = n2 = list != null ? list.size() : 0;
                if (n2 <= 0) break block8;
                switch (n) {
                    case 4: {
                        mat = new Mat(n2, 1, CvType.CV_32SC3);
                        int[] nArray = new int[n2 * 3];
                        for (int i = 0; i < n2; ++i) {
                            Point3 point3 = list.get(i);
                            nArray[i * 3] = (int)point3.x;
                            nArray[i * 3 + 1] = (int)point3.y;
                            nArray[i * 3 + 2] = (int)point3.z;
                        }
                        mat.put(0, 0, nArray);
                        break block9;
                    }
                    case 5: {
                        mat = new Mat(n2, 1, CvType.CV_32FC3);
                        float[] fArray = new float[n2 * 3];
                        for (int i = 0; i < n2; ++i) {
                            Point3 point3 = list.get(i);
                            fArray[i * 3] = (float)point3.x;
                            fArray[i * 3 + 1] = (float)point3.y;
                            fArray[i * 3 + 2] = (float)point3.z;
                        }
                        mat.put(0, 0, fArray);
                        break block9;
                    }
                    case 6: {
                        mat = new Mat(n2, 1, CvType.CV_64FC3);
                        double[] dArray = new double[n2 * 3];
                        for (int i = 0; i < n2; ++i) {
                            Point3 point3 = list.get(i);
                            dArray[i * 3] = point3.x;
                            dArray[i * 3 + 1] = point3.y;
                            dArray[i * 3 + 2] = point3.z;
                        }
                        mat.put(0, 0, dArray);
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("'typeDepth' can be CV_32S, CV_32F or CV_64F");
                    }
                }
            }
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_Point2f(Mat mat, List<Point> list) {
        Converters.Mat_to_vector_Point(mat, list);
    }

    public static void Mat_to_vector_Point2d(Mat mat, List<Point> list) {
        Converters.Mat_to_vector_Point(mat, list);
    }

    public static void Mat_to_vector_Point(Mat mat, List<Point> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        int n = mat.rows();
        int n2 = mat.type();
        if (mat.cols() != 1) {
            throw new IllegalArgumentException("Input Mat should have one column\n" + mat);
        }
        list.clear();
        if (n2 == CvType.CV_32SC2) {
            int[] nArray = new int[2 * n];
            mat.get(0, 0, nArray);
            for (int i = 0; i < n; ++i) {
                list.add(new Point(nArray[i * 2], nArray[i * 2 + 1]));
            }
        } else if (n2 == CvType.CV_32FC2) {
            float[] fArray = new float[2 * n];
            mat.get(0, 0, fArray);
            for (int i = 0; i < n; ++i) {
                list.add(new Point(fArray[i * 2], fArray[i * 2 + 1]));
            }
        } else if (n2 == CvType.CV_64FC2) {
            double[] dArray = new double[2 * n];
            mat.get(0, 0, dArray);
            for (int i = 0; i < n; ++i) {
                list.add(new Point(dArray[i * 2], dArray[i * 2 + 1]));
            }
        } else {
            throw new IllegalArgumentException("Input Mat should be of CV_32SC2, CV_32FC2 or CV_64FC2 type\n" + mat);
        }
    }

    public static void Mat_to_vector_Point3i(Mat mat, List<Point3> list) {
        Converters.Mat_to_vector_Point3(mat, list);
    }

    public static void Mat_to_vector_Point3f(Mat mat, List<Point3> list) {
        Converters.Mat_to_vector_Point3(mat, list);
    }

    public static void Mat_to_vector_Point3d(Mat mat, List<Point3> list) {
        Converters.Mat_to_vector_Point3(mat, list);
    }

    public static void Mat_to_vector_Point3(Mat mat, List<Point3> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        int n = mat.rows();
        int n2 = mat.type();
        if (mat.cols() != 1) {
            throw new IllegalArgumentException("Input Mat should have one column\n" + mat);
        }
        list.clear();
        if (n2 == CvType.CV_32SC3) {
            int[] nArray = new int[3 * n];
            mat.get(0, 0, nArray);
            for (int i = 0; i < n; ++i) {
                list.add(new Point3(nArray[i * 3], nArray[i * 3 + 1], nArray[i * 3 + 2]));
            }
        } else if (n2 == CvType.CV_32FC3) {
            float[] fArray = new float[3 * n];
            mat.get(0, 0, fArray);
            for (int i = 0; i < n; ++i) {
                list.add(new Point3(fArray[i * 3], fArray[i * 3 + 1], fArray[i * 3 + 2]));
            }
        } else if (n2 == CvType.CV_64FC3) {
            double[] dArray = new double[3 * n];
            mat.get(0, 0, dArray);
            for (int i = 0; i < n; ++i) {
                list.add(new Point3(dArray[i * 3], dArray[i * 3 + 1], dArray[i * 3 + 2]));
            }
        } else {
            throw new IllegalArgumentException("Input Mat should be of CV_32SC3, CV_32FC3 or CV_64FC3 type\n" + mat);
        }
    }

    public static Mat vector_Mat_to_Mat(List<Mat> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_32SC2);
            int[] nArray = new int[n * 2];
            for (int i = 0; i < n; ++i) {
                long l = list.get((int)i).nativeObj;
                nArray[i * 2] = (int)(l >> 32);
                nArray[i * 2 + 1] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            }
            mat.put(0, 0, nArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_Mat(Mat mat, List<Mat> list) {
        if (list == null) {
            throw new IllegalArgumentException("mats == null");
        }
        int n = mat.rows();
        if (CvType.CV_32SC2 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_32SC2 != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        int[] nArray = new int[n * 2];
        mat.get(0, 0, nArray);
        for (int i = 0; i < n; ++i) {
            long l = (long)nArray[i * 2] << 32 | (long)nArray[i * 2 + 1] & 0xFFFFFFFFL;
            list.add(new Mat(l));
        }
    }

    public static Mat vector_float_to_Mat(List<Float> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_32FC1);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                float f;
                fArray[i] = f = list.get(i).floatValue();
            }
            mat.put(0, 0, fArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_float(Mat mat, List<Float> list) {
        if (list == null) {
            throw new IllegalArgumentException("fs == null");
        }
        int n = mat.rows();
        if (CvType.CV_32FC1 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_32FC1 != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        float[] fArray = new float[n];
        mat.get(0, 0, fArray);
        for (int i = 0; i < n; ++i) {
            list.add(Float.valueOf(fArray[i]));
        }
    }

    public static Mat vector_uchar_to_Mat(List<Byte> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_8UC1);
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byte by;
                byArray[i] = by = list.get(i).byteValue();
            }
            mat.put(0, 0, byArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_uchar(Mat mat, List<Byte> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        int n = mat.rows();
        if (CvType.CV_8UC1 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_8UC1 != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        byte[] byArray = new byte[n];
        mat.get(0, 0, byArray);
        for (int i = 0; i < n; ++i) {
            list.add(byArray[i]);
        }
    }

    public static Mat vector_char_to_Mat(List<Byte> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_8SC1);
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byte by;
                byArray[i] = by = list.get(i).byteValue();
            }
            mat.put(0, 0, byArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static Mat vector_int_to_Mat(List<Integer> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_32SC1);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                int n3;
                nArray[i] = n3 = list.get(i).intValue();
            }
            mat.put(0, 0, nArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_int(Mat mat, List<Integer> list) {
        if (list == null) {
            throw new IllegalArgumentException("is == null");
        }
        int n = mat.rows();
        if (CvType.CV_32SC1 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_32SC1 != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        int[] nArray = new int[n];
        mat.get(0, 0, nArray);
        for (int i = 0; i < n; ++i) {
            list.add(nArray[i]);
        }
    }

    public static void Mat_to_vector_char(Mat mat, List<Byte> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        int n = mat.rows();
        if (CvType.CV_8SC1 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_8SC1 != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        byte[] byArray = new byte[n];
        mat.get(0, 0, byArray);
        for (int i = 0; i < n; ++i) {
            list.add(byArray[i]);
        }
    }

    public static Mat vector_Rect_to_Mat(List<Rect> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_32SC4);
            int[] nArray = new int[4 * n];
            for (int i = 0; i < n; ++i) {
                Rect rect = list.get(i);
                nArray[4 * i] = rect.x;
                nArray[4 * i + 1] = rect.y;
                nArray[4 * i + 2] = rect.width;
                nArray[4 * i + 3] = rect.height;
            }
            mat.put(0, 0, nArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_Rect(Mat mat, List<Rect> list) {
        if (list == null) {
            throw new IllegalArgumentException("rs == null");
        }
        int n = mat.rows();
        if (CvType.CV_32SC4 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_32SC4 != m.type() ||  m.rows()!=1\n" + mat);
        }
        list.clear();
        int[] nArray = new int[4 * n];
        mat.get(0, 0, nArray);
        for (int i = 0; i < n; ++i) {
            list.add(new Rect(nArray[4 * i], nArray[4 * i + 1], nArray[4 * i + 2], nArray[4 * i + 3]));
        }
    }

    public static Mat vector_Rect2d_to_Mat(List<Rect2d> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_64FC4);
            double[] dArray = new double[4 * n];
            for (int i = 0; i < n; ++i) {
                Rect2d rect2d = list.get(i);
                dArray[4 * i] = rect2d.x;
                dArray[4 * i + 1] = rect2d.y;
                dArray[4 * i + 2] = rect2d.width;
                dArray[4 * i + 3] = rect2d.height;
            }
            mat.put(0, 0, dArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_Rect2d(Mat mat, List<Rect2d> list) {
        if (list == null) {
            throw new IllegalArgumentException("rs == null");
        }
        int n = mat.rows();
        if (CvType.CV_64FC4 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_64FC4 != m.type() ||  m.rows()!=1\n" + mat);
        }
        list.clear();
        double[] dArray = new double[4 * n];
        mat.get(0, 0, dArray);
        for (int i = 0; i < n; ++i) {
            list.add(new Rect2d(dArray[4 * i], dArray[4 * i + 1], dArray[4 * i + 2], dArray[4 * i + 3]));
        }
    }

    public static Mat vector_KeyPoint_to_Mat(List<KeyPoint> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_64FC(7));
            double[] dArray = new double[n * 7];
            for (int i = 0; i < n; ++i) {
                KeyPoint keyPoint = list.get(i);
                dArray[7 * i] = keyPoint.pt.x;
                dArray[7 * i + 1] = keyPoint.pt.y;
                dArray[7 * i + 2] = keyPoint.size;
                dArray[7 * i + 3] = keyPoint.angle;
                dArray[7 * i + 4] = keyPoint.response;
                dArray[7 * i + 5] = keyPoint.octave;
                dArray[7 * i + 6] = keyPoint.class_id;
            }
            mat.put(0, 0, dArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_KeyPoint(Mat mat, List<KeyPoint> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        int n = mat.rows();
        if (CvType.CV_64FC(7) != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_64FC(7) != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        double[] dArray = new double[7 * n];
        mat.get(0, 0, dArray);
        for (int i = 0; i < n; ++i) {
            list.add(new KeyPoint((float)dArray[7 * i], (float)dArray[7 * i + 1], (float)dArray[7 * i + 2], (float)dArray[7 * i + 3], (float)dArray[7 * i + 4], (int)dArray[7 * i + 5], (int)dArray[7 * i + 6]));
        }
    }

    public static Mat vector_vector_Point_to_Mat(List<MatOfPoint> list, List<Mat> list2) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            list2.addAll(list);
            mat = Converters.vector_Mat_to_Mat(list2);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_vector_Point(Mat mat, List<MatOfPoint> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        if (mat == null) {
            throw new IllegalArgumentException("Input Mat can't be null");
        }
        ArrayList<Mat> arrayList = new ArrayList<Mat>(mat.rows());
        Converters.Mat_to_vector_Mat(mat, arrayList);
        for (Mat mat2 : arrayList) {
            MatOfPoint matOfPoint = new MatOfPoint(mat2);
            list.add(matOfPoint);
            mat2.release();
        }
        arrayList.clear();
    }

    public static void Mat_to_vector_vector_Point2f(Mat mat, List<MatOfPoint2f> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        if (mat == null) {
            throw new IllegalArgumentException("Input Mat can't be null");
        }
        ArrayList<Mat> arrayList = new ArrayList<Mat>(mat.rows());
        Converters.Mat_to_vector_Mat(mat, arrayList);
        for (Mat mat2 : arrayList) {
            MatOfPoint2f matOfPoint2f = new MatOfPoint2f(mat2);
            list.add(matOfPoint2f);
            mat2.release();
        }
        arrayList.clear();
    }

    public static Mat vector_vector_Point2f_to_Mat(List<MatOfPoint2f> list, List<Mat> list2) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            list2.addAll(list);
            mat = Converters.vector_Mat_to_Mat(list2);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_vector_Point3f(Mat mat, List<MatOfPoint3f> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        if (mat == null) {
            throw new IllegalArgumentException("Input Mat can't be null");
        }
        ArrayList<Mat> arrayList = new ArrayList<Mat>(mat.rows());
        Converters.Mat_to_vector_Mat(mat, arrayList);
        for (Mat mat2 : arrayList) {
            MatOfPoint3f matOfPoint3f = new MatOfPoint3f(mat2);
            list.add(matOfPoint3f);
            mat2.release();
        }
        arrayList.clear();
    }

    public static Mat vector_vector_Point3f_to_Mat(List<MatOfPoint3f> list, List<Mat> list2) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            list2.addAll(list);
            mat = Converters.vector_Mat_to_Mat(list2);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static Mat vector_vector_KeyPoint_to_Mat(List<MatOfKeyPoint> list, List<Mat> list2) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            list2.addAll(list);
            mat = Converters.vector_Mat_to_Mat(list2);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_vector_KeyPoint(Mat mat, List<MatOfKeyPoint> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        if (mat == null) {
            throw new IllegalArgumentException("Input Mat can't be null");
        }
        ArrayList<Mat> arrayList = new ArrayList<Mat>(mat.rows());
        Converters.Mat_to_vector_Mat(mat, arrayList);
        for (Mat mat2 : arrayList) {
            MatOfKeyPoint matOfKeyPoint = new MatOfKeyPoint(mat2);
            list.add(matOfKeyPoint);
            mat2.release();
        }
        arrayList.clear();
    }

    public static Mat vector_double_to_Mat(List<Double> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_64FC1);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                double d;
                dArray[i] = d = list.get(i).doubleValue();
            }
            mat.put(0, 0, dArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_double(Mat mat, List<Double> list) {
        if (list == null) {
            throw new IllegalArgumentException("ds == null");
        }
        int n = mat.rows();
        if (CvType.CV_64FC1 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_64FC1 != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        double[] dArray = new double[n];
        mat.get(0, 0, dArray);
        for (int i = 0; i < n; ++i) {
            list.add(dArray[i]);
        }
    }

    public static Mat vector_DMatch_to_Mat(List<DMatch> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_64FC4);
            double[] dArray = new double[n * 4];
            for (int i = 0; i < n; ++i) {
                DMatch dMatch = list.get(i);
                dArray[4 * i] = dMatch.queryIdx;
                dArray[4 * i + 1] = dMatch.trainIdx;
                dArray[4 * i + 2] = dMatch.imgIdx;
                dArray[4 * i + 3] = dMatch.distance;
            }
            mat.put(0, 0, dArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_DMatch(Mat mat, List<DMatch> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        int n = mat.rows();
        if (CvType.CV_64FC4 != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_64FC4 != m.type() ||  m.cols()!=1\n" + mat);
        }
        list.clear();
        double[] dArray = new double[4 * n];
        mat.get(0, 0, dArray);
        for (int i = 0; i < n; ++i) {
            list.add(new DMatch((int)dArray[4 * i], (int)dArray[4 * i + 1], (int)dArray[4 * i + 2], (float)dArray[4 * i + 3]));
        }
    }

    public static Mat vector_vector_DMatch_to_Mat(List<MatOfDMatch> list, List<Mat> list2) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            list2.addAll(list);
            mat = Converters.vector_Mat_to_Mat(list2);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_vector_DMatch(Mat mat, List<MatOfDMatch> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        if (mat == null) {
            throw new IllegalArgumentException("Input Mat can't be null");
        }
        ArrayList<Mat> arrayList = new ArrayList<Mat>(mat.rows());
        Converters.Mat_to_vector_Mat(mat, arrayList);
        list.clear();
        for (Mat mat2 : arrayList) {
            MatOfDMatch matOfDMatch = new MatOfDMatch(mat2);
            list.add(matOfDMatch);
            mat2.release();
        }
        arrayList.clear();
    }

    public static Mat vector_vector_char_to_Mat(List<MatOfByte> list, List<Mat> list2) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            list2.addAll(list);
            mat = Converters.vector_Mat_to_Mat(list2);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_vector_char(Mat mat, List<List<Byte>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Output List can't be null");
        }
        if (mat == null) {
            throw new IllegalArgumentException("Input Mat can't be null");
        }
        ArrayList<Mat> arrayList = new ArrayList<Mat>(mat.rows());
        Converters.Mat_to_vector_Mat(mat, arrayList);
        for (Mat mat2 : arrayList) {
            ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
            Converters.Mat_to_vector_char(mat2, arrayList2);
            list.add(arrayList2);
            mat2.release();
        }
        arrayList.clear();
    }

    public static Mat vector_RotatedRect_to_Mat(List<RotatedRect> list) {
        Mat mat;
        int n;
        int n2 = n = list != null ? list.size() : 0;
        if (n > 0) {
            mat = new Mat(n, 1, CvType.CV_32FC(5));
            float[] fArray = new float[5 * n];
            for (int i = 0; i < n; ++i) {
                RotatedRect rotatedRect = list.get(i);
                fArray[5 * i] = (float)rotatedRect.center.x;
                fArray[5 * i + 1] = (float)rotatedRect.center.y;
                fArray[5 * i + 2] = (float)rotatedRect.size.width;
                fArray[5 * i + 3] = (float)rotatedRect.size.height;
                fArray[5 * i + 4] = (float)rotatedRect.angle;
            }
            mat.put(0, 0, fArray);
        } else {
            mat = new Mat();
        }
        return mat;
    }

    public static void Mat_to_vector_RotatedRect(Mat mat, List<RotatedRect> list) {
        if (list == null) {
            throw new IllegalArgumentException("rs == null");
        }
        int n = mat.rows();
        if (CvType.CV_32FC(5) != mat.type() || mat.cols() != 1) {
            throw new IllegalArgumentException("CvType.CV_32FC5 != m.type() ||  m.rows()!=1\n" + mat);
        }
        list.clear();
        float[] fArray = new float[5 * n];
        mat.get(0, 0, fArray);
        for (int i = 0; i < n; ++i) {
            list.add(new RotatedRect(new Point(fArray[5 * i], fArray[5 * i + 1]), new Size(fArray[5 * i + 2], fArray[5 * i + 3]), fArray[5 * i + 4]));
        }
    }
}

