/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfRect;
import org.opencv.core.Scalar;
import org.opencv.objdetect.Dictionary;
import org.opencv.utils.Converters;

public class Objdetect {
    public static final int CASCADE_DO_CANNY_PRUNING = 1;
    public static final int CASCADE_SCALE_IMAGE = 2;
    public static final int CASCADE_FIND_BIGGEST_OBJECT = 4;
    public static final int CASCADE_DO_ROUGH_SEARCH = 8;
    public static final int DetectionBasedTracker_DETECTED_NOT_SHOWN_YET = 0;
    public static final int DetectionBasedTracker_DETECTED = 1;
    public static final int DetectionBasedTracker_DETECTED_TEMPORARY_LOST = 2;
    public static final int DetectionBasedTracker_WRONG_OBJECT = 3;
    public static final int CORNER_REFINE_NONE = 0;
    public static final int CORNER_REFINE_SUBPIX = 1;
    public static final int CORNER_REFINE_CONTOUR = 2;
    public static final int CORNER_REFINE_APRILTAG = 3;
    public static final int DICT_4X4_50 = 0;
    public static final int DICT_4X4_100 = 1;
    public static final int DICT_4X4_250 = 2;
    public static final int DICT_4X4_1000 = 3;
    public static final int DICT_5X5_50 = 4;
    public static final int DICT_5X5_100 = 5;
    public static final int DICT_5X5_250 = 6;
    public static final int DICT_5X5_1000 = 7;
    public static final int DICT_6X6_50 = 8;
    public static final int DICT_6X6_100 = 9;
    public static final int DICT_6X6_250 = 10;
    public static final int DICT_6X6_1000 = 11;
    public static final int DICT_7X7_50 = 12;
    public static final int DICT_7X7_100 = 13;
    public static final int DICT_7X7_250 = 14;
    public static final int DICT_7X7_1000 = 15;
    public static final int DICT_ARUCO_ORIGINAL = 16;
    public static final int DICT_APRILTAG_16h5 = 17;
    public static final int DICT_APRILTAG_25h9 = 18;
    public static final int DICT_APRILTAG_36h10 = 19;
    public static final int DICT_APRILTAG_36h11 = 20;
    public static final int DICT_ARUCO_MIP_36h12 = 21;

    public static void groupRectangles(MatOfRect matOfRect, MatOfInt matOfInt, int n, double d) {
        MatOfRect matOfRect2 = matOfRect;
        MatOfInt matOfInt2 = matOfInt;
        Objdetect.groupRectangles_0(matOfRect2.nativeObj, matOfInt2.nativeObj, n, d);
    }

    public static void groupRectangles(MatOfRect matOfRect, MatOfInt matOfInt, int n) {
        MatOfRect matOfRect2 = matOfRect;
        MatOfInt matOfInt2 = matOfInt;
        Objdetect.groupRectangles_1(matOfRect2.nativeObj, matOfInt2.nativeObj, n);
    }

    public static Dictionary getPredefinedDictionary(int n) {
        return new Dictionary(Objdetect.getPredefinedDictionary_0(n));
    }

    public static Dictionary extendDictionary(int n, int n2, Dictionary dictionary, int n3) {
        return new Dictionary(Objdetect.extendDictionary_0(n, n2, dictionary.nativeObj, n3));
    }

    public static Dictionary extendDictionary(int n, int n2, Dictionary dictionary) {
        return new Dictionary(Objdetect.extendDictionary_1(n, n2, dictionary.nativeObj));
    }

    public static Dictionary extendDictionary(int n, int n2) {
        return new Dictionary(Objdetect.extendDictionary_2(n, n2));
    }

    public static void drawDetectedMarkers(Mat mat, List<Mat> list, Mat mat2, Scalar scalar) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Objdetect.drawDetectedMarkers_0(mat.nativeObj, mat3.nativeObj, mat2.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void drawDetectedMarkers(Mat mat, List<Mat> list, Mat mat2) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Objdetect.drawDetectedMarkers_1(mat.nativeObj, mat3.nativeObj, mat2.nativeObj);
    }

    public static void drawDetectedMarkers(Mat mat, List<Mat> list) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Objdetect.drawDetectedMarkers_2(mat.nativeObj, mat2.nativeObj);
    }

    public static void generateImageMarker(Dictionary dictionary, int n, int n2, Mat mat, int n3) {
        Objdetect.generateImageMarker_0(dictionary.nativeObj, n, n2, mat.nativeObj, n3);
    }

    public static void generateImageMarker(Dictionary dictionary, int n, int n2, Mat mat) {
        Objdetect.generateImageMarker_1(dictionary.nativeObj, n, n2, mat.nativeObj);
    }

    public static void drawDetectedCornersCharuco(Mat mat, Mat mat2, Mat mat3, Scalar scalar) {
        Objdetect.drawDetectedCornersCharuco_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void drawDetectedCornersCharuco(Mat mat, Mat mat2, Mat mat3) {
        Objdetect.drawDetectedCornersCharuco_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void drawDetectedCornersCharuco(Mat mat, Mat mat2) {
        Objdetect.drawDetectedCornersCharuco_2(mat.nativeObj, mat2.nativeObj);
    }

    public static void drawDetectedDiamonds(Mat mat, List<Mat> list, Mat mat2, Scalar scalar) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Objdetect.drawDetectedDiamonds_0(mat.nativeObj, mat3.nativeObj, mat2.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void drawDetectedDiamonds(Mat mat, List<Mat> list, Mat mat2) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Objdetect.drawDetectedDiamonds_1(mat.nativeObj, mat3.nativeObj, mat2.nativeObj);
    }

    public static void drawDetectedDiamonds(Mat mat, List<Mat> list) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Objdetect.drawDetectedDiamonds_2(mat.nativeObj, mat2.nativeObj);
    }

    private static native void groupRectangles_0(long var0, long var2, int var4, double var5);

    private static native void groupRectangles_1(long var0, long var2, int var4);

    private static native long getPredefinedDictionary_0(int var0);

    private static native long extendDictionary_0(int var0, int var1, long var2, int var4);

    private static native long extendDictionary_1(int var0, int var1, long var2);

    private static native long extendDictionary_2(int var0, int var1);

    private static native void drawDetectedMarkers_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12);

    private static native void drawDetectedMarkers_1(long var0, long var2, long var4);

    private static native void drawDetectedMarkers_2(long var0, long var2);

    private static native void generateImageMarker_0(long var0, int var2, int var3, long var4, int var6);

    private static native void generateImageMarker_1(long var0, int var2, int var3, long var4);

    private static native void drawDetectedCornersCharuco_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12);

    private static native void drawDetectedCornersCharuco_1(long var0, long var2, long var4);

    private static native void drawDetectedCornersCharuco_2(long var0, long var2);

    private static native void drawDetectedDiamonds_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12);

    private static native void drawDetectedDiamonds_1(long var0, long var2, long var4);

    private static native void drawDetectedDiamonds_2(long var0, long var2);
}

