/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;

public class Dictionary {
    protected final long nativeObj;

    protected Dictionary(long l) {
        this.nativeObj = l;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Dictionary __fromPtr__(long l) {
        return new Dictionary(l);
    }

    public Dictionary() {
        this.nativeObj = Dictionary.Dictionary_0();
    }

    public Dictionary(Mat mat, int n, int n2) {
        this.nativeObj = Dictionary.Dictionary_1(mat.nativeObj, n, n2);
    }

    public Dictionary(Mat mat, int n) {
        this.nativeObj = Dictionary.Dictionary_2(mat.nativeObj, n);
    }

    public boolean identify(Mat mat, int[] nArray, int[] nArray2, double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        boolean bl = Dictionary.identify_0(this.nativeObj, mat.nativeObj, dArray, dArray2, d);
        if (nArray != null) {
            nArray[0] = (int)dArray[0];
        }
        if (nArray2 != null) {
            nArray2[0] = (int)dArray2[0];
        }
        return bl;
    }

    public int getDistanceToId(Mat mat, int n, boolean bl) {
        return Dictionary.getDistanceToId_0(this.nativeObj, mat.nativeObj, n, bl);
    }

    public int getDistanceToId(Mat mat, int n) {
        return Dictionary.getDistanceToId_1(this.nativeObj, mat.nativeObj, n);
    }

    public void generateImageMarker(int n, int n2, Mat mat, int n3) {
        Dictionary.generateImageMarker_0(this.nativeObj, n, n2, mat.nativeObj, n3);
    }

    public void generateImageMarker(int n, int n2, Mat mat) {
        Dictionary.generateImageMarker_1(this.nativeObj, n, n2, mat.nativeObj);
    }

    public static Mat getByteListFromBits(Mat mat) {
        return new Mat(Dictionary.getByteListFromBits_0(mat.nativeObj));
    }

    public static Mat getBitsFromByteList(Mat mat, int n) {
        return new Mat(Dictionary.getBitsFromByteList_0(mat.nativeObj, n));
    }

    public Mat get_bytesList() {
        return new Mat(Dictionary.get_bytesList_0(this.nativeObj));
    }

    public void set_bytesList(Mat mat) {
        Dictionary.set_bytesList_0(this.nativeObj, mat.nativeObj);
    }

    public int get_markerSize() {
        return Dictionary.get_markerSize_0(this.nativeObj);
    }

    public void set_markerSize(int n) {
        Dictionary.set_markerSize_0(this.nativeObj, n);
    }

    public int get_maxCorrectionBits() {
        return Dictionary.get_maxCorrectionBits_0(this.nativeObj);
    }

    public void set_maxCorrectionBits(int n) {
        Dictionary.set_maxCorrectionBits_0(this.nativeObj, n);
    }

    protected void finalize() throws Throwable {
        Dictionary.delete(this.nativeObj);
    }

    private static native long Dictionary_0();

    private static native long Dictionary_1(long var0, int var2, int var3);

    private static native long Dictionary_2(long var0, int var2);

    private static native boolean identify_0(long var0, long var2, double[] var4, double[] var5, double var6);

    private static native int getDistanceToId_0(long var0, long var2, int var4, boolean var5);

    private static native int getDistanceToId_1(long var0, long var2, int var4);

    private static native void generateImageMarker_0(long var0, int var2, int var3, long var4, int var6);

    private static native void generateImageMarker_1(long var0, int var2, int var3, long var4);

    private static native long getByteListFromBits_0(long var0);

    private static native long getBitsFromByteList_0(long var0, int var2);

    private static native long get_bytesList_0(long var0);

    private static native void set_bytesList_0(long var0, long var2);

    private static native int get_markerSize_0(long var0);

    private static native void set_markerSize_0(long var0, int var2);

    private static native int get_maxCorrectionBits_0(long var0);

    private static native void set_maxCorrectionBits_0(long var0, int var2);

    private static native void delete(long var0);
}

