/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.face;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.face.PredictCollector;
import org.opencv.utils.Converters;

public class FaceRecognizer
extends Algorithm {
    protected FaceRecognizer(long l) {
        super(l);
    }

    public static FaceRecognizer __fromPtr__(long l) {
        return new FaceRecognizer(l);
    }

    public void train(List<Mat> list, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        FaceRecognizer.train_0(this.nativeObj, mat2.nativeObj, mat.nativeObj);
    }

    public void update(List<Mat> list, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        FaceRecognizer.update_0(this.nativeObj, mat2.nativeObj, mat.nativeObj);
    }

    public int predict_label(Mat mat) {
        return FaceRecognizer.predict_label_0(this.nativeObj, mat.nativeObj);
    }

    public void predict(Mat mat, int[] nArray, double[] dArray) {
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        FaceRecognizer.predict_0(this.nativeObj, mat.nativeObj, dArray2, dArray3);
        if (nArray != null) {
            nArray[0] = (int)dArray2[0];
        }
        if (dArray != null) {
            dArray[0] = dArray3[0];
        }
    }

    public void predict_collect(Mat mat, PredictCollector predictCollector) {
        FaceRecognizer.predict_collect_0(this.nativeObj, mat.nativeObj, predictCollector.getNativeObjAddr());
    }

    public void write(String string) {
        FaceRecognizer.write_0(this.nativeObj, string);
    }

    public void read(String string) {
        FaceRecognizer.read_0(this.nativeObj, string);
    }

    public void setLabelInfo(int n, String string) {
        FaceRecognizer.setLabelInfo_0(this.nativeObj, n, string);
    }

    public String getLabelInfo(int n) {
        return FaceRecognizer.getLabelInfo_0(this.nativeObj, n);
    }

    public MatOfInt getLabelsByString(String string) {
        return MatOfInt.fromNativeAddr(FaceRecognizer.getLabelsByString_0(this.nativeObj, string));
    }

    @Override
    protected void finalize() throws Throwable {
        FaceRecognizer.delete(this.nativeObj);
    }

    private static native void train_0(long var0, long var2, long var4);

    private static native void update_0(long var0, long var2, long var4);

    private static native int predict_label_0(long var0, long var2);

    private static native void predict_0(long var0, long var2, double[] var4, double[] var5);

    private static native void predict_collect_0(long var0, long var2, long var4);

    private static native void write_0(long var0, String var2);

    private static native void read_0(long var0, String var2);

    private static native void setLabelInfo_0(long var0, int var2, String var3);

    private static native String getLabelInfo_0(long var0, int var2);

    private static native long getLabelsByString_0(long var0, String var2);

    private static native void delete(long var0);
}

