/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Range;
import org.opencv.core.Rect;

public class MatOfRect
extends Mat {
    private static final int _depth = 4;
    private static final int _channels = 4;

    public MatOfRect() {
    }

    protected MatOfRect(long l) {
        super(l);
        if (!this.empty() && this.checkVector(4, 4) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfRect fromNativeAddr(long l) {
        return new MatOfRect(l);
    }

    public MatOfRect(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(4, 4) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfRect(Rect ... rectArray) {
        this.fromArray(rectArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(4, 4));
        }
    }

    public void fromArray(Rect ... rectArray) {
        if (rectArray == null || rectArray.length == 0) {
            return;
        }
        int n = rectArray.length;
        this.alloc(n);
        int[] nArray = new int[n * 4];
        for (int i = 0; i < n; ++i) {
            Rect rect = rectArray[i];
            nArray[4 * i + 0] = rect.x;
            nArray[4 * i + 1] = rect.y;
            nArray[4 * i + 2] = rect.width;
            nArray[4 * i + 3] = rect.height;
        }
        this.put(0, 0, nArray);
    }

    public Rect[] toArray() {
        int n = (int)this.total();
        Rect[] rectArray = new Rect[n];
        if (n == 0) {
            return rectArray;
        }
        int[] nArray = new int[n * 4];
        this.get(0, 0, nArray);
        for (int i = 0; i < n; ++i) {
            rectArray[i] = new Rect(nArray[i * 4], nArray[i * 4 + 1], nArray[i * 4 + 2], nArray[i * 4 + 3]);
        }
        return rectArray;
    }

    public void fromList(List<Rect> list) {
        Rect[] rectArray = list.toArray(new Rect[0]);
        this.fromArray(rectArray);
    }

    public List<Rect> toList() {
        Rect[] rectArray = this.toArray();
        return Arrays.asList(rectArray);
    }
}

