/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ximgproc;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint;
import org.opencv.utils.Converters;
import org.opencv.ximgproc.EdgeDrawing_Params;

public class EdgeDrawing
extends Algorithm {
    public static final int PREWITT = 0;
    public static final int SOBEL = 1;
    public static final int SCHARR = 2;
    public static final int LSD = 3;

    protected EdgeDrawing(long l) {
        super(l);
    }

    public static EdgeDrawing __fromPtr__(long l) {
        return new EdgeDrawing(l);
    }

    public void detectEdges(Mat mat) {
        EdgeDrawing.detectEdges_0(this.nativeObj, mat.nativeObj);
    }

    public void getEdgeImage(Mat mat) {
        EdgeDrawing.getEdgeImage_0(this.nativeObj, mat.nativeObj);
    }

    public void getGradientImage(Mat mat) {
        EdgeDrawing.getGradientImage_0(this.nativeObj, mat.nativeObj);
    }

    public List<MatOfPoint> getSegments() {
        ArrayList<MatOfPoint> arrayList = new ArrayList<MatOfPoint>();
        Mat mat = new Mat(EdgeDrawing.getSegments_0(this.nativeObj));
        Converters.Mat_to_vector_vector_Point(mat, arrayList);
        return arrayList;
    }

    public MatOfInt getSegmentIndicesOfLines() {
        return MatOfInt.fromNativeAddr(EdgeDrawing.getSegmentIndicesOfLines_0(this.nativeObj));
    }

    public void detectLines(Mat mat) {
        EdgeDrawing.detectLines_0(this.nativeObj, mat.nativeObj);
    }

    public void detectEllipses(Mat mat) {
        EdgeDrawing.detectEllipses_0(this.nativeObj, mat.nativeObj);
    }

    public void setParams(EdgeDrawing_Params edgeDrawing_Params) {
        EdgeDrawing.setParams_0(this.nativeObj, edgeDrawing_Params.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        EdgeDrawing.delete(this.nativeObj);
    }

    private static native void detectEdges_0(long var0, long var2);

    private static native void getEdgeImage_0(long var0, long var2);

    private static native void getGradientImage_0(long var0, long var2);

    private static native long getSegments_0(long var0);

    private static native long getSegmentIndicesOfLines_0(long var0);

    private static native void detectLines_0(long var0, long var2);

    private static native void detectEllipses_0(long var0, long var2);

    private static native void setParams_0(long var0, long var2);

    private static native void delete(long var0);
}

