/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.xfeatures2d;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint2f;
import org.opencv.utils.Converters;

public class PCTSignatures
extends Algorithm {
    public static final int L0_25 = 0;
    public static final int L0_5 = 1;
    public static final int L1 = 2;
    public static final int L2 = 3;
    public static final int L2SQUARED = 4;
    public static final int L5 = 5;
    public static final int L_INFINITY = 6;
    public static final int UNIFORM = 0;
    public static final int REGULAR = 1;
    public static final int NORMAL = 2;
    public static final int MINUS = 0;
    public static final int GAUSSIAN = 1;
    public static final int HEURISTIC = 2;

    protected PCTSignatures(long l) {
        super(l);
    }

    public static PCTSignatures __fromPtr__(long l) {
        return new PCTSignatures(l);
    }

    public static PCTSignatures create(int n, int n2, int n3) {
        return PCTSignatures.__fromPtr__(PCTSignatures.create_0(n, n2, n3));
    }

    public static PCTSignatures create(int n, int n2) {
        return PCTSignatures.__fromPtr__(PCTSignatures.create_1(n, n2));
    }

    public static PCTSignatures create(int n) {
        return PCTSignatures.__fromPtr__(PCTSignatures.create_2(n));
    }

    public static PCTSignatures create() {
        return PCTSignatures.__fromPtr__(PCTSignatures.create_3());
    }

    public static PCTSignatures create(MatOfPoint2f matOfPoint2f, int n) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        return PCTSignatures.__fromPtr__(PCTSignatures.create_4(matOfPoint2f2.nativeObj, n));
    }

    public static PCTSignatures create(MatOfPoint2f matOfPoint2f, MatOfInt matOfInt) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfInt matOfInt2 = matOfInt;
        return PCTSignatures.__fromPtr__(PCTSignatures.create_5(matOfPoint2f2.nativeObj, matOfInt2.nativeObj));
    }

    public void computeSignature(Mat mat, Mat mat2) {
        PCTSignatures.computeSignature_0(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public void computeSignatures(List<Mat> list, List<Mat> list2) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        Mat mat2 = Converters.vector_Mat_to_Mat(list2);
        PCTSignatures.computeSignatures_0(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public static void drawSignature(Mat mat, Mat mat2, Mat mat3, float f, int n) {
        PCTSignatures.drawSignature_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, f, n);
    }

    public static void drawSignature(Mat mat, Mat mat2, Mat mat3, float f) {
        PCTSignatures.drawSignature_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, f);
    }

    public static void drawSignature(Mat mat, Mat mat2, Mat mat3) {
        PCTSignatures.drawSignature_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void generateInitPoints(MatOfPoint2f matOfPoint2f, int n, int n2) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        PCTSignatures.generateInitPoints_0(matOfPoint2f2.nativeObj, n, n2);
    }

    public int getSampleCount() {
        return PCTSignatures.getSampleCount_0(this.nativeObj);
    }

    public int getGrayscaleBits() {
        return PCTSignatures.getGrayscaleBits_0(this.nativeObj);
    }

    public void setGrayscaleBits(int n) {
        PCTSignatures.setGrayscaleBits_0(this.nativeObj, n);
    }

    public int getWindowRadius() {
        return PCTSignatures.getWindowRadius_0(this.nativeObj);
    }

    public void setWindowRadius(int n) {
        PCTSignatures.setWindowRadius_0(this.nativeObj, n);
    }

    public float getWeightX() {
        return PCTSignatures.getWeightX_0(this.nativeObj);
    }

    public void setWeightX(float f) {
        PCTSignatures.setWeightX_0(this.nativeObj, f);
    }

    public float getWeightY() {
        return PCTSignatures.getWeightY_0(this.nativeObj);
    }

    public void setWeightY(float f) {
        PCTSignatures.setWeightY_0(this.nativeObj, f);
    }

    public float getWeightL() {
        return PCTSignatures.getWeightL_0(this.nativeObj);
    }

    public void setWeightL(float f) {
        PCTSignatures.setWeightL_0(this.nativeObj, f);
    }

    public float getWeightA() {
        return PCTSignatures.getWeightA_0(this.nativeObj);
    }

    public void setWeightA(float f) {
        PCTSignatures.setWeightA_0(this.nativeObj, f);
    }

    public float getWeightB() {
        return PCTSignatures.getWeightB_0(this.nativeObj);
    }

    public void setWeightB(float f) {
        PCTSignatures.setWeightB_0(this.nativeObj, f);
    }

    public float getWeightContrast() {
        return PCTSignatures.getWeightContrast_0(this.nativeObj);
    }

    public void setWeightContrast(float f) {
        PCTSignatures.setWeightContrast_0(this.nativeObj, f);
    }

    public float getWeightEntropy() {
        return PCTSignatures.getWeightEntropy_0(this.nativeObj);
    }

    public void setWeightEntropy(float f) {
        PCTSignatures.setWeightEntropy_0(this.nativeObj, f);
    }

    public MatOfPoint2f getSamplingPoints() {
        return MatOfPoint2f.fromNativeAddr(PCTSignatures.getSamplingPoints_0(this.nativeObj));
    }

    public void setWeight(int n, float f) {
        PCTSignatures.setWeight_0(this.nativeObj, n, f);
    }

    public void setWeights(MatOfFloat matOfFloat) {
        MatOfFloat matOfFloat2 = matOfFloat;
        PCTSignatures.setWeights_0(this.nativeObj, matOfFloat2.nativeObj);
    }

    public void setTranslation(int n, float f) {
        PCTSignatures.setTranslation_0(this.nativeObj, n, f);
    }

    public void setTranslations(MatOfFloat matOfFloat) {
        MatOfFloat matOfFloat2 = matOfFloat;
        PCTSignatures.setTranslations_0(this.nativeObj, matOfFloat2.nativeObj);
    }

    public void setSamplingPoints(MatOfPoint2f matOfPoint2f) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        PCTSignatures.setSamplingPoints_0(this.nativeObj, matOfPoint2f2.nativeObj);
    }

    public MatOfInt getInitSeedIndexes() {
        return MatOfInt.fromNativeAddr(PCTSignatures.getInitSeedIndexes_0(this.nativeObj));
    }

    public void setInitSeedIndexes(MatOfInt matOfInt) {
        MatOfInt matOfInt2 = matOfInt;
        PCTSignatures.setInitSeedIndexes_0(this.nativeObj, matOfInt2.nativeObj);
    }

    public int getInitSeedCount() {
        return PCTSignatures.getInitSeedCount_0(this.nativeObj);
    }

    public int getIterationCount() {
        return PCTSignatures.getIterationCount_0(this.nativeObj);
    }

    public void setIterationCount(int n) {
        PCTSignatures.setIterationCount_0(this.nativeObj, n);
    }

    public int getMaxClustersCount() {
        return PCTSignatures.getMaxClustersCount_0(this.nativeObj);
    }

    public void setMaxClustersCount(int n) {
        PCTSignatures.setMaxClustersCount_0(this.nativeObj, n);
    }

    public int getClusterMinSize() {
        return PCTSignatures.getClusterMinSize_0(this.nativeObj);
    }

    public void setClusterMinSize(int n) {
        PCTSignatures.setClusterMinSize_0(this.nativeObj, n);
    }

    public float getJoiningDistance() {
        return PCTSignatures.getJoiningDistance_0(this.nativeObj);
    }

    public void setJoiningDistance(float f) {
        PCTSignatures.setJoiningDistance_0(this.nativeObj, f);
    }

    public float getDropThreshold() {
        return PCTSignatures.getDropThreshold_0(this.nativeObj);
    }

    public void setDropThreshold(float f) {
        PCTSignatures.setDropThreshold_0(this.nativeObj, f);
    }

    public int getDistanceFunction() {
        return PCTSignatures.getDistanceFunction_0(this.nativeObj);
    }

    public void setDistanceFunction(int n) {
        PCTSignatures.setDistanceFunction_0(this.nativeObj, n);
    }

    @Override
    protected void finalize() throws Throwable {
        PCTSignatures.delete(this.nativeObj);
    }

    private static native long create_0(int var0, int var1, int var2);

    private static native long create_1(int var0, int var1);

    private static native long create_2(int var0);

    private static native long create_3();

    private static native long create_4(long var0, int var2);

    private static native long create_5(long var0, long var2);

    private static native void computeSignature_0(long var0, long var2, long var4);

    private static native void computeSignatures_0(long var0, long var2, long var4);

    private static native void drawSignature_0(long var0, long var2, long var4, float var6, int var7);

    private static native void drawSignature_1(long var0, long var2, long var4, float var6);

    private static native void drawSignature_2(long var0, long var2, long var4);

    private static native void generateInitPoints_0(long var0, int var2, int var3);

    private static native int getSampleCount_0(long var0);

    private static native int getGrayscaleBits_0(long var0);

    private static native void setGrayscaleBits_0(long var0, int var2);

    private static native int getWindowRadius_0(long var0);

    private static native void setWindowRadius_0(long var0, int var2);

    private static native float getWeightX_0(long var0);

    private static native void setWeightX_0(long var0, float var2);

    private static native float getWeightY_0(long var0);

    private static native void setWeightY_0(long var0, float var2);

    private static native float getWeightL_0(long var0);

    private static native void setWeightL_0(long var0, float var2);

    private static native float getWeightA_0(long var0);

    private static native void setWeightA_0(long var0, float var2);

    private static native float getWeightB_0(long var0);

    private static native void setWeightB_0(long var0, float var2);

    private static native float getWeightContrast_0(long var0);

    private static native void setWeightContrast_0(long var0, float var2);

    private static native float getWeightEntropy_0(long var0);

    private static native void setWeightEntropy_0(long var0, float var2);

    private static native long getSamplingPoints_0(long var0);

    private static native void setWeight_0(long var0, int var2, float var3);

    private static native void setWeights_0(long var0, long var2);

    private static native void setTranslation_0(long var0, int var2, float var3);

    private static native void setTranslations_0(long var0, long var2);

    private static native void setSamplingPoints_0(long var0, long var2);

    private static native long getInitSeedIndexes_0(long var0);

    private static native void setInitSeedIndexes_0(long var0, long var2);

    private static native int getInitSeedCount_0(long var0);

    private static native int getIterationCount_0(long var0);

    private static native void setIterationCount_0(long var0, int var2);

    private static native int getMaxClustersCount_0(long var0);

    private static native void setMaxClustersCount_0(long var0, int var2);

    private static native int getClusterMinSize_0(long var0);

    private static native void setClusterMinSize_0(long var0, int var2);

    private static native float getJoiningDistance_0(long var0);

    private static native void setJoiningDistance_0(long var0, float var2);

    private static native float getDropThreshold_0(long var0);

    private static native void setDropThreshold_0(long var0, float var2);

    private static native int getDistanceFunction_0(long var0);

    private static native void setDistanceFunction_0(long var0, int var2);

    private static native void delete(long var0);
}

