/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.highgui;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public final class ImageWindow {
    public static final int WINDOW_NORMAL = 0;
    public static final int WINDOW_AUTOSIZE = 1;
    public String name;
    public Mat img = null;
    public Boolean alreadyUsed = false;
    public Boolean imgToBeResized = false;
    public Boolean windowToBeResized = false;
    public Boolean positionToBeChanged = false;
    public JFrame frame = null;
    public JLabel lbl = null;
    public int flag;
    public int x = -1;
    public int y = -1;
    public int width = -1;
    public int height = -1;

    public ImageWindow(String string, Mat mat) {
        this.name = string;
        this.img = mat;
        this.flag = 0;
    }

    public ImageWindow(String string, int n) {
        this.name = string;
        this.flag = n;
    }

    public static Size keepAspectRatioSize(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        if (n > n3) {
            n5 = n3;
            n6 = n5 * n2 / n;
        }
        if (n6 > n4) {
            n6 = n4;
            n5 = n6 * n / n2;
        }
        return new Size(n5, n6);
    }

    public void setMat(Mat mat) {
        this.img = mat;
        this.alreadyUsed = false;
        if (this.imgToBeResized.booleanValue()) {
            this.resizeImage();
            this.imgToBeResized = false;
        }
    }

    public void setFrameLabelVisible(JFrame jFrame, JLabel jLabel) {
        this.frame = jFrame;
        this.lbl = jLabel;
        if (this.windowToBeResized.booleanValue()) {
            jLabel.setPreferredSize(new Dimension(this.width, this.height));
            this.windowToBeResized = false;
        }
        if (this.positionToBeChanged.booleanValue()) {
            jFrame.setLocation(this.x, this.y);
            this.positionToBeChanged = false;
        }
        jFrame.add(jLabel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void setNewDimension(int n, int n2) {
        if (this.width != n || this.height != n2) {
            this.width = n;
            this.height = n2;
            if (this.img != null) {
                this.resizeImage();
            } else {
                this.imgToBeResized = true;
            }
            if (this.lbl != null) {
                this.lbl.setPreferredSize(new Dimension(n, n2));
            } else {
                this.windowToBeResized = true;
            }
        }
    }

    public void setNewPosition(int n, int n2) {
        if (this.x != n || this.y != n2) {
            this.x = n;
            this.y = n2;
            if (this.frame != null) {
                this.frame.setLocation(n, n2);
            } else {
                this.positionToBeChanged = true;
            }
        }
    }

    private void resizeImage() {
        if (this.flag == 0) {
            Size size = ImageWindow.keepAspectRatioSize(this.img.width(), this.img.height(), this.width, this.height);
            Imgproc.resize(this.img, this.img, size, 0.0, 0.0, 5);
        }
    }
}

