/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import org.opencv.core.Point;
import org.opencv.core.Size;

public class Rect2d {
    public double x;
    public double y;
    public double width;
    public double height;

    public Rect2d(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public Rect2d() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Rect2d(Point point, Point point2) {
        this.x = point.x < point2.x ? point.x : point2.x;
        this.y = point.y < point2.y ? point.y : point2.y;
        this.width = (point.x > point2.x ? point.x : point2.x) - this.x;
        this.height = (point.y > point2.y ? point.y : point2.y) - this.y;
    }

    public Rect2d(Point point, Size size) {
        this(point.x, point.y, size.width, size.height);
    }

    public Rect2d(double[] dArray) {
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.x = dArray.length > 0 ? dArray[0] : 0.0;
            this.y = dArray.length > 1 ? dArray[1] : 0.0;
            this.width = dArray.length > 2 ? dArray[2] : 0.0;
            this.height = dArray.length > 3 ? dArray[3] : 0.0;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.width = 0.0;
            this.height = 0.0;
        }
    }

    public Rect2d clone() {
        return new Rect2d(this.x, this.y, this.width, this.height);
    }

    public Point tl() {
        return new Point(this.x, this.y);
    }

    public Point br() {
        return new Point(this.x + this.width, this.y + this.height);
    }

    public Size size() {
        return new Size(this.width, this.height);
    }

    public double area() {
        return this.width * this.height;
    }

    public boolean empty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean contains(Point point) {
        return this.x <= point.x && point.x < this.x + this.width && this.y <= point.y && point.y < this.y + this.height;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.height);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.width);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rect2d)) {
            return false;
        }
        Rect2d rect2d = (Rect2d)object;
        return this.x == rect2d.x && this.y == rect2d.y && this.width == rect2d.width && this.height == rect2d.height;
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.width + "x" + this.height + "}";
    }
}

