/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.KeyPoint;
import org.opencv.core.Mat;
import org.opencv.core.Range;

public class MatOfKeyPoint
extends Mat {
    private static final int _depth = 5;
    private static final int _channels = 7;

    public MatOfKeyPoint() {
    }

    protected MatOfKeyPoint(long l) {
        super(l);
        if (!this.empty() && this.checkVector(7, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfKeyPoint fromNativeAddr(long l) {
        return new MatOfKeyPoint(l);
    }

    public MatOfKeyPoint(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(7, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfKeyPoint(KeyPoint ... keyPointArray) {
        this.fromArray(keyPointArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(5, 7));
        }
    }

    public void fromArray(KeyPoint ... keyPointArray) {
        if (keyPointArray == null || keyPointArray.length == 0) {
            return;
        }
        int n = keyPointArray.length;
        this.alloc(n);
        float[] fArray = new float[n * 7];
        for (int i = 0; i < n; ++i) {
            KeyPoint keyPoint = keyPointArray[i];
            fArray[7 * i + 0] = (float)keyPoint.pt.x;
            fArray[7 * i + 1] = (float)keyPoint.pt.y;
            fArray[7 * i + 2] = keyPoint.size;
            fArray[7 * i + 3] = keyPoint.angle;
            fArray[7 * i + 4] = keyPoint.response;
            fArray[7 * i + 5] = keyPoint.octave;
            fArray[7 * i + 6] = keyPoint.class_id;
        }
        this.put(0, 0, fArray);
    }

    public KeyPoint[] toArray() {
        int n = (int)this.total();
        KeyPoint[] keyPointArray = new KeyPoint[n];
        if (n == 0) {
            return keyPointArray;
        }
        float[] fArray = new float[n * 7];
        this.get(0, 0, fArray);
        for (int i = 0; i < n; ++i) {
            keyPointArray[i] = new KeyPoint(fArray[7 * i + 0], fArray[7 * i + 1], fArray[7 * i + 2], fArray[7 * i + 3], fArray[7 * i + 4], (int)fArray[7 * i + 5], (int)fArray[7 * i + 6]);
        }
        return keyPointArray;
    }

    public void fromList(List<KeyPoint> list) {
        KeyPoint[] keyPointArray = list.toArray(new KeyPoint[0]);
        this.fromArray(keyPointArray);
    }

    public List<KeyPoint> toList() {
        KeyPoint[] keyPointArray = this.toArray();
        return Arrays.asList(keyPointArray);
    }
}

