/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xsd.documentation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.options.md;
import ro.sync.options.k;
import ro.sync.util.Resource;
import ro.sync.util.URLUtil;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.xsd.documentation.DocumentationOptions;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XSDDocumentationOptions
extends DocumentationOptions {
    private static final Logger logger = Logger.getLogger((String)XSDDocumentationOptions.class.getName());
    public static final URL HTML_XSL = Resource.getResource("/builtin/documentation/schema_documentation/xsdDocHtml.xsl");
    public static final URL DOCBOOK_XSL = Resource.getResource("/builtin/documentation/schema_documentation/xsdDocDocbook.xsl");
    private static final String FO_XSL_PATH = "${frameworksDir}/docbook/oxygen/xsdDocDocbookCustomizationFO.xsl";
    public static final URL[] XSD_HTML_AND_PDF_IMAGES = new URL[]{Resource.getResource("/builtin/documentation/img/HierarchyArrow12.jpg"), Resource.getResource("/builtin/documentation/img/Cycle12.png"), Resource.getResource("/builtin/documentation/img/Import12.gif"), Resource.getResource("/builtin/documentation/img/Include12.gif"), Resource.getResource("/builtin/documentation/img/Redefine12.gif"), Resource.getResource("/builtin/documentation/img/Override12.gif")};
    private String imageType = "jpeg";
    private boolean includeGlobalElements = true;
    private boolean includeGlobalAttributes = true;
    private boolean includeLocalElements = true;
    private boolean includeLocalAttributes = true;
    private boolean includeSimpleTypes = true;
    private boolean includeComplexTypes = true;
    private boolean includeGroups = true;
    private boolean includeAttributesGroups = true;
    private boolean includeRedefines = true;
    private boolean includeReferencedSchemas = true;
    private boolean includeNotations = true;
    private boolean detailsDiagram = true;
    private boolean detailsNamespace = true;
    private boolean detailsLocation = true;
    private boolean detailsType = true;
    private boolean detailsTypeHierarchy = true;
    private boolean detailsModel = true;
    private boolean detailsChildren = true;
    private boolean detailsInstance = true;
    private boolean detailsUsedby = true;
    private boolean detailsProperties = true;
    private boolean detailsFacets = true;
    private boolean detailsAttributes = true;
    private boolean detailsAsserts = true;
    private boolean detailsIdentityConstr = true;
    private boolean detailsEscapeAnn = true;
    private boolean detailsSource = true;
    private boolean detailsAnnotations = true;
    private boolean includeIndexLocalComponents = false;
    private boolean showAnnotationsInDiagram = false;
    private boolean filterByLanguage = false;
    private String languageToFilter = "";
    private boolean includeIndexResourceHierarchy = true;

    public static final File getFOxslFile() {
        return new File(EditorVariables.expandEditorVariables(FO_XSL_PATH, null));
    }

    public XSDDocumentationOptions() {
    }

    public XSDDocumentationOptions(String string, int n2, boolean bl, int n3, URL uRL, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, String string2, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, boolean bl23, boolean bl24, boolean bl25, boolean bl26, boolean bl27, boolean bl28, boolean bl29, boolean bl30, boolean bl31, boolean bl32, boolean bl33, boolean bl34) {
        this(string, n2, bl, n3, uRL, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, bl15, bl16, bl17, string2, bl18, bl19, bl20, bl21, bl22, bl23, bl24, bl25, bl26, bl27, bl28, bl29, bl30, bl31, bl32, bl33, bl34, false, null, false, null);
    }

    public XSDDocumentationOptions(String string, int n2, boolean bl, int n3, URL uRL, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, String string2, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, boolean bl23, boolean bl24, boolean bl25, boolean bl26, boolean bl27, boolean bl28, boolean bl29, boolean bl30, boolean bl31, boolean bl32, boolean bl33, boolean bl34, boolean bl35, URL uRL2, boolean bl36, String string3) {
        super(string, n2, bl, n3, uRL, bl2, bl3, bl35, uRL2);
        this.imageType = string2;
        this.showAnnotationsInDiagram = bl18;
        this.includeIndexLocalComponents = bl4;
        this.includeIndexResourceHierarchy = bl5;
        this.includeGlobalElements = bl6;
        this.includeGlobalAttributes = bl7;
        this.includeLocalElements = bl8;
        this.includeLocalAttributes = bl9;
        this.includeSimpleTypes = bl10;
        this.includeComplexTypes = bl11;
        this.includeGroups = bl12;
        this.includeAttributesGroups = bl13;
        this.includeRedefines = bl14;
        this.includeReferencedSchemas = bl15;
        this.includeNotations = bl16;
        this.detailsDiagram = bl17;
        this.detailsNamespace = bl19;
        this.detailsLocation = bl20;
        this.detailsType = bl21;
        this.detailsTypeHierarchy = bl22;
        this.detailsModel = bl23;
        this.detailsChildren = bl24;
        this.detailsInstance = bl25;
        this.detailsUsedby = bl26;
        this.detailsProperties = bl27;
        this.detailsFacets = bl28;
        this.detailsAttributes = bl29;
        this.detailsAsserts = bl30;
        this.detailsIdentityConstr = bl31;
        this.detailsEscapeAnn = bl32;
        this.detailsSource = bl33;
        this.detailsAnnotations = bl34;
        this.filterByLanguage = bl36;
        this.languageToFilter = this.getNonNullValue(string3);
    }

    protected String getNonNullValue(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public URL getXSL() {
        URL uRL = null;
        uRL = this.format == 4 ? this.getCustomURL() : (this.format == 3 || this.format == 2 ? DOCBOOK_XSL : HTML_XSL);
        return uRL;
    }

    public boolean isIncludeIndexLocalComponents() {
        return this.includeIndexLocalComponents;
    }

    public boolean isIncludeGlobalElements() {
        return this.includeGlobalElements;
    }

    public boolean isIncludeGlobalAttributes() {
        return this.includeGlobalAttributes;
    }

    public boolean isIncludeLocalElements() {
        return this.includeLocalElements;
    }

    public boolean isIncludeLocalAttributes() {
        return this.includeLocalAttributes;
    }

    public boolean isIncludeSimpleTypes() {
        return this.includeSimpleTypes;
    }

    public boolean isIncludeComplexTypes() {
        return this.includeComplexTypes;
    }

    public boolean isIncludeGroups() {
        return this.includeGroups;
    }

    public boolean isIncludeAttributesGroups() {
        return this.includeAttributesGroups;
    }

    public boolean isIncludeRedefines() {
        return this.includeRedefines;
    }

    public boolean isIncludeReferencedSchemas() {
        return this.includeReferencedSchemas;
    }

    public boolean isDetailsDiagram() {
        return this.detailsDiagram;
    }

    public boolean isDetailsNamespace() {
        return this.detailsNamespace;
    }

    public boolean isDetailsLocation() {
        return this.detailsLocation;
    }

    public boolean isDetailsType() {
        return this.detailsType;
    }

    public boolean isDetailsTypeHierarchy() {
        return this.detailsTypeHierarchy;
    }

    public boolean isDetailsModel() {
        return this.detailsModel;
    }

    public boolean isDetailsChildren() {
        return this.detailsChildren;
    }

    public boolean isDetailsInstance() {
        return this.detailsInstance;
    }

    public boolean isDetailsUsedby() {
        return this.detailsUsedby;
    }

    public boolean isDetailsProperties() {
        return this.detailsProperties;
    }

    public boolean isDetailsFacets() {
        return this.detailsFacets;
    }

    public boolean isDetailsAttributes() {
        return this.detailsAttributes;
    }

    public boolean isDetailsAsserts() {
        return this.detailsAsserts;
    }

    public boolean isDetailsIdentityConstr() {
        return this.detailsIdentityConstr;
    }

    public boolean isDetailsEscapeAnn() {
        return this.detailsEscapeAnn;
    }

    public boolean isDetailsSource() {
        return this.detailsSource;
    }

    public boolean isDetailsAnnotations() {
        return this.detailsAnnotations;
    }

    public void setDetailsDiagram(boolean bl) {
        this.detailsDiagram = bl;
    }

    public void setIncludeReferencedSchemas(boolean bl) {
        this.includeReferencedSchemas = bl;
    }

    public void setIncludeNotations(boolean bl) {
        this.includeNotations = bl;
    }

    public void setIncludeLocalElements(boolean bl) {
        this.includeLocalElements = bl;
    }

    public void setIncludeLocalAttributes(boolean bl) {
        this.includeLocalAttributes = bl;
    }

    public void setIncludeComplexTypes(boolean bl) {
        this.includeComplexTypes = bl;
    }

    public void setIncludeSimpleTypes(boolean bl) {
        this.includeSimpleTypes = bl;
    }

    public void setIncludeGroups(boolean bl) {
        this.includeGroups = bl;
    }

    public void setIncludeAttributesGroups(boolean bl) {
        this.includeAttributesGroups = bl;
    }

    public void setIncludeGlobalElements(boolean bl) {
        this.includeGlobalElements = bl;
    }

    public void setIncludeGlobalAttributes(boolean bl) {
        this.includeGlobalAttributes = bl;
    }

    public void setIncludeRedefines(boolean bl) {
        this.includeRedefines = bl;
    }

    public void setIncludeIndexLocalComponents(boolean bl) {
        this.includeIndexLocalComponents = bl;
    }

    public void setDetailsNamespace(boolean bl) {
        this.detailsNamespace = bl;
    }

    public void setDetailsLocation(boolean bl) {
        this.detailsLocation = bl;
    }

    public void setDetailsType(boolean bl) {
        this.detailsType = bl;
    }

    public void setDetailsTypeHierarchy(boolean bl) {
        this.detailsTypeHierarchy = bl;
    }

    public void setDetailsModel(boolean bl) {
        this.detailsModel = bl;
    }

    public void setDetailsChildren(boolean bl) {
        this.detailsChildren = bl;
    }

    public void setDetailsInstance(boolean bl) {
        this.detailsInstance = bl;
    }

    public void setDetailsUsedby(boolean bl) {
        this.detailsUsedby = bl;
    }

    public void setDetailsProperties(boolean bl) {
        this.detailsProperties = bl;
    }

    public void setDetailsFacets(boolean bl) {
        this.detailsFacets = bl;
    }

    public void setDetailsIdentityConstr(boolean bl) {
        this.detailsIdentityConstr = bl;
    }

    public void setDetailsAttributes(boolean bl) {
        this.detailsAttributes = bl;
    }

    public void setDetailsAsserts(boolean bl) {
        this.detailsAsserts = bl;
    }

    public void setDetailsAnnotations(boolean bl) {
        this.detailsAnnotations = bl;
    }

    public void setDetailsSource(boolean bl) {
        this.detailsSource = bl;
    }

    @Override
    public void setFormat(int n2) {
        this.format = n2;
    }

    public void setDetailsEscapeAnn(boolean bl) {
        this.detailsEscapeAnn = bl;
    }

    public boolean isShowAnnotationsInDiagram() {
        return this.showAnnotationsInDiagram;
    }

    public boolean isIncludeNotations() {
        return this.includeNotations;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String string) {
        this.imageType = string;
    }

    public boolean isFilterByLanguage() {
        return this.filterByLanguage;
    }

    public void setFilterByLanguage(boolean bl) {
        this.filterByLanguage = bl;
    }

    public String getLanguageToFilter() {
        return this.languageToFilter;
    }

    public void setLanguageToFilter(String string) {
        this.languageToFilter = this.getNonNullValue(string);
    }

    public boolean isIncludeIndexResourceHierarchy() {
        return this.includeIndexResourceHierarchy;
    }

    public void setIncludeIndexResourceHierarchy(boolean bl) {
        this.includeIndexResourceHierarchy = bl;
    }

    public static void copyXsdHTMLImages(File file) {
        DocumentationOptions.copyImages(file, HTML_IMAGES);
        DocumentationOptions.copyImages(file, XSD_HTML_AND_PDF_IMAGES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(File file) throws IOException {
        file = URLUtil.correctFileExtension(file, "xml");
        k k2 = new k(false, md.b);
        k2.setObjectProperty(this.getOptionsTag(), this);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            k2.store(outputStream);
        }
        finally {
            block9: {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)iOException, (Throwable)iOException);
                    }
                }
            }
        }
    }

    protected String getOptionsTag() {
        return "xsd.documentation.options";
    }
}

