/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util.editorvars;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.options.Options;
import ro.sync.exml.workspace.api.util.EditorVariablesResolver;
import ro.sync.io.FileSystemUtil;
import ro.sync.io.mb;
import ro.sync.util.Equaler;
import ro.sync.util.PlatformDetector;
import ro.sync.util.URLUtil;
import ro.sync.util.bb;
import ro.sync.util.cc;
import ro.sync.util.editorvars.UserEditorVariablePO;
import ro.sync.util.editorvars.c;
import ro.sync.util.editorvars.e;
import ro.sync.util.editorvars.f;
import ro.sync.util.editorvars.g;
import ro.sync.util.m;
import ro.sync.util.s;
import ro.sync.util.ub;
import ro.sync.util.xb;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public final class EditorVariables {
    private static final Logger logger = Logger.getLogger((String)EditorVariables.class.getName());
    public static final String EDITOR_VARIABLES_PREFIX = "${";
    public static final String CURRENT_FILE_DIRECTORY_URL = "${cfdu}";
    public static final String CURRENT_FILE_DIRECTORY = "${cfd}";
    public static final String CURRENT_FILE_URL = "${currentFileURL}";
    public static final String CURRENT_FILE_URL_OLD = "${cfu}";
    public static final String CURRENT_FILE = "${cf}";
    public static final String CURRENT_FILENAME = "${cfn}";
    public static final String CURRENT_FILENAME_WITH_EXTENSION = "${cfne}";
    public static final String PROJECT_DIRECTORY_URL = "${pdu}";
    public static final String PROJECT_DIRECTORY = "${pd}";
    public static final String PROJECT_NAME = "${pn}";
    public static final String ARCHIVE_NAME = "${afn}";
    public static final String ARCHIVE_NAME_WITH_EXTENSION = "${afne}";
    public static final String ARCHIVE_PATH = "${af}";
    public static final String ARCHIVE_PATH_URL = "${afu}";
    public static final String ARCHIVE_FILE_DIRECTORY = "${afd}";
    public static final String ARCHIVE_FILE_DIRECTORY_URL = "${afdu}";
    public static final String FRAMEWORKS_DIRECTORY_URL = "${frameworks}";
    public static final String USER_HOME_URL = "${home}";
    public static final String FRAMEWORKS_DIRECTORY = "${frameworksDir}";
    public static final String FRAMEWORK_DIRECTORY = "${frameworkDir}";
    public static final String FRAMEWORK_URL = "${framework}";
    public static final String BASE_FRAMEWORK_DIRECTORY = "${baseFrameworkDir}";
    public static final String BASE_FRAMEWORK_URL = "${baseFramework}";
    public static final String USER_HOME_DIR = "${homeDir}";
    public static final String OXYGEN_INSTALL_DIR = "${oxygenInstallDir}";
    public static final String DETECTED_SCHEMA = "${ds}";
    public static final String DETECTED_SCHEMA_URL = "${dsu}";
    public static final String TRANSFORMATION_SAVED_FILE = "${tsf}";
    public static final String DEBUGGER_XML_SOURCE = "${dbgXML}";
    public static final String DEBUGGER_XSL_SOURCE = "${dbgXSL}";
    public static final String FOP_TRANSFORMATION_METHOD = "${method}";
    public static final String FOP_AH_TRANSFORMATION_METHOD = "${ah_method}";
    public static final String FO_INPUT_FILE = "${fo}";
    public static final String OUTPUT_FILE = "${out}";
    public static final String OUTPUT_FILE_URL = "${outu}";
    public static final String OXYGEN_HOME_URL = "${oxygenHome}";
    public static final String XML = "${xml}";
    public static final String XSL = "${xsl}";
    public static final String SQL = "${sql}";
    public static final String XQUERY = "${xq}";
    public static final String XPROC = "${xproc}";
    public static final String XML_URL = "${xmlu}";
    public static final String XSL_URL = "${xslu}";
    public static final String SQL_URL = "${sqlu}";
    public static final String XQUERY_URL = "${xqu}";
    public static final String XPROC_URL = "${xprocu}";
    public static final String PATH_SEPARATOR = "${ps}";
    public static final String FIRST_FILE_TO_DIFF = "${firstFile}";
    public static final String SECOND_FILE_TO_DIFF = "${secondFile}";
    public static final String ANCESTOR_FILE_TO_DIFF = "${ancestorFile}";
    public static final String TIMESTAMP = "${timeStamp}";
    public static final String UUID = "${uuid}";
    public static final String ID = "${id}";
    public static final String ASK_PARAM_VALUE_TEMPLATE = "${ask('Message', input_type, 'default_value')}";
    static final String FRAMEWORK_FUNCTION_VARIABLE_PREFIX = "${framework(";
    public static final String FRAMEWORK_URL_FUNCTION_TEMPLATE = "${framework(framework_name)}";
    static final String FRAMEWORK_DIR_FUNCTION_VARIABLE_PREFIX = "${frameworkDir(";
    static final String FRAMEWORK_DIR_FUNCTION_TEMPLATE = "${frameworkDir(framework_name)}";
    static final String ENV_FUNCTION_VARIABLE_PREFIX = "${env(";
    static final String SYSTEM_FUNCTION_VARIABLE_PREFIX = "${system(";
    public static final String TRANSLATE_FUNCTION_VARIABLE_PREFIX = "${i18n(";
    static final String DATE_FUNCTION_VARIABLE_PREFIX = "${date(";
    static final String STATIC_XPATH_FUNCTION_VARIABLE_PREFIX = "${xpath_eval(";
    public static final String FUNCTION_VARIABLE_SUFFIX = ")}";
    static final String ENV_VAR_NAME = "VAR_NAME";
    static final String SYSTEM_VAR_NAME = "var.name";
    static final String ENV_FUNCTION_SAMPLE = "${env(VAR_NAME)}";
    static final String SYSTEM_FUNCTION_SAMPLE = "${system(var.name)}";
    static final String DATE_FORMAT_SAMPLE = "yyyy-MM-dd";
    public static final String DATE_FUNCTION_SAMPLE = "${date(yyyy-MM-dd)}";
    public static final String XPATH_FUNCTION_SAMPLE = "${xpath_eval(expression)}";
    public static final String CT_CARET_EDITOR_VARIABLE = "${caret}";
    public static final String CT_SELECTION_EDITOR_VARIABLE = "${selection}";
    public static final String UNIQUE_CARET_MARKER_PI_NAME_FOR_AUTHOR = "UNIQUE_CARET_MARKER_FOR_AUTHOR";
    public static final String UNIQUE_CARET_MARKER_FOR_AUTHOR = "<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>";
    static AtomicBoolean frameworksDirInitialized = new AtomicBoolean(false);
    static final Set EDITOR_VARIABLES_SET = new HashSet(){
        {
            this.add(EditorVariables.CURRENT_FILE_DIRECTORY);
            this.add(EditorVariables.CURRENT_FILE_DIRECTORY_URL);
            this.add(EditorVariables.CURRENT_FILE);
            this.add(EditorVariables.CURRENT_FILE_URL);
            this.add(EditorVariables.CURRENT_FILE_URL_OLD);
            this.add(EditorVariables.CURRENT_FILENAME);
            this.add(EditorVariables.CURRENT_FILENAME_WITH_EXTENSION);
            this.add(EditorVariables.PROJECT_DIRECTORY_URL);
            this.add(EditorVariables.PROJECT_DIRECTORY);
            this.add(EditorVariables.PROJECT_NAME);
            this.add(EditorVariables.FRAMEWORKS_DIRECTORY_URL);
            this.add(EditorVariables.FRAMEWORKS_DIRECTORY);
            this.add(EditorVariables.BASE_FRAMEWORK_URL);
            this.add(EditorVariables.BASE_FRAMEWORK_DIRECTORY);
            this.add(EditorVariables.USER_HOME_URL);
            this.add(EditorVariables.USER_HOME_DIR);
            this.add(EditorVariables.OXYGEN_INSTALL_DIR);
            this.add(EditorVariables.OXYGEN_HOME_URL);
            this.add(EditorVariables.DETECTED_SCHEMA);
            this.add(EditorVariables.DETECTED_SCHEMA_URL);
            this.add(EditorVariables.TRANSFORMATION_SAVED_FILE);
            this.add(EditorVariables.DEBUGGER_XML_SOURCE);
            this.add(EditorVariables.DEBUGGER_XSL_SOURCE);
            this.add(EditorVariables.FOP_TRANSFORMATION_METHOD);
            this.add(EditorVariables.FOP_AH_TRANSFORMATION_METHOD);
            this.add(EditorVariables.FO_INPUT_FILE);
            this.add(EditorVariables.OUTPUT_FILE);
            this.add(EditorVariables.OUTPUT_FILE_URL);
            this.add(EditorVariables.XML);
            this.add(EditorVariables.XSL);
            this.add(EditorVariables.SQL);
            this.add(EditorVariables.XQUERY);
            this.add(EditorVariables.XPROC);
            this.add(EditorVariables.XML_URL);
            this.add(EditorVariables.XSL_URL);
            this.add(EditorVariables.SQL_URL);
            this.add(EditorVariables.XQUERY_URL);
            this.add(EditorVariables.XPROC_URL);
            this.add(EditorVariables.PATH_SEPARATOR);
            this.add(EditorVariables.TIMESTAMP);
            this.add(EditorVariables.UUID);
            this.add(EditorVariables.ID);
            this.add(EditorVariables.UNIQUE_CARET_MARKER_FOR_AUTHOR);
            this.add(EditorVariables.ARCHIVE_NAME);
            this.add(EditorVariables.ARCHIVE_NAME_WITH_EXTENSION);
            this.add(EditorVariables.ARCHIVE_PATH);
            this.add(EditorVariables.ARCHIVE_PATH_URL);
            this.add(EditorVariables.ARCHIVE_FILE_DIRECTORY);
            this.add(EditorVariables.ARCHIVE_FILE_DIRECTORY_URL);
            this.add(EditorVariables.FRAMEWORK_DIRECTORY);
            this.add(EditorVariables.FRAMEWORK_URL);
        }
    };
    private static s projectURLProvider;
    private static m archiveURLProvider;
    private static g frameworkLocationResolver;
    private static xb archiveExtensionsRecognizer;
    private static e staticXpathEvaluator;
    private static final List<EditorVariablesResolver> customResolvers;
    private static URL frameworksURLForTests;
    private static ThreadLocal<Boolean> frameworksDirInitializing;
    static URL DEFAULT_FRAMEWORK_URL;
    private static File frameworksDirForTests;
    private static final int BASE = 26;
    private static final long OFFSET = 1286892000000L;
    private static long lastUsedTimestamp;

    public static String getDescription(String string) {
        String string2 = (String)c.b.get(string);
        if (string2 == null) {
            UserEditorVariablePO[] userEditorVariablePOArray = (UserEditorVariablePO[])Options.getInstance().getObjectArrayProperty("user.defined.editor.variables", UserEditorVariablePO.class);
            for (int i2 = 0; i2 < userEditorVariablePOArray.length; ++i2) {
                String string3 = userEditorVariablePOArray[i2].getVarName();
                if (!string3.equals(string)) continue;
                string2 = userEditorVariablePOArray[i2].getVarShortDescription();
                break;
            }
        }
        return string2;
    }

    public static boolean containsEditorVariable(String string) {
        boolean bl = false;
        if (string != null) {
            for (UserEditorVariablePO[] userEditorVariablePOArray : EDITOR_VARIABLES_SET) {
                if (!string.contains((CharSequence)userEditorVariablePOArray)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                UserEditorVariablePO[] userEditorVariablePOArray;
                userEditorVariablePOArray = (UserEditorVariablePO[])Options.getInstance().getObjectArrayProperty("user.defined.editor.variables", UserEditorVariablePO.class);
                for (int i2 = 0; i2 < userEditorVariablePOArray.length; ++i2) {
                    String string2 = userEditorVariablePOArray[i2].getVarName();
                    if (!string.contains(string2)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl && (string.contains(ENV_FUNCTION_VARIABLE_PREFIX) || string.contains(SYSTEM_FUNCTION_VARIABLE_PREFIX) || string.contains(DATE_FUNCTION_VARIABLE_PREFIX) || string.contains(STATIC_XPATH_FUNCTION_VARIABLE_PREFIX) || string.contains(FRAMEWORK_FUNCTION_VARIABLE_PREFIX) || string.contains(FRAMEWORK_DIR_FUNCTION_VARIABLE_PREFIX)) && string.contains(FUNCTION_VARIABLE_SUFFIX)) {
                bl = true;
            }
        }
        return bl;
    }

    public static String expandEditorVariablesAsFilePath(String string, String string2) {
        String string3 = EditorVariables.expandEditorVariables(string, string2);
        if (string3 != null && string3.contains(":/")) {
            try {
                File file = URLUtil.getCanonicalFileFromFileUrl(new URL(string3));
                if (file != null) {
                    string3 = file.getAbsolutePath();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string3;
    }

    public static String expandEditorVariables(String string, final String string2) {
        Object object;
        block54: {
            URL uRL;
            URL uRL2;
            URL uRL3;
            URL uRL4;
            URL uRL5;
            URL uRL6;
            int n2;
            URL uRL7;
            String string3;
            File file;
            Object object2;
            int n3;
            if (!customResolvers.isEmpty()) {
                int n4 = customResolvers.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    object = customResolvers.get(n3);
                    object2 = ((EditorVariablesResolver)object).resolveEditorVariables(string, string2);
                    if (object2 == null) continue;
                    string = object2;
                }
            }
            if (!EditorVariables.containsEditorVariable(string)) {
                return string;
            }
            UserEditorVariablePO[] userEditorVariablePOArray = (UserEditorVariablePO[])Options.getInstance().getObjectArrayProperty("user.defined.editor.variables", UserEditorVariablePO.class);
            for (n3 = 0; n3 < userEditorVariablePOArray.length; ++n3) {
                object = userEditorVariablePOArray[n3].getVarName();
                string = bb.c(string, (String)object, userEditorVariablePOArray[n3].getVarValue());
            }
            string = EditorVariables.replaceFunctions(string, FRAMEWORK_FUNCTION_VARIABLE_PREFIX, FUNCTION_VARIABLE_SUFFIX, new _b(){

                @Override
                public String resolveFunctionWithParameter(String string) {
                    String string2;
                    String string3 = "";
                    String string4 = string2 = frameworkLocationResolver != null ? frameworkLocationResolver.b(string) : null;
                    if (string2 != null) {
                        try {
                            string3 = URLUtil.correct(new File(string2).getParentFile()).toExternalForm();
                        }
                        catch (MalformedURLException malformedURLException) {
                            logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                        }
                    }
                    return string3;
                }
            });
            string = EditorVariables.replaceFunctions(string, FRAMEWORK_DIR_FUNCTION_VARIABLE_PREFIX, FUNCTION_VARIABLE_SUFFIX, new _b(){

                @Override
                public String resolveFunctionWithParameter(String string) {
                    String string2;
                    String string3 = "";
                    String string4 = string2 = frameworkLocationResolver != null ? frameworkLocationResolver.b(string) : null;
                    if (string2 != null) {
                        string3 = new File(string2).getParentFile().getAbsolutePath().replace('\\', '/');
                    }
                    return string3;
                }
            });
            string = EditorVariables.replaceFunctions(string, ENV_FUNCTION_VARIABLE_PREFIX, FUNCTION_VARIABLE_SUFFIX, new _b(){

                @Override
                public String resolveFunctionWithParameter(String string) {
                    try {
                        return System.getenv(string);
                    }
                    catch (SecurityException securityException) {
                        logger.error((Object)("Insufficient privilidges to access System.env, possibly running from applet " + securityException), (Throwable)securityException);
                        return "";
                    }
                }
            });
            string = EditorVariables.replaceFunctions(string, SYSTEM_FUNCTION_VARIABLE_PREFIX, FUNCTION_VARIABLE_SUFFIX, new _b(){

                @Override
                public String resolveFunctionWithParameter(String string) {
                    return System.getProperty(string);
                }
            });
            string = EditorVariables.replaceFunctions(string, DATE_FUNCTION_VARIABLE_PREFIX, FUNCTION_VARIABLE_SUFFIX, new _b(){

                @Override
                public String resolveFunctionWithParameter(String string) {
                    String string2 = "";
                    try {
                        if (string.equalsIgnoreCase("xs:date")) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            string2 = DatatypeConverter.printDate((Calendar)calendar);
                        } else if (string.equalsIgnoreCase("xs:dateTime")) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            string2 = DatatypeConverter.printDateTime((Calendar)calendar);
                        } else {
                            string2 = new SimpleDateFormat(string).format(new Date());
                        }
                        return string2;
                    }
                    catch (Exception exception) {
                        logger.warn((Object)exception, (Throwable)exception);
                        return "";
                    }
                }
            });
            if (string2 != null && string2.length() > 0) {
                block53: {
                    Serializable serializable;
                    int n5;
                    int n6;
                    Object object3;
                    String string4 = null;
                    object = null;
                    object2 = null;
                    try {
                        object3 = URLUtil.extractPathAndFileName(new URL(string2));
                        string4 = object3[0];
                        if (string4 != null && string4.endsWith("/")) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        if ((object = URLUtil.uncorrect((String)object3[1])) != null) {
                            object2 = object;
                            n6 = ((String)object).lastIndexOf(46);
                            if (n6 != -1) {
                                object = ((String)object).substring(0, n6);
                            }
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.warn((Object)malformedURLException, (Throwable)malformedURLException);
                    }
                    if (string4 == null || object == null) {
                        object3 = string2;
                        if (((String)object3).startsWith("/")) {
                            object3 = ((String)object3).substring(1);
                        }
                        if ((n6 = ((String)object3).lastIndexOf(47)) != -1) {
                            if (string4 == null) {
                                string4 = ((String)object3).substring(0, n6);
                            }
                            if (object == null) {
                                object2 = object = URLUtil.uncorrect(((String)object3).substring(n6 + 1));
                                n5 = ((String)object3).lastIndexOf(46);
                                if (n5 != -1 && n5 >= n6 + 1) {
                                    object = ((String)object3).substring(n6 + 1, n5);
                                }
                            }
                        }
                    }
                    object3 = null;
                    try {
                        serializable = null;
                        if (string4 != null) {
                            string4 = URLUtil.correct(string4, false);
                            serializable = new URL(string4);
                        }
                        if (serializable != null) {
                            if ("file".equals(((URL)serializable).getProtocol())) {
                                n5 = 0;
                                String string5 = ((URL)serializable).toString();
                                if (PlatformDetector.isWin32() && string5.endsWith(":")) {
                                    serializable = new URL(string5 + "/");
                                    n5 = 1;
                                }
                                object3 = URLUtil.getCanonicalFileFromFileUrl((URL)serializable).getAbsolutePath();
                                if (n5 != 0 && ((String)object3).endsWith("\\") && !string.endsWith(CURRENT_FILE_DIRECTORY)) {
                                    object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
                                }
                            } else {
                                File file2 = FileSystemUtil.getOxygenTempDirectory();
                                File file3 = new File(file2, FileSystemUtil.proposeValidFileName(string4));
                                object3 = file3.getAbsolutePath();
                            }
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)("Error when expand " + string4 + " - " + malformedURLException), (Throwable)malformedURLException);
                    }
                    string = EditorVariables.slashifyIfNeeded(string, CURRENT_FILE_DIRECTORY_URL);
                    string = bb.c(string, CURRENT_FILE_DIRECTORY_URL, string4);
                    if (object3 != null) {
                        string = bb.c(string, CURRENT_FILE_DIRECTORY, (String)object3);
                    }
                    string = bb.c(string, CURRENT_FILENAME, (String)object);
                    string = bb.c(string, CURRENT_FILENAME_WITH_EXTENSION, (String)object2);
                    string = bb.c(string, CURRENT_FILE_URL, string2);
                    try {
                        serializable = URLUtil.getCanonicalFileFromFileUrl(new URL(string2));
                        if (serializable != null) {
                            string = bb.c(string, CURRENT_FILE, ((File)serializable).getAbsolutePath());
                        }
                    }
                    catch (Throwable throwable) {
                        if (!logger.isDebugEnabled()) break block53;
                        logger.debug((Object)("Current file could not be calculated: " + throwable), throwable);
                    }
                }
                string = bb.c(string, CURRENT_FILE_URL_OLD, string2);
            }
            if (string.indexOf(PROJECT_DIRECTORY) != -1 && (file = EditorVariables.getProjectDirectory(string2)) != null) {
                object = file.toString();
                if (((String)object).endsWith("/")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                string = bb.c(string, PROJECT_DIRECTORY, (String)object);
            }
            if (string.indexOf(PROJECT_NAME) != -1 && (string3 = EditorVariables.getProjectName(string2)) != null) {
                string = bb.c(string, PROJECT_NAME, string3);
            }
            if (string.indexOf(PROJECT_DIRECTORY_URL) != -1 && (uRL7 = EditorVariables.getCurrentProjectURL(string2)) != null && (n2 = ((String)(object = uRL7.toString())).lastIndexOf("/")) != -1) {
                object = ((String)object).substring(0, n2);
                string = bb.c(string, PROJECT_DIRECTORY_URL, (String)object);
            }
            if (string.indexOf(ARCHIVE_NAME) != -1 && (uRL6 = EditorVariables.getCurrentArchiveURL(string2)) != null && (object = URLUtil.extractFileName(uRL6)) != null) {
                int n7 = ((String)(object = URLUtil.uncorrect((String)object))).lastIndexOf(".");
                if (n7 != -1) {
                    object = ((String)object).substring(0, n7);
                }
                string = bb.c(string, ARCHIVE_NAME, (String)object);
            }
            if (string.indexOf(ARCHIVE_NAME_WITH_EXTENSION) != -1 && (uRL5 = EditorVariables.getCurrentArchiveURL(string2)) != null && (object = URLUtil.extractFileName(uRL5)) != null) {
                object = URLUtil.uncorrect((String)object);
                string = bb.c(string, ARCHIVE_NAME_WITH_EXTENSION, (String)object);
            }
            if (string.indexOf(ARCHIVE_PATH) != -1 && (uRL4 = EditorVariables.getCurrentArchiveURL(string2)) != null && (object = URLUtil.getCanonicalFileFromFileUrl(uRL4)) != null) {
                string = bb.c(string, ARCHIVE_PATH, ((File)object).getAbsolutePath());
            }
            if (string.indexOf(ARCHIVE_PATH_URL) != -1 && (uRL3 = EditorVariables.getCurrentArchiveURL(string2)) != null) {
                string = bb.c(string, ARCHIVE_PATH_URL, uRL3.toString());
            }
            if (string.indexOf(ARCHIVE_FILE_DIRECTORY) != -1 && (uRL2 = EditorVariables.getCurrentArchiveURL(string2)) != null && (object = URLUtil.getCanonicalFileFromFileUrl(uRL2)) != null) {
                string = bb.c(string, ARCHIVE_FILE_DIRECTORY, ((File)object).getParentFile().getAbsolutePath());
            }
            if (string.indexOf(ARCHIVE_FILE_DIRECTORY_URL) != -1 && (uRL = EditorVariables.getCurrentArchiveURL(string2)) != null && (object = URLUtil.getCanonicalFileFromFileUrl(uRL)) != null) {
                try {
                    string = bb.c(string, ARCHIVE_FILE_DIRECTORY_URL, URLUtil.correct(((File)object).getParentFile()).toString());
                }
                catch (MalformedURLException malformedURLException) {
                    logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                }
            }
            try {
                if (string.indexOf(USER_HOME_URL) != -1) {
                    string = bb.c(string, USER_HOME_URL, new File(System.getProperty("user.home")).toURL().toString());
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)("Cannot convert user.home to URL." + malformedURLException), (Throwable)malformedURLException);
            }
            string = bb.c(string, USER_HOME_DIR, new File(System.getProperty("user.home")).toString());
            String string6 = System.getProperty("com.oxygenxml.editor.home.url");
            try {
                object = EditorVariables.getFrameworksUrl();
                string = EditorVariables.slashifyIfNeeded(string, FRAMEWORKS_DIRECTORY_URL);
                string = bb.c(string, FRAMEWORKS_DIRECTORY_URL, ((URL)object).toString());
                string = EditorVariables.slashifyIfNeeded(string, FRAMEWORKS_DIRECTORY);
                File file4 = EditorVariables.getFrameworksDir();
                if (file4 != null) {
                    string = bb.c(string, FRAMEWORKS_DIRECTORY, file4.toString());
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!logger.isDebugEnabled()) break block54;
                logger.debug((Object)("Cannot convert ${frameworks} or ${frameworksDir}. Home url is " + string6));
            }
        }
        if (string.indexOf(OXYGEN_INSTALL_DIR) != -1) {
            object = ub.c();
            string = bb.c(string, OXYGEN_INSTALL_DIR, (String)object);
        }
        if (string.indexOf(OXYGEN_HOME_URL) != -1) {
            string = bb.c(string, OXYGEN_HOME_URL, System.getProperty("com.oxygenxml.editor.home.url"));
        }
        if (string.indexOf(PATH_SEPARATOR) != -1) {
            string = bb.c(string, PATH_SEPARATOR, EditorVariables.getSystemPathSeparator());
        }
        if (string.indexOf(TIMESTAMP) != -1) {
            string = bb.c(string, TIMESTAMP, EditorVariables.getTimeStamp());
        }
        if (string.indexOf(UUID) != -1) {
            string = bb.b(string, UUID, new f(){

                @Override
                public String b() {
                    return java.util.UUID.randomUUID().toString();
                }
            });
        }
        if (string.indexOf(ID) != -1) {
            string = bb.b(string, ID, new f(){

                @Override
                public String b() {
                    return EditorVariables.generateUniqueID();
                }
            });
        }
        string = EditorVariables.replaceFunctions(string, STATIC_XPATH_FUNCTION_VARIABLE_PREFIX, FUNCTION_VARIABLE_SUFFIX, new _b(){

            @Override
            public String resolveFunctionWithParameter(String string) {
                try {
                    String string22;
                    if (staticXpathEvaluator != null && (string22 = staticXpathEvaluator.b(string, string2)) != null) {
                        return string22;
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)exception, (Throwable)exception);
                }
                return "";
            }
        });
        return string;
    }

    public static String replaceFunctions(String string, String string2, String string3, _b _b2) {
        if (string.contains(string2) && string.contains(string3)) {
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder(string);
            while (n2 >= 0) {
                if ((n2 = stringBuilder.indexOf(string2, n2)) == -1) continue;
                int n3 = stringBuilder.indexOf(string3, n2);
                if (n3 == -1) break;
                String string4 = stringBuilder.substring(n2 + string2.length(), n3);
                if (string4.length() > 0) {
                    String string5 = _b2.resolveFunctionWithParameter(string4);
                    if (string5 != null) {
                        int n4 = n3 + string3.length() - n2;
                        String string6 = String.valueOf(string5);
                        stringBuilder.replace(n2, n2 + n4, string6);
                        n2 += string6.length();
                        continue;
                    }
                    n2 = n3 + string3.length();
                    continue;
                }
                n2 = n3 + string3.length();
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private static String getProjectName(String string) {
        int n2;
        String string2 = null;
        URL uRL = EditorVariables.getCurrentProjectURL(string);
        if (PlatformDetector.isEclipse()) {
            File file = URLUtil.getCanonicalFileFromFileUrl(uRL);
            if (file != null) {
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                string2 = file.getName();
            }
        } else if (uRL != null && (string2 = URLUtil.extractFileName(URLUtil.uncorrect(uRL.toString()))) != null && (n2 = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    private static File getProjectDirectory(String string) {
        block4: {
            URL uRL = EditorVariables.getCurrentProjectURL(string);
            if (uRL != null) {
                try {
                    File file = URLUtil.getCanonicalFileFromFileUrl(uRL);
                    if (file != null && !file.isDirectory()) {
                        file = file.getParentFile();
                    }
                    return file;
                }
                catch (Throwable throwable) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("Project dir could not be calculated: " + throwable), throwable);
                }
            }
        }
        return null;
    }

    public static String makeURLRelative2Frameworks(String string) {
        if (string != null) {
            try {
                String string2 = EditorVariables.getFrameworksUrl().toString();
                StringBuilder stringBuilder = new StringBuilder();
                if (string.startsWith(string2) && (string.length() == string2.length() || string2.endsWith("/") || string.charAt(string2.length()) == '/' || string.charAt(string2.length()) == '\\')) {
                    stringBuilder.append(FRAMEWORKS_DIRECTORY_URL);
                    if (string2.endsWith("/")) {
                        stringBuilder.append("/");
                    }
                    stringBuilder.append(string.substring(string2.length()));
                    string = stringBuilder.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String makeFileRelative2Frameworks(String string) {
        if (string != null) {
            try {
                String string2 = EditorVariables.getFrameworksDir().getCanonicalPath();
                String string3 = new File(string).getCanonicalPath();
                StringBuilder stringBuilder = new StringBuilder();
                if (string3 != null && string3.startsWith(string2) && (string3.length() == string2.length() || string3.charAt(string2.length()) == '/' || string3.charAt(string2.length()) == '\\')) {
                    stringBuilder.append(FRAMEWORKS_DIRECTORY);
                    stringBuilder.append(string.substring(string2.length()));
                    string = stringBuilder.toString();
                    string = ro.sync.util.g.g(string, "\\", "/");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void setFrameworksURLForTest(URL uRL) {
        frameworksURLForTests = uRL;
    }

    public static URL getFrameworksUrl() throws MalformedURLException {
        if (frameworksURLForTests != null) {
            return frameworksURLForTests;
        }
        return EditorVariables.getCurrentFrameworksURL();
    }

    public static void resetFrameworksDir() {
        frameworksDirInitialized.set(false);
        System.clearProperty("com.oxygenxml.editor.frameworks.url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getCurrentFrameworksURL() throws MalformedURLException {
        URL uRL = null;
        if (!Boolean.TRUE.equals(frameworksDirInitializing.get())) {
            String string;
            if (!Boolean.TRUE.equals(frameworksDirInitialized.get())) {
                if (System.getenv("com.oxygenxml.editor.frameworks.url") != null) {
                    System.setProperty("com.oxygenxml.editor.frameworks.url", System.getenv("com.oxygenxml.editor.frameworks.url"));
                }
                if (System.getProperty("com.oxygenxml.editor.frameworks.url") == null && Options.getInstance().getBooleanProperty("use.custom.frameworks.directory.url")) {
                    string = Options.getInstance().getStringProperty("frameworks.directory.url.with.editor.variables");
                    if (string != null) {
                        try {
                            frameworksDirInitializing.set(true);
                            string = EditorVariables.expandEditorVariables(string, null);
                        }
                        finally {
                            frameworksDirInitializing.set(false);
                        }
                        try {
                            uRL = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                            try {
                                uRL = URLUtil.correct(new File(string));
                            }
                            catch (MalformedURLException malformedURLException2) {
                                logger.error((Object)malformedURLException2, (Throwable)malformedURLException2);
                            }
                        }
                    }
                    if (uRL == null) {
                        uRL = Options.getInstance().getURLProperty("frameworks.directory.url");
                    }
                }
                if (uRL != null) {
                    System.setProperty("com.oxygenxml.editor.frameworks.url", uRL.toString());
                }
                frameworksDirInitialized.set(true);
            }
            if ((string = System.getProperty("com.oxygenxml.editor.frameworks.url")) != null) {
                try {
                    uRL = new URL(URLUtil.correct(string, false));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (uRL == null) {
            uRL = EditorVariables.getDefaultFrameworkURL();
        }
        return uRL;
    }

    public static URL getDefaultFrameworkURL() throws MalformedURLException {
        if (DEFAULT_FRAMEWORK_URL == null) {
            String string = System.getProperty("com.oxygenxml.editor.home.url");
            DEFAULT_FRAMEWORK_URL = new URL(new URL(URLUtil.correct(string, false)), "frameworks");
        }
        return DEFAULT_FRAMEWORK_URL;
    }

    public static void resetDefaultFrameworkURL() {
        DEFAULT_FRAMEWORK_URL = null;
    }

    public static void setFrameworksDirForTest(File file) {
        frameworksDirForTests = file;
    }

    public static File getFrameworksDir() throws MalformedURLException {
        if (frameworksDirForTests != null) {
            return frameworksDirForTests;
        }
        return URLUtil.getCanonicalFileFromFileUrl(EditorVariables.getCurrentFrameworksURL());
    }

    public static File getBaseUserFrameworksDir() {
        return new File(cc.e().c(), "frameworks");
    }

    public static File[] getUserFrameworksDirs() {
        File file = EditorVariables.getBaseUserFrameworksDir();
        return file.listFiles(new mb(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && super.accept(file);
            }
        });
    }

    public static File[] getAllFrameworksDirs() {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            File file;
            File[] fileArray;
            File[] fileArray2 = EditorVariables.getUserFrameworksDirs();
            if (fileArray2 != null) {
                arrayList.addAll(Arrays.asList(fileArray2));
            }
            if ((fileArray = EditorVariables.getAdditionalFrameworksDirs()) != null) {
                arrayList.addAll(Arrays.asList(fileArray));
            }
            if ((file = EditorVariables.getFrameworksDir()) != null) {
                arrayList.add(file);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return arrayList.toArray(new File[0]);
    }

    public static File[] getAdditionalFrameworksDirs() {
        ArrayList<File> arrayList = null;
        String[] stringArray = Options.getInstance().getStringArrayProperty("additional.frameworks.directories");
        if (stringArray != null) {
            arrayList = new ArrayList<File>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = EditorVariables.expandEditorVariables(stringArray[i2], null);
                arrayList.add(new File(string));
            }
        }
        return arrayList != null ? arrayList.toArray(new File[0]) : null;
    }

    public static URL getCurrentProjectURL(String string) {
        URL uRL = null;
        if (projectURLProvider != null) {
            uRL = projectURLProvider.uod(string);
        } else if (!PlatformDetector.isEclipse()) {
            uRL = Options.getInstance().getURLProperty("last.project");
        }
        if (uRL == null || "file:newProject.xpr".equals(uRL.toString())) {
            try {
                return new File(System.getProperty("user.dir", ".")).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static URL getCurrentArchiveURL(String string) {
        URL uRL;
        block10: {
            uRL = null;
            if (string != null) {
                if (string.startsWith("zip:")) {
                    int n2 = string.indexOf("!/");
                    try {
                        if (n2 != -1) {
                            uRL = new URL(string.substring("zip:".length(), n2));
                            break block10;
                        }
                        uRL = new URL(string.substring("zip:".length(), string.length()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                    }
                } else if (archiveExtensionsRecognizer != null && archiveExtensionsRecognizer.b(string)) {
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                    }
                }
            }
        }
        if (uRL == null && archiveURLProvider != null) {
            uRL = archiveURLProvider.b();
        }
        return uRL;
    }

    private static String slashifyIfNeeded(String string, String string2) {
        if (string.endsWith(string2)) {
            string = string + "/";
        }
        return string;
    }

    public static void setProjectURLProvider(s s2) {
        projectURLProvider = s2;
    }

    public static void setArchiveURLProvider(m m2) {
        archiveURLProvider = m2;
    }

    public static void setFrameworkLocationResolver(g g2) {
        frameworkLocationResolver = g2;
    }

    public static void setArchiveExtensionsRecognizer(xb xb2) {
        archiveExtensionsRecognizer = xb2;
    }

    public static String getSystemPathSeparator() {
        return File.pathSeparator;
    }

    static String getTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return simpleDateFormat.format(Calendar.getInstance().getTime());
    }

    public static synchronized String generateUniqueID() {
        String string = "";
        long l2 = System.currentTimeMillis() - 1286892000000L;
        if (l2 <= lastUsedTimestamp) {
            l2 = lastUsedTimestamp + 1L;
        }
        int n2 = 0;
        lastUsedTimestamp = l2;
        while (l2 != 0L) {
            int n3 = (int)(l2 % 26L);
            char c2 = (char)(97 + n3);
            string = string.isEmpty() ? string + c2 : string + EditorVariables.convertVowelToInt(c2);
            if ((l2 /= 26L) <= 0L || (string.length() - n2) % 3 != 0) continue;
            string = string + "_";
            ++n2;
        }
        return string;
    }

    private static char convertVowelToInt(char n2) {
        int n3 = n2;
        switch (n2) {
            case 97: {
                n3 = 49;
                break;
            }
            case 101: {
                n3 = 50;
                break;
            }
            case 105: {
                n3 = 51;
                break;
            }
            case 111: {
                n3 = 52;
                break;
            }
            case 117: {
                n3 = 53;
            }
        }
        return (char)n3;
    }

    public static String expandFrameworksVariables(String string, String string2, _c _c2) {
        return EditorVariables.expandFrameworksVariables(string, string2, null, _c2);
    }

    public static String expandFrameworksVariables(String string, String string2, String string3, _c _c2) {
        block6: {
            Serializable serializable;
            Object object;
            try {
                if (string != null && string3 != null) {
                    object = EditorVariables.getCanonicalDir(string3);
                    serializable = URLUtil.correct((File)object);
                    string = EditorVariables.expandBaseFrameworkVars(string, string2, _c2, (File)object, (URL)serializable);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException, (Throwable)malformedURLException);
            }
            if (string2 != null) {
                object = System.getProperty("com.oxygenxml.editor.home.url");
                try {
                    serializable = EditorVariables.getCanonicalDir(string2);
                    URL uRL = URLUtil.correct((File)serializable);
                    File file = ((File)serializable).getParentFile();
                    URL uRL2 = URLUtil.correct(file);
                    return EditorVariables.expandFrameworksVariables(string, _c2, file, uRL2, (File)serializable, uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)("Cannot convert ${frameworks} or ${frameworksDir}. Home url is " + (String)object));
                }
            }
        }
        return string;
    }

    private static String expandBaseFrameworkVars(String string, String string2, _c _c2, File file, URL uRL) throws MalformedURLException {
        String string3 = uRL.toExternalForm();
        if (string3.endsWith("/")) {
            uRL = new URL(string3.substring(0, string3.length() - 1));
        }
        if (file != null && (_c2 == _c.e || _c2 == _c.d)) {
            String string4;
            File file2;
            String string5;
            _c _c3 = _c2;
            if (string2 == null) {
                _c3 = _c.e;
            } else if (_c2 == _c.d && !Equaler.verifyEquals(string5 = (file2 = EditorVariables.getCanonicalDir(string2)) != null ? file2.getParent() : null, string4 = file.getParent())) {
                _c3 = _c.e;
            }
            string = EditorVariables.expandFrameworkOnly(string, _c3, file.toString().replace('\\', '/'), uRL, true);
        }
        return string;
    }

    private static File getCanonicalDir(String string) {
        File file = null;
        if (string != null) {
            try {
                URL uRL = new URL(string);
                file = URLUtil.getCanonicalFileFromFileUrl(uRL).getParentFile();
            }
            catch (MalformedURLException malformedURLException) {
                file = new File(string).getParentFile();
            }
        }
        return file;
    }

    public static String expandFrameworksVariables(String string, _c _c2, File file, URL uRL, File file2, URL uRL2) {
        block10: {
            if (uRL2 != null && string != null) {
                String string2 = System.getProperty("com.oxygenxml.editor.home.url");
                try {
                    String string3 = uRL2.toExternalForm();
                    if (string3.endsWith("/")) {
                        uRL2 = new URL(string3.substring(0, string3.length() - 1));
                    }
                    if ((string3 = uRL.toExternalForm()).endsWith("/")) {
                        uRL = new URL(string3.substring(0, string3.length() - 1));
                    }
                    String string4 = file2.toString().replace('\\', '/');
                    if (_c2 != _c.g) {
                        string = EditorVariables.expandFrameworkOnly(string, _c2, string4, uRL2, false);
                    }
                    if (_c2 != _c.d) {
                        String string5 = string = EditorVariables.slashifyIfNeeded(string, FRAMEWORKS_DIRECTORY_URL);
                        String string6 = string = bb.c(string, FRAMEWORKS_DIRECTORY_URL, uRL.toString());
                        if (_c2 != _c.e && (string = bb.c(string, uRL2.toExternalForm() + "/", "${framework}/")).equals(string6)) {
                            string = string6.equals(uRL2.toExternalForm()) ? "${framework}/" : string5;
                        }
                        string = EditorVariables.slashifyIfNeeded(string, FRAMEWORKS_DIRECTORY);
                        if (file != null) {
                            String string7 = file.toString().replace('\\', '/');
                            string5 = string;
                            string6 = string = bb.c(string, FRAMEWORKS_DIRECTORY, string7);
                            if (_c2 != _c.e && (string = bb.c(string, string4 + "/", "${frameworkDir}/")).equals(string6)) {
                                string = string6.equals(string4) ? "${frameworkDir}/" : string5;
                            }
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug((Object)("Cannot convert ${frameworks} or ${frameworksDir}. Home url is " + string2));
                }
            }
        }
        return string;
    }

    private static String expandFrameworkOnly(String string, _c _c2, String string2, URL uRL, boolean bl) {
        String string3 = uRL.toString();
        if (_c2 == _c.d) {
            string3 = EditorVariables.makeURLRelative2Frameworks(string3);
        }
        String string4 = FRAMEWORK_URL;
        if (bl) {
            string4 = BASE_FRAMEWORK_URL;
        }
        string = EditorVariables.slashifyIfNeeded(string, string4);
        string = bb.c(string, string4, string3);
        string4 = FRAMEWORK_DIRECTORY;
        if (bl) {
            string4 = BASE_FRAMEWORK_DIRECTORY;
        }
        string = EditorVariables.slashifyIfNeeded(string, string4);
        String string5 = string2;
        if (_c2 == _c.d) {
            string5 = EditorVariables.makeFileRelative2Frameworks(string5);
        }
        string = bb.c(string, string4, string5);
        return string;
    }

    public static String makeURLRelative2Framework(String string, String string2) {
        if (string != null && string2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
            if (string.startsWith(string3)) {
                stringBuilder.append(FRAMEWORK_URL);
                stringBuilder.append("/");
                stringBuilder.append(string.substring(string3.length()));
                string = stringBuilder.toString();
            } else {
                try {
                    URL uRL = new URL(string2);
                    File file = URLUtil.getAbsoluteFileFromFileUrl(uRL).getParentFile();
                    File file2 = file.getParentFile().getCanonicalFile();
                    String string4 = URLUtil.correct(file2).toExternalForm();
                    if (string.startsWith(string4) && (string.length() == string4.length() || string4.endsWith("/") || string.charAt(string4.length()) == '\\' || string.charAt(string4.length()) == '/')) {
                        stringBuilder.append(FRAMEWORKS_DIRECTORY_URL);
                        if (string4.endsWith("/")) {
                            stringBuilder.append("/");
                        }
                        stringBuilder.append(string.substring(string4.length()));
                        string = stringBuilder.toString();
                    }
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, (Throwable)iOException);
                }
            }
        }
        return string;
    }

    public static String makeURLRelative2Project(String string, String string2) {
        if (string != null && string2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
            if (string.startsWith(string3)) {
                stringBuilder.append(PROJECT_DIRECTORY_URL);
                stringBuilder.append("/");
                stringBuilder.append(string.substring(string3.length()));
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    public static String makeFileRelative2Framework(String string, String string2) {
        if (string != null && string2 != null) {
            try {
                String string3 = new File(string2).getParentFile().getCanonicalPath();
                String string4 = new File(string).getCanonicalPath();
                StringBuilder stringBuilder = new StringBuilder();
                if (string4 != null && string4.startsWith(string3) && (string4.length() == string3.length() || string4.charAt(string3.length()) == '/' || string4.charAt(string3.length()) == '\\')) {
                    stringBuilder.append(FRAMEWORK_DIRECTORY);
                    stringBuilder.append(string.substring(string3.length()));
                    string = stringBuilder.toString();
                    string = ro.sync.util.g.g(string, "\\", "/");
                } else {
                    String string5 = new File(string3).getParentFile().getCanonicalPath();
                    if (string4 != null && string4.startsWith(string5) && (string4.length() == string5.length() || string4.charAt(string5.length()) == '/' || string4.charAt(string5.length()) == '\\')) {
                        stringBuilder.append(FRAMEWORKS_DIRECTORY);
                        stringBuilder.append(string.substring(string5.length()));
                        string = stringBuilder.toString();
                        string = ro.sync.util.g.g(string, "\\", "/");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String makeFileRelative2Project(String string, String string2) {
        if (string != null && string2 != null) {
            try {
                String string3 = new File(string2).getParentFile().getCanonicalPath();
                String string4 = new File(string).getCanonicalPath();
                StringBuilder stringBuilder = new StringBuilder();
                if (string4 != null && string4.startsWith(string3) && (string4.length() == string3.length() || string4.charAt(string3.length()) == '/' || string4.charAt(string3.length()) == '\\')) {
                    stringBuilder.append(PROJECT_DIRECTORY);
                    stringBuilder.append(string.substring(string3.length()));
                    string = stringBuilder.toString();
                    string = ro.sync.util.g.g(string, "\\", "/");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void setXpathEvaluator(e e2) {
        staticXpathEvaluator = e2;
    }

    public static void addCustomEditorVariablesResolver(EditorVariablesResolver editorVariablesResolver) {
        customResolvers.add(editorVariablesResolver);
    }

    public static void removeCustomEditorVariablesResolver(EditorVariablesResolver editorVariablesResolver) {
        customResolvers.remove(editorVariablesResolver);
    }

    static {
        customResolvers = new ArrayList<EditorVariablesResolver>();
        frameworksURLForTests = null;
        frameworksDirInitializing = new ThreadLocal();
        DEFAULT_FRAMEWORK_URL = null;
        frameworksDirForTests = null;
        lastUsedTimestamp = 0L;
    }

    public static interface _b {
        public String resolveFunctionWithParameter(String var1);
    }

    public static enum _c {
        e,
        d,
        g,
        f,
        c;

    }
}

