/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SortedList<E>
extends ArrayList<E>
implements Serializable {
    public static final long serialVersionUID = 2751121163240L;
    private Comparator<? super E> comparator;

    public SortedList(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public SortedList(Comparator<? super E> comparator, int n2) {
        super(n2);
        this.comparator = comparator;
    }

    @Override
    @Deprecated
    public void add(int n2, E e2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean add(E e2) {
        return this.addWithSort(e2) != -1;
    }

    public int addWithSort(E e2) {
        int n2 = -1;
        if (this.comparator != null) {
            int n3 = Collections.binarySearch(this, e2, this.comparator);
            if (n3 < 0) {
                n2 = -n3 - 1;
                super.add(n2, e2);
            } else {
                super.add(n3, e2);
                n2 = n3;
            }
        } else {
            super.add(e2);
            n2 = this.size();
        }
        return n2;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean addAll(int n2, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Deprecated
    public E set(int n2, E e2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int indexOf(Object object) {
        if (this.comparator != null) {
            return Collections.binarySearch(this, object, this.comparator);
        }
        return super.indexOf(object);
    }

    @Override
    public boolean remove(Object object) {
        if (this.comparator != null) {
            int n2 = Collections.binarySearch(this, object, this.comparator);
            if (n2 >= 0) {
                return super.remove(n2) != null;
            }
            return false;
        }
        return super.remove(object);
    }
}

