/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.udc.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.bb;
import ro.sync.options.j;
import ro.sync.udc.data.ProductData;
import ro.sync.udc.data.ResourceData;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class UsageData
implements PersistentObject {
    private ProductData productData;
    private String userID;
    private String country;
    public static DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private String start;
    private String end;
    private long sessionMillis;
    private final String timezone;
    private bb<ResourceData> resourceData = new bb();

    public UsageData() {
        this.timezone = System.getProperty("user.timezone");
    }

    public String toString() {
        return "Usage date for " + this.userID + " country:" + this.country + "\n" + this.productData + "\n" + this.resourceData + "\n" + "\nSession from:" + this.start + " to:" + this.end + " time zone:" + this.timezone;
    }

    public List<ResourceData> getResourceDataList() {
        return this.resourceData;
    }

    @Override
    public void checkValid() throws j {
        if (this.sessionMillis < 0L) {
            this.sessionMillis = 0L;
        }
        if (this.resourceData == null) {
            throw new j("Resource DATA must not be null");
        }
        if (this.userID == null) {
            throw new j("User ID must not be null");
        }
        try {
            FORMAT.parse(this.start);
        }
        catch (Exception exception) {
            throw new j("Session start not valid " + this.start);
        }
        try {
            FORMAT.parse(this.end);
        }
        catch (Exception exception) {
            throw new j("Session end not valid " + this.end);
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            UsageData usageData = (UsageData)super.clone();
            if (this.resourceData != null) {
                usageData.resourceData = (bb)this.resourceData.clone();
            }
            if (this.productData != null) {
                usageData.productData = (ProductData)this.productData.clone();
            }
            return usageData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void setProductData(ProductData productData) {
        this.productData = productData;
    }

    public void setLocale(Locale locale) {
        this.country = locale.getCountry();
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public long getSessionUpTime() {
        return this.sessionMillis;
    }

    public void setStart(Date date) {
        this.start = FORMAT.format(date);
    }

    public void setEnd(Date date) {
        this.end = FORMAT.format(date);
    }

    public String getUserID() {
        return this.userID;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public ProductData getProductData() {
        return this.productData;
    }

    public void increaseSessionMillis(long l2) {
        this.sessionMillis += l2;
    }

    public long getUsageDataRecordingTime() {
        long l2 = 0L;
        try {
            Date date = FORMAT.parse(this.start);
            Date date2 = FORMAT.parse(this.end);
            return date2.getTime() - date.getTime();
        }
        catch (ParseException parseException) {
            return l2;
        }
    }

    public Date getStartDate() {
        Date date = null;
        try {
            date = FORMAT.parse(this.start);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public Date getEndDate() {
        Date date = null;
        try {
            date = FORMAT.parse(this.end);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public String getCountry() {
        return this.country;
    }
}

