/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.wc;

import java.io.File;
import java.io.IOException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.j;
import ro.sync.util.PlatformDetector;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class WorkingCopyItem
implements PersistentObject {
    private static final boolean IS_CASE_INSENSITIVE_PLATFORM = PlatformDetector.isWin32();
    private String name;
    private String path;
    private boolean ignoreExternals;

    public WorkingCopyItem() {
    }

    public WorkingCopyItem(String string) {
        try {
            this.path = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.path = string;
        }
        this.name = URLUtil.extractFileName(this.path.replace(File.separatorChar, '/'));
    }

    public WorkingCopyItem(String string, String string2) {
        this.name = string;
        try {
            this.path = new File(string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.path = string2;
        }
    }

    public WorkingCopyItem(String string, String string2, boolean bl) {
        this(string, string2);
        this.ignoreExternals = bl;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternals;
    }

    public void setIgnoreExternals(boolean bl) {
        this.ignoreExternals = bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof WorkingCopyItem) {
            WorkingCopyItem workingCopyItem = (WorkingCopyItem)object;
            bl = IS_CASE_INSENSITIVE_PLATFORM ? this.path.equalsIgnoreCase(workingCopyItem.path) : this.path.equals(workingCopyItem.path);
        }
        return bl;
    }

    public int hashCode() {
        return (IS_CASE_INSENSITIVE_PLATFORM ? this.path.toLowerCase() : this.path).hashCode();
    }

    @Override
    public void checkValid() throws j {
        if (this.name == null || this.name.length() == 0) {
            throw new j("Invalid WC_NAME: [" + this.name + "]");
        }
        if (this.path == null || this.path.length() == 0) {
            throw new j("Invalid WC_PATH: [" + this.path + "]");
        }
    }

    public String toString() {
        return "Name: [" + this.name + "] Path: [" + this.path + "]";
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }
}

