/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.auth;

import java.io.File;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.j;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SVNAuthenticationInfo
implements PersistentObject {
    private String password;
    private String user;
    private String realm;
    private String kind;
    private String certificate;
    private String passphrase;
    private String privateKey;
    private String sshSVNUser;

    public SVNAuthenticationInfo() {
    }

    public SVNAuthenticationInfo(String string, String string2, String string3) {
        this.realm = string;
        this.user = string2;
        this.kind = string3;
    }

    public SVNAuthenticationInfo(String string, String string2, String string3, String string4) {
        this.realm = string;
        this.password = string2;
        this.user = string3;
        this.kind = string4;
    }

    public SVNAuthenticationInfo(String string, File file, String string2, String string3) {
        this.realm = string;
        this.certificate = file.getAbsolutePath();
        this.password = string2;
        this.kind = string3;
    }

    public SVNAuthenticationInfo(String string, String string2, File file, String string3, String string4) {
        this.realm = string;
        this.user = string2;
        this.privateKey = file.getAbsolutePath();
        this.passphrase = string3;
        this.kind = string4;
    }

    @Override
    public void checkValid() throws j {
        if (this.realm == null) {
            throw new j("null realm for SVNAuthenticationInfo");
        }
        if (this.kind == null) {
            throw new j("null kind for SVNAuthenticationInfo");
        }
        if ("svn.simple".equals(this.kind)) {
            if (this.user == null) {
                throw new j("null user for PASSWORD SVNAuthenticationInfo");
            }
            if (this.password == null) {
                throw new j("null password for PASSWORD SVNAuthenticationInfo");
            }
        } else if ("svn.username".equals(this.kind)) {
            if (this.user == null) {
                throw new j("null user for USERNAME SVNAuthenticationInfo");
            }
        } else if ("svn.ssl.client-passphrase".equals(this.kind)) {
            if (this.password == null) {
                throw new j("null password for SSL SVNAuthenticationInfo");
            }
            if (this.certificate == null) {
                throw new j("null certificate for SSL SVNAuthenticationInfo");
            }
        } else if ("svn.ssh".equals(this.kind)) {
            if (this.privateKey != null) {
                if (this.passphrase == null) {
                    throw new j("null passphrase for SSH SVNAuthenticationInfo");
                }
                if (this.user == null) {
                    throw new j("null user for SSH SVNAuthenticationInfo");
                }
            } else {
                if (this.user == null) {
                    throw new j("null user for SSH SVNAuthenticationInfo");
                }
                if (this.password == null) {
                    throw new j("null password for SSH SVNAuthenticationInfo");
                }
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isInRealm(String string, String string2) {
        return Equaler.verifyEquals(this.kind, string2) && Equaler.verifyEquals(this.realm, string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Realm: ").append(this.realm);
        stringBuffer.append(" Kind: ").append(this.kind);
        stringBuffer.append(" User: ").append(this.user);
        return stringBuffer.toString();
    }

    public String getUser() {
        return this.user;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SVNAuthenticationInfo) {
            SVNAuthenticationInfo sVNAuthenticationInfo = (SVNAuthenticationInfo)object;
            bl = Equaler.verifyEquals(this.kind, sVNAuthenticationInfo.kind) && Equaler.verifyEquals(this.realm, sVNAuthenticationInfo.realm);
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.kind != null) {
            n2 += this.kind.hashCode();
        }
        if (this.realm != null) {
            n2 += this.realm.hashCode();
        }
        return n2;
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void setSVNUserName(String string) {
        this.sshSVNUser = string;
    }

    public String getSSHSVNUserName() {
        return this.sshSVNUser;
    }
}

