/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.outline;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.j;
import ro.sync.outline.PathItem;
import ro.sync.outline.t;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class TokenIndexPath
implements PersistentObject {
    public static final String SEPARATOR = ",";
    private PathItem[] pathItems = new PathItem[0];

    public TokenIndexPath() {
    }

    public TokenIndexPath(String string) throws t {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                PathItem pathItem = new PathItem(string2);
                this.addPathItem(pathItem);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new t(noSuchElementException.getMessage());
        }
    }

    public void addPathItem(PathItem pathItem) {
        PathItem[] pathItemArray = new PathItem[this.pathItems.length + 1];
        System.arraycopy(this.pathItems, 0, pathItemArray, 0, this.pathItems.length);
        pathItemArray[this.pathItems.length] = pathItem;
        this.pathItems = pathItemArray;
    }

    public void addPathItemFirst(PathItem pathItem) {
        PathItem[] pathItemArray = new PathItem[this.pathItems.length + 1];
        System.arraycopy(this.pathItems, 0, pathItemArray, 1, this.pathItems.length);
        pathItemArray[0] = pathItem;
        this.pathItems = pathItemArray;
    }

    public String serialize() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.pathItems.length; ++i2) {
            PathItem pathItem = this.pathItems[i2];
            stringBuffer.append(pathItem.serialize());
            if (i2 >= this.pathItems.length - 1) continue;
            stringBuffer.append(SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public String getXPathRepresentation() {
        return this.getXPathRepresentation(true);
    }

    public String getXPathRepresentation(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.pathItems.length; ++i2) {
            stringBuilder.append("/");
            PathItem pathItem = this.pathItems[i2];
            stringBuilder.append(pathItem.toXPathString(bl));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof TokenIndexPath) {
            return Equaler.verifyArrayEquals(this.pathItems, ((TokenIndexPath)object).pathItems);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.pathItems != null && this.pathItems.length > 0) {
            for (int i2 = 0; i2 < this.pathItems.length; ++i2) {
                n2 += this.pathItems[i2].hashCode();
            }
        }
        return n2;
    }

    public String toString() {
        if (this.pathItems != null) {
            return Arrays.asList(this.pathItems).toString();
        }
        return String.valueOf(this.pathItems);
    }

    @Override
    public void checkValid() throws j {
        if (this.pathItems == null) {
            throw new j("The pathItems is null.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public PathItem[] getPathItems() {
        return this.pathItems;
    }

    @Override
    public Object clone() {
        TokenIndexPath tokenIndexPath = null;
        try {
            tokenIndexPath = (TokenIndexPath)super.clone();
            if (this.pathItems != null) {
                tokenIndexPath.pathItems = (PathItem[])this.pathItems.clone();
                for (int i2 = 0; i2 < this.pathItems.length; ++i2) {
                    if (this.pathItems[i2] == null) continue;
                    tokenIndexPath.pathItems[i2] = (PathItem)this.pathItems[i2].clone();
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return tokenIndexPath;
    }
}

