/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.net.protocol.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.options.Options;
import ro.sync.io.m;
import ro.sync.io.y;
import ro.sync.net.protocol.ftp.b;
import ro.sync.net.protocol.ftp.d;
import ro.sync.net.protocol.j;
import ro.sync.net.protocol.sftp.e;
import ro.sync.util.URLUtil;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public class SFTPURLConnection
extends URLConnection
implements b,
y,
j {
    protected static Logger logger = Logger.getLogger((String)SFTPURLConnection.class.getName());
    public static String CONTENT_LENGTH = "content-length";
    public static String LAST_MODIFIED = "last-modified";
    private long d;
    private long b;
    private ChannelSftp c;

    public SFTPURLConnection(URL uRL) {
        super(uRL);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created SFTP connection: " + URLUtil.clearUserInfo(uRL)));
        }
    }

    @Override
    public void connect() throws IOException {
        block15: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"On connect()");
            }
            try {
                block14: {
                    Session session = SFTPURLConnection.createSession(this.url);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Connecting...");
                    }
                    session.connect();
                    this.c = (ChannelSftp)session.openChannel("sftp");
                    this.c.connect();
                    try {
                        this.c.setFilenameEncoding(Options.getInstance().getStringProperty("ftp.control-connection-encoding"));
                    }
                    catch (SftpException sftpException) {
                        if (!logger.isDebugEnabled()) break block14;
                        logger.debug((Object)"Cannot set filename encoding to channel ", (Throwable)sftpException);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Connected.");
                }
                this.connected = this.c.isConnected();
                try {
                    Vector vector = this.c.ls(this.url.getPath());
                    if (vector.size() == 1) {
                        ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)vector.get(0);
                        this.d = lsEntry.getAttrs().getMTime();
                        this.b = lsEntry.getAttrs().getSize();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("The modified time is: " + this.d));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("The content length is: " + this.b));
                        }
                        break block15;
                    }
                    logger.debug((Object)"Probably the file does not exist.");
                }
                catch (SftpException sftpException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)sftpException, (Throwable)sftpException);
                    }
                }
            }
            catch (JSchException jSchException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Got Exception: " + (Object)((Object)jSchException)), (Throwable)jSchException);
                }
                throw new IOException(jSchException.getMessage(), jSchException);
            }
        }
    }

    public static Session createSession(URL uRL) throws JSchException {
        String string;
        String string2 = null;
        String string3 = null;
        JSch jSch = new JSch();
        e e2 = null;
        String string4 = uRL.getUserInfo();
        if (string4 != null && !"".equals(string4)) {
            string3 = URLUtil.uncorrect(URLUtil.extractPassword(string4));
            string2 = URLUtil.uncorrect(URLUtil.extractUser(string4));
            if (string3 != null && string3.length() > 0) {
                e2 = new e(string3);
            } else {
                string = Options.getInstance().getStringProperty("sftp.key.file");
                if (!"".equals(string)) {
                    jSch.addIdentity(string);
                }
                e2 = new e(null);
            }
        }
        string = uRL.getHost();
        int n2 = uRL.getPort() <= 0 ? 22 : uRL.getPort();
        Session session = jSch.getSession(string2, string, n2);
        session.setUserInfo(e2);
        String string5 = Options.getInstance().getStringProperty("sftp.known-hosts-file");
        jSch.setKnownHosts(EditorVariables.expandEditorVariables(string5, null));
        session.setConfig("HashKnownHosts", "yes");
        return session;
    }

    @Override
    public String getHeaderField(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getHeaderField for " + string));
        }
        if (CONTENT_LENGTH.equals(string)) {
            return String.valueOf(this.b);
        }
        if (LAST_MODIFIED.equals(string)) {
            return "" + this.d;
        }
        return null;
    }

    @Override
    public String getHeaderField(int n2) {
        switch (n2) {
            case 0: {
                return "0";
            }
            case 1: {
                return "" + this.d;
            }
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        switch (n2) {
            case 0: {
                return CONTENT_LENGTH;
            }
            case 1: {
                return LAST_MODIFIED;
            }
        }
        return null;
    }

    @Override
    public long getLastModified() {
        return this.d;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String string;
        if (!this.connected) {
            this.connect();
        }
        if ("".equals(string = this.url.getPath())) {
            string = "/";
        }
        String string2 = URLUtil.uncorrect(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Input stream for:" + string2));
        }
        d d2 = null;
        try {
            d2 = new d(this.c.get(string2), this);
        }
        catch (SftpException sftpException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sftpException, (Throwable)sftpException);
            }
            throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException), sftpException);
        }
        return d2;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        String string;
        if (!this.connected) {
            this.connect();
        }
        if ("".equals(string = this.url.getPath())) {
            string = "/";
        }
        String string2 = URLUtil.uncorrect(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Output stream for:" + string2));
        }
        m m2 = null;
        try {
            m2 = new m(this.c.put(string2), this);
        }
        catch (SftpException sftpException) {
            if (logger.isDebugEnabled()) {
                // empty if block
            }
            logger.info((Object)sftpException, (Throwable)sftpException);
            throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException), sftpException);
        }
        return m2;
    }

    @Override
    public void onInputStreamClose() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Call quit on the ftp from input stream close notification");
        }
        this.disconnect();
    }

    public void disconnect() {
        block4: {
            if (this.c != null) {
                this.c.quit();
                try {
                    Session session = this.c.getSession();
                    if (session != null) {
                        session.disconnect();
                    }
                }
                catch (JSchException jSchException) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error during disconnect ", (Throwable)jSchException);
                }
            }
        }
    }

    @Override
    public void onOutputStreamClose() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Call quit on the ftp from output stream close notification");
        }
        this.disconnect();
    }

    public ChannelSftp getChannel() {
        return this.c;
    }

    public static String getErrorMessagesFromId(SftpException sftpException) {
        String string = "";
        switch (sftpException.id) {
            case 2: {
                string = "File not found";
                break;
            }
            case 3: {
                string = "Permission denied";
                break;
            }
            case 4: {
                string = "Failure";
                break;
            }
            case 0: {
                string = "Succes";
                break;
            }
            case 1: {
                string = "Reached end of file";
                break;
            }
            case 5: {
                string = "Bad message";
                break;
            }
            case 6: {
                string = "No connection to server";
                break;
            }
            case 7: {
                string = "Connection to server has been lost";
                break;
            }
            case 8: {
                string = "Operation not supported";
                break;
            }
            default: {
                string = "Error";
            }
        }
        String string2 = sftpException.getMessage();
        if (string2 != null && string2.trim().length() > 0) {
            string = string2.startsWith(string) ? string2 + "." : string + ". " + string2;
        }
        return string;
    }

    @Override
    public void removeResource() throws IOException {
        this.connect();
        if (this.getChannel() != null) {
            try {
                this.getChannel().rmdir(this.url.getPath());
            }
            catch (SftpException sftpException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)sftpException, (Throwable)sftpException);
                }
                if (sftpException.id == 2) {
                    try {
                        this.getChannel().rm(this.url.getPath());
                    }
                    catch (SftpException sftpException2) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)sftpException2, (Throwable)sftpException2);
                        }
                        throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException2), sftpException2);
                    }
                }
                throw new IOException(SFTPURLConnection.getErrorMessagesFromId(sftpException), sftpException);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }
}

