/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.version.checker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.j;
import ro.sync.exml.version.checker.ReleasedVersionInfo;
import ro.sync.util.p;

@XmlRootElement(name="versions")
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ReleasedVersionsCollection {
    private static final Logger logger = Logger.getLogger((String)ReleasedVersionsCollection.class.getName());
    private boolean sortedVersions = false;
    @XmlElement(name="version")
    private final List<ReleasedVersionInfo> releasedVersions = new ArrayList<ReleasedVersionInfo>();

    public List<ReleasedVersionInfo> getSortedReleasedVersions() {
        if (!this.sortedVersions) {
            Collections.sort(this.releasedVersions);
            this.sortedVersions = true;
        }
        return this.releasedVersions;
    }

    boolean isLatestMajorVersion(String string) throws p {
        boolean bl = false;
        List<ReleasedVersionInfo> list = this.getSortedReleasedVersions();
        if (list.size() > 0) {
            ReleasedVersionInfo releasedVersionInfo = list.get(list.size() - 1);
            bl = j.c().compareVersions(releasedVersionInfo.versionNo, string) == 0;
        }
        return bl;
    }

    ReleasedVersionInfo getLatestReleasedVersion() {
        ReleasedVersionInfo releasedVersionInfo = null;
        List<ReleasedVersionInfo> list = this.getSortedReleasedVersions();
        if (list.size() > 0) {
            releasedVersionInfo = list.get(list.size() - 1);
        }
        return releasedVersionInfo;
    }

    ReleasedVersionInfo getReleasedVersion(String string) {
        ReleasedVersionInfo releasedVersionInfo = null;
        for (ReleasedVersionInfo releasedVersionInfo2 : this.getSortedReleasedVersions()) {
            try {
                if (j.c().compareVersions(string, releasedVersionInfo2.versionNo) != 0) continue;
                releasedVersionInfo = releasedVersionInfo2;
                break;
            }
            catch (p p2) {
            }
        }
        return releasedVersionInfo;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RelesedVersionsCollection [attributes = {\n");
        for (ReleasedVersionInfo releasedVersionInfo : this.releasedVersions) {
            stringBuilder.append(" >>    ");
            stringBuilder.append(releasedVersionInfo);
            stringBuilder.append("\n");
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }
}

