/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform.advanced;

import java.net.MalformedURLException;
import java.net.URL;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.xmleditor.transform.advanced.AdvancedTransformerOptionsBase;
import ro.sync.options.j;
import ro.sync.util.Equaler;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SaxonHEAdvancedOptions
extends AdvancedTransformerOptionsBase {
    @PersistentObjectField(hasEditorVariables=false)
    private String errorRecoverPolicy;
    @PersistentObjectField(hasEditorVariables=false)
    private String stripWS;
    @PersistentObjectField(hasEditorVariables=false)
    private String optimizationLevel = "0";
    private boolean useConfigFile;
    @PersistentObjectField(hasEditorVariables=true)
    private String configSystemID;
    @PersistentObjectField(hasEditorVariables=false)
    private String initializer;

    @Override
    public void checkValid() throws j {
        if (this.errorRecoverPolicy == null) {
            throw new j("Error recover policy for the Saxon transformer cannot be null.");
        }
        if (this.stripWS == null) {
            throw new j("Strip whitespaces setting for the Saxon transformer cannot be null.");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SaxonHEAdvancedOptions) {
            SaxonHEAdvancedOptions saxonHEAdvancedOptions = (SaxonHEAdvancedOptions)object;
            return this.useConfigFile == saxonHEAdvancedOptions.useConfigFile && Equaler.verifyEquals(this.configSystemID, saxonHEAdvancedOptions.getConfigSystemID()) && this.errorRecoverPolicy.equals(saxonHEAdvancedOptions.errorRecoverPolicy) && this.stripWS.equals(saxonHEAdvancedOptions.stripWS);
        }
        return false;
    }

    public int hashCode() {
        int n2 = Boolean.valueOf(this.useConfigFile).hashCode();
        if (this.stripWS != null) {
            n2 += this.stripWS.hashCode();
        }
        if (this.errorRecoverPolicy != null) {
            n2 += this.errorRecoverPolicy.hashCode();
        }
        if (this.configSystemID != null) {
            n2 += this.configSystemID.hashCode();
        }
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public void setErrorRecoverPolicy(String string) {
        this.errorRecoverPolicy = string;
    }

    public String getErrorRecoverPolicy() {
        return this.errorRecoverPolicy;
    }

    public void setStripWS(String string) {
        this.stripWS = string;
    }

    public String getStripWS() {
        return this.stripWS;
    }

    public void setOptimizationLevel(String string) {
        this.optimizationLevel = string;
    }

    public String getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public boolean isUseConfigFile() {
        return this.useConfigFile;
    }

    public void setUseConfigFile(boolean bl) {
        this.useConfigFile = bl;
    }

    public String getConfigSystemID() {
        return this.configSystemID;
    }

    public void setConfigSystemID(String string) {
        this.configSystemID = string;
    }

    public void setInitializer(String string) {
        this.initializer = string;
    }

    public String getInitializer() {
        return this.initializer;
    }

    public String getCommandLineOptions(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useConfigFile) {
            String string2 = EditorVariables.expandEditorVariables(this.configSystemID, string);
            try {
                new URL(string2);
                stringBuilder.append(" -config:").append(string2);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            String string3 = "recover";
            if ("saxon.recover.silently".equals(this.errorRecoverPolicy)) {
                string3 = "silent";
            } else if ("saxon.do.not.recover".equals(this.errorRecoverPolicy)) {
                string3 = "fatal";
            }
            stringBuilder.append(" -warnings:").append(string3);
            String string4 = "none";
            if (this.stripWS.equals("saxon.strip.ws.all")) {
                string4 = "all";
            } else if (this.stripWS.equals("saxon.strip.ws.ignorable")) {
                string4 = "ignorable";
            }
            stringBuilder.append(" -strip:").append(string4);
            stringBuilder.append(" -opt:").append(this.optimizationLevel);
        }
        if (this.initializer != null) {
            stringBuilder.append(" -init:").append(this.initializer);
        }
        return stringBuilder.toString();
    }
}

