/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.images.xmlimages;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.NameValue;
import ro.sync.contentcompletion.xml.db;
import ro.sync.ecss.extensions.commons.CannotEditException;
import ro.sync.ecss.images.xmlimages.XMLFragmentEditor;
import ro.sync.ecss.images.xmlimages.XMLImageHandler;
import ro.sync.exml.r;
import ro.sync.util.PlatformDetector;
import ro.sync.util.URLUtil;
import ro.sync.xml.encoding.e;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public abstract class AbstractXMLImageHandler
implements XMLImageHandler {
    private static Logger h = Logger.getLogger((String)AbstractXMLImageHandler.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean editImage(URL uRL) throws CannotEditException {
        boolean bl = false;
        if (!"file".equals(uRL.getProtocol())) throw new CannotEditException("Only local files can be edited. Could not open: " + uRL);
        ArrayList arrayList = new ArrayList(4);
        InputStreamReader inputStreamReader = null;
        Writer writer = null;
        try {
            inputStreamReader = e.x(uRL, r.getInstance().getEncodingChooser(), "UTF8", arrayList);
            String string = inputStreamReader.getEncoding();
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1024];
            int n2 = inputStreamReader.read(cArray);
            while (n2 >= 0) {
                stringBuilder.append(new String(cArray, 0, n2));
                n2 = inputStreamReader.read(cArray);
            }
            inputStreamReader.close();
            String string2 = this.editImage(stringBuilder.toString(), null, uRL.toString(), null);
            if (string2 == null) return bl;
            String string3 = "UTF-8";
            if (string2.startsWith("<?xml")) {
                string = e.q(string2, arrayList);
            } else if (string2.startsWith("<")) {
                string = "UTF8";
            }
            string3 = e.i(string);
            if (string3 == null) {
                throw new CannotEditException("The IANA encoding: " + string + " cannot be mapped to a Java encoding.");
            }
            OutputStream outputStream = null;
            if (PlatformDetector.isEclipse() && "file".equals(uRL.getProtocol())) {
                File file = URLUtil.getCanonicalFileFromFileUrl(uRL);
                outputStream = new FileOutputStream(file);
            } else {
                outputStream = URLUtil.openOutputStream(uRL);
            }
            writer = e.hb(outputStream, string, "UTF8", arrayList != null && arrayList.size() > 2);
            if (!string2.startsWith("<?xml") && string != null && string.length() > 0) {
                writer.write("<?xml version='1.0' encoding='" + string3 + "'?>" + System.getProperty("line.separator"));
            }
            writer.write(string2);
            writer.close();
            return true;
        }
        catch (IOException iOException) {
            h.error((Object)iOException, (Throwable)iOException);
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            if (writer == null) throw new CannotEditException(iOException.getMessage(), iOException);
            try {
                writer.close();
                throw new CannotEditException(iOException.getMessage(), iOException);
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw new CannotEditException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public String editImage(String string, String string2, String string3, List<NameValue> list) throws CannotEditException {
        try {
            r r2 = r.getInstance();
            if (r2 != null) {
                XMLFragmentEditor xMLFragmentEditor = r2.getXMLFragmentEditor();
                if (xMLFragmentEditor != null) {
                    return xMLFragmentEditor.editFragment(string, string2, new URL(string3), this.getSchemaManagerForEditing());
                }
                throw new CannotEditException("The basic XML fragment editor has not been set:" + string3);
            }
            throw new CannotEditException("The IDE Access is null:" + string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CannotEditException("Invalid fragment URL: " + string3, malformedURLException);
        }
    }

    @Override
    public String getImageSourceFragment(String string, String string2) {
        return string != null ? string + string2 : string2;
    }

    protected abstract db getSchemaManagerForEditing();
}

