/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class HTMLTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider {
    private static final String ELEMENT_NAME_COLGROUP = "colgroup";
    private static final String ELEMENT_NAME_COL = "col";
    private static final String ELEMENT_NAME_THEAD = "thead";
    private static final String ELEMENT_NAME_TFOOT = "tfoot";
    private static final String ELEMENT_NAME_TBODY = "tbody";
    private static final String ATTR_NAME_SPAN = "span";
    private static final String ATTR_NAME_WIDTH = "width";
    private static final String ATTR_NAME_ALIGN = "align";
    private static final String HTML_CELL_NAME = "td";
    private static final String HTML_ROW_NAME = "tr";
    private static final String HTML_HEADER_CELL_NAME = "th";
    private static Logger logger = Logger.getLogger((String)HTMLTableCellInfoProvider.class.getName());
    private List<WidthRepresentation> colWidthSpecs = new ArrayList<WidthRepresentation>();
    private AuthorElement tableElement;

    @Override
    public Integer getColSpan(AuthorElement authorElement) {
        Integer n2 = null;
        AttrValue attrValue = authorElement.getAttribute("colspan");
        if (attrValue != null) {
            try {
                int n3 = Integer.parseInt(attrValue.getValue());
                n2 = Math.max(n3, 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public Integer getRowSpan(AuthorElement authorElement) {
        Integer n2 = null;
        AttrValue attrValue = authorElement.getAttribute("rowspan");
        if (attrValue != null) {
            try {
                int n3 = Integer.parseInt(attrValue.getValue());
                n2 = Math.max(n3, 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public void init(AuthorElement authorElement) {
        block27: {
            block26: {
                this.tableElement = authorElement;
                AuthorElement[] authorElementArray = authorElement.getElementsByLocalName(ELEMENT_NAME_COLGROUP);
                if (authorElementArray == null || authorElementArray.length <= 0) break block26;
                for (int i2 = 0; i2 < authorElementArray.length; ++i2) {
                    int n2;
                    AttrValue attrValue;
                    AuthorElement authorElement2;
                    block23: {
                        authorElement2 = authorElementArray[i2];
                        attrValue = authorElement2.getAttribute(ATTR_NAME_SPAN);
                        n2 = 1;
                        if (attrValue != null) {
                            try {
                                n2 = Integer.parseInt(attrValue.getValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!logger.isDebugEnabled()) break block23;
                                logger.debug((Object)numberFormatException, (Throwable)numberFormatException);
                            }
                        }
                    }
                    attrValue = authorElement2.getAttribute(ATTR_NAME_WIDTH);
                    String string = null;
                    if (attrValue != null) {
                        string = attrValue.getValue();
                    }
                    String string2 = null;
                    attrValue = authorElement2.getAttribute(ATTR_NAME_ALIGN);
                    if (attrValue != null) {
                        string2 = attrValue.getValue();
                    }
                    List<AuthorNode> list = authorElement2.getContentNodes();
                    for (AuthorNode n4 : list) {
                        int n3;
                        String string3;
                        String string4;
                        block24: {
                            AuthorElement numberFormatException;
                            if (!(n4 instanceof AuthorElement) || !ELEMENT_NAME_COL.equals((numberFormatException = (AuthorElement)n4).getLocalName())) continue;
                            n2 = -1;
                            AttrValue attrValue2 = numberFormatException.getAttribute(ATTR_NAME_WIDTH);
                            string4 = null;
                            if (attrValue2 != null) {
                                string4 = attrValue2.getValue();
                            } else if (string != null) {
                                string4 = string;
                            }
                            string3 = string2;
                            attrValue = authorElement2.getAttribute(ATTR_NAME_ALIGN);
                            if (attrValue != null) {
                                string3 = attrValue.getValue();
                            }
                            AttrValue attrValue3 = numberFormatException.getAttribute(ATTR_NAME_SPAN);
                            n3 = 1;
                            if (attrValue3 != null) {
                                try {
                                    n3 = Integer.parseInt(attrValue3.getValue());
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    if (!logger.isDebugEnabled()) break block24;
                                    logger.debug((Object)numberFormatException2, (Throwable)numberFormatException2);
                                }
                            }
                        }
                        for (int i3 = 0; i3 < n3; ++i3) {
                            WidthRepresentation widthRepresentation = new WidthRepresentation(string4, true);
                            widthRepresentation.setAlign(string3);
                            this.colWidthSpecs.add(widthRepresentation);
                        }
                    }
                    if (n2 <= 0) continue;
                    for (int i4 = 0; i4 < n2; ++i4) {
                        WidthRepresentation widthRepresentation = new WidthRepresentation(string, true);
                        widthRepresentation.setAlign(string2);
                        this.colWidthSpecs.add(widthRepresentation);
                    }
                }
                break block27;
            }
            AuthorElement[] authorElementArray = authorElement.getElementsByLocalName(ELEMENT_NAME_COL);
            if (authorElementArray == null || authorElementArray.length <= 0) break block27;
            for (int i5 = 0; i5 < authorElementArray.length; ++i5) {
                int n4;
                String string;
                String string5;
                block25: {
                    AuthorElement authorElement4 = authorElementArray[i5];
                    AttrValue attrValue = authorElement4.getAttribute(ATTR_NAME_WIDTH);
                    string5 = null;
                    if (attrValue != null) {
                        string5 = attrValue.getValue();
                    }
                    string = null;
                    AttrValue attrValue4 = authorElement4.getAttribute(ATTR_NAME_ALIGN);
                    if (attrValue4 != null) {
                        string = attrValue4.getValue();
                    }
                    AttrValue attrValue5 = authorElement4.getAttribute(ATTR_NAME_SPAN);
                    n4 = 1;
                    if (attrValue5 != null) {
                        try {
                            n4 = Integer.parseInt(attrValue5.getValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!logger.isDebugEnabled()) break block25;
                            logger.debug((Object)numberFormatException, (Throwable)numberFormatException);
                        }
                    }
                }
                for (int i4 = 0; i4 < n4; ++i4) {
                    WidthRepresentation widthRepresentation = new WidthRepresentation(string5, true);
                    widthRepresentation.setAlign(string);
                    this.colWidthSpecs.add(widthRepresentation);
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return "Provides information about cells in HTML tables";
    }

    @Override
    public boolean hasColumnSpecifications(AuthorElement authorElement) {
        return true;
    }

    @Override
    public List<WidthRepresentation> getCellWidth(AuthorElement authorElement, int n2, int n3) {
        ArrayList<WidthRepresentation> arrayList = null;
        int n4 = this.colWidthSpecs.size();
        if (n4 >= n2 && n4 >= n2 + n3) {
            arrayList = new ArrayList<WidthRepresentation>(n3);
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                arrayList.add(this.colWidthSpecs.get(i2));
            }
        }
        return arrayList;
    }

    @Override
    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] widthRepresentationArray, String string) throws AuthorOperationException {
        if (this.isHTMLTableCellTagName(string)) {
            int n2;
            AuthorElement[] authorElementArray = this.tableElement.getElementsByLocalName(ELEMENT_NAME_COLGROUP);
            boolean bl = false;
            if (authorElementArray != null && authorElementArray.length > 0) {
                bl = true;
                int n3 = 0;
                for (n2 = 0; n2 < authorElementArray.length; ++n2) {
                    AuthorElement authorElement = authorElementArray[n2];
                    AuthorElement[] authorElementArray2 = authorElement.getElementsByLocalName(ELEMENT_NAME_COL);
                    for (int i2 = 0; i2 < authorElementArray2.length; ++i2) {
                        AuthorElement authorElement2 = authorElementArray2[i2];
                        authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(widthRepresentationArray[n3++].getWidthRepresentation()), authorElement2);
                    }
                }
            } else {
                AuthorElement[] authorElementArray3 = this.tableElement.getElementsByLocalName(ELEMENT_NAME_COL);
                if (authorElementArray3 != null && authorElementArray3.length > 0) {
                    bl = true;
                    for (n2 = 0; n2 < authorElementArray3.length; ++n2) {
                        AuthorElement authorElement = authorElementArray3[n2];
                        authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(widthRepresentationArray[n2].getWidthRepresentation()), authorElement);
                    }
                }
            }
            if (!bl && widthRepresentationArray != null && authorDocumentController != null && this.tableElement != null) {
                String string2 = this.createXMLFragment(widthRepresentationArray);
                n2 = this.getInsertColsOffset();
                if (n2 == -1) {
                    throw new AuthorOperationException("No valid offset to insert the columns width specification.");
                }
                authorDocumentController.insertXMLFragment(string2, n2);
            }
        }
    }

    private int getInsertColsOffset() {
        int n2 = -1;
        AuthorElement[] authorElementArray = this.tableElement.getElementsByLocalName(ELEMENT_NAME_THEAD);
        if (authorElementArray != null && authorElementArray.length > 0) {
            n2 = authorElementArray[0].getStartOffset();
        } else {
            AuthorElement[] authorElementArray2 = this.tableElement.getElementsByLocalName(ELEMENT_NAME_TBODY);
            if (authorElementArray2 != null && authorElementArray2.length > 0) {
                n2 = authorElementArray2[0].getStartOffset();
            } else {
                AuthorElement[] authorElementArray3 = this.tableElement.getElementsByLocalName(HTML_ROW_NAME);
                if (authorElementArray3 != null && authorElementArray3.length > 0) {
                    n2 = authorElementArray3[0].getStartOffset();
                } else {
                    AuthorElement[] authorElementArray4 = this.tableElement.getElementsByLocalName(ELEMENT_NAME_TFOOT);
                    if (authorElementArray4 != null && authorElementArray4.length > 0) {
                        n2 = authorElementArray4[0].getStartOffset();
                    }
                }
            }
        }
        return n2;
    }

    private String createXMLFragment(WidthRepresentation[] widthRepresentationArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.tableElement.getNamespace();
        for (int i2 = 0; i2 < widthRepresentationArray.length; ++i2) {
            WidthRepresentation widthRepresentation = widthRepresentationArray[i2];
            stringBuffer.append("<col");
            String string2 = widthRepresentation.getWidthRepresentation();
            if (string2 != null) {
                stringBuffer.append(" width=\"" + widthRepresentation.getWidthRepresentation() + "\"");
            }
            if (string != null && string.length() > 0) {
                stringBuffer.append(" xmlns=\"" + string + "\"");
            }
            stringBuffer.append("/>");
        }
        return stringBuffer.toString();
    }

    @Override
    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int n2, String string) throws AuthorOperationException {
        if (this.isHTMLTableCellTagName(string) && n2 > 0 && authorDocumentController != null) {
            if (this.tableElement != null) {
                String string2 = String.valueOf(n2);
                authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(string2), this.tableElement);
            } else {
                throw new AuthorOperationException("Cannot find the element representing the table.");
            }
        }
    }

    @Override
    public WidthRepresentation getTableWidth(String string) {
        WidthRepresentation widthRepresentation = null;
        if (this.isHTMLTableCellTagName(string)) {
            widthRepresentation = this.getTableWidth();
        }
        return widthRepresentation;
    }

    private WidthRepresentation getTableWidth() {
        String string;
        AttrValue attrValue;
        WidthRepresentation widthRepresentation = null;
        if (this.tableElement != null && (attrValue = this.tableElement.getAttribute(ATTR_NAME_WIDTH)) != null && (string = attrValue.getValue()) != null) {
            widthRepresentation = new WidthRepresentation(string, true);
        }
        return widthRepresentation;
    }

    @Override
    public boolean isTableAcceptingWidth(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isTableAndColumnsResizable(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isAcceptingFixedColumnWidths(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isAcceptingPercentageColumnWidths(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    @Override
    public boolean isAcceptingProportionalColumnWidths(String string) {
        return this.isHTMLTableCellTagName(string);
    }

    public boolean isHTMLTableCellTagName(String string) {
        return HTML_CELL_NAME.equals(string) || HTML_HEADER_CELL_NAME.equals(string);
    }

    @Override
    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        if (this.colWidthSpecs.size() > 0) {
            return this.colWidthSpecs;
        }
        return null;
    }
}

