/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class UnwrapTagsOperation
implements AuthorOperation {
    private static final String ARGUMENT_XPATH_UNWRAP_ELEMENT = "unwrapElementLocation";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("unwrapElementLocation", 2, "An XPath expression indicating the element to unwrap.\nNote: If it is not defined then the element at the caret is unwrapped.")};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorNode authorNode = null;
        Object object = argumentsMap.getArgumentValue(ARGUMENT_XPATH_UNWRAP_ELEMENT);
        if (object instanceof String && ((String)object).length() > 0) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object, true, true, true);
            if (authorNodeArray.length <= 0 || !(authorNodeArray[0] instanceof AuthorElement)) throw new AuthorOperationException("The XPath expression does not identify an element: " + object);
            authorNode = authorNodeArray[0];
        } else {
            AuthorNode authorNode2 = null;
            try {
                int n2 = authorAccess.getEditorAccess().getCaretOffset();
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Cannot identify the current element", badLocationException);
            }
            for (authorNode2 = authorAccess.getDocumentController().getNodeAtOffset(n2); authorNode2 != null && !(authorNode2 instanceof AuthorElement); authorNode2 = authorNode2.getParent()) {
            }
            if (!(authorNode2 instanceof AuthorElement)) throw new AuthorOperationException("You need to have the carret inside an element.");
            authorNode = authorNode2;
        }
        authorAccess.getDocumentController().beginCompoundEdit();
        try {
            CommonsOperationsUtil.unwrapTags(authorAccess, authorNode);
        }
        catch (BadLocationException badLocationException) {
            authorAccess.getDocumentController().cancelCompoundEdit();
            throw new AuthorOperationException("The unwrap cannot be performed.");
        }
        authorAccess.getDocumentController().endCompoundEdit();
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Unwrap element tags.";
    }
}

