/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SurroundWithTextOperation
implements AuthorOperation {
    private static final String ARGUMENT_HEADER = "header";
    private static final String ARGUMENT_FOOTER = "footer";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("header", 0, "The text to append before"), new ArgumentDescriptor("footer", 0, "The text to append after")};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_HEADER);
        Object object2 = argumentsMap.getArgumentValue(ARGUMENT_FOOTER);
        if (object != null && object instanceof String && object2 != null && object2 instanceof String) {
            if (!authorAccess.getEditorAccess().hasSelection()) {
                authorAccess.getEditorAccess().selectWord();
            }
        } else {
            throw new IllegalArgumentException("One or both of the argument values are not declared, they are: header - " + object + ", footer - " + object2);
        }
        int n2 = authorAccess.getEditorAccess().getSelectionStart();
        int n3 = authorAccess.getEditorAccess().getSelectionEnd();
        authorAccess.getDocumentController().surroundInText((String)object, (String)object2, n2, n3);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Surround a selection with text. Places a header at the start of the selection and a footer at the end.If no selection exists, the word at caret will be surrounded.";
    }
}

