/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.exml.view.graphics.Rectangle;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class MoveCaretUtil {
    private static final Logger logger = Logger.getLogger((String)MoveCaretUtil.class.getName());

    public static boolean hasImposedEditorVariableCaretOffset(String string) {
        return string.contains("<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>");
    }

    public static void moveCaretToImposedEditorVariableOffset(AuthorAccess authorAccess, int n2) {
        AuthorNode authorNode = MoveCaretUtil.detectCaretPI(authorAccess.getDocumentController(), n2);
        if (authorNode != null) {
            int n3 = authorNode.getStartOffset();
            authorAccess.getDocumentController().deleteNode(authorNode);
            AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
            authorEditorAccess.setCaretPosition(n3);
            Rectangle rectangle = authorEditorAccess.modelToViewRectangle(authorEditorAccess.getCaretOffset());
            if (rectangle != null && rectangle.y > 100) {
                rectangle.y -= 100;
                authorEditorAccess.scrollToRectangle(rectangle);
            }
        }
    }

    private static AuthorNode detectCaretPI(AuthorDocumentController authorDocumentController, int n2) {
        try {
            return MoveCaretUtil.detectCaretPI(authorDocumentController.getNodeAtOffset(n2));
        }
        catch (BadLocationException badLocationException) {
            logger.warn((Object)badLocationException, (Throwable)badLocationException);
            return null;
        }
    }

    private static AuthorNode detectCaretPI(AuthorNode authorNode) throws BadLocationException {
        if (authorNode.getType() == 5 && authorNode.getTextContent().equals("UNIQUE_CARET_MARKER_FOR_AUTHOR")) {
            return authorNode;
        }
        if (authorNode instanceof AuthorParentNode) {
            List<AuthorNode> list = ((AuthorParentNode)authorNode).getContentNodes();
            Iterator<AuthorNode> iterator = list.iterator();
            while (iterator.hasNext()) {
                AuthorNode authorNode2 = MoveCaretUtil.detectCaretPI(iterator.next());
                if (authorNode2 == null) continue;
                return authorNode2;
            }
        }
        return null;
    }
}

