/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.commons.operations.InsertFragmentOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class InsertOrReplaceFragmentOperation
extends InsertFragmentOperation {
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        authorDocumentController.beginCompoundEdit();
        boolean bl = false;
        try {
            if (authorAccess.getEditorAccess().hasSelection()) {
                bl = true;
                authorAccess.getEditorAccess().deleteSelection();
            }
            super.doOperation(authorAccess, argumentsMap);
        }
        catch (AuthorOperationException authorOperationException) {
            if (bl) {
                authorDocumentController.cancelCompoundEdit();
            }
            throw authorOperationException;
        }
        finally {
            authorDocumentController.endCompoundEdit();
        }
    }

    @Override
    public String getDescription() {
        return "Insert a document fragment. If selection is present, the selection will be replaced with the given fragment.";
    }
}

