/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.util.SortedList;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class AuthorNodeUtil {
    private static final Logger logger = Logger.getLogger((String)AuthorNodeUtil.class.getName());

    public static List<AuthorNode> minimizeAuthorCollection(Collection<? extends AuthorNode> collection) {
        SortedList<AuthorNode> sortedList = new SortedList<AuthorNode>(new Comparator<AuthorNode>(){

            @Override
            public int compare(AuthorNode authorNode, AuthorNode authorNode2) {
                return authorNode.getStartOffset() - authorNode2.getStartOffset();
            }
        });
        Object object = collection.iterator();
        while (object.hasNext()) {
            AuthorNode authorNode = object.next();
            if (authorNode == null) continue;
            if (authorNode.getOwnerDocument() == null) {
                object.remove();
                continue;
            }
            sortedList.add(authorNode);
        }
        object = new ArrayList();
        for (int i2 = 0; i2 < sortedList.size(); ++i2) {
            AuthorNode authorNode;
            AuthorNode authorNode2 = (AuthorNode)sortedList.get(i2);
            AuthorNode authorNode3 = authorNode = object.isEmpty() ? null : (AuthorNode)object.get(object.size() - 1);
            if (authorNode != null && authorNode.getStartOffset() <= authorNode2.getStartOffset() && authorNode2.getEndOffset() <= authorNode.getEndOffset()) continue;
            object.add(authorNode2);
        }
        return object;
    }

    public static AuthorNode getFirstLeaf(AuthorDocumentFragment authorDocumentFragment) {
        AuthorNode authorNode = null;
        List<AuthorNode> list = authorDocumentFragment.getContentNodes();
        if (list != null && list.size() > 0 && (authorNode = AuthorNodeUtil.getPossibleLeaf(list)) instanceof AuthorParentNode) {
            AuthorNode authorNode2;
            list = ((AuthorParentNode)authorNode).getContentNodes();
            while (!list.isEmpty() && (authorNode2 = AuthorNodeUtil.getPossibleLeaf(list)) instanceof AuthorParentNode) {
                authorNode = authorNode2;
                list = ((AuthorParentNode)authorNode).getContentNodes();
            }
        }
        return authorNode;
    }

    private static AuthorNode getPossibleLeaf(List<AuthorNode> list) {
        AuthorNode authorNode = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AuthorNode authorNode2 = list.get(i2);
            try {
                if (authorNode2.getType() == 5 && authorNode2.getTextContent().equals("UNIQUE_CARET_MARKER_FOR_AUTHOR")) continue;
                authorNode = list.get(i2);
                break;
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return authorNode;
    }
}

