/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.node;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.Content;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class AuthorDocumentFragment {
    private static Logger logger = Logger.getLogger((String)AuthorDocumentFragment.class.getName());
    private final Content content;
    private final List<AuthorNode> nodes;
    private int righSplits;
    private int leftSplits;
    private List<AuthorPersistentHighlight> changeMarks;
    private List<AuthorPersistentHighlight> persistentMarks;
    private Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> attributesChanges = null;

    public AuthorDocumentFragment(Content content, List<AuthorNode> list, int n2, int n3) {
        this(content, list, n2, n3, null, null);
    }

    public AuthorDocumentFragment(Content content, List<AuthorNode> list, int n2, int n3, List<AuthorPersistentHighlight> list2, List<AuthorPersistentHighlight> list3) {
        this(content, list, n2, n3, list2, list3, null);
    }

    public AuthorDocumentFragment(Content content, List<AuthorNode> list, int n2, int n3, List<AuthorPersistentHighlight> list2, List<AuthorPersistentHighlight> list3, Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> map) {
        this.content = content;
        this.nodes = list;
        this.leftSplits = n2;
        this.righSplits = n3;
        this.changeMarks = list2;
        this.persistentMarks = list3;
        this.attributesChanges = map;
    }

    public Content getContent() {
        return this.content;
    }

    public int getAcceptedLength() {
        int n2 = this.getLength();
        if (this.changeMarks != null) {
            for (int i2 = 0; i2 < this.changeMarks.size(); ++i2) {
                AuthorPersistentHighlight authorPersistentHighlight = this.changeMarks.get(i2);
                if (authorPersistentHighlight.getType() != AuthorPersistentHighlight.PersistentHighlightType.CHANGE_DELETE) continue;
                n2 -= authorPersistentHighlight.getEndOffset() - authorPersistentHighlight.getStartOffset() + 1;
            }
        }
        return n2;
    }

    public int getLength() {
        return this.content.getLength();
    }

    public List<AuthorNode> getContentNodes() {
        return this.nodes;
    }

    public String toString() {
        String string = "";
        try {
            string = "Fragment content '" + this.content.getString(0, this.content.getLength()).replace('\u0000', 'X') + "'\n Elements '" + this.nodes + "\nRight splits:" + this.righSplits + " Left splits:" + this.leftSplits;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return string;
    }

    public int getLeftSplits() {
        return this.leftSplits;
    }

    public int getRightSplits() {
        return this.righSplits;
    }

    public void setLeftSplits(int n2) {
        this.leftSplits = n2;
    }

    public void setRighSplits(int n2) {
        this.righSplits = n2;
    }

    public List<AuthorPersistentHighlight> getChangeHighlights() {
        return this.changeMarks;
    }

    public Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> getAttributesChangeHighlights() {
        return this.attributesChanges;
    }

    public List<AuthorPersistentHighlight> getCommentsAndCustomHighlights() {
        return this.persistentMarks;
    }

    public void setCommentAndCustomHighlights(List<AuthorPersistentHighlight> list) {
        this.persistentMarks = list;
    }

    public void setChangeHighlights(List<AuthorPersistentHighlight> list) {
        this.changeMarks = list;
    }

    public void setAttributesChanges(Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> map) {
        this.attributesChanges = map;
    }

    public boolean isEmpty() {
        return this.content.getLength() == 0;
    }

    public boolean containsSimpleText() {
        boolean bl = false;
        try {
            List<AuthorNode> list = this.getContentNodes();
            Content content = this.getContent();
            if (list == null || list.size() == 0) {
                String string = content.getString(0, content.getLength());
                bl = string.trim().length() > 0;
            } else {
                int n2 = 0;
                Object object = list.iterator();
                while (object.hasNext()) {
                    String string;
                    AuthorNode authorNode = object.next();
                    int n3 = authorNode.getStartOffset();
                    if (n3 < n2) continue;
                    if (n3 != n2 && (string = content.getString(n2, n3 - n2)).trim().length() > 0) {
                        bl = true;
                        break;
                    }
                    n2 = authorNode.getEndOffset() + 1;
                }
                if (((String)(object = content.getString(n2, content.getLength() - n2))).trim().length() > 0) {
                    bl = true;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

