/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.highlights;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.highlights.HighlightPainterInfo;
import ro.sync.ecss.extensions.api.highlights.TextForegroundHighlighterPainter;
import ro.sync.exml.view.graphics.Color;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class ColorHighlightPainter
implements TextForegroundHighlighterPainter {
    private Color color = Color.COLOR_RED_DARKER;
    private int height = -1;
    private int totalHeight = 1;
    private TextDecoration decoration = null;
    private int textDecorationStroke = 0;
    private Color bgColor;
    private Color foregroundColor;
    private boolean useParentLineBoxHeight;

    public ColorHighlightPainter() {
    }

    public ColorHighlightPainter(Color color, int n2, int n3) {
        this.color = color;
        this.height = n2;
        this.totalHeight = n3;
    }

    @Override
    public void paint(HighlightPainterInfo highlightPainterInfo) {
        int n2;
        int n3;
        int n4 = this.height;
        if (n4 == -1) {
            n4 = (int)Math.max(1L, Math.round((double)highlightPainterInfo.getFontSize() / 16.0));
            n4 = highlightPainterInfo.isHighlightOverFormControl() ? 1 : n4;
            this.totalHeight = n4 + 1;
        }
        if (this.bgColor != null) {
            Color color = this.bgColor;
            if (highlightPainterInfo.isHighlightOverImage() && this.bgColor.getAlpha() > 50) {
                color = new Color(this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue(), 50);
            }
            highlightPainterInfo.getGraphics().setFillColor(color);
            n3 = this.useParentLineBoxHeight ? highlightPainterInfo.getParentLineBoxOrigin().y : highlightPainterInfo.getOrigin().y;
            int n5 = n2 = this.useParentLineBoxHeight ? highlightPainterInfo.getParentLineBoxHight() : highlightPainterInfo.getCurrentBoxHeight();
            if (highlightPainterInfo.getLength() > 0) {
                highlightPainterInfo.getGraphics().fillRect(highlightPainterInfo.getOrigin().x + highlightPainterInfo.getRelativeX(), n3, highlightPainterInfo.getLength(), n2);
            }
        }
        if (this.decoration == null) {
            this.decoration = TextDecoration.UNDERLINE;
        }
        if (this.decoration != TextDecoration.NONE) {
            int n6;
            highlightPainterInfo.getGraphics().setDrawColor(this.color);
            n3 = n6 = highlightPainterInfo.getOrigin().y;
            if (this.decoration == TextDecoration.STRIKEOUT) {
                if (!highlightPainterInfo.isHighlightOverFormControl()) {
                    if ((n6 += highlightPainterInfo.getTextYPadding() + highlightPainterInfo.getBaseLine() - highlightPainterInfo.getFontAscent() / 3) < n3) {
                        n6 = n3 + highlightPainterInfo.getTextYPadding() + highlightPainterInfo.getBaseLine() - 5;
                    }
                } else if (highlightPainterInfo.getCurrentBoxHeight() != 0) {
                    n6 += highlightPainterInfo.getCurrentBoxHeight() / 2;
                }
            } else if (this.decoration == TextDecoration.UNDERLINE) {
                n6 += highlightPainterInfo.getTextYPadding();
                n6 = this.useBaseLineForUnderline() && highlightPainterInfo.isHighlightOverText() && !highlightPainterInfo.isHighlightOverFormControl() ? (n6 += highlightPainterInfo.getBaseLine() + 1) : (n6 += highlightPainterInfo.getCurrentBoxHeight() - this.totalHeight);
            } else {
                n6 += highlightPainterInfo.getCurrentBoxHeight() - n4 - 1;
            }
            n2 = highlightPainterInfo.getGraphics().getStrokeType();
            int n7 = highlightPainterInfo.getGraphics().getStrokeWidth();
            highlightPainterInfo.getGraphics().setStroke(n4, this.textDecorationStroke);
            if (highlightPainterInfo.getLength() > 0) {
                highlightPainterInfo.getGraphics().drawLine(highlightPainterInfo.getOrigin().x + highlightPainterInfo.getRelativeX(), n6, highlightPainterInfo.getOrigin().x + highlightPainterInfo.getRelativeX() + highlightPainterInfo.getLength(), n6);
            }
            highlightPainterInfo.getGraphics().setStroke(n7, n2);
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.decoration = textDecoration;
    }

    public void setBgColor(Color color) {
        if (this.decoration == null) {
            this.decoration = TextDecoration.NONE;
        }
        this.bgColor = color;
    }

    public void setBgColor(Color color, boolean bl) {
        if (this.decoration == null) {
            this.decoration = TextDecoration.NONE;
        }
        this.bgColor = color;
        this.useParentLineBoxHeight = bl;
    }

    public boolean useBaseLineForUnderline() {
        return false;
    }

    public void setTextDecorationStroke(int n2) {
        this.textDecorationStroke = n2;
    }

    @Deprecated
    public void setStrikeOut(boolean bl) {
        if (bl) {
            this.setTextDecoration(TextDecoration.STRIKEOUT);
        } else {
            this.setTextDecoration(TextDecoration.UNDERLINE);
        }
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Color getColor() {
        return this.color;
    }

    public void setTextForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    @Override
    public Color getTextForegroundColor() {
        return this.foregroundColor;
    }

    public static enum TextDecoration {
        NONE,
        UNDERLINE,
        STRIKEOUT,
        BOTTOM;

    }
}

