/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.css;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.css.CSSCounter;
import ro.sync.ecss.css.CSSCounterIncrement;
import ro.sync.ecss.css.RelativeLength;
import ro.sync.ecss.css.StaticContent;
import ro.sync.ecss.css.URIContent;
import ro.sync.ecss.css.s;
import ro.sync.exml.view.graphics.Color;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.FontMetrics;
import ro.sync.ui.theme.d;
import ro.sync.util.Equaler;
import ro.sync.util.c;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Styles
implements Cloneable {
    public static final float EX_FACTOR = 0.6f;
    public static final int FONT_WEIGHT_NORMAL = 400;
    public static final int FONT_WEIGHT_BOLD = 700;
    static final int BORDER_WIDTH_THIN = 1;
    static final int BORDER_WIDTH_MEDIUM = 3;
    static final int BORDER_WIDTH_THICK = 5;
    public static int counter = 0;
    public static final int KEY_BACKGROUND_COLOR = counter++;
    public static final int KEY_BORDER_BOTTOM_COLOR = counter++;
    public static final int KEY_BORDER_BOTTOM_STYLE = counter++;
    public static final int KEY_BORDER_BOTTOM_WIDTH = counter++;
    public static final int KEY_BORDER_LEFT_COLOR = counter++;
    public static final int KEY_BORDER_LEFT_STYLE = counter++;
    public static final int KEY_BORDER_LEFT_WIDTH = counter++;
    public static final int KEY_BORDER_RIGHT_COLOR = counter++;
    public static final int KEY_BORDER_RIGHT_STYLE = counter++;
    public static final int KEY_BORDER_RIGHT_WIDTH = counter++;
    public static final int KEY_BORDER_TOP_COLOR = counter++;
    public static final int KEY_BORDER_TOP_STYLE = counter++;
    public static final int KEY_BORDER_TOP_WIDTH = counter++;
    public static final int KEY_FOREGROUND_COLOR = counter++;
    public static final int KEY_MIXED_CONTENT = counter++;
    public static final int KEY_DISPLAY = counter++;
    public static final int KEY_FONT = counter++;
    public static final int KEY_FONT_WEIGHT = counter++;
    public static final int KEY_LINE_HEIGHT_MULTIPLIER = counter++;
    public static final int KEY_LIST_STYLE_TYPE = counter++;
    public static final int KEY_MARGIN_BOTTOM = counter++;
    public static final int KEY_MARGIN_LEFT = counter++;
    public static final int KEY_MARGIN_RIGHT = counter++;
    public static final int KEY_MARGIN_TOP = counter++;
    public static final int KEY_PADDING_BOTTOM = counter++;
    public static final int KEY_PADDING_LEFT = counter++;
    public static final int KEY_PADDING_RIGHT = counter++;
    public static final int KEY_PADDING_TOP = counter++;
    public static final int KEY_WIDTH = counter++;
    public static final int KEY_HEIGHT = counter++;
    public static final int KEY_MIN_WIDTH = counter++;
    public static final int KEY_MAX_WIDTH = counter++;
    public static final int KEY_TEXT_ALIGN = counter++;
    public static final int KEY_WHITESPACE = counter++;
    public static final int KEY_EDITABLE = counter++;
    public static final int KEY_BORDER_SPACING = counter++;
    public static final int KEY_VISIBITY = counter++;
    public static final int KEY_EMPTY_CELLS = counter++;
    public static final int KEY_FOLDABLE = counter++;
    public static final int KEY_NON_FOLDABLE_CHILD_NAME = counter++;
    public static final int KEY_VERTICAL_ALIGN = counter++;
    public static final int KEY_COUNTER_RESET = counter++;
    public static final int KEY_COUNTER_INCREMENT = counter++;
    public static final int KEY_IMPOSED_DISPLAY = counter++;
    public static final int KEY_TEXT_DECORATION = counter++;
    public static final int KEY_TEXT_DECORATION_COLOR = counter++;
    public static final int KEY_LINK_URL = counter++;
    public static final int KEY_DISPLAY_TAGS = counter++;
    public static final int KEY_DIRECT_WHITESPACE = counter++;
    public static final int KEY_FILTERED_OUT = counter++;
    public static final int KEY_TEXT_TRANSFORM = counter++;
    public static final int KEY_SHOW_PLACEHOLDER = counter++;
    public static final int KEY_PLACEHOLDER_CONTENT = counter++;
    public static final int KEY_FOLDED = counter++;
    public static final int KEY_TAGS_BACKGROUND_COLOR = counter++;
    public static final int KEY_TAGS_COLOR = counter++;
    public static final int KEY_BACKGROUND_IMAGE = counter++;
    public static final int KEY_BACKGROUND_REPEAT = counter++;
    public static final int KEY_BACKGROUND_POSITION = counter++;
    public static final int KEY_DIRECTION = counter++;
    public static final int KEY_UNICODE_BIDI = counter++;
    public static final int KEY_TEXT_DECORATION_STYLE = counter++;
    private Object[] stylesArray = new Object[counter];
    private boolean canBeCached;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final StaticContent[] EMPTY_CONTENT = new StaticContent[0];
    private static final CSSCounter[] EMPTY_COUNTERS = new CSSCounter[0];
    private static final CSSCounterIncrement[] EMPTY_COUNTERS_INCREMENT = new CSSCounterIncrement[0];
    private static final int[] EMPTY_BORDER_SPACING = new int[]{0, 0};
    private static final RelativeLength ZERO_RELATIVE_LENGTH = RelativeLength.createAbsolute(0);
    private static final Map<String, Integer> propertyToIndex = new HashMap<String, Integer>();
    private static final Set<Integer> UN_INHERITABLE_STYLES;

    public Object getPropertyByName(String string) {
        Integer n2 = propertyToIndex.get(string);
        Object object = null;
        if (n2 != null) {
            object = this.stylesArray[n2];
        } else {
            Font font = this.getFont();
            if (font != null) {
                if ("font-style".equals(string)) {
                    object = (font.getStyle() & 2) == 2 ? "italic" : "normal";
                } else if ("font-size".equals(string)) {
                    object = font.getSize() + "px";
                } else if ("font-family".equals(string)) {
                    object = font.getName();
                }
            } else {
                throw new IllegalArgumentException("No property: " + string);
            }
        }
        return object;
    }

    public Color getBackgroundColor() {
        Color color = (Color)this.stylesArray[KEY_BACKGROUND_COLOR];
        if (color != null) {
            return color;
        }
        return null;
    }

    public URIContent getBackgroundImage() {
        URIContent uRIContent = (URIContent)this.stylesArray[KEY_BACKGROUND_IMAGE];
        if (uRIContent != null) {
            return uRIContent;
        }
        return null;
    }

    public String getBackgroundRepeat() {
        String string = (String)this.stylesArray[KEY_BACKGROUND_REPEAT];
        if (string != null) {
            return string;
        }
        return "repeat";
    }

    public s getBackgroundPosition() {
        s s2 = (s)this.stylesArray[KEY_BACKGROUND_POSITION];
        if (s2 != null) {
            return s2;
        }
        return null;
    }

    public Color getTagsBackgroundColor() {
        Color color = (Color)this.stylesArray[KEY_TAGS_BACKGROUND_COLOR];
        if (color != null) {
            return color;
        }
        return null;
    }

    public Color getTagsColor() {
        Color color = (Color)this.stylesArray[KEY_TAGS_COLOR];
        if (color != null) {
            return color;
        }
        return null;
    }

    public boolean hasBorder() {
        boolean bl = false;
        if (this.getBorderLeftWidth() != 0 || this.getBorderRightWidth() != 0 || this.getBorderTopWidth() != 0 || this.getBorderBottomWidth() != 0) {
            bl = true;
        }
        return bl;
    }

    public Color getBorderBottomColor() {
        Color color = (Color)this.stylesArray[KEY_BORDER_BOTTOM_COLOR];
        if (color != null) {
            return color;
        }
        return this.getColor();
    }

    public String getBorderBottomStyle() {
        String string = (String)this.stylesArray[KEY_BORDER_BOTTOM_STYLE];
        if (string != null) {
            return string;
        }
        return "none";
    }

    public Color getBorderLeftColor() {
        Color color;
        int n2 = KEY_BORDER_LEFT_COLOR;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_BORDER_RIGHT_COLOR;
        }
        if ((color = (Color)this.stylesArray[n2]) != null) {
            return color;
        }
        return this.getColor();
    }

    public String getBorderLeftStyle() {
        String string;
        int n2 = KEY_BORDER_LEFT_STYLE;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_BORDER_RIGHT_STYLE;
        }
        if ((string = (String)this.stylesArray[n2]) != null) {
            return string;
        }
        return "none";
    }

    public Color getBorderRightColor() {
        Color color;
        int n2 = KEY_BORDER_RIGHT_COLOR;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_BORDER_LEFT_COLOR;
        }
        if ((color = (Color)this.stylesArray[n2]) != null) {
            return color;
        }
        return this.getColor();
    }

    public String getBorderRightStyle() {
        String string;
        int n2 = KEY_BORDER_RIGHT_STYLE;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_BORDER_LEFT_STYLE;
        }
        if ((string = (String)this.stylesArray[n2]) != null) {
            return string;
        }
        return "none";
    }

    public Color getBorderTopColor() {
        Color color = (Color)this.stylesArray[KEY_BORDER_TOP_COLOR];
        if (color != null) {
            return color;
        }
        return this.getColor();
    }

    public String getBorderTopStyle() {
        String string = (String)this.stylesArray[KEY_BORDER_TOP_STYLE];
        if (string != null) {
            return string;
        }
        return "none";
    }

    public Color getColor() {
        Color color = (Color)this.stylesArray[KEY_FOREGROUND_COLOR];
        if (color != null) {
            return color;
        }
        return new Color(d.getInstance().getTextForegroundColor());
    }

    public StaticContent[] getMixedContent() {
        StaticContent[] staticContentArray = (StaticContent[])this.stylesArray[KEY_MIXED_CONTENT];
        if (staticContentArray != null) {
            return staticContentArray;
        }
        return EMPTY_CONTENT;
    }

    public String getDisplay() {
        String string = "inline";
        String string2 = (String)this.stylesArray[KEY_IMPOSED_DISPLAY];
        if (string2 == null) {
            string2 = (String)this.stylesArray[KEY_DISPLAY];
            if (string2 != null) {
                string = string2;
            }
        } else {
            string = string2;
        }
        return string;
    }

    public boolean isMorphDisplay() {
        String string = this.getDisplay();
        return "morph".equals(string) || "-oxy-morph".equals(string);
    }

    public boolean isInvisible() {
        String string = this.getDisplay();
        return "none".equals(string) || "ignored".equals(string);
    }

    public boolean isListItem() {
        return "list-item".equals(this.getDisplay());
    }

    public Font getFont() {
        return (Font)this.stylesArray[KEY_FONT];
    }

    public int getFontWeight() {
        Integer n2 = (Integer)this.stylesArray[KEY_FONT_WEIGHT];
        if (n2 != null) {
            return n2;
        }
        return 400;
    }

    public int getLineHeight(FontMetrics fontMetrics) {
        int n2 = -1;
        Float f2 = (Float)this.stylesArray[KEY_LINE_HEIGHT_MULTIPLIER];
        n2 = f2 != null ? Math.round((float)fontMetrics.getHeight() * f2.floatValue()) : fontMetrics.getHeight();
        return n2;
    }

    public String getListStyleType() {
        String string = (String)this.stylesArray[KEY_LIST_STYLE_TYPE];
        if (string != null) {
            return string;
        }
        return "disc";
    }

    public String getTextAlign() {
        String string = (String)this.stylesArray[KEY_TEXT_ALIGN];
        if (string != null) {
            return string;
        }
        return "left";
    }

    public boolean isSpecifiedTextAlign() {
        return this.stylesArray[KEY_TEXT_ALIGN] != null;
    }

    public boolean isInline() {
        return "inline".equals(this.getDisplay());
    }

    public boolean isTableRowGroup() {
        return this.getDisplay().equals("table-row-group");
    }

    public boolean isTableRow() {
        return this.getDisplay().equals("table-row");
    }

    public int getBorderBottomWidth() {
        Integer n2 = (Integer)this.stylesArray[KEY_BORDER_BOTTOM_WIDTH];
        if (n2 != null) {
            return n2;
        }
        return 3;
    }

    public int getBorderLeftWidth() {
        Integer n2;
        int n3 = KEY_BORDER_LEFT_WIDTH;
        if ("rtl" == this.getDirection()) {
            n3 = KEY_BORDER_RIGHT_WIDTH;
        }
        if ((n2 = (Integer)this.stylesArray[n3]) != null) {
            return n2;
        }
        return 3;
    }

    public int getBorderRightWidth() {
        Integer n2;
        int n3 = KEY_BORDER_RIGHT_WIDTH;
        if ("rtl" == this.getDirection()) {
            n3 = KEY_BORDER_LEFT_WIDTH;
        }
        if ((n2 = (Integer)this.stylesArray[n3]) != null) {
            return n2;
        }
        return 3;
    }

    public int getBorderTopWidth() {
        Integer n2 = (Integer)this.stylesArray[KEY_BORDER_TOP_WIDTH];
        if (n2 != null) {
            return n2;
        }
        return 3;
    }

    public RelativeLength getMarginBottom() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_MARGIN_BOTTOM];
        if (relativeLength != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public RelativeLength getMarginLeft() {
        RelativeLength relativeLength;
        int n2 = KEY_MARGIN_LEFT;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_MARGIN_RIGHT;
        }
        if ((relativeLength = (RelativeLength)this.stylesArray[n2]) != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public RelativeLength getMarginRight() {
        RelativeLength relativeLength;
        int n2 = KEY_MARGIN_RIGHT;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_MARGIN_LEFT;
        }
        if ((relativeLength = (RelativeLength)this.stylesArray[n2]) != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public RelativeLength getMarginTop() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_MARGIN_TOP];
        if (relativeLength != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public RelativeLength getPaddingBottom() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_PADDING_BOTTOM];
        if (relativeLength != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public String getDirection() {
        String string = (String)this.stylesArray[KEY_DIRECTION];
        if (string != null) {
            return string;
        }
        return "ltr";
    }

    public String getUnicodeBIDI() {
        String string = (String)this.stylesArray[KEY_UNICODE_BIDI];
        if (string != null) {
            return string;
        }
        return "normal";
    }

    public RelativeLength getPaddingLeft() {
        RelativeLength relativeLength;
        int n2 = KEY_PADDING_LEFT;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_PADDING_RIGHT;
        }
        if ((relativeLength = (RelativeLength)this.stylesArray[n2]) != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public RelativeLength getPaddingRight() {
        RelativeLength relativeLength;
        int n2 = KEY_PADDING_RIGHT;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_PADDING_LEFT;
        }
        if ((relativeLength = (RelativeLength)this.stylesArray[n2]) != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public RelativeLength getPaddingTop() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_PADDING_TOP];
        if (relativeLength != null) {
            return relativeLength;
        }
        return ZERO_RELATIVE_LENGTH;
    }

    public boolean isTable() {
        String string = this.getDisplay();
        return "table".equals(string) || "inline-table".equals(string);
    }

    public String getWhitespace() {
        String string = (String)this.stylesArray[KEY_WHITESPACE];
        if (string != null) {
            return string;
        }
        return "normal";
    }

    public String getDirectWhitespace() {
        return (String)this.stylesArray[KEY_DIRECT_WHITESPACE];
    }

    public boolean isTableHeaderGroup() {
        return this.getDisplay().equals("table-header-group");
    }

    public boolean isTableFooterGroup() {
        return this.getDisplay().equals("table-footer-group");
    }

    public boolean isTableColumn() {
        return this.getDisplay().equals("table-column");
    }

    public boolean isTableColumnGroup() {
        return this.getDisplay().equals("table-column-group");
    }

    public RelativeLength getWidth() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_WIDTH];
        if (relativeLength != null) {
            return relativeLength;
        }
        return null;
    }

    public RelativeLength getHeight() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_HEIGHT];
        if (relativeLength != null) {
            return relativeLength;
        }
        return null;
    }

    public RelativeLength getMinWidth() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_MIN_WIDTH];
        if (relativeLength != null) {
            return relativeLength;
        }
        return null;
    }

    public RelativeLength getMaxWidth() {
        RelativeLength relativeLength = (RelativeLength)this.stylesArray[KEY_MAX_WIDTH];
        if (relativeLength != null) {
            return relativeLength;
        }
        return null;
    }

    public boolean isEditable() {
        Boolean bl = (Boolean)this.stylesArray[KEY_EDITABLE];
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public int getHorizontalBorderSpacing() {
        return this.getBorderSpacing()[0];
    }

    public int getVerticalBorderSpacing() {
        return this.getBorderSpacing()[1];
    }

    private int[] getBorderSpacing() {
        int[] nArray = (int[])this.stylesArray[KEY_BORDER_SPACING];
        if (nArray != null) {
            return nArray;
        }
        return EMPTY_BORDER_SPACING;
    }

    public void setProperty(int n2, Object object) {
        this.stylesArray[n2] = object;
    }

    public Object getProperty(int n2) {
        return this.stylesArray[n2];
    }

    void copyAdditionalStylesFrom(Styles styles, boolean bl) {
        if (styles != null) {
            Object[] objectArray = styles.stylesArray;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                String string;
                boolean bl2;
                boolean bl3 = bl2 = this.stylesArray[i2] == null && i2 != KEY_COUNTER_RESET && i2 != KEY_COUNTER_INCREMENT && i2 != KEY_MIXED_CONTENT && i2 != KEY_FILTERED_OUT && (!bl || Styles.isInheritable(i2));
                if (!bl2 && KEY_DISPLAY == i2 && "none".equals(string = (String)objectArray[i2])) {
                    bl2 = true;
                }
                if (!bl2) continue;
                this.stylesArray[i2] = objectArray[i2];
            }
            if ("none".equals(this.getBorderBottomStyle()) || "hidden".equals(this.getBorderBottomStyle())) {
                this.stylesArray[Styles.KEY_BORDER_BOTTOM_WIDTH] = c.i(0);
            }
            if ("none".equals(this.getBorderTopStyle()) || "hidden".equals(this.getBorderTopStyle())) {
                this.stylesArray[Styles.KEY_BORDER_TOP_WIDTH] = c.i(0);
            }
            if ("none".equals(this.getBorderLeftStyle()) || "hidden".equals(this.getBorderLeftStyle())) {
                this.stylesArray[Styles.KEY_BORDER_LEFT_WIDTH] = c.i(0);
            }
            if ("none".equals(this.getBorderRightStyle()) || "hidden".equals(this.getBorderRightStyle())) {
                this.stylesArray[Styles.KEY_BORDER_RIGHT_WIDTH] = c.i(0);
            }
        }
    }

    static boolean isInheritable(int n2) {
        return !UN_INHERITABLE_STYLES.contains(n2);
    }

    public String getVisibility() {
        String string = "visible";
        String string2 = (String)this.stylesArray[KEY_VISIBITY];
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public String getShowPlaceholders() {
        return (String)this.stylesArray[KEY_SHOW_PLACEHOLDER];
    }

    public String getPlaceholderContent() {
        return (String)this.stylesArray[KEY_PLACEHOLDER_CONTENT];
    }

    public boolean getShowEmptyCells() {
        boolean bl = true;
        Boolean bl2 = (Boolean)this.stylesArray[KEY_EMPTY_CELLS];
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    public boolean isFoldable() {
        Boolean bl = (Boolean)this.stylesArray[KEY_FOLDABLE];
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public boolean isFolded() {
        Boolean bl = (Boolean)this.stylesArray[KEY_FOLDED];
        return bl != null ? bl : false;
    }

    public String[] getNonFoldableChildName() {
        String[] stringArray = (String[])this.stylesArray[KEY_NON_FOLDABLE_CHILD_NAME];
        if (stringArray != null) {
            return stringArray;
        }
        return EMPTY_STRING_ARRAY;
    }

    public boolean isTableCaption() {
        return this.getDisplay().equals("table-caption");
    }

    public boolean isInlineInCSS() {
        String string = (String)this.stylesArray[KEY_DISPLAY];
        return string == null || "inline".equals(string);
    }

    public String getVerticalAlign() {
        String string = (String)this.stylesArray[KEY_VERTICAL_ALIGN];
        return string != null ? string : "baseline";
    }

    public String[] getTextDecoration() {
        String[] stringArray;
        String[] stringArray2 = (String[])this.stylesArray[KEY_TEXT_DECORATION];
        if (stringArray2 != null) {
            stringArray = stringArray2;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "none";
        }
        return stringArray;
    }

    public String getTextDecorationStyle() {
        String string = (String)this.stylesArray[KEY_TEXT_DECORATION_STYLE];
        return string != null ? string : "solid";
    }

    public Color getTextDecorationColor() {
        Color color = (Color)this.stylesArray[KEY_TEXT_DECORATION_COLOR];
        if (color != null) {
            return color;
        }
        return new Color(d.getInstance().getTextForegroundColor());
    }

    public CSSCounter[] getCounters() {
        CSSCounter[] cSSCounterArray = (CSSCounter[])this.stylesArray[KEY_COUNTER_RESET];
        return cSSCounterArray == null ? EMPTY_COUNTERS : cSSCounterArray;
    }

    public CSSCounterIncrement[] getCountersIncrement() {
        CSSCounterIncrement[] cSSCounterIncrementArray = (CSSCounterIncrement[])this.stylesArray[KEY_COUNTER_INCREMENT];
        return cSSCounterIncrementArray == null ? EMPTY_COUNTERS_INCREMENT : cSSCounterIncrementArray;
    }

    public boolean isInTable() {
        return this.isTable() || this.isTableRow() || this.isTableRowGroup() || this.isTableFooterGroup() || this.isTableHeaderGroup();
    }

    public String getLinkURL() {
        String string = (String)this.stylesArray[KEY_LINK_URL];
        return string;
    }

    public String getDisplayTags() {
        String string = (String)this.stylesArray[KEY_DISPLAY_TAGS];
        return string != null ? string : "default";
    }

    public String getTextTransform() {
        return (String)this.stylesArray[KEY_TEXT_TRANSFORM];
    }

    public boolean isFilteredOut() {
        Boolean bl = (Boolean)this.stylesArray[KEY_FILTERED_OUT];
        return bl != null ? bl : false;
    }

    public boolean equals(Object object) {
        if (object instanceof Styles) {
            Styles styles = (Styles)object;
            for (int i2 = 0; i2 < this.stylesArray.length; ++i2) {
                if (!(this.stylesArray[i2] instanceof Object[] && styles.stylesArray[i2] instanceof Object[] ? !Equaler.verifyArrayEquals((Object[])this.stylesArray[i2], (Object[])styles.stylesArray[i2]) : !Equaler.verifyEquals(this.stylesArray[i2], styles.stylesArray[i2]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Styles.hash(23, this.stylesArray);
    }

    private static int hash(int n2, Object object) {
        int n3 = n2;
        if (object == null) {
            n3 = Styles.hash(n3, 0);
        } else if (!Styles.isArray(object)) {
            n3 = Styles.hash(n3, object.hashCode());
        } else {
            int n4 = Array.getLength(object);
            for (int i2 = 0; i2 < n4; ++i2) {
                Object object2 = Array.get(object, i2);
                if (object2 == null) continue;
                n3 = Styles.hash(n3, object2);
            }
        }
        return n3;
    }

    private static int hash(int n2, int n3) {
        return 37 * n2 + n3;
    }

    private static boolean isArray(Object object) {
        return object.getClass().isArray();
    }

    public Object clone() {
        Styles styles = new Styles();
        styles.stylesArray = new Object[this.stylesArray.length];
        System.arraycopy(this.stylesArray, 0, styles.stylesArray, 0, this.stylesArray.length);
        return styles;
    }

    public boolean canBeCached() {
        return this.canBeCached && this.getCounters().length == 0 && this.getMixedContent().length == 0;
    }

    public void setCanBeCached(boolean bl) {
        this.canBeCached = bl;
    }

    public String toString() {
        String string = "STYLES:\n";
        for (int i2 = 0; i2 < this.stylesArray.length; ++i2) {
            if (this.stylesArray[i2] == null) continue;
            string = string + "key " + i2 + " val:" + this.stylesArray[i2] + "\n";
        }
        return string;
    }

    static {
        Field[] fieldArray = Styles.class.getDeclaredFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            String string = fieldArray[i2].getName();
            if (string.startsWith("KEY")) {
                String string2 = string.substring(4);
                string2 = string2.toLowerCase();
                string2 = string2.replace("_", "-");
                try {
                    int n2 = fieldArray[i2].getInt(null);
                    propertyToIndex.put(string2, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            propertyToIndex.put("color", KEY_FOREGROUND_COLOR);
            propertyToIndex.put("white-space", KEY_WHITESPACE);
            propertyToIndex.put("content", KEY_MIXED_CONTENT);
            propertyToIndex.remove("font");
        }
        UN_INHERITABLE_STYLES = new HashSet<Integer>();
        UN_INHERITABLE_STYLES.add(KEY_DISPLAY);
        UN_INHERITABLE_STYLES.add(KEY_WIDTH);
        UN_INHERITABLE_STYLES.add(KEY_HEIGHT);
        UN_INHERITABLE_STYLES.add(KEY_MIN_WIDTH);
        UN_INHERITABLE_STYLES.add(KEY_MAX_WIDTH);
        UN_INHERITABLE_STYLES.add(KEY_COUNTER_RESET);
        UN_INHERITABLE_STYLES.add(KEY_COUNTER_INCREMENT);
        UN_INHERITABLE_STYLES.add(KEY_FOLDABLE);
        UN_INHERITABLE_STYLES.add(KEY_FOLDED);
        UN_INHERITABLE_STYLES.add(KEY_MIXED_CONTENT);
        UN_INHERITABLE_STYLES.add(KEY_FILTERED_OUT);
        UN_INHERITABLE_STYLES.add(KEY_SHOW_PLACEHOLDER);
        UN_INHERITABLE_STYLES.add(KEY_PLACEHOLDER_CONTENT);
        UN_INHERITABLE_STYLES.add(KEY_MARGIN_BOTTOM);
        UN_INHERITABLE_STYLES.add(KEY_MARGIN_LEFT);
        UN_INHERITABLE_STYLES.add(KEY_MARGIN_RIGHT);
        UN_INHERITABLE_STYLES.add(KEY_MARGIN_TOP);
        UN_INHERITABLE_STYLES.add(KEY_PADDING_BOTTOM);
        UN_INHERITABLE_STYLES.add(KEY_PADDING_LEFT);
        UN_INHERITABLE_STYLES.add(KEY_PADDING_RIGHT);
        UN_INHERITABLE_STYLES.add(KEY_PADDING_TOP);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_BOTTOM_COLOR);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_BOTTOM_STYLE);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_BOTTOM_WIDTH);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_LEFT_COLOR);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_LEFT_STYLE);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_LEFT_WIDTH);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_RIGHT_COLOR);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_RIGHT_STYLE);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_RIGHT_WIDTH);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_TOP_COLOR);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_TOP_STYLE);
        UN_INHERITABLE_STYLES.add(KEY_BORDER_TOP_WIDTH);
        UN_INHERITABLE_STYLES.add(KEY_BACKGROUND_COLOR);
        UN_INHERITABLE_STYLES.add(KEY_BACKGROUND_IMAGE);
        UN_INHERITABLE_STYLES.add(KEY_BACKGROUND_REPEAT);
        UN_INHERITABLE_STYLES.add(KEY_BACKGROUND_POSITION);
        UN_INHERITABLE_STYLES.add(KEY_UNICODE_BIDI);
    }
}

