/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.l.x;
import ro.sync.ecss.component.editor.c;
import ro.sync.ecss.component.editor.y;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Point;
import ro.sync.ui.e;
import ro.sync.util.PlatformDetector;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TextFieldEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
y {
    private static final Logger fpd = Logger.getLogger((String)TextFieldEditor.class.getName());
    private e cpd = null;
    private Color ipd;
    private c hpd = new c();
    private FocusAdapter epd = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (fpd.isDebugEnabled()) {
                fpd.debug((Object)("Focus lost " + focusEvent.getOppositeComponent()));
            }
            TextFieldEditor.this.fireCommitValue(new EditingEvent((String)TextFieldEditor.this.getValue()));
        }
    };
    private KeyAdapter dpd = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27 && !((x)TextFieldEditor.this.cpd).jej().pdj().isVisible()) {
                keyEvent.consume();
                TextFieldEditor.this.cancelEditing();
            } else if (keyEvent.getKeyCode() == 10 && !((x)TextFieldEditor.this.cpd).jej().pdj().isVisible()) {
                keyEvent.consume();
                TextFieldEditor.this.evc(false, true);
            }
        }
    };
    private Insets bpd;
    private Font gpd;

    private void lvc(AuthorInplaceContext authorInplaceContext, boolean bl) {
        Object object;
        if (this.cpd == null) {
            this.cpd = bl ? new x() : new e();
            this.gpd = this.cpd.getFont();
            this.ipd = this.cpd.getForeground();
            object = this.cpd.getMargin();
            this.bpd = null;
            this.bpd = object != null ? (Insets)((Insets)object).clone() : new Insets(1, 1, 1, 1);
            if (PlatformDetector.isWin32()) {
                this.bpd.top -= 2;
                this.bpd.bottom += 3;
            }
        }
        if (bl) {
            this.cpd.removeKeyListener(this.dpd);
            this.cpd.removeFocusListener(this.epd);
        }
        if ((object = (ro.sync.exml.view.graphics.Font)authorInplaceContext.getArguments().get("font")) != null) {
            this.cpd.setFont(new Font(((ro.sync.exml.view.graphics.Font)object).getName(), ((ro.sync.exml.view.graphics.Font)object).getStyle(), ((ro.sync.exml.view.graphics.Font)object).getSize()));
        } else {
            this.cpd.setFont(this.gpd);
        }
        this.kvc(authorInplaceContext, bl, false);
        if (bl) {
            this.cpd.addKeyListener(this.dpd);
            this.cpd.addFocusListener(this.epd);
            this.cpd.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    TextFieldEditor.this.fireEditingOccured();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    TextFieldEditor.this.fireEditingOccured();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    TextFieldEditor.this.fireEditingOccured();
                }
            });
        }
        if (!bl && authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null && !authorInplaceContext.getAuthorAccess().getWorkspaceAccess().isStandalone()) {
            this.cpd.setMargin(this.bpd);
        }
        String string = (String)authorInplaceContext.getArguments().get("tooltip");
        this.cpd.setToolTipText(string);
        InplaceEditorUtil.relayout(this.cpd, authorInplaceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kvc(AuthorInplaceContext authorInplaceContext, boolean bl, boolean bl2) {
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.cpd.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.cpd.setForeground(this.ipd);
        }
        if (bl) {
            this.hpd.eee(authorInplaceContext);
            ((x)this.cpd).setCCManager(this.hpd);
        }
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        if (!bl && string == null) {
            string = (String)authorInplaceContext.getArguments().get("default_value");
            this.cpd.setForeground(Color.GRAY);
        }
        if (string == null) {
            string = "";
        }
        if (bl2) {
            try {
                x x2 = (x)this.cpd;
                x2.beginCompoundUndoableEdit();
                try {
                    this.cpd.getDocument().remove(0, this.cpd.getDocument().getLength());
                    this.cpd.getDocument().insertString(0, string, null);
                }
                finally {
                    x2.endCompoundUndoableEdit();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            this.cpd.setText(string);
        }
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.lvc(authorInplaceContext, false);
        return this.cpd;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.lvc(authorInplaceContext, false);
        Dimension dimension = this.cpd.getPreferredSize();
        return new RendererLayoutInfo(this.cpd.getBaseline(dimension.width, dimension.height), InplaceEditorUtil.getPreferredSize(this.cpd, authorInplaceContext));
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, ro.sync.exml.view.graphics.Rectangle rectangle, Point point) {
        this.lvc(authorInplaceContext, true);
        return this.cpd;
    }

    @Override
    public void requestFocus() {
        this.cpd.requestFocus();
    }

    @Override
    public Object getValue() {
        return this.cpd.getText();
    }

    @Override
    public void stopEditing() {
        this.evc(true, false);
    }

    private void evc(boolean bl, boolean bl2) {
        this.cpd.removeKeyListener(this.dpd);
        this.cpd.removeFocusListener(this.epd);
        ((x)this.cpd).cancelCC();
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void cancelEditing() {
        this.cpd.removeKeyListener(this.dpd);
        this.cpd.removeFocusListener(this.epd);
        ((x)this.cpd).cancelCC();
        this.fireEditingCanceled();
    }

    @Override
    public String getDescription() {
        return "A text field renderer and editor";
    }

    @Override
    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        ro.sync.exml.view.graphics.Rectangle rectangle = null;
        try {
            Rectangle rectangle2 = this.cpd.modelToView(this.cpd.getCaretPosition());
            rectangle = new ro.sync.exml.view.graphics.Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        catch (BadLocationException badLocationException) {
            fpd.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return rectangle;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.lvc(authorInplaceContext, false);
        String string = this.cpd.getToolTipText();
        if (string == null) {
            string = this.cpd.getText();
        }
        return string;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.lvc(authorInplaceContext, false);
        stringBuilder.append("value:'").append(this.cpd.getText()).append("'");
        if (this.cpd.getToolTipText() != null) {
            stringBuilder.append(", tooltip:'").append(this.cpd.getToolTipText()).append("'");
        }
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.kvc(authorInplaceContext, true, true);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        try {
            this.cpd.getDocument().insertString(this.cpd.getCaretPosition(), string, null);
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            fpd.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

